.\" @(#)xgettext.1 1.4 90/08/20 SMI; from Sun
.TH xgettext 1 "14 Sep 1990"
.SH NAME
xgettext \- conditionally extract strings from C programs
.SH SYNOPSIS
.br
.B xgettext
.B \-d
[
.B cmnopvhP
]
[
.BI \-o \&directory-prefix
]
[
.BI \-x \&exclude-list
]
[
.I filename \|.\|.\|.
]
.br
.B xgettext
[
.B \-amopvhP
]
[
.BI \-x \&exclude-list
] 
[
.I filename \|.\|.\|.
]
.br
.\"... gwen please check indexes.
.IX xgettext "" "\fLxgettext\fP \(em conditionally extract strings"
.IX messages "conditionally extract strings" "" "conditionally extract strings"
.SH DESCRIPTION
.LP
.B xgettext
is used to automate the creation of portable message files.
A portable message file contains copies of "C" strings that are found in 
"C" source code in
.I filename.
When the 
.B -d
option is specified,
.B xgettext
places the extracted strings in the file 
.I name\c
.BR \&.po .
.I name 
is either the domain specified in a
.B dgettext
call, or
.B messages.po
for strings extracted from 
.B gettext
and
.B textdomain
calls. If the
.B -d
flag is not specified,
.B xgettext
places all the strings in
.BR messages.po .
The portable message file can be used as input to the 
.BR msgfmt (1)
utility, which will produce a binary form of the message file than can be 
used at application run-time.
.SH OPTIONS
.TP 10
.BI \-a
Extract ALL strings, not just those found in
.BR gettext ,
.BR dgettext ,
and
.B textdomain
calls.
.TP 10
.BI \-c flag
Comments beginning with
.I flag filename
on the first line of the comment are added to file
.IR filename
as 
.I #
delimited comments.
.TP 10
.B \-d
Produce duplicates. Does not sort output when
writing the portable message
file and will not overwrite existing output files.
Places output
from each domain specified in a
.B dgettext
call into a separate file named for the domain, 
.IR ie .
.IB name .po
.TP 10
.BI \-c flag
Comments beginning with
.I flag filename
on the first line of the comment are added to file
.IR filename
as 
.I #
delimited comments.
.TP 10
.BI \-m string
Causes
.B xgettext
to fill in the
.B msgstr
line of the portable message files it produces.
.B xgettext
uses the
corresponding msgid string
extracted from the "C" file, appending
.IR string .
Useful for debugging purposes.
.TP 10
.B \-n
Add
.I # 
delimited line number comments to output file indicating
the line number in the source file
where each extracted string is encountered.
.TP 10
.BI \-o filename
rename the default output file from
.BR messages.po
to
.IR filename .
.TP 10
.BI \-p pathname
Specify the directory where the output files will be placed.
This option overrides the current working 
directory. 
.TP 10
.BI \-x filename
Specify a file that contains a list of strings that
are not be extracted from the input files.
Each string to be excluded must appear on a line by itself
in the file
.I filename.
.TP 10
.B \-P
include strings in pre-processor statements.
.TP 10
.B \-v
Verbose mode.
.TP 10
.B \-h
Print a help message on standard output.
.SH FILES
.TP 14
.TP
.B messages.po
is always created, but may be empty.
.SH "SEE ALSO"
.BR msgfmt (1) ,
.BR xstr (1) ,
.BR gettext ,
.BR dgettext ,
.BR textdomain (3) .
