.\" @(#)textedit.1 1.29 90/02/26 SMI;
.\" Updated 6/8/90
.TH TEXTEDIT 1 "11 June 1990"
.SH NAME
textedit 
\- XView window- and mouse-based text editor
.SH SYNOPSIS
.B textedit
[
.I generic-tool-arguments
] 
[
.B "\-Ea on\|" |\| off 
] 
[
.B \-adjust_is_pending_delete
]
[
.B "\-Ei on\|" |\| off 
] 
.if t .ti +0.5i
[
.B \-auto_indent
]
[
.B "\-Eo on\|" |\| off 
] 
[
.B \-okay_to_overwrite
]
[
.B "\-Er on\|" |\| off 
] 
[
.B \-read_only
]
.if t .ti +0.5i
[
.BI \-Ec " N"
] 
[
.BI \-checkpoint " count"
]
[
.BI \-\s-1EL\s0 " lines"
] 
[
.BI \-lower_context " lines"
]
[
.BI \-Em " pixels"
] 
.if t .ti +0.5i
[
.BI \-margin " pixels"
]
[
.BI \-En " N"
] 
[
.BI \-number_of_lines " lines"
]
[
.BI \-\s-1ES\s0 " N"
] 
.if t .ti +0.5i
[
.BI \-multi_click_space " radius"
]
[
.BI \-Et " N"
] 
[
.BI \-tab_width " tabstop"
]
[
.BI \-\s-1ET\s0 " N"
] 
.if t .ti +0.5i
[
.BI \-multi_click_timeout " intrvl"
]
[
.BI \-Eu " N"
] 
[
.BI \-history_limit " max"
]
[
.BI \-\s-1EU\s0 " N"
] 
.if t .ti +0.5i
[
.BI \-upper_context " lines"
]
.I filename 
.SH AVAILABILITY
This command is available with the OpenWindows 
environment.
For information about installing OpenWindows, refer to the
.I OpenWindows Installation and Start-Up Guide.
.SH DESCRIPTION
.IX tools textedit "" "\fLtextedit\fR"
.LP
.B textedit
is a window-based \s-1XV\s0iew application 
that provides both mouse and pointer operations 
and keyboard accelerators for the editing of
text. 
In general, text editing throughout the OpenWindows
user environment uses
.B textedit
conventions, both in text display areas such 
as mail message windows and command panel text fields.
.LP
.B textedit 
operates via a set of command panel buttons and text
fields and a set of menus and submenus accessible from the main
editing window.
.SH OPTIONS
.LP
.TP 
.I generic-tool-arguments
.B textedit
accepts the \s-1XV\s0iew generic tool arguments described in the
.I XView Reference Manual.
.LP
.TP 
.BR "\-Ea on" \||\| off
.PD 0
.TP
.B \-adjust_is_pending_delete
.PD
Choose whether or not an adjustment to a selection makes the
selection \(lqpending-delete.\(rq  
The default is off.
This option corresponds to, and overrides, the 
.B adjust_is_pending_delete
Text defaults entry.
.TP 
.PD 0
.BR "\-Ei on" \||\| off
.TP
.B \-auto_indent
.PD
Choose whether or not to automatically indent newly-opened
lines.  
The default is off.  
Corresponds to the
.BR auto_indent 
Text default.
.TP 
.BR "\-Eo on" \||\| off
.PD 0
.TP 
.B \-okay_to_overwrite
.PD
Set behavior to the 
.B "Store as New File"
menu item.  If 
.B on
a
.B "Store as New File"
to the current file is treated as a
.BR "Save Current File" .
If 
.B off
(the standard default),
.B "Store as New File"
operations using the current filename 
results in an error message.
Corresponds to
.BR Store_self_is_save .
.TP 
.PD 0
.BR "\-Er on" \||\| off
.TP
.B \-read_only
.PD
Turn read-only mode on or off.
When on, text cannot be modified.
.TP
.BI \-Ec " N"
.PD 0
.TP
.BI \-checkpoint " count"
.PD
Checkpoint after every
.I count
editing operation.
If 
.I count 
is 0 (the standard default), no checkpointing takes place.
Each character typed, each
.BR Paste ,
and each
.B Cut
counts as an editing operation.
Corresponds to 
.BR checkpoint_frequency .
.TP 
.BI \-EL " lines"
.PD 0
.TP
.BI \-lower_context lines
.PD
Specify the minimum number of lines to keep between the caret
and the bottom of the text subwindow.
The default is 2.
Corresponds to
.BR lower_context .
.TP 
.BI \-Em " pixels"
.PD 0
.TP
.BI \-margin " pixels"
.PD
Set the scrollbar margin width in pixels. 
The default is 4.
Corresponds to
.BR left_margin .
.TP 
.BI \-En " N"
.PD 0
.TP
.BI \-number_of_lines " lines"
.PD
Set the number of lines in the bottom subwindow.
The default is 45.
.TP 
.BI \-ES " N"
.PD 0
.TP
.BI \-multi_click_space " radius"
.PD
Set the radius in pixels, within which clicks must
occur to be treated as a multi-click selection.
The default is 3 pixels. 
Corresponds to 
.BR multi_click_space .
.TP
.BI \-Et " N"
.PD 0
.TP
.BI \-tab_width " tabstop"
.PD
Set the number of
.SM SPACE
characters displayed per
.SM TAB
stop. 
The default is 8.
This option has no effect on the characters in the file.
Corresponds to 
.BR tab_width .
.TP 
.BI \-ET " N"
.PD 0
.TP
.BI \-multi_click_timeout " intrvl"
.PD
Set the interval, in milliseconds,
within which any two clicks must occur to be treated as a 
multi-click selection.
The default is 390 milliseconds.
Corresponds to 
.BR multi_click_timeout .
.TP
.BI \-Eu " N"
.PD 0
.TP
.BI \-history_limit " max"
.PD
Set the maximum number of editing operations that can be
undone or replayed.
The default is 50.
Corresponds to
.BR history_limit .
.TP
.B \-EU " N"
.PD 0
.TP
.BI \-upper_context " lines"
.PD
Set the minimum number of lines to keep between the caret and
the top of the text subwindow.
The default is 2.
Corresponds to
.BR upper_context .
.SH USAGE
.B textedit
is part of the OpenWindows user environment.
For a descriptions of the basic concepts of OpenWindows,
see the
.I OpenWindows User's Guide.
.SS Signal Processing
.LP
If
.B textedit
hangs, for whatever reason, you can send a
.B \s-1SIGHUP\as0
signal to its process
.SM ID,
which forces it to write any changes
(if possible):
.IP
.BI "kill \-\s-1HUP\s0 " pid
.LP
The edits are written to the file 
.BI textedit. pid
in its working directory.
If that fails,
.B textedit
successively tries to write to a file by that name in
.BR /var/tmp ,
and then
.BR /tmp .
In addition, whenever
.B textedit
catches a fatal signal, such as 
.BR \s-1SIGILL\s0 ,
it tries to write out the edits before aborting.
.SS Defaults Options
.LP
You can specify a number of defaults using the 
.B .Xdefaults
file that affect the behavior of the text-based 
facilities.  
See 
.BR xview (1)
for more detailed information.
.SS Selections
.LP
Selections in 
.B textedit
are defined as selected portions of text to 
which editing operations can be applied. 
For example, a selection can be
.I deleted, moved, copied, etc.
.LP
.B textedit
provides two types of selections: primary and secondary.
Primary selections allow you to select a set of 
text on which to perform an editing function. 
Secondary selections allow you to define a 
.I second
block of text without undefining your primary 
text selection or repositioning your cursor. 
Being able to define two sets of text at once 
allows you to take advantage of the advanced editing
functions described below in the section called
.B Function Keys.
.bp
.TP 10
.B Using a Mouse and Pointer:
.RS
Single characters can be selected using the
.SM SELECT.
.sp .5
Blocks of text can be selected by selecting a starting
point with the
.SM SELECT
and selecting an ending point with 
.SM ADJUST.
.sp .5
Or blocks of text can be selected using OPEN LOOK's
.I wipe through
feature by pointing at a beginning character and depressing the
.B select 
button while moving the pointer to the end of a block
of text.
.sp .5
Selections can also be made by
sing 
.I clicking
(rapidly pressing)
the select button. Click once to select a single letter;
click twice to select a word; click three times to select
a complete line of text; click four times to select the
entire document being edited.
.RE
.TP
.B Visual Feedback 
.RS
All primary selections are indicated visually 
by inverse video of the text selected and are
.I pending delete.
Pending delete selections are replaced if you 
type or paste while the text is selected.
.sp .5
Secondary selections that are not 
.I pending delete
are indicated by underlining of the text.
.sp .5
Secondary selections pending delete are indicated by underlining
of the text and strike through of the individual characters.
.RE
.SS Secondary Selections
.RS
Secondary selections are made using any of 
the selection methods described above in 
addition to holding down one of the four function keys
corresponding to the commands
.BR Cut ,
.BR Find ,
.BR Paste ,
or
.BR Copy  .
.LP
Secondary selections are made pending delete by holding the
.SM CTRL key when making the secondary selection.
If a secondary selection is pending-delete,
it is deleted when the function key is released, except in the case
of the 
.BR Find ,
which deselects the secondary selection.
.LP
You can make adjusted selections switch to pending-delete using the
.B adjust_is_pending_delete
defaults entry, or the
.B \-Ea
option. 
In this case,
\s-1CTRL\s0-Middle
makes the selection
.I not
pending-delete.
.LP
Commands that operate on the primary selection do so even if the
primary selection is not in the window that issued the command.
.RE
.SS "Inserting Text and Command Characters"
.LP
For the most part, typing any of the standard
keys either inserts the corresponding character
at the insertion point, or erases characters.
However, certain key combinations are treated as commands.
Some of the most useful are:
.LP
.ta 20n 40n
.nf
.B Command	Character	Description
.sp
\fBCut-Primary\fR	\s-1META\s0-X 	Erases, and moves to the Clipboard, the primary selection.
\fBFind-Primary\fR	\s-1META\s0-F	Searches the text for the pattern specified by the primary
		selection or by the Clipboard, if there is no primary selection.
\fBCopy-to-Clipboard\fR	\s-1META\s0-C	Copies the primary selection to the 	Clipboard. 
\fBPaste-Clipboard\fR	\s-1META\s0-V	Inserts the Clipboard contents at the insertion point.
\fBCopy-then-Paste\fR	\s-1META\s0-P	Copies the primary selection to the insertion point (through
		the Clipboard).
\fBGo-to-\s-1EOF\s0\fR	\s-1CTRL\s0-\s-1RETURN\s0	Moves the insertion point to the end of the text, positioning
		the text so that the insertion point is visible.
.fi
.br
.ne 8
.SS Function Keys
.LP
The commands indicated by use of the function keys are:
.LP
.ta 20n 40n
.nf
\fBCommand\fP	\fBSun-2\||\|3 Key\fP	\fBDescription\fP
.sp
\fBStop\fR	L1	Aborts the current command.
\fBAgain\fR	L2	Repeats the previous editing sequence since a 
		primary selection was made.
\fBUndo\fR	L4	Undoes a prior editing sequence.
\fBFront\fR	L5	Makes the window completely visible (or 
		hides it, if it is already exposed).
\fBCopy\fR	L6	Copies the primary selection, either to the 
		Clipboard or at the closest end of the secondary 
		selection.
\fBOpen\fR	L7	Makes the window iconic (or normal, if it is already 
		iconic).
\fBPaste\fR	L8	Copies either the secondary selection or the Clipboard at 
		the insertion point.
\fBFind\fR	L9	Searches for the pattern specified by, in order, the 
		secondary selection, the primary selection, or the Clipboard.
\fBCut\fR	L10	Erases, and moves to the Clipboard, either the primary or 
		the secondary selection.
\fB\s-1Help\s0\fR	F1	Produces help text.
.fi
.LP
.B Find
usually searches the text forwards, towards the end.
Holding down the 
.SM SHIFT
key while invoking
.B Find
searches backward through the text, towards the beginning.
If the pattern is not found before the search encounters
either extreme, it \(lqwraps around\(rq and
continues from the other extreme.
.B Find
starts the search at the appropriate end of the primary selection,
if the primary selection is in the subwindow that the search is made in;
otherwise it starts at the insertion point, unless the subwindow cannot
be edited, in which case it starts at the beginning of the text.
.LP
\s-1CTRL\s0-Find
invokes the
.B Find and Replace
pop-up frame.
.LP
.br
.ne 10
.SS Menu Items
.LP
.TP 10
.B File
A pull-right menu item for file operations.
.TP
.B Edit
A pull-right menu item equivalent of the editing function keys.
The
.B Edit
submenu provides
.BR Again ,
.BR Undo ,
.BR Copy ,
.BR Paste ,
and
.B Cut
(same as function keys L2, L4, L6, L8, and L10).
.TP
.B Display
A pull-right menu item for controlling the way
text is displayed and line display format.
.TP
.B Find
A pull-right menu item for find and delimiter matching operations.
.TP
.B Extras
A user definable pull-right menu item.  The
.B Extras
standard submenu is controlled by
.BR /usr/lib/.text_extras_menu ,
which has the same format as
.B \&.rootmenu
file.
This can be overridden in two ways:
.RS 15
1) Change the value of the .Xdefaults parameter 
.B text.extrasMenuFilename 
to the correct file path.
.br
2) Set the environment variable 
.B \s-1EXTRASMENU\s0
to the file desired.
.br
Note that option 1 overrides option 2 if both are
used.
.br
For more information see the
.I "DeskSet Environment Reference Guide".
See also
.BR xview (1).
.RE
.LP
Only those items that are active appear 
as normal text in the menu;
inactive items (which are inappropriate 
at the time) are \(lqgrayed out\(rq.
.bp
.SS User Defined Commands
.LP
The file
.B /usr/lib/text_extras_menu
specifies filter programs that are included in the text subwindow
.B Extras
pull-right menu item.  
The file 
.B ~/.textswrc
specifies filter programs that are assigned to (available)
function keys.
These filters are applied to the contents of the primary selection.
Their output is entered at the caret.
.LP
The file
.B /usr/lib/textswrc
is a sample containing a set of useful filters.
It is not read automatically.
.SH FILES
.PD 0
.TP 25
.B ~/.textswrc
Specifies bindings of filters to function keys
.TP
.B /usr/lib/text_extras_menu
Specifies bindings of filters for the extras menu pull-right items
.TP
.B /usr/bin
Contains useful filters, including \fBshift_lines\fP and \fBcapitalize\fP.
.TP
.IB filename %
Prior version of
.I filename
is available here after a
.B Save Current File
menu operation
.TP
.BI textedit. pid
Edited version of
.IR filename ;
generated in response to fatal internal errors
.TP
.B /tmp/Text*
Editing session logs
.PD
.SH "SEE ALSO"
.BR kill (1)
.LP
.I Introduction to the OpenWindows User Environment
.SH DIAGNOSTICS
.TP 35
.B "Cannot open file '\fIfilename\fP', aborting!"
.I filename
does not exist or cannot be read.
.LP
.B textedit
produces the following exit status codes:
.LP
.PD 0
.RS
.TP
0
normal termination
.TP
1
standard OpenWindows help message was printed
.TP
2
help message was requested and printed
.TP
3
abnormal termination in response to a signal, usually due to an internal error
.TP
4
abnormal termination during initialization,
usually due to a missing file or running out of swap space
.PD
.RE
.SH BUGS
Multi-click to change the current selection does not work for
.BR "Adjust Selection" .
.LP
Handling of long lines is incorrect in certain scrolling situations.
.LP
There is no way to replay any editing sequence except the most recent.
.LP
