#!/bin/bash
#
# $Id: install_packages.sh,v 1.4 2004/06/01 12:13:11 vcojot Exp $
#

MASTER_DIR=`dirname $0`

PKG_FILE_LIST="install_list.txt"
INCOMPAT_FILE_LIST="incompatible_list.txt"

INIT_PKG_LIST=""
MASTER_PKG_LIST=""
INCOMPAT_PKG_LIST=""

echo -n "Checking Operating System: "
if [ "`/sbin/uname -s`" = "SunOS" ]; then
	echo -n "SunOS|"

	OSREL=`/sbin/uname -r`
	case $OSREL in
		5.9)
			echo -n "$OSREL|"
			;;
		5.10)
			echo -n "$OSREL|"
			;;
		*)
			echo "Unsupported OS Release: ${OSREL}!"; exit 1
			;;
	esac

	CPUTYPE=`/sbin/uname -p`
	case $CPUTYPE in
		sparc)
			echo "sparc"
			;;
		i386)
			echo -e "\nWrong architecture! Please use the correct i386 packages!" ; exit 1
			;;
		*)
			echo "Unsupported CPU type!"; exit 1
			;;
	esac
else
	echo "...not SunOS!"; exit 1
fi

echo -n "Looking for incompatible list (${MASTER_DIR}/${INCOMPAT_FILE_LIST}) "
if [ -r ${MASTER_DIR}/${INCOMPAT_FILE_LIST} ]; then
	echo "...OK"
	INCOMPAT_PKG_LIST=`cat ${MASTER_DIR}/${INCOMPAT_FILE_LIST}|xargs`
else
	echo "...not found!!!"; exit 1
fi

echo -e "Checking for incompatible packages..."
for item in ${INCOMPAT_PKG_LIST}
do
	echo -n "${item}.."
	/usr/bin/pkginfo -q ${item}
	if [ $? -eq 0 ]; then
		echo -e "\nIncompatible Package installed: ${item}!!!\nExiting..."; exit 1
	else
		echo -n "."
	fi
done

echo -n "Looking for list (${MASTER_DIR}/${PKG_FILE_LIST}) "
if [ -r ${MASTER_DIR}/${PKG_FILE_LIST} ]; then
	echo "...OK"
	MASTER_PKG_LIST=`cat ${MASTER_DIR}/${PKG_FILE_LIST}|xargs`
else
	echo "...not found!!!"; exit 1
fi

echo -e "Looking for packages..."
for item in ${MASTER_PKG_LIST} ${INIT_PKG_LIST}
do
	echo -n "Checking ${item}..."
	/usr/bin/pkginfo -q -d ${MASTER_DIR} ${item}
	if [ $? -eq 0 ]; then
		echo "...OK"
	else
		echo "...not found!!!"; exit 1
	fi
done

#
echo -e "\nUpgrading packages (Quiet mode)..."

for pkg_item in ${MASTER_PKG_LIST}
do
        echo -n "Checking ${pkg_item}..."
	/usr/bin/pkginfo -q ${pkg_item}
	if [ $? -eq 0 ]; then
		echo -n "...OK. Comparing Packages.."
		O_VERSION=`/usr/bin/pkgparam ${pkg_item} VERSION`
		N_VERSION=`/usr/bin/pkgparam -d ${MASTER_DIR} ${pkg_item} VERSION`
		O_PSTAMP=`/usr/bin/pkgparam ${pkg_item} PSTAMP`
		N_PSTAMP=`/usr/bin/pkgparam -d ${MASTER_DIR} ${pkg_item} PSTAMP`
		if [ "X${O_VERSION}" = "X${N_VERSION}" -a "X${O_PSTAMP}" = "X${N_PSTAMP}" ]; then
			echo "...OK."
		else
			echo "...Packages Differ! Upgrading ${pkg_item}..."
			/usr/sbin/pkgadd -d ${MASTER_DIR} -a ${MASTER_DIR}/admin.default ${pkg_item} 2>&1 | /usr/bin/grep -v '^/master/'
		fi
	else
		echo "...not found! Installing ${pkg_item}..."
		/usr/sbin/pkgadd -d ${MASTER_DIR} -a ${MASTER_DIR}/admin.default ${pkg_item} 2>&1 | /usr/bin/grep -v '^/master/'
	fi
done
