#!/bin/bash
#
# $Id: remove_packages.sh,v 1.4 2004/06/01 12:13:12 vcojot Exp $
#

MASTER_DIR=`dirname $0`

PKG_FILE_LIST="remove_list.txt"

#INIT_PKG_LIST="BTlogm131"
INIT_PKG_LIST=""
MASTER_PKG_LIST=""

echo -n "Checking Operating System: "
if [ "`/sbin/uname -s`" = "SunOS" ]; then
	echo -n "SunOS|"

	OSREL=`/sbin/uname -r`
	case $OSREL in
		5.9)
			echo -n "$OSREL|"
			;;
		5.10)
			echo -n "$OSREL|"
			;;
		*)
			echo "Unsupported OS Release: ${OSREL}!"; exit 1
			;;
	esac

	CPUTYPE=`/sbin/uname -p`
	case $CPUTYPE in
		sparc)
			echo "sparc"
			;;
		i386)
			echo "i386"
			;;
		*)
			echo "Unsupported CPU type!"; exit 1
			;;
	esac
else
	echo "...not SunOS!"; exit 1
fi

echo -n "Looking for remove list (${MASTER_DIR}/${PKG_FILE_LIST}) "
if [ -r ${MASTER_DIR}/${PKG_FILE_LIST} ]; then
	echo "...OK"
	MASTER_PKG_LIST=`cat ${MASTER_DIR}/${PKG_FILE_LIST}|xargs`
else
	echo "...not found!!!"; exit 1
fi

for pkg_item in ${MASTER_PKG_LIST}
do
	/usr/sbin/pkgrm -n -a ${MASTER_DIR}/admin.default ${pkg_item}
done
