#!/bin/bash
#
# $Id: check_packages.sh,v 1.5 2004/04/27 14:29:29 vcojot Exp $
#

MASTER_DIR=`dirname $0`

PKG_FILE_LIST="check_list.txt"

INIT_PKG_LIST=""
MASTER_PKG_LIST=""

echo -n "Looking for package list (${MASTER_DIR}/${PKG_FILE_LIST}) "
if [ -r ${MASTER_DIR}/${PKG_FILE_LIST} ]; then
	echo "...OK"
	MASTER_PKG_LIST=`cat ${MASTER_DIR}/${PKG_FILE_LIST}|xargs`
else
	echo "...not found!!!"; exit 1
fi

echo -e "Verifying packages..."
for pkg_item in ${INIT_PKG_LIST} ${MASTER_PKG_LIST}
do
	echo -n "Verifying ${pkg_item}..."
	/usr/bin/pkginfo -q ${pkg_item}
	if [ $? -eq 0 ]; then
		echo -n "...OK. Verifying pkg.."
		/usr/sbin/pkgchk ${pkg_item}
		if [ $? -eq 0 ]; then
			echo "...OK"
		else
			echo "...pkgchk failed!"
		fi
	else
		echo "...not found!"
	fi
done
