/*
 * This file is a product of Sun Microsystems, Inc. and is provided for
 * unrestricted use provided that this legend is included on all tape
 * media and as a part of the software program in whole or part.  Users
 * may copy or modify this file without charge, but are not authorized to
 * license or distribute it to anyone else except as part of a product
 * or program developed by the user.
 * 
 * THIS FILE IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
 * WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 * 
 * This file is provided with no support and without any obligation on the
 * part of Sun Microsystems, Inc. to assist in its use, correction,
 * modification or enhancement.
 * 
 * SUN MICROSYSTEMS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
 * INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY THIS FILE
 * OR ANY PART THEREOF.
 * 
 * In no event will Sun Microsystems, Inc. be liable for any lost revenue
 * or profits or other special, indirect and consequential damages, even
 * if Sun has been advised of the possibility of such damages.
 * 
 * Sun Microsystems, Inc.
 * 2550 Garcia Avenue
 * Mountain View, California  94043
 */

/*
 * @(#)GroupP.h	1.11 91/08/14 Copyright 1991 Sun Microsystems
 */

/***********************************************************************
 *
 * Group Widget Private Data
 *
 ***********************************************************************/

#ifndef _OlGroupP_h
#define _OlGroupP_h


#include <X11/ConstrainP.h>
#include <Xol/ManagerP.h>
#include <Group.h>

/* private */

typedef	struct	_row_col_info {
			Widget		w;
			Position	x_off, y_off;
} RowColInfo, *RowColInfoPtr;

typedef	struct	group_constraint_rec {
			int	row;
			int	column;
} GroupConstraintRec, *GroupConstraints;
			
/***********************************************************************
 *
 * Class record
 *
 ***********************************************************************/

typedef	Boolean	(*GroupPositionAnchorRelativeFunc) OL_ARGS(( GroupWidget,
							     Position *,
							     Position *,
							     Boolean ));

/* New fields for the GroupWidget class record */
typedef struct {
	GroupPositionAnchorRelativeFunc	position_anchor_relative;
	XtPointer			extension;
} GroupClassPart;

#define	XtInheritGroupPositionAnchorRelativeFunc	\
				((GroupPositionAnchorRelativeFunc)_XtInherit)

/* Full class record declaration */
typedef struct _GroupClassRec {
    CoreClassPart	core_class;
    CompositeClassPart	composite_class;
    ConstraintClassPart	constraint_class;
    ManagerClassPart	manager_class;
    GroupClassPart	group_class;
} GroupClassRec;

extern GroupClassRec	groupClassRec;

/***********************************************************************
 *
 * Instance record
 *
 ***********************************************************************/

/* New fields for the GroupWidget record */
typedef struct _GroupPart {
	OlDefine	group_type;	

	Boolean		use_constraints;

	unsigned int	constraint_max_row;
	unsigned int	constraint_max_column;

	OlDefine	column_alignment;
	OlDefine	row_alignment;

	Boolean		rows_set;
	unsigned int	rows;
	Boolean		columns_set;
	unsigned int	columns;
	
	unsigned int	denominator;

	Dimension	h_space;
	Dimension	v_space;

	Boolean		min_x_set;
	Position	min_x;
	Boolean		min_y_set;
	Position	min_y;

	Dimension	max_item_width;
	Dimension	max_item_height;

	Dimension	h_offset;
	Dimension	v_offset;

	Widget		anchor;
	String		anchor_name;
	OlDefine	anchor_point;
	OlDefine	reference_point;

	Boolean		minimise_row_col;

	Boolean		track_anchor_geom;

#define	Grid(gw, row, col)	\
	((gw)->group.grid + ((row) * (gw)->group.columns) + (col))

	Dimension	*row_heights;
	Dimension	*column_widths;

	RowColInfoPtr	grid;
} GroupPart;

/* Full instance record declaration */
typedef struct _GroupRec {
    CorePart		core;
    CompositePart	composite;
    ConstraintPart	constraint;
    ManagerPart		manager;
    GroupPart		group;
} GroupRec;


/***********************************************************************
 *
 * Constants
 *
 ***********************************************************************/

#define GROUPPART(w)		( &(((GroupWidget)(w))->group) )
#define GROUPCLASSPART(wc)	( &(((GroupWidgetClass)(wc))->group_class) )
#define _OlIsGroup(w)		XtIsSubclass((w), groupWidgetClass)
#define _OL_IS_GROUP		_OlIsGroup
#endif /* _OlGroupP_h */
