/*
 * This file is a product of Sun Microsystems, Inc. and is provided for
 * unrestricted use provided that this legend is included on all tape
 * media and as a part of the software program in whole or part.  Users
 * may copy or modify this file without charge, but are not authorized to
 * license or distribute it to anyone else except as part of a product
 * or program developed by the user.
 * 
 * THIS FILE IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
 * WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 * 
 * This file is provided with no support and without any obligation on the
 * part of Sun Microsystems, Inc. to assist in its use, correction,
 * modification or enhancement.
 * 
 * SUN MICROSYSTEMS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
 * INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY THIS FILE
 * OR ANY PART THEREOF.
 * 
 * In no event will Sun Microsystems, Inc. be liable for any lost revenue
 * or profits or other special, indirect and consequential damages, even
 * if Sun has been advised of the possibility of such damages.
 * 
 * Sun Microsystems, Inc.
 * 2550 Garcia Avenue
 * Mountain View, California  94043
 */

#ifdef SHARELIB
#include <Xol/libXoli.h>
#include <Xol/OlMinStr.h>
#endif

#ifndef lint
static char     sccsid[] = "@(#)Group.c	1.12 6/7/91 Copyright 1991 Sun Microsystems";
#endif

#include <malloc.h>
#include <stdio.h>

#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>

#include <Xol/OpenLook.h>
#include <Xol/OpenLookP.h>
#include <Xol/ManagerP.h>
#include <GroupP.h>
#include <Xol/CaptionP.h>
/* #include <Xol/Error.h> */
#include <Xol/OlDnDVCX.h>

extern void		_OlDnDSetDisableDSClipping OL_ARGS (( Widget, Boolean ));

static void		GroupClassInitialize	 OL_NO_ARGS();
static void		GroupClassPartInitialize OL_ARGS(( WidgetClass ));
static void		GroupRealize		 OL_ARGS(( Widget, 
							   XtValueMask *,
							   XSetWindowAttributes *));
static void		GroupDestroy		 OL_ARGS(( Widget ));
static void		GroupInitialize		 OL_ARGS(( Widget, Widget,
							   ArgList,
							   Cardinal *));
static void		GroupResize		 OL_ARGS(( Widget ));
static Boolean		GroupSetValues		 OL_ARGS(( Widget, Widget,
							   Widget, ArgList,
							   Cardinal *));
static void		GroupChangeManaged	 OL_ARGS(( Widget ));
static XtGeometryResult GroupGeometryManager	 OL_ARGS(( Widget,
							   XtWidgetGeometry *,
							   XtWidgetGeometry *));
static XtGeometryResult GroupQueryGeometry	 OL_ARGS(( Widget,
							   XtWidgetGeometry *,
							   XtWidgetGeometry *));

static void		GroupConstraintInitialize	 OL_ARGS(( Widget,
								   Widget,
							   	   ArgList,
							           Cardinal *));

#ifdef	NOTDEF
static void		GroupConstraintDestroy		 OL_ARGS(( Widget ));

#endif
static Boolean		GroupConstraintSetValues	 OL_ARGS(( Widget,
								   Widget,
							   	   Widget,
								   ArgList,
							           Cardinal *));

static Boolean PositionAnchorRelative OL_ARGS (( GroupWidget,
						 Position *,
						 Position *,
						 Boolean ));

/* private */

static void CalculateGroupWidthHeight OL_ARGS (( GroupWidget,
						 Dimension *,
						 Dimension * ));


static void PopulateGrid  OL_ARGS(( GroupWidget ));

static Boolean LayoutGrid OL_ARGS(( GroupWidget, Widget,
					Boolean, Boolean ));

static Boolean MoveTheGrid OL_ARGS (( GroupWidget, Widget ));


/******************* resources ************************/

#define OFFSET(field)	XtOffsetOf(GroupRec, group.field)
static XtResource
resources[] = {
  { XtNgroupType, XtCGroupType, XtROlDefine, sizeof(OlDefine),
    OFFSET(group_type), XtRImmediate, (XtPointer)OL_NONE
  },
  { XtNuseConstraints, XtCUseConstraints, XtRBoolean, sizeof(Boolean),
    OFFSET(use_constraints), XtRImmediate, (XtPointer)False
  },
  { XtNcolumnAlignment, XtCColumnAlignment, XtROlDefine, sizeof(OlDefine),
    OFFSET(column_alignment), XtRImmediate, (XtPointer)OL_NONE
  },
  { XtNrowAlignment, XtCRowAlignment, XtROlDefine, sizeof(OlDefine),
    OFFSET(row_alignment), XtRImmediate, (XtPointer)OL_NONE
  },
  { XtNcolumns, XtCColumns, XtRInt, sizeof(int),
    OFFSET(columns), XtRImmediate, (XtPointer)1
  },
  { XtNrows, XtCRows, XtRInt, sizeof(int),
    OFFSET(rows), XtRImmediate, (XtPointer)1
  },
  { XtNvSpace, XtCVSpace, XtRDimension, sizeof(Dimension),
    OFFSET(v_space), XtRImmediate, (XtPointer)10
  },
  { XtNhSpace, XtCHSpace, XtRDimension, sizeof(Dimension),
    OFFSET(h_space), XtRImmediate, (XtPointer)10
  },
  { XtNminX, XtCMinX, XtRPosition, sizeof(Position),
    OFFSET(min_x), XtRImmediate, (XtPointer)NULL
  },
  { XtNminY, XtCMinY, XtRPosition, sizeof(Position),
    OFFSET(min_y), XtRImmediate, (XtPointer)NULL
  },
  { XtNvOffset, XtCVOffset, XtRDimension, sizeof(Dimension),
    OFFSET(v_offset), XtRImmediate, (XtPointer)10
  },
  { XtNhOffset, XtCHOffset, XtRDimension, sizeof(Dimension),
    OFFSET(h_offset), XtRImmediate, (XtPointer)10
  },
  { XtNdenominator, XtCDenominator, XtRInt, sizeof(int),
    OFFSET(denominator), XtRImmediate, (XtPointer)4
  },
  { XtNanchor, XtCAnchor, XtRWidget, sizeof(Widget),
    OFFSET(anchor), XtRImmediate, (XtPointer)NULL
  },
  { XtNanchorName, XtCAnchorName, XtRString, sizeof(String),
    OFFSET(anchor_name), XtRImmediate, (XtPointer)NULL
  },
  { XtNanchorPoint, XtCAnchorPoint, XtROlDefine, sizeof(OlDefine),
    OFFSET(anchor_point), XtRImmediate, (XtPointer)OL_NORTHEAST
  },
  { XtNreferencePoint, XtCReferencePoint, XtROlDefine, sizeof(OlDefine),
    OFFSET(reference_point), XtRImmediate, (XtPointer)OL_NORTHEAST
  },
  { XtNminimiseRowCol, XtCMinimiseRowCol, XtRBoolean, sizeof(Boolean),
    OFFSET(minimise_row_col), XtRImmediate, (XtPointer)True
  },
  { XtNtrackAnchorGeom, XtCTrackAnchorGeom, XtRBoolean, sizeof(Boolean),
    OFFSET(track_anchor_geom), XtRImmediate, (XtPointer)True
  },
};
#undef OFFSET

#define OFFSET(field)	XtOffsetOf(GroupConstraintRec, field)
static XtResource
constraint_resources[] = {
  { XtNrow, XtCRowColLocation, XtRInt, sizeof(int),
    OFFSET(row), XtRImmediate, (XtPointer)-1
  },
  { XtNcolumn, XtCRowColLocation, XtRInt, sizeof(int),
    OFFSET(column), XtRImmediate, (XtPointer)-1
  },
};
#undef OFFSET

/*************************************************************************
 *
 * Define Class Record structure to be initialized at Compile time
 *
 ***************************widget*class*record**************************/

GroupClassRec groupClassRec =
{
   {
/* core_class fields      */
    /* superclass         */    (WidgetClass)&managerClassRec,
    /* class_name         */    "Group",
    /* widget_size        */    sizeof(GroupRec),
    /* class_initialize   */    GroupClassInitialize,
    /* class_part_init    */    GroupClassPartInitialize,
    /* class_inited       */	FALSE,
    /* initialize         */    GroupInitialize,
    /* initialize_hook	  */    NULL,
    /* realize            */    GroupRealize,
    /* actions	          */	/* See ClassInitialize */NULL,
    /* num_actions        */	/* See ClassInitialize */NULL,
    /* resources          */    resources,
    /* num_resources      */    XtNumber(resources),
    /* xrm_class          */    NULLQUARK,
    /* compress_motion	  */	TRUE,
    /* compress_exposure  */	TRUE,
    /* compress_enterleave*/	TRUE,
    /* visible_interest   */    FALSE,
    /* destroy            */    GroupDestroy,
    /* resize             */    GroupResize,
    /* expose             */    XtInheritExpose,
    /* set_values         */    GroupSetValues,
    /* set_values_hook    */    NULL,
    /* set_values_almost  */    XtInheritSetValuesAlmost,
    /* get_values_hook    */    NULL,
    /* accept_focus       */	XtInheritAcceptFocus,
    /* Version            */    XtVersion,
    /* PRIVATE cb list    */    NULL,
    /* tm_table           */    /* See ClassInitialize */NULL,
    /* query_geom         */    GroupQueryGeometry,
    /* display_accelerator*/	XtInheritDisplayAccelerator,
    /* extension	  */	NULL
   },
   {
/* composite_class fields */
    /* geometry_group     */    GroupGeometryManager,
    /* change_managed     */    GroupChangeManaged,
    /* insert_child	  */	XtInheritInsertChild,
    /* delete_child	  */	XtInheritDeleteChild,
    /* extension	  */	NULL
   },
   {
/* constraint_class fields */
    /* resources	  */	constraint_resources,
    /* num_resources	  */	sizeof(constraint_resources) /
				sizeof(constraint_resources[0]),
    /* constraint_size	  */	sizeof(GroupConstraintRec),
#ifdef	NOTDEF
    /* initialize	  */	GroupConstraintInitialize,
    /* destroy		  */	GroupConstraintDestroy,
    /* set_values	  */	GroupConstraintSetValues,
#else
    /* initialize	  */	GroupConstraintInitialize,
    /* destroy		  */	NULL,
    /* set_values	  */	GroupConstraintSetValues,
#endif
    /* extension	  */	NULL
   },
   {
/*
 * Note Manager is OLIT Specific ....
 *
 * manager_class fields */     
    /* highlight_handler	*/	NULL,
    /* reserved                 */      NULL,
    /* reserved                 */      NULL,
    /* traversal_handler	*/	NULL,
    /* activate widget          */      NULL,
    /* event_procs		*/	NULL,
    /* num_event_procs   	*/	NULL,
    /* register_focus		*/	NULL,
    /* reserved                 */      NULL,
    /* version			*/	OlVersion,
    /* extension		*/	NULL,
    /* dyn_data			*/	{ NULL, 0 },
    /* transparent_proc		*/	_OlDefaultTransparentProc,
   },
/* group_class fields */
   {
    /* position anchor relative */	PositionAnchorRelative,
    /* extension                */	(XtPointer)NULL,
   },
};


/*************************************************************************
 *
 * Public Widget Class Definition of the Widget Class Record
 *
 *************************public*class*definition************************/

WidgetClass groupWidgetClass = (WidgetClass)&groupClassRec;


/*************************************************************************
 *
 * Private Procedures
 *
 ***************************private*procedures***************************/

static Widget
_checkcomposite OLARGLIST(( comp, name, except ))
	OLARG(CompositeWidget,	comp)
	OLARG(String,		name)
	OLGRA(Widget,		except)
{
	Cardinal	num = comp->composite.num_children,
			n;
	register Widget	*child = comp->composite.children,
			w = (Widget)NULL;

	if (strcmp(name, XtName((Widget)comp)) == 0) return ((Widget)comp);

	for (n = 0; n < num && w == (Widget)NULL; n++, child++) {
		if (*child == except) continue;

		if (XtIsSubclass(*child, compositeWidgetClass)) {
			w = _checkcomposite(*child, name, (Widget)NULL);
		} else if (strcmp(name, XtName(*child)) == 0) w = *child;
	}

	return (w);
}

static Widget
FindAnchorWidgetFromName OLARGLIST(( gw ))
	OLGRA(GroupWidget,	gw)
{
	Widget	parent, w = (Widget)gw;

	for (parent = XtParent(w);
	     parent != (Widget)NULL;
	     parent = XtParent(w = parent)) {
		w = _checkcomposite(parent, gw->group.anchor_name, w);

		if (w != (Widget)NULL) return (w);
	}
	return ((Widget)NULL);
}

static void
CalculateGroupWidthHeight OLARGLIST(( gw, width, height ))
	OLARG(GroupWidget,	gw)
	OLARG(Dimension *,	width)
	OLGRA(Dimension *,	height)
{
	Dimension	w = 2 * gw->group.min_x,
			h = 2 * gw->group.min_y;
	unsigned int	rows,
			columns;

	if (gw->group.group_type == OL_NONE) {
		Widget	p;
		Dimension	totw = (Position)0, 
				toth = (Position)0,
				tmpw,
				tmph;

		for (rows = 0;
		     rows <= gw->group.constraint_max_row;
		     rows++) {
			p = Grid(gw, rows,
				 gw->group.constraint_max_column)->w;

			if (p == (Widget)NULL) continue;

			tmpw = p->core.x + p->core.width + 
			       2 * p->core.border_width;

			if (tmpw > totw) totw = tmpw;
		}
			
		w += totw;

		for (columns = 0;
		     columns <= gw->group.constraint_max_column;
		     columns++) {
			p = Grid(gw, gw->group.constraint_max_row, columns)->w;

			if (p == (Widget)NULL) continue;

			tmph = p->core.y + p->core.height +
			       2 * p->core.border_width;

			if (tmph > toth) toth = tmph;
		}
	
		h += toth;
	} else {
		w += gw->group.h_space * (gw->group.columns - 1);
		h += gw->group.v_space * (gw->group.rows - 1);

		if (!gw->group.minimise_row_col ||
		    gw->group.column_widths == (Dimension *)NULL) {
			w += gw->group.max_item_width * gw->group.columns;
		} else {
			for (columns = 0;
			     columns < gw->group.columns; columns++)
				w += gw->group.column_widths[columns];
		}
		if (!gw->group.minimise_row_col ||
		    gw->group.row_heights == (Dimension *)NULL) {
			h += gw->group.max_item_height * gw->group.rows;
		} else {
			for (rows = 0; rows < gw->group.rows; rows++)
				h += gw->group.row_heights[rows];
		}
	}

	*width  = w;
	*height = h;
}

static void
CalcCaptionXOff OLARGLIST(( w, xoffs ))
	OLARG( Widget,		w)
	OLGRA( Dimension *,	xoffs)
{
	CaptionWidget	cw;
	GroupWidget	grp;
	CompositeWidget	comp;
	Widget		*p;
	
	*xoffs += w->core.border_width;

	if (XtIsSubclass(w, captionWidgetClass)) {
		cw = (CaptionWidget)w;
		switch (cw->caption.position) {
			case OL_LEFT:
				*xoffs +=
					cw->caption.caption_x +
					cw->caption.caption_width +
					cw->caption.space;
				break;
			case OL_RIGHT:
			case OL_TOP:
			case OL_BOTTOM:
				break;
		}
	} else if (XtIsSubclass(w, groupWidgetClass) &&
		   ((CompositeWidget)w)->composite.num_children > 0) {
		grp = (GroupWidget)w;
		*xoffs += grp->core.x;
		if ((w = Grid(grp, 0, 0)->w) != (Widget)NULL) {
			*xoffs += w->core.x;
			CalcCaptionXOff(w, xoffs);
		}
	} else if (XtIsSubclass(w, compositeWidgetClass) &&
		   ((CompositeWidget)w)->composite.num_children > 0) {
		comp  = (CompositeWidget)w;
		p     = comp->composite.children;

		*xoffs += comp->core.x;

		for (w = *p++;
		     p < comp->composite.children + 
			 comp->composite.num_children;
		     p++) {
			if ((*p)->core.x < w->core.x)
				w = *p;
		}

		*xoffs += w->core.x;
		CalcCaptionXOff(w, xoffs);
	} else *xoffs += w->core.width + w->core.border_width;
}

static void
AlignColumnLabels OLARGLIST(( gw ))
	OLGRA(GroupWidget,	gw)
{
	register unsigned int	rows, columns;
	Dimension		*captionxoffs;
	Position		x = 0;

	captionxoffs = (Dimension *)XtCalloc(gw->group.rows,
					     sizeof(Dimension));

	x = gw->group.min_x;
	for (columns = 0; columns < gw->group.columns; columns++) {
		RowColInfoPtr	rcip;
		Widget		w;
		Dimension	largest_xoff = 0;
		Dimension	column_width;

		column_width = (gw->group.minimise_row_col		  ?
					gw->group.column_widths[columns]  :
					gw->group.max_item_width);

		for (rows = 0; rows < gw->group.rows; rows++) {
			CaptionWidget	cw;

			rcip = Grid(gw, rows, columns);
			w = rcip->w;

			if (w == (Widget)NULL) continue;

			rcip->x_off = x;

			CalcCaptionXOff(w, captionxoffs + rows);

			if (captionxoffs[rows] > largest_xoff)
				largest_xoff = captionxoffs[rows];
		}

		for (rows = 0; rows < gw->group.rows; rows++) {
			int t;

			rcip = Grid(gw, rows, columns);

			if (rcip->w == (Widget)NULL) continue;

			rcip->x_off += largest_xoff - captionxoffs[rows];

			if ((t = rcip->x_off - x + rcip->w->core.width + 
			    2 * rcip->w->core.border_width) > column_width)
				column_width = t;
		}

		bzero((char *)captionxoffs,
		      sizeof(Dimension) * gw->group.rows);

		x += column_width + gw->group.h_space;
		gw->group.column_widths[columns] = column_width;
	}
}

static Boolean
MoveTheGrid OLARGLIST((gw, except))
	OLARG(register GroupWidget,	gw)
	OLGRA(register Widget,		except)
{
	register  unsigned int	rows, columns;
	register  RowColInfoPtr	rcip;
	register  Widget	w;
	int			moved = 0;

	_OlDnDSetDisableDSClipping((Widget)gw, True); /* for Drag N Drop */
	for (rows = 0; rows < gw->group.rows; rows++) {
		for (columns = 0; columns < gw->group.columns; columns++) {
			rcip = Grid(gw, rows, columns);
			w = rcip->w;

			if (w == (Widget)NULL) continue;

			if (w->core.x == rcip->x_off &&
			    w->core.y == rcip->y_off)
				continue;

			if (w != (Widget)NULL && w != except) {
				XtMoveWidget(w, rcip->x_off, rcip->y_off);
			} else if (except != (Widget)NULL && w == except) {
				except->core.x = rcip->x_off;
				except->core.y = rcip->y_off;
			}
			moved++;
		}
	}
	_OlDnDSetDisableDSClipping((Widget)gw, False);	/* for Drag N Drop */

	if (moved != 0) {
		OlDnDWidgetConfiguredInHier((Widget)gw); /* for Drag N Drop */
		return (True);
	} else
		return (False);
}

static void
DoColumnLayout OLARGLIST(( gw ))
	OLGRA(register GroupWidget,	gw)
{
	register unsigned int	rows, columns;
	Widget			w;
	Position		x;
	GroupWidgetClass	gwc = (GroupWidgetClass)gw->core.widget_class;

	if (gw->group.grid == (RowColInfoPtr)NULL) PopulateGrid(gw);

	if (gw->group.column_alignment == OL_COLUMN_ALIGN_LABELS) {
		AlignColumnLabels(gw);
		return;
	} /* special case */

	x = gw->group.min_x;
	for (columns = 0; columns < gw->group.columns; columns++) {
		register RowColInfoPtr	rcip;
		Dimension		column_width;

		column_width = (gw->group.minimise_row_col 		 ? 
					gw->group.column_widths[columns] :
					gw->group.max_item_width);

		for (rows = 0; rows < gw->group.rows; rows++) {
			rcip = Grid(gw, rows, columns);
			w = rcip->w;

			if (w == (Widget)NULL) continue;

			rcip->x_off = x;

			switch (gw->group.column_alignment) {
				case  OL_COLUMN_ALIGN_V_CENTER:
					rcip->x_off +=
						(column_width -
						   (w->core.width + 2 *
						    w->core.border_width)) / 2;
					break;
				case  OL_COLUMN_ALIGN_LEFT:
					break; /* already done */
				case  OL_COLUMN_ALIGN_RIGHT:
					rcip->x_off +=
						column_width -
						   (w->core.width + 2 *
						    w->core.border_width);
					break;
			}
		}
		x += column_width + gw->group.h_space;
	}
}

static void
DoRowLayout OLARGLIST(( gw ))
	OLGRA(register GroupWidget,	gw)
{
	register  unsigned int	rows, columns;
	Widget			w;
	Position		y;
	GroupWidgetClass	gwc = (GroupWidgetClass)gw->core.widget_class;

	if (gw->group.grid == (RowColInfoPtr)NULL) PopulateGrid(gw);

	y = gw->group.min_y;

	for (rows = 0; rows < gw->group.rows; rows++) {
		register RowColInfoPtr	rcip;
		Dimension		row_height;

		row_height = (gw->group.minimise_row_col 	 	?
					gw->group.row_heights[rows]	:
					gw->group.max_item_height);

		for (columns = 0; columns < gw->group.columns; columns++) {
			rcip = Grid(gw, rows, columns);
			w    = rcip->w;

			if (w == (Widget)NULL) continue;

			rcip->y_off = y; /* baseline for row */

			switch (gw->group.row_alignment) {
				case OL_ROW_ALIGN_TOP_EDGES:
					break;	/* already done */
				case OL_ROW_ALIGN_BOTTOM_EDGES:
					rcip->y_off +=
						row_height -
						   (w->core.height + 2 *
						    w->core.border_width);
					break;
				case OL_ROW_ALIGN_H_CENTER:
					rcip->y_off +=
						    (row_height -
						     (w->core.height + 2 *
						      w->core.border_width)) / 2;
					break;
			}
		}

		y += row_height + gw->group.v_space;
	}
}

static Boolean
LayoutGrid OLARGLIST(( gw, requestor, do_layout, resize_ok ))
	OLARG(GroupWidget,	gw)
	OLARG(Widget,		requestor)
	OLARG(Boolean,		do_layout)
	OLGRA(Boolean,		resize_ok)
{
	XtGeometryResult	result = XtGeometryYes;
	GroupWidgetClass	gwc = (GroupWidgetClass)gw->core.widget_class;
	Dimension		width, height;
	XtWidgetGeometry	req, rep;

	switch (gw->group.group_type) {
		case OL_COLUMNS:
			DoColumnLayout(gw);
			DoRowLayout(gw);
			break;
		case OL_ROWS:
		case OL_ROWCOLUMN:
			DoRowLayout(gw);
			DoColumnLayout(gw);
			break;
		default:
		case OL_NONE:;
	};


	if (do_layout)	/* for Drag N Drop */
		_OlDnDSetDisableDSClipping((Widget)gw, True);

	if (resize_ok) {
		CalculateGroupWidthHeight(gw, &width, &height);

		req.request_mode = CWWidth | CWHeight;
		req.width = width;
		req.height = height;

		if (!do_layout) req.request_mode |= XtCWQueryOnly;

		while ((result = XtMakeGeometryRequest((Widget)gw, &req, &rep))
		       == XtGeometryAlmost) {
			req = rep;
		}
	}

	if (do_layout && gw->group.group_type != OL_NONE)
		MoveTheGrid(gw, requestor);

	if (do_layout) {	/* for Drag N Drop */
		_OlDnDSetDisableDSClipping((Widget)gw, False);
		OlDnDWidgetConfiguredInHier((Widget)gw);
	}

	return(result != XtGeometryNo);
}

typedef	struct	_pwinfo {
		Position	x_centre,
				y_centre;

		Dimension	half_height,
				half_width;

		Boolean		constraints_specified,
				zero_xy,
				positioned;
} PWInfo, *PWInfoPtr;

static int
_comparX OLARGLIST(( first, second ))
	OLARG( int *,	first)
	OLGRA( int *,	second)
{
	return (((PWInfoPtr)*first)->x_centre -
		((PWInfoPtr)*second)->x_centre);
}

static int
_comparY OLARGLIST(( first, second ))
	OLARG( int *,	first)
	OLGRA( int *,	second)
{
	return (((PWInfoPtr)*first)->y_centre -
		((PWInfoPtr)*second)->y_centre);
}

static void 
PopulateGrid OLARGLIST(( gw ))
	OLGRA( GroupWidget,	gw)
{
#ifdef	major	/* sysmacros.h */
#undef	major
#endif
#ifdef	minor	/* sysmacros.h */
#undef	minor
#endif
	Widget			*children = gw->composite.children;

	Cardinal		num_children = gw->composite.num_children,
				columns      = gw->group.columns,
				rows         = gw->group.rows,
				num,
				*major,
				*minor,
				major_max,
				minor_max;

	unsigned int		num_rows	= 1,
				num_cols	= 1,
				zeroes		= 0;

	PWInfoPtr		pwinfo,
				*ascendingx = (PWInfoPtr *)NULL,
				*ascendingy = (PWInfoPtr *)NULL;

	Boolean			figure_rowcols_from_xys = (Boolean)False;

#define	GWConstraints(v) ((GroupConstraints)(children[v]->core.constraints))

#define	SetIF(obj, field, relop, var)	\
	if ((int)((obj)->core.field + 2 * (obj)->core.border_width) relop var)\
		var = (obj)->core.field  + 2 * (obj)->core.border_width


	if (gw->group.grid != (RowColInfoPtr)NULL) {
		XtFree((char *)gw->group.grid);
	}

	if (gw->group.row_heights != (Dimension *)NULL)
		XtFree((char *)gw->group.row_heights);

	if (gw->group.column_widths != (Dimension *)NULL)
		XtFree((char *)gw->group.column_widths);

	if (!num_children) return;

	pwinfo = (PWInfoPtr)XtCalloc(num_children, sizeof(PWInfo));

	gw->group.constraint_max_row    = 0;
	gw->group.constraint_max_column = 0;

	for (num = 0; num < num_children; num++) {
		Widget	w = children[num];
		Boolean	zero_xy;

		pwinfo[num].constraints_specified =
			(GWConstraints(num)->row    != -1 &&
			 GWConstraints(num)->column != -1);

		pwinfo[num].zero_xy = (w->core.x == (Position)0 &&
				       w->core.y == (Position)0);
			
		if (pwinfo[num].zero_xy)
			zeroes++;
		else {
			pwinfo[num].half_width  = w->core.width / 2 + 
						  w->core.border_width;
			pwinfo[num].half_height = w->core.height /2 +
						  w->core.border_width;

			pwinfo[num].x_centre    = w->core.x +
						  pwinfo[num].half_width;
			pwinfo[num].y_centre    = w->core.y + 
						  pwinfo[num].half_height;
		}

		SetIF(w, width,  >, gw->group.max_item_width);
		SetIF(w, height, >, gw->group.max_item_height);
	}

	figure_rowcols_from_xys = !gw->group.use_constraints		&&
				  zeroes < num_children			&& 
				  (gw->group.group_type == OL_NONE	||
				   !(gw->group.rows_set			||
				     gw->group.columns_set));

	if (figure_rowcols_from_xys) {
		PWInfoPtr	*px,
				*py,
				prevx,
				prevy;
		Dimension	xslop = gw->group.h_space /
					gw->group.denominator,
				yslop = gw->group.v_space /
					gw->group.denominator;

		ascendingx = (PWInfoPtr *)XtCalloc(num_children, 
						   sizeof(PWInfoPtr *));
		ascendingy = (PWInfoPtr *)XtCalloc(num_children, 
						   sizeof(PWInfoPtr *));

		for (num = 0; num < num_children; num++) {
			ascendingy[num] = ascendingx[num] = pwinfo + num;
			pwinfo[num].constraints_specified = (Boolean)True;
		}

		qsort((char *)ascendingx, num_children, sizeof(PWInfoPtr),
		      _comparX);
		qsort((char *)ascendingy, num_children, sizeof(PWInfoPtr),
		      _comparY);

		prevx = *(px = ascendingx);
		prevy = *(py = ascendingy);


		GWConstraints(*px - pwinfo)->column = 0;
		GWConstraints(*py - pwinfo)->row    = 0;

		for (px++, py++;
		     px - ascendingx < num_children;
		     (prevx = *px++), (prevy = *py++)) {
			if (prevx->x_centre <
			    (*px)->x_centre - ((*px)->half_width + xslop) &&
			    (*px)->x_centre >
			    prevx->x_centre + (prevx->half_width + xslop)) {
				num_cols++;
			}
			if (prevy->y_centre <
			    (*py)->y_centre - ((*py)->half_height + yslop) &&
			    (*py)->y_centre >
			    prevy->y_centre + (prevy->half_height + yslop)) {
				num_rows++;
			}

			GWConstraints(*px - pwinfo)->column = num_cols - 1;
			GWConstraints(*py - pwinfo)->row    = num_rows - 1;
		}

	} else {
		num_rows = rows    ? rows    : 1;
		num_cols = columns ? columns : 1;
	}

	if (num_children > num_rows * num_cols) {
		Cardinal	*const,
				*var;

		switch (gw->group.group_type) {
			case OL_ROWS:
				const = &num_rows;
				var   = &num_cols;
				break;

			case OL_COLUMNS:
				const = &num_cols;
				var   = &num_rows;
				break;

			case OL_NONE:
			case OL_ROWCOLUMN:
				if (gw->group.rows_set &&
				    !gw->group.columns_set) {
					const = &num_rows;
					var   = &num_cols;
					break;
				}

				if (gw->group.columns_set &&
				    !gw->group.rows_set) {
					const = &num_cols;
					var   = &num_rows;
					break;
				}
				
				while (num_rows * num_cols < num_children) {
					int	deltar,
						deltac;

					deltar = num_children - 
						(num_rows + 1 * num_cols);
					deltac = num_children -
						(num_cols + 1 * num_rows);
			
					if (deltar < 0 || deltac < 0) {
						if (abs(deltar) > abs(deltac)) {
							const = &num_cols;
							var   = &num_rows;
						} else {
							const = &num_rows;
							var   = &num_cols;
						}
					} else {
						if (deltar < deltac) {
							const = &num_cols;
							var   = &num_rows;
						} else {
							const = &num_rows;
							var   = &num_cols;
						}
					}

					while (*const * *var < num_children)
						(*var)++;
				}
				break;
		}

		while (*const * *var < num_children) (*var)++;
	}

	gw->group.rows    = num_rows;
	gw->group.columns = num_cols;

	gw->group.grid = (RowColInfoPtr)XtCalloc(num_cols * num_rows, 
					         sizeof(RowColInfo));

	gw->group.row_heights = (Dimension *)XtCalloc(num_rows,
						     sizeof(Dimension));

	gw->group.column_widths = (Dimension *)XtCalloc(num_cols,
						       sizeof(Dimension));

	if (gw->group.group_type == OL_COLUMNS ||
	    (gw->group.group_type == OL_ROWCOLUMN &&
	     gw->group.columns_set)) {
		major = &columns;
		minor = &rows;
		major_max = gw->group.columns;
		minor_max = gw->group.rows;
	} else {	/* otherwise search row-major */
		major = &rows;
		minor = &columns;
		major_max = gw->group.rows;
		minor_max = gw->group.columns;
	}

	for (num = 0; num < num_children; num++) {
		Widget	w = children[num];

		/*
		 * try constraints first .....
		 */

		if ((gw->group.use_constraints || figure_rowcols_from_xys) && 
		    pwinfo[num].constraints_specified) {

			rows    = GWConstraints(num)->row;
			columns = GWConstraints(num)->column;

			if (rows    < gw->group.rows    && 
			    columns < gw->group.columns &&
			    Grid(gw, rows, columns)->w == (Widget)NULL) {
				Grid(gw, rows, columns)->w     = w;
				Grid(gw, rows, columns)->x_off = w->core.x;
				Grid(gw, rows, columns)->y_off = w->core.y;

				pwinfo[num].positioned = (Boolean)True;
			}
		}

		if (!pwinfo[num].positioned) {
			rows = columns = 0;

			for (; *major < major_max; (*major)++) {
				for (; *minor < minor_max; (*minor)++) {
					if (Grid(gw, rows, columns)->w ==
					    (Widget)NULL) {
						goto gotone;
					}
				}
				*minor = 0;
			}
			
			continue;	/* failed! */

			gotone:;

			Grid(gw, rows, columns)->w     = w;
			Grid(gw, rows, columns)->x_off = w->core.x;
			Grid(gw, rows, columns)->y_off = w->core.y;
				
			pwinfo[num].positioned = (Boolean)True;
		}

		if (pwinfo[num].positioned) {
			GWConstraints(num)->row    = rows;
			GWConstraints(num)->column = columns;

			if (gw->group.constraint_max_row < rows)
				gw->group.constraint_max_row = rows;
			if (gw->group.constraint_max_column < columns)
				gw->group.constraint_max_column = columns;

			SetIF(w, width,  >, gw->group.column_widths[columns]);
			SetIF(w, height, >, gw->group.row_heights[rows]);
		}
	}

	if (ascendingx != (PWInfoPtr *)NULL)	XtFree((char *)ascendingx);
	if (ascendingy != (PWInfoPtr *)NULL)	XtFree((char *)ascendingy);

	XtFree((char *)pwinfo);

#undef	SetIF
#undef	GWConstraints
}

/*************************************************************************
 *
 * Class Procedures
 *
 ****************************class*procedures****************************/

static void
GroupClassInitialize()
{
	_OlAddOlDefineType( "rowcolumn", 	OL_ROWCOLUMN);
	_OlAddOlDefineType( "columns",		OL_COLUMNS);
	_OlAddOlDefineType( "rows",		OL_ROWS);
	_OlAddOlDefineType( "none",		OL_NONE);

	_OlAddOlDefineType( "alignvcenters",	OL_COLUMN_ALIGN_V_CENTER);
	_OlAddOlDefineType( "alignleftedges",	OL_COLUMN_ALIGN_LEFT);
	_OlAddOlDefineType( "alignrightedges",	OL_COLUMN_ALIGN_RIGHT);
	_OlAddOlDefineType( "alignlabels",	OL_COLUMN_ALIGN_LABELS);

	_OlAddOlDefineType( "aligntopedges",	OL_ROW_ALIGN_TOP_EDGES);
	_OlAddOlDefineType( "alignbottomedges",	OL_ROW_ALIGN_BOTTOM_EDGES);
	_OlAddOlDefineType( "alignhcenters",	OL_ROW_ALIGN_H_CENTER);

	_OlAddOlDefineType( "north",		OL_NORTH);
	_OlAddOlDefineType( "northeast",	OL_NORTHEAST);
	_OlAddOlDefineType( "east",		OL_EAST);
	_OlAddOlDefineType( "southeast",	OL_SOUTHEAST);
	_OlAddOlDefineType( "south",		OL_SOUTH);
	_OlAddOlDefineType( "southwest",	OL_SOUTHWEST);
	_OlAddOlDefineType( "west",		OL_WEST);
	_OlAddOlDefineType( "northwest",	OL_NORTHWEST);
	_OlAddOlDefineType( "center",		OL_CENTER);
} /* END OF ClassInitialize() */

static void
_anchorconfigured OLARGLIST((w, clientd, event, continue_to_dispatch))
	OLARG(Widget,		w)
	OLARG(XtPointer,	clientd)
	OLARG(XEvent,		*event)
	OLGRA(Boolean,		*continue_to_dispatch)
{
	GroupWidget	gw = (GroupWidget)clientd;
	GroupWidgetClass	gwc = (GroupWidgetClass)gw->core.widget_class;

	if (event->xany.type != ConfigureNotify) return;

	(void)
	(*gwc->group_class.position_anchor_relative)(gw, (Position *)NULL,
						     (Position *)NULL,
						     (Boolean)True );
} 

static void
_anchordestroy OLARGLIST(( w, clientd, calld ))
	OLARG( Widget,		w )
	OLARG( XtPointer,	clientd )
	OLGRA( XtPointer,	calld)
{
	GroupWidget	gw = (GroupWidget)clientd;
	
	if (gw->group.track_anchor_geom)
		XtRemoveEventHandler(w, StructureNotifyMask, False,
				     _anchorconfigured, clientd);

	gw->group.anchor = (Widget)NULL;
}

#ifdef	NOTDEF
static void
GroupConstraintDestroy OLARGLIST (( w ))
	OLGRA(Widget,	w)
{
}
#endif

static void
GroupDestroy OLARGLIST (( w ))
	OLGRA(Widget,	w)
{
 	GroupWidget	gw = (GroupWidget)w;

	if (gw->group.anchor != (Widget)NULL) {
		XtRemoveCallback(gw->group.anchor, XtNdestroyCallback,
				 _anchordestroy, (XtPointer)w);
		if (gw->group.track_anchor_geom)
			XtRemoveEventHandler(gw->group.anchor,
					     StructureNotifyMask, False,
					     _anchorconfigured, 
					     (XtPointer)gw);
	}

	if (gw->group.row_heights != (Dimension *)NULL)
		XtFree((char *)gw->group.row_heights);

	if (gw->group.column_widths != (Dimension *)NULL)
		XtFree((char *)gw->group.column_widths);

	if (gw->group.grid != (RowColInfoPtr)NULL)
		XtFree((char *)gw->group.grid);
}

static void
GroupConstraintInitialize OLARGLIST((request, w, args, num_args))
   OLARG( Widget,	request)
   OLARG( Widget,	w)
   OLARG( ArgList,	args)
   OLGRA( Cardinal,	*num_args)
{
	GroupConstraints	gcs = (GroupConstraints)w->core.constraints;
	GroupWidget		gw = (GroupWidget)XtParent(w);

	if (gcs->row > gw->group.constraint_max_row)
		gw->group.constraint_max_row = gcs->row;
	if (gcs->column > gw->group.constraint_max_column)
		gw->group.constraint_max_column = gcs->column;
}

static void
GroupClassPartInitialize OLARGLIST(( wc ))
	OLGRA(WidgetClass,	wc)
{
	GroupWidgetClass gwc = (GroupWidgetClass)wc,
			 super = (GroupWidgetClass)wc->core_class.superclass;


	if (gwc->group_class.position_anchor_relative == 
	    XtInheritGroupPositionAnchorRelativeFunc)
		gwc->group_class.position_anchor_relative =
			super->group_class.position_anchor_relative;
}

static void
GroupInitialize OLARGLIST((request, w, args, num_args))
   OLARG( Widget,	request)
   OLARG( Widget,	w)
   OLARG( ArgList,	args)
   OLGRA( Cardinal,	*num_args)
{
 	GroupWidget	gw = (GroupWidget)w;
	Cardinal	n;

	if (gw->group.anchor != (Widget)NULL) {
		XtAddCallback(gw->group.anchor, XtNdestroyCallback,
			      _anchordestroy, (XtPointer)gw);
	}

	gw->group.min_x_set		= False;
	gw->group.min_y_set		= False;
	gw->group.rows_set		= False;
	gw->group.columns_set		= False;
	gw->group.constraint_max_row    = 0;
	gw->group.constraint_max_column = 0;
	gw->group.max_item_width        = 0;
	gw->group.max_item_height       = 0;
	gw->group.row_heights	        = (Dimension *)NULL;
	gw->group.column_widths	        = (Dimension *)NULL;
	gw->group.grid                  = (RowColInfoPtr)NULL;

	for (n = 0; n < *num_args; n++) {
		if (strcmp(args[n].name, XtNrows) == 0) {
			gw->group.rows_set = (Boolean)True;
			continue;
		}
		if (strcmp(args[n].name, XtNcolumns) == 0) {
			gw->group.columns_set = (Boolean)True;
			continue;
		}
		if (strcmp(args[n].name, XtNminX) == 0) {
			gw->group.min_x_set = (Boolean)True;
			continue;
		}
		if (strcmp(args[n].name, XtNminY) == 0) {
			gw->group.min_y_set = (Boolean)True;
			continue;
		}
	}
}

static void
GroupRealize OLARGLIST((w, values, attrs))
	OLARG( Widget, 			w)
	OLARG( XtValueMask *,		values)
	OLGRA( XSetWindowAttributes *,	attrs)
{
	GroupWidget		gw = (GroupWidget)w;
	GroupWidgetClass	gwc = (GroupWidgetClass)gw->core.widget_class;

	if (gw->group.anchor == (Widget)NULL) {
		Widget	anchor;

		if (gw->group.anchor_name != (String)NULL &&
		    (anchor = FindAnchorWidgetFromName(gw)) != (Widget)NULL) {
			gw->group.anchor = anchor;
			XtAddEventHandler(anchor, StructureNotifyMask, False,
					  _anchorconfigured, (XtPointer)gw);
		}
	}

	(*gwc->group_class.position_anchor_relative)
		(gw, (Position *)NULL, (Position *)NULL, (Boolean)True);

	(*groupWidgetClass->core_class.superclass->core_class.realize)
		(w, values, attrs);
}

static Boolean
GroupConstraintSetValues OLARGLIST ((current, request, new, args, num_args))
	OLARG( Widget,		current)
	OLARG( Widget,		request)
	OLARG( Widget,		new)
	OLARG( ArgList,		args)
	OLGRA( Cardinal *,	num_args)
{
	GroupConstraints	nc =
				(GroupConstraints)request->core.constraints,
				cc =
				(GroupConstraints)current->core.constraints;
	GroupWidget		gw = (GroupWidget)XtParent(current);
	GroupWidgetClass	gwc = (GroupWidgetClass)gw->core.widget_class;

	if (!gw->group.use_constraints) return (False);

	PopulateGrid(gw);
	LayoutGrid(gw, new, (Boolean)True, (Boolean)True);

	return (False);
}

static Boolean
GroupSetValues OLARGLIST ((current, request, new, args, num_args))
	OLARG( Widget,		current)
	OLARG( Widget,		request)
	OLARG( Widget,		new)
	OLARG( ArgList,		args)
	OLGRA( Cardinal *,	num_args)
{
	GroupWidget 		cgw = (GroupWidget) current;
	GroupPart   		*curPart = &cgw->group;
	GroupWidget 		ngw = (GroupWidget) new;
	GroupPart   		*newPart = &ngw->group;
	GroupWidgetClass	gwc = (GroupWidgetClass)cgw->core.widget_class;
	Boolean			new_anchor;

#define	Changed(field)		(cgw->group.field != ngw->group.field)
#define	OverrideNew(field)	ngw->group.field = cgw->group.field

	if (Changed(group_type)) /* dont allow changes to group type */
		OverrideNew(group_type);

	if ((new_anchor = (Changed(anchor) || Changed(anchor_name)))) {
		Widget	w = FindAnchorWidgetFromName(ngw);

		if (cgw->group.anchor != (Widget)NULL) {
			XtRemoveCallback(cgw->group.anchor, XtNdestroyCallback,
					 _anchordestroy, (XtPointer)cgw);
			if (cgw->group.track_anchor_geom)
				XtRemoveEventHandler(cgw->group.anchor,
						     StructureNotifyMask, False,
						     _anchorconfigured,
						     (XtPointer)cgw);

		}
		if (Changed(anchor_name) && w != (Widget)NULL)
			ngw->group.anchor = w;

		if (ngw->group.anchor != (Widget)NULL) {
			XtAddCallback(ngw->group.anchor, XtNdestroyCallback,
				      _anchordestroy, (XtPointer)ngw);
			if (ngw->group.track_anchor_geom)
				XtAddEventHandler(ngw->group.anchor,
						  StructureNotifyMask, False,
						  _anchorconfigured,
						  (XtPointer)ngw);
		}
	}

	if (Changed(track_anchor_geom) &&
	    !new_anchor && ngw->group.anchor != (Widget)NULL) {
		if (cgw->group.track_anchor_geom) {
		      XtRemoveEventHandler(ngw->group.anchor,
				           StructureNotifyMask, False,
				           _anchorconfigured, (XtPointer)ngw);
		} else {
		      XtAddEventHandler(ngw->group.anchor,
				       StructureNotifyMask, False,
				       _anchorconfigured, (XtPointer)ngw);
		}
	}

	if ((Changed(anchor) && ngw->group.anchor != (Widget)NULL)	||
	    (Changed(anchor_name) && ngw->group.anchor != (Widget)NULL) ||
	    Changed(reference_point)	||
	    Changed(anchor_point)	||
	    Changed(h_offset)		||
	    Changed(v_offset)		||
	    (ngw->core.width != cgw->core.width ||
	     ngw->core.height != cgw->core.height) ||
	    (ngw->core.x != cgw->core.x ||
	     ngw->core.y != cgw->core.y)) {
		Position	new_x = ngw->core.x,
				new_y = ngw->core.y;

		if ((*gwc->group_class.position_anchor_relative)
		    (ngw, &new_x, &new_y, (Boolean)False)) {
			ngw->core.x = new_x;
			ngw->core.y = new_y;
		}
	}
	
	if (Changed(column_alignment)		        ||
	    (ngw->group.rows_set =  Changed(rows))      ||
	    (ngw->group.columns_set = Changed(columns)) ||
	    (ngw->group.min_x_set = Changed(min_x))     ||
	    (ngw->group.min_y_set = Changed(min_y))     ||
	    Changed(row_alignment)		        ||
	    Changed(h_space)			        ||
	    Changed(v_space)			        ||
	    Changed(minimise_row_col)) {
		PopulateGrid(ngw);
		LayoutGrid(ngw, (Widget)NULL, (Boolean)True, (Boolean)False);
	}

    return (False);
#undef Changed
}

static void
GroupResize OLARGLIST(( w ))
	OLGRA( Widget, w)
{
	GroupWidget		gw = (GroupWidget)w;
	GroupWidgetClass	gwc = (GroupWidgetClass)gw->core.widget_class;

	LayoutGrid(gw, (Widget)NULL, (Boolean)True, (Boolean)False);
}

static void
GroupChangeManaged OLARGLIST(( w ))
	OLGRA( Widget, w)
{
	GroupWidget		gw = (GroupWidget)w;
	GroupWidgetClass	gwc = (GroupWidgetClass)gw->core.widget_class;

	PopulateGrid(gw);
	LayoutGrid(gw, (Widget)NULL, (Boolean)True, (Boolean)True);
}

static XtGeometryResult
GroupGeometryManager OLARGLIST((w, req, rep))
	OLARG( Widget,			w)
	OLARG( XtWidgetGeometry *,	req)
	OLGRA( XtWidgetGeometry *,	rep)
{
	Position		save_x, save_y;
	Dimension		save_width, save_height, save_bw;
	Boolean			really_do_it;
	GroupWidget		gw = (GroupWidget)w->core.parent;
	GroupWidgetClass	gwc = (GroupWidgetClass)gw->core.widget_class;
	XtGeometryResult	result = XtGeometryYes;

	*rep = *req;

	if ((req->request_mode & ~(CWStackMode & CWSibling)) == 0)
		return XtGeometryYes;	/* allow stacking order changes */

	save_x = w->core.x;
	save_y = w->core.y;

	if ((req->request_mode & XtCWQueryOnly) != XtCWQueryOnly &&
	    ((req->request_mode & CWX) == CWX ||
	     (req->request_mode & CWY) == CWY)) {
		if ((req->request_mode & CWX) == CWX)
			w->core.x = req->x;
		if ((req->request_mode & CWY) == CWY)
			w->core.y = req->y;
		PopulateGrid(gw);
	}

	save_width  = w->core.width;
	save_height = w->core.height;
	save_bw     = w->core.border_width;

	if ((req->request_mode & CWWidth) == CWWidth)
		w->core.width = req->width;
	if ((req->request_mode & CWHeight) == CWHeight)
		w->core.height = req->height;
	if ((req->request_mode & CWBorderWidth) == CWBorderWidth)
		w->core.border_width = req->border_width;

	really_do_it = (req->request_mode & XtCWQueryOnly) != XtCWQueryOnly;

	if (really_do_it)
		_OlDnDSetDisableDSClipping((Widget)gw, True);

	if (LayoutGrid(gw, w, really_do_it, really_do_it)) {

		if (!really_do_it) {
			w->core.x            = save_x;
			w->core.y            = save_y;
			w->core.width        = save_width;
			w->core.height       = save_height;
			w->core.border_width = save_bw;
		}

		if ((req->request_mode & CWX) == CWX && save_x != w->core.x) {
			rep->x = w->core.x;
			rep->request_mode |= CWX;
			result = XtGeometryAlmost;
		}
		if ((req->request_mode & CWY) == CWY && save_y != w->core.y) {
			rep->y = w->core.y;
			rep->request_mode |= CWY;
			result = XtGeometryAlmost;
		}
	} else {
		w->core.x            = save_x;
		w->core.y            = save_y;
		w->core.width        = save_width;
		w->core.height       = save_height;
		w->core.border_width = save_bw;

		result = XtGeometryNo;
	}

	if (really_do_it) {
		_OlDnDSetDisableDSClipping((Widget)gw, False);
		if (result == XtGeometryYes) 
			OlDnDWidgetConfiguredInHier((Widget)gw);
	}

	return (result);
}

static XtGeometryResult
GroupQueryGeometry OLARGLIST((w, rep, req))
	OLARG( Widget,			w)
	OLARG( XtWidgetGeometry *,	req)
	OLGRA( XtWidgetGeometry *,	rep)
{
	XtGeometryResult	result = XtGeometryYes;
	Dimension		width, height;
	Position		x = w->core.x,
				y = w->core.y;
	GroupWidget		gw = (GroupWidget)w;
	GroupWidgetClass	gwc = (GroupWidgetClass)gw->core.widget_class;

	(void)
	(*gwc->group_class.position_anchor_relative)
		((GroupWidget)w, &x, &y, (Boolean)False);

	CalculateGroupWidthHeight(gw, &width, &height);

#define	SetIF(flags, field, relop, var)					    \
	if ((req->request_mode & flags) == flags && req->field relop var) { \
		rep->request_mode |= flags;				    \
		rep->field = var;					    \
		result = XtGeometryAlmost;				    \
	}

	SetIF(CWX, x,!=,x);
	SetIF(CWY, y,!=,y);
	SetIF(CWWidth, width, < , width);
	SetIF(CWHeight, height, <, height);

#undef  SetIF
        return (result);
}

static Boolean
PositionAnchorRelative OLARGLIST((group, new_x, new_y, doit))
	OLARG(GroupWidget,	group)
	OLARG(Position *,	new_x)
	OLARG(Position *,	new_y)
	OLGRA(Boolean,		doit)
{
#define	BUFF	8
	Widget			cache1[BUFF * 4], *anchor_ancestors = cache1, 
				cache2[BUFF * 4], *group_ancestors  = cache2,
				common = (Widget)NULL;

	XtGeometryResult	result = XtGeometryNo;

	register Widget		*anc = anchor_ancestors,
				*grp = group_ancestors,
				p,
				q,
				anchor;

#define	SizeOfStkCache(cache)	(sizeof(cache) / sizeof(cache[0]))
#define	StkCacheOvFlw(ptr, cache)			\
	(ptr == (cache + SizeOfStkCache(cache)))
#define	BufferOvFlw(ptr, buffer, cache)			\
	(ptr > (buffer + SizeOfStkCache(cache)) && 	\
	 ((ptr - buffer) % BUFF) == 0)
#define	IsStkCache(ptr, cache)				\
	(ptr >= cache && 				\
	 ptr < (cache + SizeOfStkCache(cache)))

	if (group->group.anchor == (Widget)NULL) {
			goto wayout;
	}

	if (new_x != (Position *)NULL)
		*new_x = group->core.x;
	if (new_y != (Position *)NULL)
		*new_y = group->core.y;

	if (!XtIsRealized(group->group.anchor)) {
		Widget	w = group->group.anchor, parent = XtParent(w);

		for (; parent != (Widget)NULL && !XtIsRealized(parent);
		       (w = parent), (parent = XtParent(w)))
		;

		XtRealizeWidget(w);
	}

	/* find their common ancestor */

	for ((p = group->group.anchor), (q = (Widget)group);
	     p != (Widget)NULL || q != (Widget)NULL;) {
	     
		if (p == q) common = p;

		if (p != (Widget)NULL) {
			if (BufferOvFlw(anc, anchor_ancestors, cache1) ||
			    StkCacheOvFlw(anc, cache1)) {
				if (StkCacheOvFlw(anc, cache1)) {
					anchor_ancestors = (Widget *)
						XtCalloc(SizeOfStkCache(cache1)
						      + BUFF, sizeof (Widget));

					bcopy((char *)cache1, 
					      (char *)anchor_ancestors,
					      SizeOfStkCache(cache1));
					anc = anchor_ancestors +
					      SizeOfStkCache(cache1);
				} else {
					int	off = anc - anchor_ancestors;
					anchor_ancestors = (Widget *)XtRealloc(
						(char *)anchor_ancestors,
						 off + BUFF);

					anc = anchor_ancestors + off;
				}
			}

			*anc++ = p;
			p = XtParent(p);
		}

		if (q != (Widget)NULL) {
                        if (BufferOvFlw(grp, group_ancestors, cache2) ||
                            StkCacheOvFlw(grp, cache2)) {
                                if (StkCacheOvFlw(grp, cache2)) {
                                        group_ancestors = (Widget *)
                                                XtCalloc(SizeOfStkCache(cache2)                                                      + BUFF, sizeof (Widget));
                                        bcopy((char *)cache2,
                                              (char *)group_ancestors,
                                              SizeOfStkCache(cache2));
                                        grp = group_ancestors +
                                              SizeOfStkCache(cache2);
                                } else {
                                        int     off = grp - group_ancestors;
                                        group_ancestors = (Widget *)XtRealloc(
                                                (char *)group_ancestors,
                                                 off + BUFF);

                                        grp = group_ancestors + off;
                                }
                        }

                        *grp++ = q;
			q = XtParent(q);
                 }

			if (common != (Widget)NULL)
				goto gotcommon; /* found a common ancestor */
	}

	if (common == (Widget)NULL && *--grp == *--anc) {
		register Widget	*pp, *qq;

		for (pp = group_ancestors; pp <= grp; pp++)
			for (qq = anchor_ancestors; qq <= anc; qq++)
				if (*pp == *qq) {
					common = *pp;
					goto gotcommon;
				}
	}

	if (common == (Widget)NULL) goto wayout; /* give up! */

	/* finally we have it ... */

gotcommon:

	{
		register Position 	x = (Position)0,
					y = (Position)0;

		anchor = group->group.anchor;

		if (anchor != common) {
			x = anchor->core.x;
			y = anchor->core.y;
		}

		switch (group->group.anchor_point) {
			case OL_NORTH:
				x += anchor->core.border_width + 
				     (anchor->core.width / 2);
				break;

			case OL_NORTHEAST:
				x += anchor->core.width +
				     (2 * anchor->core.border_width);
				break;

			case OL_EAST:
				x += anchor->core.width +
				     (2 * anchor->core.border_width);
				y += anchor->core.border_width +
				     (anchor->core.height / 2);
				break;

			case OL_SOUTHEAST:
				x += anchor->core.width +
				     (2 * anchor->core.border_width);
				y += anchor->core.height +
                                     (2 * anchor->core.border_width);
				break;

			case OL_SOUTH:
				x += anchor->core.border_width +
				     (anchor->core.width / 2);
				y += anchor->core.height  +
                                     (2 * anchor->core.border_width);
				break;

			case OL_SOUTHWEST:
				y += anchor->core.height +
                                     (2 * anchor->core.border_width);
				break;

			case OL_WEST:
				y += anchor->core.border_width +
				     (anchor->core.height / 2);
				break;

			case OL_NORTHWEST:
			default:
				break;
			case OL_CENTER:
				x += anchor->core.border_width +
				     (anchor->core.width / 2);
				y += anchor->core.border_width +
				     (anchor->core.height / 2);
				break;

		};


		/* map anchor co-ordinates into space of common widget */

		if (anchor != common &&
		    anchor_ancestors[1] != common) {
			register Widget	*pp;

			for (pp = anchor_ancestors + 2; *pp != common; pp++) {
				x += (*pp)->core.x + (*pp)->core.border_width;
				y += (*pp)->core.y + (*pp)->core.border_width;
			}
		}

		x += group->group.h_offset;
		y += group->group.v_offset;

		/* map offsets back into cordinate space of groups parent */

		if (group_ancestors[1] != common) {
			register Widget	*pp;

			for (pp = group_ancestors + 2; *pp != common; pp++) {
				x -= (*pp)->core.x + (*pp)->core.border_width;
				y -= (*pp)->core.y + (*pp)->core.border_width;
			}
		}

		switch (group->group.reference_point) {
			case OL_NORTH:
				x -= group->core.border_width + 
				     (group->core.width / 2);
				break;

			case OL_NORTHEAST:
				x -= group->core.width +
				     (2 * group->core.border_width);
				break;

			case OL_EAST:
				x -= group->core.width +
				     (2 * group->core.border_width);
				y -= group->core.border_width +
				     (group->core.height / 2);
				break;

			case OL_SOUTHEAST:
				x -= group->core.width +
				     (2 * group->core.border_width);
				y -= group->core.height +
                                     (2 * group->core.border_width);
				break;

			case OL_SOUTH:
				x -= group->core.border_width +
				     (group->core.width / 2);
				y -= group->core.height  +
                                     (2 * group->core.border_width);
				break;

			case OL_SOUTHWEST:
				y -= group->core.height +
                                     (2 * group->core.border_width);
				break;

			case OL_WEST:
				y -= group->core.border_width +
				     (group->core.height / 2);
				break;

			case OL_NORTHWEST:
			default:
				break;
			case OL_CENTER:
				x -= group->core.border_width +
				     (group->core.width / 2);
				y -= group->core.border_width +
				     (group->core.height / 2);
				break;
		};

		if (doit && (x != group->core.x || y != group->core.y)) {
			XtWidgetGeometry	rep, req;
			req.request_mode = (CWX | CWY);
			req.x = x;
			req.y = y;


			_OlDnDSetDisableDSClipping(group, True);
			result = XtMakeGeometryRequest(group, &req, &rep);
			switch (result) {
				case XtGeometryAlmost:
					req = rep;
					result = XtMakeGeometryRequest(group,
								       &req,
								       &rep);
				case XtGeometryYes:
					x = req.x;
					y = req.y;
					break;

				case XtGeometryNo:
					x = group->core.x;
					y = group->core.y;
			}
			_OlDnDSetDisableDSClipping(group, False);
			OlDnDWidgetConfiguredInHier(group);
			
		} else result = XtGeometryYes;

		if (new_x != (Position *)NULL)
			*new_x = x;
		if (new_y != (Position *)NULL)
			*new_y = y;
			
	}

wayout:
	if (!IsStkCache(anc, cache1))
		XtFree((char *)anchor_ancestors);

	if (!IsStkCache(grp, cache2))
		XtFree((char *)group_ancestors);

#undef	SizeOfStkCache
#undef	StkCacheOvFlw
#undef	IsStkCache
#undef	BufferOvFlw
	return (result == XtGeometryNo);
}
