/* xdf version 1.3 Dec 21st 1997
   by Georg C. F. Greve (greve@fusebox.hanse.de)
   */

/*{{{  Header  */

/* Standard C++ includes */
#include <stdio.h>
#include <iostream.h>
#include <strstream.h>
#ifdef __linux__
#include <syscall.h>
#endif
#include <sys/param.h>
#include <sys/types.h>
#include <sys/vfs.h>
#include <unistd.h>
#include <ctype.h>
#include <pwd.h>
#include <stdlib.h>
#include <assert.h>
#if defined(__sun__) && !defined(__linux__)
#include <sys/mnttab.h>
#include <sys/mntent.h>
#include <sys/vfstab.h>
#else
#include <mntent.h>
#endif
#include <sys/mount.h>
#include <sys/vfs.h>

/* Xlib includes */
#include <X11/Xlib.h>
#include <X11/Xresource.h>
#include <xview/xview.h>
#include <xview/frame.h>
#include <xview/panel.h>
#include <xview/notify.h>
#include <xview/cms.h>
#include <xview/svrimage.h>

#include "config.H"
#include "xdf.H"
#include "galaxy.xbm"
/*}}}*/

/*{{{  Initialisation (Main)  */
int main(int argc, char* argv[]){

  prgname = argv[0];

  XrmInitialize();
  xv_init(XV_INIT_ARGC_PTR_ARGV, &argc, argv, NULL);

  if ( parseUseroptions(&argc, argv) == ERROR ) return ERROR;
  
  Server_image image = (Server_image) xv_create ( (Xv_Screen) NULL, SERVER_IMAGE,
						  XV_WIDTH, galaxy_width,
						  XV_HEIGHT, galaxy_height,
						  SERVER_IMAGE_X_BITS, galaxy_bits,
						  NULL); 
  

  frame = (Frame) xv_create ( (long unsigned int) NULL, FRAME, 
			      FRAME_LABEL, VERSION,
			      NULL);

  Icon icon = (Icon) xv_create(frame, ICON,
			       ICON_IMAGE, image,
			       XV_X, galaxy_width,
			       XV_Y, galaxy_height,
			       NULL);

  xv_set(frame, FRAME_ICON, icon, NULL);

  panel = (Panel) xv_create (frame, PANEL, 
			     WIN_ROW_GAP, 8,
			     WIN_COLUMN_GAP, 80,
			     NULL);


/*{{{  Get Information and create Panel  */
  row = 0;

#if defined(__sun__) && !defined(__linux__)
  vfs_table = new vfstab;
  fd_fstab = fopen(VFSTAB,"r");

  mountpoints=0;
  while ((ret = getvfsent(fd_fstab,vfs_table) ) >= 0 ) {
   if ( ret == 0
        && vfs_table->vfs_mountp != NULL
        && vfs_table->vfs_fstype != NULL ) {
     if ( strcmp( "swap", vfs_table->vfs_mountp)
	 && strcmp( "/proc", vfs_table->vfs_mountp)
	 && strcmp( "/dev/fd", vfs_table->vfs_mountp)
	 && strcmp( "devfs", vfs_table->vfs_fstype)
	 && strcmp( "ctfs", vfs_table->vfs_fstype)
	 && strcmp( "objfs", vfs_table->vfs_fstype)
 	 && ( strcmp( "nfs", vfs_table->vfs_fstype ) || ( ! no_nfs ) )
 	 && ( strcmp( "hsfs", vfs_table->vfs_fstype ) || ( ! no_iso9660 ) )
 	 ){
       par_table[mountpoints] = new Partition;
       par_table[mountpoints]->name = new char[ strlen(vfs_table->vfs_mountp) + 1 ];
       strcpy(par_table[mountpoints]->name, vfs_table->vfs_mountp);
       statvfs(par_table[mountpoints]->name, &stat_buffer);
       par_table[mountpoints]->last_max_value = 
 	par_table[mountpoints]->max_value = ((double)stat_buffer.f_blocks * (double)stat_buffer.f_frsize) / (double) 1024;
       par_table[mountpoints]->last_value = 
	par_table[mountpoints]->max_value - (((double)stat_buffer.f_bfree * (double)stat_buffer.f_frsize)/ (double) 1024);
       create_size_string (par_table[mountpoints]->string_maxsize, par_table[mountpoints]->max_value,par_table[mountpoints]->max_value, TOTAL );
       create_size_string (par_table[mountpoints]->string_size, par_table[mountpoints]->last_value,par_table[mountpoints]->max_value, FULL);
       create_size_string (par_table[mountpoints]->string_freesize, (double) ( par_table[mountpoints]->max_value - par_table[mountpoints]->last_value ),par_table[mountpoints]->max_value, FREE);
       par_table[mountpoints]->status = TRUE;
       par_table[mountpoints]->last_value = -1;
       mountpoints++;
     }
   }
  }
  fclose(fd_fstab);
#else
  fd_fstab = setmntent( "/etc/fstab", "r");

  mountpoints=0;
  while ( table = getmntent( fd_fstab ) ) {
    if ( strcmp( "swap", table->mnt_dir) && strcmp( "/proc", table->mnt_dir) 
	 && ( strcmp( "nfs", table->mnt_type ) || ( ! no_nfs ) )
	 && ( strcmp( "iso9660", table->mnt_type ) || ( ! no_iso9660 ) )
	 ){
      par_table[mountpoints] = new Partition;
      par_table[mountpoints]->name = new char[ strlen(table->mnt_dir) + 1 ];
      strcpy(par_table[mountpoints]->name, table->mnt_dir);
      statfs(par_table[mountpoints]->name, &stat_buffer);
      par_table[mountpoints]->last_max_value = 
	par_table[mountpoints]->max_value = ((double)stat_buffer.f_blocks * (double)stat_buffer.f_bsize) / (double) 1024;
      par_table[mountpoints]->last_value = 
	par_table[mountpoints]->max_value - (((double)stat_buffer.f_bfree * (double)stat_buffer.f_bsize)/ (double) 1024);
      create_size_string (par_table[mountpoints]->string_maxsize, par_table[mountpoints]->max_value,par_table[mountpoints]->max_value, TOTAL );
      create_size_string (par_table[mountpoints]->string_size, par_table[mountpoints]->last_value,par_table[mountpoints]->max_value, FULL);
      create_size_string (par_table[mountpoints]->string_freesize, (double) ( par_table[mountpoints]->max_value - par_table[mountpoints]->last_value ),par_table[mountpoints]->max_value, FREE);
      par_table[mountpoints]->status = TRUE;
      par_table[mountpoints]->last_value = -1;
      mountpoints++;
    }

  }
  endmntent( fd_fstab );
#endif

/*{{{  Title strings  */

  if ( title == TRUE ){
    xv_create(panel, PANEL_MESSAGE,
	      PANEL_LABEL_STRING, "mountpoint",
	      XV_X, xv_col(panel, 0),
	      XV_Y, xv_row(panel, row),
	      PANEL_LABEL_BOLD, TRUE,
	      NULL);
    
    xv_create(panel, PANEL_MESSAGE,
	      PANEL_LABEL_STRING, "total",
	      XV_X, xv_col(panel, 1),
	      XV_Y, xv_row(panel, row),
	      PANEL_LABEL_BOLD, TRUE,
	      NULL);
    
    xv_create(panel, PANEL_MESSAGE,
	      PANEL_LABEL_STRING, "used",
	      XV_X, xv_col(panel, 2),
	      XV_Y, xv_row(panel, row),
	      PANEL_LABEL_BOLD, TRUE,
	      NULL);
    
    xv_create(panel, PANEL_MESSAGE,
	      PANEL_LABEL_STRING, "free",
	      XV_X, xv_col(panel, 5),
	      XV_Y, xv_row(panel, row),
	      PANEL_LABEL_BOLD, TRUE,
	      NULL);

    row++;
  }

/*}}}*/

  for (int i = 0; i < mountpoints ; ++i){

    if ( strlen(par_table[i]->name) <= 12 ) strcpy(par_table[i]->panelname, par_table[i]->name);
    else {
      int spos = strlen(par_table[i]->name);
      for ( int tpos = 13 ; tpos >= 0 ; tpos-- ){
      if ( tpos < 3 ) par_table[i]->panelname[tpos] = '.';
      else par_table[i]->panelname[tpos] = par_table[i]->name[spos--];
      }
    }

    par_table[i]->name_item = xv_create(panel, PANEL_MESSAGE,
					PANEL_LABEL_STRING, par_table[i]->panelname,
					XV_X, xv_col(panel, 0),
					XV_Y, xv_row(panel, row),
					PANEL_INACTIVE, TRUE,
					NULL);

    par_table[i]->maxsize_item = xv_create(panel, PANEL_MESSAGE,
					   PANEL_LABEL_STRING, "",
					   XV_X, xv_col(panel, 1),
					   XV_Y, xv_row(panel, row),
					   NULL);
    
    par_table[i]->fillsize_item = xv_create(panel, PANEL_TEXT,
					    PANEL_VALUE, "",
					    PANEL_VALUE_DISPLAY_LENGTH, 9,
					    PANEL_VALUE_STORED_LENGTH, 30,
					    PANEL_READ_ONLY, TRUE,
					    PANEL_INACTIVE, TRUE,
					    XV_X, xv_col(panel, 2),
					    XV_Y, xv_row(panel, row),
					    NULL);

    par_table[i]->gauge = xv_create(panel, PANEL_GAUGE,
				    PANEL_GAUGE_WIDTH, 150,
				    PANEL_VALUE, 
				    (int) 0,
				    PANEL_MIN_VALUE, 0,
				    PANEL_MAX_VALUE, 100,
				    PANEL_TICKS, 11,
				    PANEL_INACTIVE, TRUE,
				    PANEL_LABEL_BOLD, FALSE,
				    XV_X, xv_col(panel, 3)-5,
				    XV_Y, xv_row(panel, row),
				    NULL);

    par_table[i]->freesize_item = xv_create(panel, PANEL_TEXT,
					    PANEL_VALUE, "",
					    PANEL_VALUE_DISPLAY_LENGTH, 9,
					    PANEL_VALUE_STORED_LENGTH, 30,
					    PANEL_READ_ONLY, TRUE,
					    PANEL_INACTIVE, TRUE,
					    XV_X, xv_col(panel, 5),
					    XV_Y, xv_row(panel, row++),
					    NULL);

  }
  
  window_fit(panel);
  window_fit(frame);
  xv_set(frame, XV_SHOW, TRUE, NULL);

/*}}}*/

  timer.it_value.tv_usec = 500 * 1000 ;
  timer.it_interval.tv_usec = 500 * 1000 ;
  notify_set_itimer_func(frame, (Notify_func) timer_routine, ITIMER_REAL,
			 &timer, NULL);

  xv_main_loop (frame);
  return TRUE;

}
/*}}}*/

/*{{{  Subroutines  */
/*{{{  XV Subroutines  */
void quit(){
  xv_destroy_safe(frame);
}


/*}}}*/
/*{{{  Timer Routine  */
Notify_value timer_routine(){

/*{{{  See which ones are mounted and change Panel accordingly  */

  for ( int i = 0 ; i < mountpoints ; ++i ){
    par_table[i]->last_status = par_table[i]->status;
    par_table[i]->status = TRUE;
  }

#if defined(__sun__) && !defined(__linux__)
  fd_mtab = fopen(MNTTAB, "r");
  mnt_table = new mnttab;
  while ( ( ret = getmntent( fd_mtab, mnt_table ) ) >= 0 ){
  if ( ret == 0 && mnt_table->mnt_mountp != NULL ) {
      for ( int i = 0 ; i < mountpoints ; ++i ){
        if ( !strcmp(par_table[i]->name, mnt_table->mnt_mountp) ) par_table[i]->status = FALSE;
      }
    }
  }
  fclose(fd_mtab);

#else  
  fd_mtab = setmntent( "/etc/mtab", "r");
  while ( table = getmntent( fd_mtab ) ){
    for ( int i = 0 ; i < mountpoints ; ++i ){
      if ( !strcmp(par_table[i]->name, table->mnt_dir) ) par_table[i]->status = FALSE;
    }
  }
  endmntent( fd_mtab );
#endif

  for ( int i = 0 ; i < mountpoints ; ++i ){
    if ( par_table[i]->status == FALSE && par_table[i]->last_status == TRUE) {
      // Yes, we are mounted:
      par_table[i]->last_value = -1;
      xv_set(par_table[i]->name_item, PANEL_INACTIVE, FALSE, NULL);
      xv_set(par_table[i]->maxsize_item, PANEL_INACTIVE, FALSE, NULL);
      xv_set(par_table[i]->fillsize_item, PANEL_INACTIVE, FALSE, NULL);
      xv_set(par_table[i]->freesize_item,PANEL_INACTIVE, FALSE, NULL);
      xv_set(par_table[i]->gauge, PANEL_INACTIVE, FALSE, NULL);
      
      xv_set(par_table[i]->maxsize_item,PANEL_LABEL_STRING, par_table[i]->string_maxsize, NULL);
      xv_set(par_table[i]->fillsize_item,PANEL_VALUE, par_table[i]->string_size, NULL);
      xv_set(par_table[i]->freesize_item,PANEL_VALUE, par_table[i]->string_freesize, NULL);
      
    } else if ( par_table[i]->status == TRUE && par_table[i]->last_status == FALSE ) {
      // No, we are not mouted:
      
      xv_set(par_table[i]->name_item, PANEL_INACTIVE, TRUE, NULL);
      xv_set(par_table[i]->maxsize_item, PANEL_LABEL_STRING, "" ,PANEL_INACTIVE, TRUE, NULL);
      xv_set(par_table[i]->fillsize_item,  PANEL_VALUE, "" ,PANEL_INACTIVE, TRUE, NULL);
      xv_set(par_table[i]->freesize_item, PANEL_VALUE, "" ,PANEL_INACTIVE, TRUE, NULL);
      xv_set(par_table[i]->gauge,  PANEL_VALUE, 0 ,PANEL_INACTIVE, TRUE, NULL);
      
    }
  }
  
/*}}}*/

  for ( int i = 0 ; i < mountpoints ; ++i )
    if ( par_table[i]->status == FALSE ){

#if defined(__sun__) && !defined(__linux__)
      statvfs(par_table[i]->name, &stat_buffer);
      par_table[i]->max_value = ( (double) stat_buffer.f_blocks * (double)stat_buffer.f_frsize) / (double) 1024;
#else
      statfs(par_table[i]->name, &stat_buffer);
      par_table[i]->max_value = ( (double) stat_buffer.f_blocks * (double)stat_buffer.f_bsize) / (double) 1024;
#endif

      if ( par_table[i]->max_value != par_table[i]->last_max_value ){
	create_size_string (par_table[i]->string_maxsize, par_table[i]->max_value,par_table[i]->max_value, TOTAL);

	xv_set(par_table[i]->maxsize_item,PANEL_LABEL_STRING, par_table[i]->string_maxsize, NULL);

	par_table[i]->last_value = -1; // We definitely want new 
	// values for the other stuff
      }
      par_table[i]->last_max_value = par_table[i]->max_value;
      
#if defined(__sun__) && !defined(__linux__)
      double  new_value = par_table[i]->max_value - (( (double)stat_buffer.f_bfree * (double)stat_buffer.f_frsize) / (double) 1024);
#else
      double  new_value = par_table[i]->max_value - (( (double)stat_buffer.f_bfree * (double)stat_buffer.f_bsize) / (double) 1024);
#endif

      if ( par_table[i]->last_value != new_value ){
	par_table[i]->last_value = new_value;
	create_size_string (par_table[i]->string_size, par_table[i]->last_value, par_table[i]->max_value, FULL);
	create_size_string (par_table[i]->string_freesize, (double) ( par_table[i]->max_value - par_table[i]->last_value ),par_table[i]->max_value, FREE);
	
	xv_set(par_table[i]->fillsize_item,PANEL_VALUE, par_table[i]->string_size, NULL);
	xv_set(par_table[i]->freesize_item,PANEL_VALUE, par_table[i]->string_freesize, NULL);
	
	// Now update gauge:
	int percent_full = (int) ((double) ( (double) 100 *  par_table[i]->last_value ) /  par_table[i]->max_value );
	xv_set (par_table[i]->gauge, PANEL_VALUE, percent_full, NULL);
      }

      if ((double) ( par_table[i]->max_value - par_table[i]->last_value ) <= ( critical / (double) 1024  ) ){
	
	if ( --par_table[i]->counter == 0 )
	  if ( par_table[i]->color == TRUE ){
	    par_table[i]->color = FALSE;
	    xv_set(par_table[i]->gauge, PANEL_ITEM_COLOR, 3 , NULL);
	    par_table[i]->counter = 1;
	  } else {
	    par_table[i]->color = TRUE;
	    xv_set(par_table[i]->gauge, PANEL_ITEM_COLOR, -1 , NULL);
	    par_table[i]->counter = 1;
	  }
	
      } else if ( par_table[i]->color == FALSE ) {
	par_table[i]->color = TRUE;
	xv_set(par_table[i]->gauge, PANEL_ITEM_COLOR, -1 , NULL);
	par_table[i]->counter = 1;
      }
    } 
  
  return NOTIFY_DONE;
}
/*}}}*/
/*{{{  Create String Subroutine  */
void create_size_string(char* string, double value, double maximum, int target){
  ostrstream OSS(string, STRLENGTH, ios::out);
  OSS.seekp(ios::beg);
  char* unit="K";
  int precision = kprec;

  if ( ( target == FULL && full_as_percent )
       || ( target == FREE && free_as_percent ) ){
    value /= ( (double) maximum / (double) 100 );
    unit = " %";
    precision = pprec;
  }  else if ( (((double) 1024 ) * value)  >= (double) giglim ){
    value /= (double) ((double) 1024 * (double) 1024);
    unit = "G";
    precision = gigprec;
  } else if ( (((double) 1024 ) * value)  >= (double) meglim ){
    value /= (double) 1024;
    unit = "M";
    precision = megprec;
  }
  
  OSS.setf(ios::fixed, ios::floatfield);
  OSS.precision( precision );
  OSS << value << unit << " " << ends;
  
}
/*}}}*/
/*{{{  Commandline & default evaluation  */
/* Subroutines for User defaults and commandline options */
void Usage(){
  cout << VERSION << " by Georg C. F. Greve (greve@fusebox.hanse.de)" << endl << endl;
  cout << "Usage: xdf [ -mlim n[K/M/G] ] [ -glim n[K/M/G] ] [ -kprec n ] [-mprec n ] [ -gprec n ] [ -pprec n ] [ -dused p/v ] [ -dfree p/v ] [ -titlestrings y/n ] [ -warn n[K/M/G] ]" << endl;
  return;
}
int parseUseroptions(int *argc, register char *argv[]){
  char environment[2048];
  XrmValue value;
  char str_buf[60];
  char *str_type=str_buf;

  XrmParseCommand(&commandlineDB, opTable, opTableEntries, "xdf", argc, argv);
  
  if (*argc != 1 ) {
    Usage();
    return ERROR;
  }
  
  // Open  ~/.xdf
  int len;
  getHomeDir(environment);
  (void) strcat(environment, "/.xdf");
  localDB = XrmGetFileDatabase(environment);
  XrmMergeDatabases(localDB, &rDB);
  
  // Commandline has priority:
  XrmMergeDatabases(commandlineDB, &rDB);

  if ( XrmGetResource(rDB, "xdf*mlim", "Xdf*Mlim", &str_type, &value)  ) 
    meglim = evalNumber( value.addr, value.size );

  if ( XrmGetResource(rDB, "xdf*glim", "Xdf*Glim", &str_type, &value)  ) 
    giglim = evalNumber( value.addr, value.size );
 
  if ( XrmGetResource(rDB, "xdf*kprec", "Xdf*Kprec", &str_type, &value)  )
    kprec = (int) evalNumber( value.addr, value.size );

  if ( XrmGetResource(rDB, "xdf*mprec", "Xdf*Mprec", &str_type, &value)  )
    megprec = (int) evalNumber( value.addr, value.size );

  if ( XrmGetResource(rDB, "xdf*gprec", "Xdf*Gprec", &str_type, &value)  )
    gigprec = (int) evalNumber( value.addr, value.size );

  if ( XrmGetResource(rDB, "xdf*pprec", "Xdf*Pprec", &str_type, &value)  )
    pprec = (int) evalNumber( value.addr, value.size );

  if ( XrmGetResource(rDB, "xdf*dused", "Xdf*Dused", &str_type, &value)  ){
    if ( value.addr[0] == 'p' || value.addr[0] == 'P' )
      full_as_percent = TRUE;
    else
      full_as_percent = FALSE;
  }

  if ( XrmGetResource(rDB, "xdf*dfree", "Xdf*Dfree", &str_type, &value)  ){
    if ( value.addr[0] == 'p' || value.addr[0] == 'P' )
      free_as_percent = TRUE;
    else
      free_as_percent = FALSE;
  }

  if ( XrmGetResource(rDB, "xdf*titlestrings", "Xdf*Titlestrings", &str_type, &value)  ){
    if ( value.addr[0] == 'y' || value.addr[0] == 'Y' )
      title = TRUE;
    else
      title = FALSE;
  }

  if ( XrmGetResource(rDB, "xdf*warn", "Xdf*Warn", &str_type, &value)  )
    critical = evalNumber( value.addr, value.size );

  return OK;
}
void getHomeDir( char* dest){
  int uid;
  extern struct passwd *getpwuid_r();
  struct passwd *pw;
  register char *ptr;
  
  if ((ptr = getenv("HOME")) != NULL) {
    (void) strcpy(dest, ptr);
  } else {
    if ((ptr = getenv("USER")) != NULL) {
      pw = getpwnam(ptr);
    } else {
      *dest = ' ';
    }
  }
  return;
}
double evalNumber( char* source, int length ){
  double number = 0;
  int i = 0;
  double divisor = 0;

  while ( i < length ){
    char x = source[i++];
    
    if ( x == 'K' || x == 'k' ){
      number *= (double) 1024;
      i = length;
    } else if ( x == 'M' || x == 'm' ){
      number *= (double) ( ((double) 1024) * ((double) 1024) );
      i = length;
    } else if ( x == 'G' || x == 'g' ){
      number *= (double) ( ((double) 1024) * ((double) 1024) * ((double) 1024) );
      i = length;
    } else if ( x == '.' || x == ',' ){
      divisor = 1;
    } else if ( x >= '0' && x<= '9'){
      number *= (double) 10;
      number += (double) ( x - '0' );
      divisor *= (double) 10;
    }
  }
  
  if ( divisor != 0 ) number /= divisor;
  
  return number;
}
/*}}}*/
/*}}}*/
