/* 
   Configuration file for XDiskFree
   This is the only file you should edit
*/

/*

  These are the compiletime options that serve as the
  default options at runtime.

 */

/*
  Should NFS filesystems be suppressed in the display ?
  just comment this line out if you want to see the NFS
  systems - but remember: this MIGHT hang your XServer
  when the NFS system is running into timing problems !

  recommended setting is to have this option enabled !

*/

#define NO_NFS TRUE

/*
  Should ISO9660 filesystems be left out ?
  just comment this line out if you want ISO9660 file-
  systems to be displayed
*/

#define NO_ISO9660 TRUE

/*
  If you want the "mountpoint total full    free"
  strings, enable this...
 */

// #define TITLE_STRINGS TRUE

/*
  The MEGLIM & GIGLIM parameters determine when the program
  starts to display Megabytes/Gigabytes instead of Kilobytes.
  A MEGLIM of 100 and a GIGLIM of 1 means that numbers bigger
  than 100Meg will be displayed as Megabytes instead of Kilobytes
  numbers bigger than 1 Gig will be displayed in Gigaybtes instead
  of Megabytes.
 */

#define MEGLIM 100
#define GIGLIM 1

/*
  If you want the free or full amount of space to be displayed as a
  percentage of the total than an absolute number, just uncomment
  the following lines:
 */

// #define FULL_AS_PERCENT TRUE
// #define FREE_AS_PERCENT TRUE

/*
  the "XPREC" parameters (K for Kilobytes, M for Mega-
  bytes, G for Gigabytes, P for Percentage) give the number 
  of trailing numbers for each of the display sizes - Kilobytes, 
  Megabytes, Gigabytes... change it as you like, but the predefine
  settings should be somewhat "sane".
 */

#define KPREC 1
#define MEGPREC 2
#define GIGPREC 3
#define PPREC 2

/*
  When should xdf start to warn that the space is running low ?
*/

#define WARN 0
