/* $Id: root.c,v 1.5 1999/03/18 14:11:28 root Exp $ */

/* Copyright 1991 Tomas Stephanson Ellemtel */
/* Copyright 1996 Tomas Stephanson Ericsson */

/* program for displaying the rootmenu */


#include <stdio.h>
#include <sys/param.h>
#include <sys/types.h>
#include <xview/xview.h>
#include <xview/panel.h>
#include <xview/textsw.h>
#include <xview/xv_xrect.h>
#include <xview/notice.h>
#ifdef SVR4
#include <sys/utsname.h>
#endif

Frame Fframe;
Panel_item Label;
Panel panel;
int result;

extern char *getConsole();
#ifndef SVR4
extern char *getHostType();
#endif

struct itimerval timer = {60,0,60,0};
Notify_value update();
Notify_value rootmenu_frame_delete();

int Warn = FALSE;
int Silent = FALSE;
int Prompt = FALSE;

int
main(argc, argv)
	int		argc;
	char		**argv;
{
  /* Panel panel; */
  Panel_item button;
  Menu menu;
#ifdef SVR4
  struct utsname host;
  char header[SYS_NMLN];
#else
  char host[MAXHOSTNAMELEN];
  char header[MAXHOSTNAMELEN+10];
#endif
  char fotter[50];
  Xv_opaque icon_image;
  Xv_opaque icon_mask_image;
  static unsigned short icon_bits[] = {
#  include "root.icon"
  };
  static unsigned short icon_mask_bits[] = {
#  include "root_mask.icon"
  };
  int busy;
  int option;
  
  while ((option = getopt (argc, argv, "qvshw")) != EOF) {
    switch (option) {
    case 'q': Warn = TRUE; break;
    case 's': Silent = TRUE; break;
    case 'w': Prompt = TRUE; break;
    case 'v':
      printf("Rootmenu Version  $Revision: 1.5 $\n");
      exit(0);
    default:
      printf("Rootmenu Version  $Revision: 1.5 $\n");
      printf("Usage: [-q] [-s] [-w] [-v]\n");
      printf("-q Warn if sombody starts using the console\n");
      printf("-s Silent mode, display a more compact interface\n");
      printf("-w Display a Notice when user attempts to quite Rootmenu\n");
      printf("-v Print version info\n");
      exit(0);
    }
  }

  if (Silent)
    Warn = FALSE;



#if defined(SVR4) || defined (__linux__)
  uname(&host);
   
  strcpy(header,host.nodename);

  sprintf(fotter,"%s %dMB",getHostType(), getMem());
#else
  gethostname(host,sizeof(host));
  strcpy(header,host);

  sprintf(fotter,"%s",getHostType());
#endif

  /*
   * Initialize XView.
   */
  xv_init(XV_INIT_ARGC_PTR_ARGV, &argc, argv, 0);

  icon_image = xv_create(0, SERVER_IMAGE,
			 SERVER_IMAGE_BITS, icon_bits,
			 SERVER_IMAGE_DEPTH, 1,
			 XV_WIDTH, 64,
			 XV_HEIGHT, 64,
			 NULL);

  icon_mask_image = xv_create(0, SERVER_IMAGE,
			 SERVER_IMAGE_BITS, icon_mask_bits,
			 SERVER_IMAGE_DEPTH, 1,
			 XV_WIDTH, 64,
			 XV_HEIGHT, 64,
			 NULL);

  Fframe = xv_create((Xv_object) NULL, FRAME,
		     XV_LABEL, header,
		     FRAME_CLOSED, FALSE,
		     FRAME_SHOW_FOOTER, TRUE,
		     FRAME_SHOW_RESIZE_CORNER, TRUE,
		     OPENWIN_NO_MARGIN,TRUE,
		     OPENWIN_SHOW_BORDERS, TRUE,
		     FRAME_ICON, xv_create(0, ICON,
					   ICON_IMAGE, icon_image,
					   ICON_MASK_IMAGE, icon_mask_image,
					   0),
		     NULL);

  panel = xv_create(Fframe, PANEL,
		    XV_X, 0,
		    XV_Y, 0,
		    XV_WIDTH, WIN_EXTEND_TO_EDGE,
		    XV_HEIGHT, WIN_EXTEND_TO_EDGE,
	            XV_WIDTH, 150, XV_HEIGHT, 60,
		    WIN_BORDER, FALSE,
		    PANEL_LAYOUT, PANEL_VERTICAL,
		    NULL);

  if (Silent) {
     xv_set(Fframe,FRAME_SHOW_FOOTER, FALSE, NULL);
  } else {
     xv_set(Fframe,FRAME_LEFT_FOOTER, fotter, NULL);
  }

  button = xv_create(panel, PANEL_BUTTON,
		PANEL_LABEL_STRING, "RootMenu",
		NULL);


  setClass(Fframe,"Rootmenu","rootmenu");

  menu = getMenu(Fframe);

  xv_set(button,PANEL_LABEL_STRING,
	 xv_get(xv_get(menu,MENU_NTH_ITEM,1),MENU_STRING),NULL);

  xv_set(button,PANEL_ITEM_MENU, menu, NULL);

  if (!Silent)
     Label = xv_create(panel,PANEL_MESSAGE,
		    PANEL_LABEL_BOLD, TRUE,
		    PANEL_LABEL_STRING,"Nisse Hult",NULL);
		    
  check(Fframe);

  notify_set_itimer_func(Fframe,update,ITIMER_REAL,&timer,NULL);
  /* window_fit(panel); */
  window_fit(Fframe);
  notify_interpose_destroy_func (Fframe, rootmenu_frame_delete);
    
  /*
   * Turn control over to XView.
   */
  xv_main_loop(Fframe);
  exit(0);
}


#include <X11/Intrinsic.h>

setClass(frame,className,resName)
     Frame frame;
     char *className;
     char *resName;
{
  XClassHint	hints;
	
  hints.res_class = className;
  hints.res_name = resName;
  XSetClassHint((Display *) xv_get(frame, XV_DISPLAY), xv_get(frame, XV_XID), &hints);
}


/* Tell people to loggoff if not idle on console */

check(frame)
     Frame frame;
{
  static int busy;
  char *str;
  Xv_notice notice;

  str = getConsole(&busy);

  if (! Silent)
    xv_set(Label,PANEL_LABEL_STRING,str,NULL);

  if ( busy && Warn ) {

    notice = xv_create(frame,NOTICE,
		       NOTICE_LOCK_SCREEN, TRUE,
		       NOTICE_MESSAGE_STRINGS,
		       str,
		       "On Console",
		       "Please Loggof",
		       NULL,
		       NOTICE_BUTTON_YES, "Ok I will loggoff",
		       XV_SHOW, TRUE,
		       NULL);
  }
}

Notify_value 
update(frame)
Frame	frame;
{
  check(frame);

  return NOTIFY_DONE;
}

Notify_value
rootmenu_frame_delete (Notify_client client, Destroy_status status)
{
  Frame        frame;
  Xv_Notice    quit_notice;

  if(Prompt) {
        if (status == DESTROY_CHECKING) {
                result = notice_prompt(panel, NULL,
                        NOTICE_FOCUS_XY,        1, 1,
                        NOTICE_MESSAGE_STRINGS, "Are You Sure?", NULL,
                        NOTICE_BUTTON_YES,      "Yes",
                        NOTICE_BUTTON_NO,       "No",
                        NULL);
                if (result == NOTICE_NO) {
                        notify_veto_destroy(client);
                } else {
                        xv_destroy_safe(Fframe);
                        _exit(0);
                }
        }
  } else {
	xv_destroy_safe(Fframe);
	_exit(0);
  }
        return NOTIFY_DONE;

}
