/* $Id: menu.c,v 1.1 1998/07/24 15:47:54 coyote Exp $ 
 *
 * Large parts taken from the olwm program 
 *
 * Copyright Tomas Stephanson Ellemtel 1992
 */

#define MemNewString(s) strdup(s)
#define MemAlloc(s)     malloc(sizeof(s))
#define DBG(s)          do { s } while ( 0 )

/*
 *      (c) Copyright 1989, 1990 Sun Microsystems, Inc. Sun design patents
 *      pending in the U.S. and foreign countries. See LEGAL_NOTICE
 *      file for terms of the license.
 */


/*
        LEGAL_NOTICE

	Any use of this source code must include, in the user documentation 
	and internal comments to the code, notices to the end user as  
	follows:


	(c) Copyright 1989 Sun Microsystems, Inc. Sun design patents
	pending in the U.S. and foreign countries. OPEN LOOK is a 
	trademark of AT&T. Used by written permission of the owners.


 	(c) Copyright Bigelow & Holmes 1986, 1985. Lucida is a registered 
	trademark of Bigelow & Holmes. Permission to use the Lucida 
	trademark is hereby granted only in association with the images 
	and fonts described in this file.



	SUN MICROSYSTEMS, INC., AT&T, AND BIGELOW & HOLMES 
	MAKE NO REPRESENTATIONS ABOUT THE SUITABILITY OF
 	THIS SOURCE CODE FOR ANY PURPOSE. IT IS PROVIDED "AS IS" 
	WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND. 
	SUN  MICROSYSTEMS, INC., AT&T AND BIGELOW  & HOLMES, 
	SEVERALLY AND INDIVIDUALLY, DISCLAIM ALL WARRANTIES 
	WITH REGARD TO THIS SOURCE CODE, INCLUDING ALL IMPLIED
	WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
	PARTICULAR PURPOSE. IN NO EVENT SHALL SUN MICROSYSTEMS,
	INC., AT&T OR BIGELOW & HOLMES BE LIABLE FOR ANY
	SPECIAL, INDIRECT, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
	OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA 	
	OR PROFITS, WHETHER IN AN ACTION OF  CONTRACT, NEGLIGENCE
	OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
	WITH THE USE OR PERFORMANCE OF THIS SOURCE CODE.

*/
#ident	"@(#)usermenu.c	26.36	91/09/14 SMI"

/*
 * This file contains all of the functions for manipulating the user menu
 *
 * Global Functions:
 * InitUserMenu 	-- load the user menu and initialise
 * ReInitUserMenu 	-- reload the user menu and re-initialise
 * RootMenuShow		-- call MenuShow on the root menu
 *
 */

/*
 * Syntax of the user menu file should be identical to that used by
 *	buildmenu (SunView style RootMenu files).
 *
 *	NOTICE that SunView compatibility has resulted in old-style
 *	olwm menus no longer being supported.
 *
 *	There are two new reserved keywords:
 *
 *		DEFAULT tags a default button
 *		TITLE tags a title string for a menu (for titlebar)
 *
 *	One syntax in sunview menus is not supported:
 *		<icon_file> can not be used as a menu item
 *
 *	Here are the common reserved keywords:
 *		MENU and END are used to delimit a submenu
 *		PIN (appearing after END) indicates the menu is pinnable
 *		EXIT (built-in - olwm service)
 *		REFRESH (built-in - olwm service)
 *		POSTSCRIPT will invoke psh on the named command
 *
 * 	The file is line-oriented, however commands to be executed can
 *	extend to the next line if the newline is escaped (\).
 *
 *	Each line consists of up to three fields:  a label (a string
 *	corresponding to either the menu label or menu option label),
 *	up to two tags (keywords), and a command to be executed
 *	(or a file from which to read a submenu).  Two tags are allowed
 *	if one of them is "DEFAULT" or "END".
 *
 *	The tag is used to indicate the start and end of menu definitions,
 *	pinnability, built-in functions, and default options.
 *	The label indicates the text which appears on the user's menu,
 *	and the command describes what should be done when each item
 *	is selected.
 *
 *	Labels must be enclosed in double quotes if they contain
 *	whitespace.  Commands may be enclosed in double quotes (but
 *	do not have to be).
 *
 *	Comments can be embedded in a file by starting a line with a
 *	pound sign (#).  Comments may not be preserved as the file is
 *	used.
 *
 *	There are several functions which aren't invoked as programs;
 *	rather, they are built in to window manager.  These built-in
 *	services are each denoted by a single keyword.  The keywords are
 *	listed in the svctokenlookup[] array initialization.
 *
 *	example (will always have label: "Workspace Menu"):
 *
 *	"Workspace Menu"	TITLE
 *	Programs	MENU
 *		"Helpful Programs"	TITLE
 *		"Command Tool"	cmdtool
 *		"Blue Xterm"	DEFAULT xterm -fg white \
 *				-bg blue
 *	Programs	END	PIN
 *	Utilities	MENU
 *		"Refresh Screen" DEFAULT REFRESH
 *		"Clipboard"	 CLIPBOARD
 *	Utilities	END
 */

#ifdef SYSV
#include <sys/types.h>
#include <unistd.h>
#endif
#include <errno.h>
#include <stdio.h>
#include <ctype.h>
#ifdef SYSV
#include <string.h>
#else
#include <strings.h>
#endif
#include <sys/file.h>
#include <sys/param.h>
#include <sys/stat.h>	/* for stat(2) */
#include <X11/Xos.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>

#include <string.h>
#include <pwd.h>

#include <xview/xview.h>


/*
#include "i18n.h"
#include "ollocale.h"
#include "olwm.h"
#include "globals.h"
#include "list.h"
#include "mem.h"
#include "win.h"
*/
#include "menu.h"

static char *menuFileName	= "openwin-menu";
static char *workspaceTitle	= "Workspace";
static char *workspaceHelpStub	= "workspace";
static char *workspaceHelp 	= "workspace:DefaultMenu";

extern char *getenv();

#define TOKLEN		300

/* parseMenu return values */
#define MENU_FATAL     -1
#define MENU_NOTFOUND	0
#define MENU_OK		1
#define MENU_PINNABLE	2

typedef enum {
    UsrToken, MenuToken, EndToken, DefaultToken, PinToken,
    TitleToken, ServiceToken, PshToken
}           TokenType;

/* locally useful macro */
#define	APPEND_STRING(buf, str)	( strncat( buf, str, \
					( sizeof(buf) - strlen(buf) - 1 ) ) )
#define COUNT(x)	(sizeof(x) / sizeof(x[0]))

/* ---------------------------------------------------------------------
 * 	Externals
 * ---------------------------------------------------------------------
 */
extern int  RefreshFunc();
extern int  ClipboardFunc();
extern int  PrintScreenFunc();
extern int  ExitFunc();
extern int  ExitNoConfirmFunc();
extern int  PropertiesFunc();
extern int  SaveWorkspaceFunc();
extern int  FlipDragFunc();
extern int  AppMenuFunc();
extern int  PshFunc();
extern int  NopFunc();
extern int  WindowCtlFunc();
extern int  RestartOLWM();
extern int  FlipFocusFunc();
extern int  ReReadUserMenuFunc();
extern int  OpenCloseSelnFunc();
extern int  FullRestoreSizeSelnFunc();
extern int  BackSelnFunc();
extern int  QuitSelnFunc();

/* ---------------------------------------------------------------------
 *	local forward declarations
 * ---------------------------------------------------------------------
 */
static Bool checkFile();
static int  menuFromFile();
static int  parseMenu();
static void fillMenuStruct();
static TokenType lookupToken();
static MenuL *buildFromSpec();
static void initMenu();
static void initButton();
static void freeButtonData();
static void freeMenuData();
static void freeUserMenu();
static Bool menuFileModified();
static void addToMenuInfo();
static void freeFileInfoList();

/* ---------------------------------------------------------------------
 *	local data
 * ---------------------------------------------------------------------
 */

typedef struct {
    char       *filename;	/* menu file path */
    dev_t       device;	/* device that the inode/file reside on */
    ino_t       inode;	/* inode of menu file */
    time_t      mtime;	/* modification time */
}           FileInfo;

typedef struct {
    char       *topfilename;	/* top-level menu file name */
/*  List       *fileinfoList;*//* list of FileInfo's for each menu file */
}           MenuFileInfo;

MenuFileInfo menuFileInfo;

typedef struct _buttondata {
    struct _buttondata *next;
    char       *name;
    Bool        isDefault;
    Bool        isLast;
    FuncPtr     func;
    char       *exec;	/* string to be executed, like "xterm" */
    void       *submenu;
}           buttondata;


typedef struct {
    char       *title;
    char       *menulabel;
    int         idefault;	/* index of default button */
    int         nbuttons;
    Bool        pinnable;
    buttondata *bfirst;
}           menudata;


/* default Root menu should be quite minimal */
static Button xtermButton = {
    {"Xterm", NULL},
    {NULL, NULL}, 
    0, 
    False, 
    True, 
    True, 
    {
	AppMenuFunc, 
	(void *) "xterm"
    },
};

static Button cmdtoolButton = {
    {"Cmdtool", NULL},
    {NULL, NULL}, 
    0, 
    False, 
    True, 
    True, 
    {
	AppMenuFunc, 
	(void *) "cmdtool"
    },
};

static Button wsrefreshButton = {
    {"Refresh", NULL}, 
    {NULL, NULL}, 
    0, 
    False, 
    True, 
    True,
    {
	RefreshFunc, 
	NULL
    },
};

static Button wsrestartButton = {
    {"Restart WM", NULL}, 
    {NULL, NULL}, 
    0, 
    False, 
    True, 
    True,
    {
	RestartOLWM,
	NULL
    },
};

static Button wsrereadButton = {
    {"Reread Menu File", NULL}, 
    {NULL, NULL}, 
    0, 
    False, 
    True, 
    True,
    {
	ReReadUserMenuFunc,
	NULL
    },
};

static Button exitWMButton = {
    {"Exit WM", NULL}, 
    {NULL, NULL}, 
    0, 
    False, 
    True, 
    True,
    {
        NULL,
	NULL
    },
};

static Button exitButton = {
    {"Exit", NULL}, 
    {NULL, NULL}, 
    0, 
    False, 
    True, 
    True,
    {
	ExitFunc, 
	NULL
    },
};

static Button separatorButton = {
    {NULL, NULL}, 
    {NULL, NULL}, 
    0, 
    False, 
    False, 
    True,
    {
	NULL, 
	NULL
    },
};

static Button *rootButtons[] = {
    &xtermButton,
    &cmdtoolButton,
    &separatorButton,
    &wsrefreshButton,
    &wsrestartButton,
    &wsrereadButton,
    &separatorButton,
    &exitWMButton,
    &exitButton,
};

/* ---------------------------------------------------------------------
 * Local routines
 * ---------------------------------------------------------------------
 */

/*
 * expandPath - expand any environment variables in a path.
 *		returns a dynamically alloacted string with
 *		the expanded path.
 * Actually, this will also expand things of the nature:
 * $(OPENWINHOME)/include:${MUBMEL}/include:$FOOBLES/include
 */

static char *
expandPath(pin, messages)
    char *pin;
    Bool messages;
{
    char pathname[1024];
    int haveslash;
    char envbuff[128];
    char *pend;
    char *penv;
    char *pstart;
    char *p;
    int len;
    struct passwd *ppw;
    char c;
    char *orig;

    if (pin == NULL)
	return NULL;

    orig = pin;

    *pathname = (char) NULL;

    len = strlen(pin);

    if (pin[len] == '/')
	--len;

    haveslash = False;

    for (p = pathname;  len > 0;) {
	switch (*pin) {
	  case '~': /*overrides everything back to last :*/
	    ++pin;
	    --len;
	    if (len <= 1 || *pin == '/') {
		penv = getenv("HOME");
	    } else {
		int tmp;
		pend = strchr(pin, '/');
		if (pend == NULL) {
		    pend = strchr(pin, ':');
		    if (pend == NULL)
			pend = pin + strlen(pin);
		}
		tmp = pend - pin;
		memcpy(envbuff, pin, tmp);
		envbuff[tmp] = (char) NULL;
		pin = pend;
		len -= tmp;
		ppw = getpwnam(envbuff);
		if (ppw == NULL && messages)
		    fprintf(stderr, 
			    "olwm: couldn't find user \"%s\" in \"%s\"\n",
			    envbuff, orig);
		penv = (char *) (ppw? ppw->pw_dir : NULL);
	    }
	    if (penv) {
		for (pstart = p;  pstart > pathname;   pstart--)
		    if (*pstart == ':') {
			++pstart;
			break;
		    }
		strcpy(pstart, penv);
		p = pstart + strlen(penv);
	    }
	    haveslash = False;
	    continue;
	  case '$':
	    if ((c = *(pin+1)) == '(' || c == '{') {
		int tmp;

		pin += 2;
		pend = strpbrk(pin, "})");
		if (pend == NULL) {
		    if (messages)
			fprintf(stderr, 
				"olwm: no match for '%c' in pathname \"%s\"\n", 
				c, orig);
		    return NULL;
		} else {
		    if (*pend == '}' && c != '{') {
			if (messages)
			    fprintf(stderr, 
				    "olwm: found a '}' before a ')' in \"%s\"\n",
				    orig);
			return NULL;
		    } else if (*pend == ')' && c != '(') {
			if (messages)
			    fprintf(stderr, 
				    "olwm: found a ')' before a '}' in \"%s\"\n",
				    orig);
			return NULL;
		    }
		}
		tmp = pend - pin;
		memcpy(envbuff, pin, tmp);
		envbuff[tmp] = (char) NULL;
		len -= (2 + tmp + 1);
		pin = pend+1;
	    } else {
		--len;
		pend = strchr(++pin, '/');
		if (pend) {
		    int tmp = pend - pin;
		    memcpy(envbuff, pin, tmp);
		    envbuff[tmp] = (char) NULL;
		    len -= tmp;
		    pin = pend;
		} else {
		    memcpy(envbuff, pin, len);
		    envbuff[len] = (char) NULL;
		    len = 0;
		}
	    }
	    penv = getenv(envbuff);
	    if (penv) {
		int tmp = strlen(penv);
		if (haveslash && *penv == '/') {
		    /*if he put /usr//home, turn it into /home*/
		    /*/mumble:/usr//home -> /mumble:/home*/
		    for (; p > pathname;  p--)
			if (*p == ':') {
			    ++p;
			    break;
			}
		}
		memcpy(p, penv, tmp);
		p += tmp;
		haveslash = len > 0 && *(p-1) == '/';
	    }
	    if (len <= 0)
		break;
	    /*FALL THROUGH*/
	  default:
	    if (*pin != '/')
		haveslash = False;
	    else {
		if (!haveslash)
		    haveslash = True;
		else {
		    ++pin;
		    --len;
		    continue;
		}
	    }
	    *p++ = *pin++;
	    --len;
	}
    }
    *p = (char) NULL;
    if (haveslash)
	pathname[strlen(pathname)-1] = (char) NULL;

    return strdup(pathname);
}


/*
 * Menu Search Path
 */
#define NUM_SEARCH_PATH	 7
static  char    **menuSearchPath;

/*
 * makeMenuSearchPath
 */
static char **
makeMenuSearchPath()
{
	char    buf[MAXPATHLEN];
	char    *home;
	char    *owHome;
	int     i = 0;

	if ((home = getenv("HOME")) == NULL)
		home = ".";
 
	if ((owHome = getenv("OPENWINHOME")) == NULL)
		owHome = "/usr/openwin";
 
	menuSearchPath = (char **)MemAlloc(NUM_SEARCH_PATH*sizeof(char *));
 
#ifdef SVR4
#ifdef OW_I18N_L3
	/* $HOME/.<menufile>.<locale> */
	sprintf(buf, "%s/.%%1$s.%%2$s", home);
	menuSearchPath[i++] = MemNewString(buf);
#endif
#endif
 
	/* $HOME/.<menufile> */
	sprintf(buf, "%s/.%%s", home);
	menuSearchPath[i++] = MemNewString(buf);

#ifdef OW_I18N_L3
	/* $OPENWINHOME/share/locale/<locale>/olwm/<menufile> */
	sprintf(buf, "%s/share/locale/%%2$s/olwm/%%1$s", owHome);
	menuSearchPath[i++] = MemNewString(buf);

	/* $OPENWINHOME/lib/<menufile>.<locale> */
	sprintf(buf, "%s/lib/%%1$s.%%2$s", owHome);
	menuSearchPath[i++] = MemNewString(buf);
#endif

	/* $OPENWINHOME/lib/<menufile> */
	sprintf(buf, "%s/lib/%%s", owHome);
	menuSearchPath[i++] = MemNewString(buf);

	/* /usr/openwin/lib/<menufile> */
	menuSearchPath[i++] = MemNewString("/usr/openwin/lib/%s");

	menuSearchPath[i] = (char *)NULL;

	return menuSearchPath;
}

/*
 * checkFile - check to see that a file (composed of named file and dir)
 *	is readable
 */
static      Bool
checkFile(location, file, path)
    char       *location, *file, *path;
{
    char       *dir;

    if ((dir = getenv(location)) == NULL)
	return False;
    strcpy(path, dir);
    strcat(path, file);
    return (access(path, R_OK) == 0);
}

/*
 * menuFromFileSearch
 */
static int
#if defined(__STDC__)
menuFromFileSearch(
	char	    *file,
	menudata    *menu,
	Bool	    messages)
#else    
menuFromFileSearch(file, menu, messages)
	char	    *file;
	menudata    *menu;
	Bool	    messages;
#endif /* __STDC__ */
{
	char	    **pFmt;
	char	    fullPath[MAXPATHLEN];
#ifdef OW_I18N_L3
	char	    *locale = GRV.lc_dlang.locale;
#endif
	int	     rval;
 
	if (file[0] == '/')
		return menuFromFile(file, menu, messages);
 
	if (menuSearchPath == NULL)
		makeMenuSearchPath();
 
	for (pFmt = menuSearchPath; *pFmt; pFmt++) {
 
#if OW_I18N_L3
		(void)sprintf(fullPath, *pFmt, file, locale);
#else
		(void)sprintf(fullPath, *pFmt, file);
#endif
#ifdef DEBUG
fprintf(stderr,"menuFromFileSearch: trying '%s'\n",fullPath);
#endif

		if (access(fullPath, R_OK) == 0) {

			rval = menuFromFile(fullPath, menu, messages);

			if (rval >= MENU_OK)
				return rval;
		}
	}
	return MENU_NOTFOUND;
}

/*
 *
 */
static menudata *makeRootMenu();

#ifdef notdef
DefaultsP   DefaultsPtr;
#endif



static menudata *
getUserMenu()
{
    menudata   *userroot;
    char        temp[MAXPATHLEN];
    char       *path;
    char       *homeEnv;
    char        homePath[MAXPATHLEN];
    char       *openwinhomeEnv;
    char        openwinhomePath[MAXPATHLEN];

    /*
     * Attempt to read menus from different sources: (1) the file named by the
     * OLWMMENU environment variable; (2) $HOME/.openwin-menu.<locale>; (3)
     * $HOME/.openwin-menu; (4) $OPENWINHOME/openwin-menu.<locale>; (5)
     * $OPENWINHOME/openwin-menu; (6) if all of the above fail, use olwm's
     * built-in menu.
     */

    /* try reading $OLWMMENU */
    path = getenv("OLWMMENU");
    if (path != NULL && (userroot = makeRootMenu(path)) != NULL)
	return userroot;

    /* get $HOME */
    homeEnv = getenv("HOME");
    if (!homeEnv)
	homeEnv = "";

    /* construct "$HOME/.openwin-menu" */
    strcpy(homePath, homeEnv);
    strcat(homePath, "/.");
    strcat(homePath, menuFileName);

#ifdef OW_I18N_L3
    /* try reading $HOME/.openwin-menu.<locale> */
    strcpy(temp, homePath);
    strcat(temp, ".");
    strcat(temp, GRV.LC.DisplayLang.locale);
    if ((userroot = makeRootMenu(temp)) != NULL) {
	return userroot;
    }
#endif	   /* OW_I18N_L3 */
    
    /* try reading $HOME/.openwin-menu */
    if ((userroot = makeRootMenu(homePath)) != NULL) {
	return userroot;
    }
    
    /* get $OPENWINHOME */
    openwinhomeEnv = getenv("OPENWINHOME");
    if (!openwinhomeEnv)
	openwinhomeEnv = "";
    
    /* construct "$OPENWINHOME/lib/openwin-menu" */
    strcpy(openwinhomePath, openwinhomeEnv);
    strcat(openwinhomePath, "/lib/");
    strcat(openwinhomePath, menuFileName);

#ifdef OW_I18N_L3
    /* try reading $OPENWINHOME/lib/openwin-menu.<locale> */
    strcpy(temp, openwinhomePath);
    strcat(temp, ".");
    strcat(temp, GRV.LC.DisplayLang.locale);
    if ((userroot = makeRootMenu(temp)) != NULL) {
	return userroot;
    }
#endif	   /* OW_I18N_L3 */
    
    /* try reading $OPENWINHOME/lib/openwin-menu */
    if ((userroot = makeRootMenu(openwinhomePath)) != NULL) {
	return userroot;
    }
    return NULL;
}

/*
 *
 */
static menudata *
makeRootMenu(file)
    char       *file;
{
    menudata   userroot;
    menudata  *proot;

    userroot.title = NULL;
    userroot.menulabel = (char *) NULL;
    userroot.idefault = NOBUTTON;
    userroot.nbuttons = 0;
    userroot.pinnable = True;
    userroot.bfirst = (buttondata *) NULL;

    if (menuFromFileSearch(file, &userroot, False) >= MENU_OK) {
      if (!menuFileInfo.topfilename)
	    menuFileInfo.topfilename = strdup(file);
	proot = (menudata *) malloc(sizeof(menudata));
	*proot = userroot;
	return proot;
    } else {
/*	freeFileInfoList(&menuFileInfo.fileinfoList);*/
	free(userroot.title);
	return (menudata *) NULL;
    }
}


/*
 * menuFromFile - read a menu description from a file
 *
 *	Return values: same as parseMenu, with the addition of
 *		MENU_NOTFOUND = couldn't read submenu file
 */
static int
menuFromFile(file, menu, messages)
    char       *file;
    menudata   *menu;
    Bool        messages;
{
    char       *new;
    FILE       *stream;
    int         lineno = 1;	/* Needed for recursion */
    int         rval;

    /* expand any environment vars in path */
    if ((new = expandPath(file, messages)) != NULL)
	file = new;

    if (file[0] != '/')
	return menuFromFileSearch(file, menu, messages);

    if ((stream = fopen(file, "r")) == NULL) {
	if (messages)
	    fprintf(stderr, "olwm: can't open menu file %s\n", file);

	return MENU_NOTFOUND;
    }
    rval = parseMenu(file, stream, menu, &lineno);
    fclose(stream);

    if (rval >= MENU_OK) {
	addToMenuInfo(file);
	fillMenuStruct(menu);
    } else {
	freeMenuData(menu);
    }

    if (new)
	free(new);

    return (rval);
}


/*
 * parseMenu -- read the user menu from the given stream and
 *	parse the stream into the menu structures defined locally.
 *	These structures (which are local to this module) are later
 *	used to build real menu structures.
 *
 *	Note that fillMenuStruct() needs to be called after parseMenu()
 *	is called (to finish filling out the menudata structure).
 *	If parseMenu() returns < 0, then freeMenuData() needs to be
 *	called instead, to free up unused memory.
 *
 *	Return values:
 *		MENU_OK		= an unpinnable menu was read successfully
 *		MENU_PINNABLE	= a pinnable menu was read successfully
 *		MENU_FATAL	= a fatal error was encountered
 *
 *	This is based heavily on buildmenu's getmenu() parsing routine.
 *
 */
static int
parseMenu(filename, stream, parent, lineno)
    char       *filename;
    FILE       *stream;
    menudata   *parent;
    int        *lineno;
{
    menudata   *currentMenu, *saveMenu;
    buttondata *currentButton;
    char        line[TOKLEN];
    char        label[TOKLEN];
    char        prog[TOKLEN];
    char        args[TOKLEN];
    static char localBuf[1024];
    char       *nqformat = "%[^ \t\n]%*[ \t]%[^ \t\n]%*[ \t]%[^\n]\n";
    char       *qformat =  "\"%[^\"]\"%*[ \t]%[^ \t\n]%*[ \t]%[^\n]\n";
    char       *format;
    register char *p;
    int         continuation;
    Bool        done;

    currentMenu = parent;
    initButton((buttondata **) & (currentMenu->bfirst));
    currentButton = currentMenu->bfirst;
    continuation = 0;

    for (; fgets(line, sizeof(line), stream); (*lineno)++) {
	if (line[0] == '#')
	    continue;

	for (p = line; isspace(*p); p++)
	    /* EMPTY */
	    ;

	if (*p == '\0')
	    continue;

	/*
	 * if we're already on a continuation line (the previous line ended in
	 * '\') then just copy the input through to the output until we get a
	 * line that doesn't end in '\' (nuke the vi backslash).
	 */
	if (continuation) {
	    /* fgets includes the newline in the string read */
	    while (line[strlen(line) - 2] == '\\') {
		/* get rid of backslash */
		line[strlen(line) - 2] = '\0';
		APPEND_STRING(localBuf, " ");
		APPEND_STRING(localBuf, p);
		if (!fgets(line, sizeof(line), stream))
		    break;
		(*lineno)++;
		for (p = line; isspace(*p); p++)
		    /* EMPTY */
		    ;
	    }
	    /* last line of continuation - replace \n with \0 */
	    line[strlen(line) - 1] = '\0';
	    APPEND_STRING(localBuf, " ");
	    APPEND_STRING(localBuf, p);
	    /* save it permanently in the buttondata structure */
	    currentButton->exec = strdup(localBuf);
	    localBuf[0] = '\0';
	    continuation = 0;
	    initButton((buttondata **) & (currentButton->next));
	    currentButton = currentButton->next;
	    continue;
	}
	/*
	 * if the line ends in '\' remember that continuation has started.
	 */
	if (line[strlen(line) - 2] == '\\') {
	    continuation = 1;
	    line[strlen(line) - 2] = '\0';
	}
	args[0] = '\0';
	format = (*p == '"') ? qformat : nqformat;

	if (sscanf(p, format, label, prog, args) < 2) {
	    /* seperator keyword appears alone on a line */
	    if (strcmp(label, "SEPARATOR") == 0) {
		currentButton->name = NULL;
		currentButton->isDefault = False;
		currentButton->func = NULL;
		currentButton->exec = NULL;
		currentButton->submenu = NULL;
		initButton((buttondata **) & (currentButton->next));
		currentButton = currentButton->next;
		continue;
	    }
	    /*otherwise...*/
	    fprintf(stderr,
		    "olwm: syntax error in menu file %s, line %d\n",
		    filename, *lineno);
	    return (MENU_FATAL);
	}
	
	if (strcmp(prog, "END") == 0) {
	    /* currently allocated button is last for this menu */
	    currentButton->isLast = True;
	    if (currentMenu->menulabel != NULL &&
		    strcmp(label, currentMenu->menulabel) != 0) {
		fprintf(stderr,
		   "olwm: menu label mismatch in file %s, line %d\n",
			filename, *lineno);
		return (MENU_FATAL);
	    }
	    /* compare PIN as # chars; args may have extra space */
	    if (strncmp(args, "PIN", 3) == 0)
		return (MENU_PINNABLE);
	    else
		return (MENU_OK);
	}
	if (strcmp(prog, "TITLE") == 0) {
	    currentMenu->title = strdup(label);

	    if (strncmp(args, "PIN", 3) == 0)
		currentMenu->pinnable = True;

	    /*
	     * we don't need to set up the next button, since the TITLE line
	     * didn't use up a button
	     */
	    continue;
	}
	currentButton->name = strdup(label);

	if (strcmp(prog, "DEFAULT") == 0) {
	    char       *t;
	    char       *u;

	    currentButton->isDefault = True;

	    /*
	     * Pull the first token from args into prog.
	     */
	    t = strtok(args, " \t");
	    if (t == NULL) {
		fprintf(stderr,
			"olwm: error in menu file %s, line %d\n",
			filename, *lineno);
		/*
		 * STRING_EXTRACTION - Since DEFAULT is keyword, do not
		 * translate.
		 */
		fputs("missing item after DEFAULT keyword.\n",stderr);
		return (MENU_FATAL);
	    }
	    strcpy(prog, t);
	    t = strtok(NULL, "");	/* get remainder of args */
	    if (t == NULL)
		args[0] = '\0';
	    else {
		u = args;
		/* can't use strcpy because they overlap */
		while (*u++ = *t++)
		    /* EMPTY */
		    ;
	    }
	}
	if (strcmp(prog, "INCLUDE") == 0) {
	    int	 rval;

	    initMenu((menudata **) & (currentButton->submenu));
	    saveMenu = currentMenu;
	    currentMenu = (menudata *) currentButton->submenu;
	    currentMenu->menulabel = MemNewString(label);

	    if (args != NULL) {
		rval = menuFromFile(args, currentMenu, False);
		switch (rval) {
		case MENU_PINNABLE:
		    currentMenu->pinnable = True;
		    /* FALL THRU */
		case MENU_OK:
		    currentMenu = saveMenu;
		    break;
		default:	/* bad menu file */
		    initMenu((menudata **) & (currentButton->submenu));
		    break;
		}
	    }
	}
	if (strcmp(prog, "MENU") == 0) {
	    int         rval;

	    initMenu((menudata **) & (currentButton->submenu));
	    saveMenu = currentMenu;
	    currentMenu = (menudata *) currentButton->submenu;
	    currentMenu->menulabel = strdup(label);

	    if (args[0] == '\0') {
		/*
		 * we haven't incremented lineno for this read loop yet, so we
		 * need to do it now. when END is read, parseMenu returns
		 * without incrementing lineno, so the count will be ok when
		 * this loop increments it before reading the next line of the
		 * file.
		 */
		(*lineno)++;
		if ((rval = parseMenu(filename, stream,
				      currentMenu, lineno)) < 0) {
		    freeMenuData(currentMenu);
		    return (MENU_FATAL);
		} else
		    fillMenuStruct(currentMenu);
	    } else {
		rval = menuFromFile(args, currentMenu, True);
		if (rval <= MENU_NOTFOUND)
		    return (MENU_FATAL);
	    }
	    if (rval == MENU_PINNABLE)
		currentMenu->pinnable = True;

	    currentMenu = saveMenu;
	    /* if submenu not found, reuse button */
	    if (rval != MENU_NOTFOUND) {
		initButton((buttondata **) & (currentButton->next));
		currentButton = currentButton->next;
	    }
	    continue;
	}
	done = False;
	while (!done) {
	    switch (lookupToken(prog, &(currentButton->func))) {
	    case UsrToken:
		/*
		 * if UsrToken, that means that "prog" was just the first word
		 * of the command to be executed,
		 */
		strcpy(localBuf, prog);
		APPEND_STRING(localBuf, " ");
		APPEND_STRING(localBuf, args);
		/*
		 * copy current contents of localBuf back into args array so
		 * that PshToken code can be used
		 */
		strcpy(args, localBuf);
		localBuf[0] = '\0';
		/* fall through */
	    case PshToken:
		if (continuation)
		    strcpy(localBuf, args);
		else
		    currentButton->exec = strdup(args);
		done = True;
		break;
	    case PinToken:
		fprintf(stderr,
		     "olwm: format error in menu file %s, line %d\n",
			filename, *lineno);
		fputs("menu title and END required before PIN keyword.\n",
		      stderr);
		return (MENU_FATAL);
		/* NOTREACHED */
		break;
	    default:
		/* some other valid token found and returned */
		done = True;
		break;
	    }
	}

	if (!continuation) {
	    initButton((buttondata **) & (currentButton->next));
	    currentButton = currentButton->next;
	}
    }
    /* never used the last button created */
    currentButton->isLast = True;

    return (MENU_OK);
}

/*
 * fillMenuStruct - Once the menu structures have been filled out using
 * 	information in the menu description file (via parseMenu()), the
 * 	nbuttons and idefault elements need to be set.
 */
static void
fillMenuStruct(mptr)
    menudata   *mptr;
{
    buttondata *bptr;
    int         buttonIndex = 0;

    bptr = mptr->bfirst;
    if (bptr->isLast == True) {
	free(bptr);
	bptr = mptr->bfirst = NULL;
    }
    for (; bptr != NULL && bptr->isLast == False; bptr = bptr->next) {
	if (bptr->isDefault == True)
	    mptr->idefault = buttonIndex;

	if ((bptr->next)->isLast == True) {
	    free(bptr->next);
	    bptr->next = NULL;
	}
	buttonIndex++;
    }
    /* buttonIndex is one past end, but started at 0, so = number buttons */
    mptr->nbuttons = buttonIndex;
}


/*
 * Allowed menu keywords ("Token")
 */

struct _svctoken {
    char       *token;
    FuncPtr     func;
    TokenType   toktype;
}           svctokenlookup[] = {
    {
	"REFRESH", RefreshFunc, ServiceToken
    },
    {
	"CLIPBOARD", ClipboardFunc, ServiceToken
    },
    {
	"PRINT_SCREEN", PrintScreenFunc, ServiceToken
    },
    {
	"EXIT", ExitFunc, ServiceToken
    },
    {
	"EXIT_NO_CONFIRM", ExitNoConfirmFunc, ServiceToken
    },
    {
	"WMEXIT", ExitFunc, ServiceToken
    },
    {
	"PROPERTIES", PropertiesFunc, ServiceToken
    },
    {
	"NOP", NopFunc, ServiceToken
    },
    {
	"DEFAULT", NULL, DefaultToken
    },
    {
	"MENU", NULL, MenuToken
    },
    {
	"END", NULL, EndToken
    },
    {
	"PIN", NULL, PinToken
    },
    {
	"TITLE", NULL, TitleToken
    },
    {
	"FLIPDRAG", FlipDragFunc, ServiceToken
    },
    {
	"SAVE_WORKSPACE", SaveWorkspaceFunc, ServiceToken
    },
    {
	"POSTSCRIPT", PshFunc, PshToken
    },
    {
	"RESTART", RestartOLWM, ServiceToken
    },
    {
	"FLIPFOCUS", FlipFocusFunc, ServiceToken
    },
    {
	"REREAD_MENU_FILE", ReReadUserMenuFunc, ServiceToken
    },
    {
	"OPEN_CLOSE_SELN", OpenCloseSelnFunc, ServiceToken
    },
    {
	"FULL_RESTORE_SIZE_SELN", FullRestoreSizeSelnFunc, ServiceToken
    },
    {
	"BACK_SELN", BackSelnFunc, ServiceToken
    },
    {
	"QUIT_SELN", QuitSelnFunc, ServiceToken
    },
};

#define NSERVICES COUNT(svctokenlookup)

/* lookupToken -- look up a token in the list of tokens
 *	given a supposed keyword or service name.  If the name doesn't
 *	match any existing token, return the user-defined token.
 */
static      TokenType
lookupToken(nm, ppf)
    char       *nm;
    FuncPtr    *ppf;
{
    int         ii;

    for (ii = 0; ii < NSERVICES; ii++) {
	if (!strcmp(nm, svctokenlookup[ii].token)) {
	    if (ppf != (FuncPtr *) 0)
		*ppf = svctokenlookup[ii].func;
	    return svctokenlookup[ii].toktype;
	}
    }
    if (ppf != (FuncPtr *) 0)
	*ppf = AppMenuFunc;
    return UsrToken;
}

#ifdef notdef
/* buildFromSpec -- build the real menu structures, and create the
 * 	associated menus, from the specifications parsed from
 *	the menu layout.  Free up the specifications as we go
 *	along.
 */
static Menu *
buildFromSpec(dpy, pmenu, deftitle)
    Display    *dpy;
    menudata   *pmenu;
    char       *deftitle;
{
    Menu       *m;
    Button     *b;
    int         ii;
    buttondata *bdata, *bsave;
    Bool flpin;
    char *tit;
    char *menuHelp;
    char helpbuff[255];

    if (pmenu->pinnable) {
	flpin = True;
	if (pmenu->title == NULL) {
	    if (deftitle == NULL)
		deftitle = workspaceTitle;
	    tit = MemNewString(deftitle);
	} else
	    tit = pmenu->title;
    } else {
	flpin = False;
	/* non-pinnable menus only get titles if they ask for them */
	/* m->title must be NULL if pmenu->title is NULL */
	tit = pmenu->title;
    }

     menuHelp = NULL;

     if (tit != NULL) {
 	sprintf(helpbuff, "%s:%s", workspaceHelpStub, tit);
 	menuHelp = MemNewString(helpbuff);
     }

     if (menuHelp == NULL && deftitle != NULL) {
 	sprintf(helpbuff, "%s:%s", workspaceHelpStub, deftitle);
 	menuHelp = MemNewString(helpbuff);
     }

     if (menuHelp != NULL)
 	ReplaceChars(menuHelp, " \t", '_');

     m = NewNamedMenu(tit, flpin, menuHelp);

    /*
     * If no default has been specified, set the first button in the menu to be
     * the default button. REMIND: The OL spec wants the pin, if one exists, to
     * be the default in such a cse. Fix this.
     */

    for (ii = 0, bdata = pmenu->bfirst; ii < pmenu->nbuttons; ii++) {
	b = (Button *) MemNew(Button);

	/*right now, usermenus cannot have alternate items*/
	b->label[0] = bdata->name;
	b->label[1] = NULL;
	b->which = 0;

	b->stacked = bdata->submenu != NULL;
	b->enabled = (bdata->name != NULL);
	b->visible = True;
	b->action.callback = bdata->func;

	if (! b->stacked) /* multi-purpose */
	    b->action.submenu = (void *) bdata->exec;
	else {
#ifdef notdef
	    DefaultsP   tail, curr;
	    /*
	     * Find the last node in DefaultsList and add this buttons label at
	     * the end
	     */
	    tail = DefaultsPtr;
	    while (tail->next)
		tail = tail->next;
	    tail->next = curr = (DefaultsP) malloc(sizeof(struct _defaults));
	    curr->next = (DefaultsP) 0;
	    strcpy(curr->Name, b->label[0]);
#endif

	    b->action.submenu =
		(void *) buildFromSpec(dpy,
				       (menudata *) (bdata->submenu),
				       bdata->name);
	}
	bsave = bdata;
	bdata = bdata->next;
	free(bsave);
	AppendMenuItem(m, b);
    }
		     
    if (pmenu->idefault == NOBUTTON)
	SetMenuDefault(m, 0);
    else
	SetMenuDefault(m, pmenu->idefault);

    free(pmenu->menulabel);
    free(pmenu);

    return (m);
}
#endif

/*
 * initMenu -
 */
static void
initMenu(newmenu)
    menudata  **newmenu;
{
    *newmenu = (menudata *) malloc(sizeof(menudata));
    (*newmenu)->title = NULL;
    (*newmenu)->menulabel = NULL;
    (*newmenu)->idefault = NOBUTTON;
    (*newmenu)->nbuttons = 0;
    (*newmenu)->pinnable = False;
    (*newmenu)->bfirst = (buttondata *) 0;
}

/*
 * initButton -
 */
static void
initButton(newButton)
    buttondata **newButton;
{
    *newButton = (buttondata *) malloc(sizeof(buttondata));
    (*newButton)->next = NULL;
    (*newButton)->name = NULL;
    (*newButton)->isDefault = False;
    (*newButton)->isLast = False;
    (*newButton)->func = (FuncPtr) 0;
    (*newButton)->exec = NULL;
    (*newButton)->submenu = NULL;
}

/*
 * freeMenuData - free any possibly allocated memory for this menudata
 *	structure (and its buttons), since it's not going to be used
 */
static void
freeMenuData(unusedMenu)
    menudata   *unusedMenu;
{
    buttondata *unusedButton;

    /* isLast probably isn't set, since this menu had an error */
    if ((unusedButton = unusedMenu->bfirst) != (buttondata *) 0)
	freeButtonData(unusedButton);

    free(unusedMenu->title);
    free(unusedMenu->menulabel);
    free(unusedMenu);
    unusedMenu = NULL;
}

/*
 * freeButtonData - free any possibly allocated memory for this buttondata
 *	structure, since it's not going to be used
 */
static void
freeButtonData(unusedButton)
    buttondata *unusedButton;
{

    if (unusedButton->next != NULL)
	freeButtonData(unusedButton->next);

    free(unusedButton->name);
    free(unusedButton->exec);
    if (unusedButton->submenu != NULL)
	freeMenuData(unusedButton->submenu);
    free(unusedButton);
    unusedButton = NULL;
}

/*
 * freeUserMenu	- free's a dynamically allocated menu and its buttons
 *	This assumes that all components of the menu structure are
 *	unique and dynamically allocated.
 */
static void
freeUserMenu(menu)
    MenuL       *menu;
{
    int         i;

    if (menu == NULL)
	return;

    for (i = 0; i < menu->buttonCount; i++) {
	if (menu->buttons[i]->stacked)
	    freeUserMenu(menu->buttons[i]->action.submenu);
	else /*was holding string to exec */
	    free(menu->buttons[i]->action.submenu);
	/*NOTE: user menus cannot yet have alternates,
	 * nor specify help on a per item basis*/
	free(menu->buttons[i]->label[0]);
	free(menu->buttons[i]);
    }
    free(menu->buttons);
    free(menu->title);
    free(menu->helpstring);
    free(menu);
}

ExitFunc()
{
  exit(0);
}

RestartOLWM()
{
  exit(0);
}

ReReadUserMenuFunc()
{

}

OpenCloseSelnFunc()
{
  fprintf(stderr,"Not Implemeted Open Close\n");
}

FlipFocusFunc()
{
  fprintf(stderr,"Not Implemeted FlipFocus\n");
}

ExitNoConfirmFunc()
{
  fprintf(stderr,"Not Implemeted ExitNoCOnfirm");
}

FullRestoreSizeSelnFunc()
{
  fprintf(stderr,"Not Implemeted FullREstoreSize\n");
}

NopFunc()
{
  ;
}

SaveWorkspaceFunc()
{
  fprintf(stderr,"Not Implemeted SaveWorkspace\n");
}

FlipDragFunc()
{
  fprintf(stderr,"Not Implemeted FlipDrag\n");
}

PshFunc()
{
  fprintf(stderr,"Not Implemeted Psh\n");
}

PrintScreenFunc()
{
  fprintf(stderr,"Not Implemeted PrintScreen\n");
}

BackSelnFunc()
{
  fprintf(stderr,"Not Implemeted");
}

RefreshFunc()
{
  fprintf(stderr,"Not Implemeted Refresh\n");
}

static void
addToMenuInfo()
{
  ;
}

QuitSelnFunc()
{
  fprintf(stderr,"Not Implemeted Quit Seln\n");
}


PropertiesFunc(menu,menu_item)
     Menu menu;
     Menu_item menu_item;
{
  DoPropertiesFunc();
}

AppMenuFunc(menu,menu_item)
     Menu menu;
     Menu_item menu_item;
{
  buttondata *button;  
  
  button = (buttondata *) xv_get(menu_item,MENU_CLIENT_DATA);
  
  DoAppMenuFunc(button->exec);

}

ClipboardFunc()
{
  fprintf(stderr,"Not Implemeted Clipboard\n");
}

/* 
 * xview department
 */

Menu
makeMenu(menud,frame)
     menudata	*menud;
     Frame	frame;
{

  char *str;
  Menu menu;
  Menu_item mi;
  Menu_item mp;
  extern Menu_item pri();
  buttondata *button;

  if (menud) {
    if (menud->title) {
      str = menud->title;
    } else {
      str = menud->menulabel;
    }

    menu = (Menu) xv_create(XV_NULL,MENU,NULL);

    xv_set(menu,MENU_TITLE_ITEM,str,NULL);

    if (menud->pinnable)
      xv_set(menu,MENU_GEN_PIN_WINDOW,frame,str,NULL);

    button = menud->bfirst;

    if ( ! button ) {
      mi = (Menu_item) xv_create(XV_NULL,MENUITEM,
				 MENU_RELEASE,
				 MENU_RELEASE_IMAGE,
				 MENU_INACTIVE,TRUE,
				 MENU_STRING, "",
				 NULL);

      xv_set(menu,MENU_APPEND_ITEM,mi,NULL);
      return menu;
    }
      

    for(; button ; button = button->next) {
      
      if ( button->submenu) {

	mp = makeMenu(button->submenu,frame);
	mi = (Menu_item) xv_create(XV_NULL,MENUITEM,
				   MENU_RELEASE,
				   MENU_RELEASE_IMAGE,
				   MENU_PULLRIGHT,mp,
				   MENU_STRING, button->name,
				   NULL);

      } else {
	/* handle buttons without strings */
	mi = (Menu_item)
	  xv_create(XV_NULL,MENUITEM,
		    MENU_RELEASE,
		    MENU_RELEASE_IMAGE,
		    MENU_STRING, (button->name == NULL ? "" : button->name),
		    MENU_NOTIFY_PROC, button->func,
		    MENU_CLIENT_DATA, button,
		    NULL);

	/* separators */
	if ( button->name == NULL)
	  xv_set(mi,MENU_INACTIVE,TRUE,NULL);

	/* disable some functions */
	if( button->func == PshFunc) {
	  xv_set(mi,MENU_INACTIVE,TRUE,NULL);
	}
	
	/* disable all functions exept */
	if (button->exec == NULL)
	  if ( button->func != PropertiesFunc ) /* button->func != ExitFunc*/
	    xv_set(mi,MENU_INACTIVE,TRUE,NULL);

      }

      xv_set(menu,MENU_APPEND_ITEM,mi,NULL);


      
    } /* for */

    if (menud->idefault >= 0)
      xv_set(menu,MENU_DEFAULT,menud->idefault + 2,NULL);

  }
  return menu;
}

Menu
getMenu(frame)
     Frame frame;
{
  menudata   *userroot;

  userroot = getUserMenu();
  
  return(makeMenu(userroot,frame));

}

