#ifdef SVR4
#include <unistd.h>
#include <sys/stat.h>
#ifdef __linux__
# include <stdio.h>
# include <fcntl.h>
#endif

#define MBYTES                   ((int)1048576)              /* Megabytes */


getMem()
{
#ifdef __use_linux__meminfo__
        FILE* meminfo;
        char bufstr[32];
        char memory[32];
        char bogomips[32];
        char sndstr[32];
        char *wk1str;
        char *wk2str;
        int  foundmach=0;
        static char tmpstr[32];

        /* read interesting info in /proc/meminfo */
        if ((meminfo = fopen("/proc/meminfo", "r")) == NULL)
                fprintf(stderr,"Error\n");

        while (feof(meminfo) == 0) {
                if ( fgets (bufstr, 32, meminfo) != NULL ) {
                        wk1str = strtok(bufstr,":");
                        sscanf(wk1str,"%s",sndstr);
                        wk2str = strtok(NULL,":");
                        if( (!strcasecmp(sndstr,"MemTotal")) ||
                            (!strcasecmp(sndstr,"type")) )
                        {
                                strncpy(memory,wk2str,32);
                                foundmach = 1;
                        }
                }
        }
        fclose(meminfo);

        if (foundmach) {
        	snprintf(tmpstr, 32, "%s"
                , memory);
        }
        return (int) (atoi(tmpstr)/1024);
#endif
#ifdef __linux__
	char Kcore[] = "/proc/kcore";
	static char *MemStr = NULL;
	int MemBytes = 0;
	int Amount = 0;
	struct stat StatBuf;

	if (stat(Kcore, &StatBuf) != 0) {
		fprintf(stderr, "%s: stat failed.", Kcore);
		return((char *) NULL);
	}

	MemBytes = (StatBuf.st_size - 4096);
	Amount = (MemBytes/MBYTES);
    
	return(Amount);

#else
        return (int) (sysconf(_SC_PHYS_PAGES) / 1024 * sysconf(_SC_PAGESIZE)/ 1024);
#endif
}
#endif
