/* $Id: gethosttype.c,v 1.3 1999/03/18 12:54:04 root Exp $ */

/* 
 * routines for getting host name
 *
 * Copyright Tomas Stephanson Ellemtel 1992
 */

#define TRUE 1
#define FALSE 0

#ifdef SVR4
#ifndef __linux__
# include <sys/systeminfo.h>
#else
# include <utmp.h>
# include <fcntl.h>
# include <sys/stat.h>
# include <sys/param.h>
# include <sys/types.h>
# include <sys/utsname.h>
#endif
#endif

#ifndef __linux__
#include "suncpu.h"
#endif

/* came in Solaris 5.5 */
#ifndef __linux__
#ifndef SI_PLATFORM
# define      SI_PLATFORM             513     /* return platform identifier */
#endif
#endif

char *
getHostType()
{
  int id;
  unsigned int res;
  char buf[40];
  static char linux_buf[40];
  int solaris55 = FALSE;
  static char systype[256];
  char *systypepek;
#ifdef __linux__
  struct utsname uts;
#endif

#ifdef SVR4
#ifndef __linux__
  /* What a mess if have SI_RELEASE function use it*/
  sysinfo(SI_RELEASE,buf,sizeof(buf));
  /* In Solaris 2.5 and greater we can ask the system */
  if ( buf[0] >= '5' && buf[2] >= '5' ) { /* Solaris 2.5 */
    sysinfo(SI_PLATFORM, systype, sizeof(systype));
    if ( strncmp(systype,"SUNW,",4) == 0 ) { /* remove SUNW,  */
      systypepek = &systype[5];	/* ugly programing */
    } else {
      systypepek = systype;
    }
    return systypepek;
  }
  sysinfo(SI_HW_SERIAL, buf, sizeof(buf));  
  id = atoi(buf);
#else /* __linux__ */
  if (uname(&uts) == -1)
       exit(1);
  snprintf(linux_buf,40,"%s",uts.machine);
  return linux_buf;

#endif /* __linux__ */
#else
  id = gethostid();
#endif /* SVR4 */

#if defined(i386) || defined (__linux__) /* Enter the Solaris PC (All run Solaris 2.5) not true */ 
  return "Upgrade to Solaris 2.5";
#else
  res = (unsigned int) id >> 24;

  switch ( res) {
  case CPU_SUN4C_05:
    return "Sun 4/05";
  case CPU_SUN4C_10:
    return "Sun 4/10";
  case CPU_SUN4C_20:
    return "Sun SLC";
  case CPU_SUN4C_32:
    return "Sun 4/32";
  case CPU_SUN4C_40:
    return "Sun IPC";
  case CPU_SUN4C_45:
    return "Sun 4/45";
  case CPU_SUN4C_50:
    return "Sun IPX";
  case CPU_SUN4C_60:
    return "SS1";
  case CPU_SUN4C_65:
    return "SS1+";
  case CPU_SUN4C_70:
    return "Sun 4/70";
  case CPU_SUN4C_75:
    return "SS2";
  case CPU_SUN4C_80:
    return "Sun 4/80";
  case CPU_SUN4C_85:
    return "Sun 4/85";
  case 0x11:
    return "Sun 3/160";
    break;
  case 0x12:
    return "Sun 3/50";
    break;
  case 0x13:
    return "Sun 3/280";
    break;
  case 0x17:
    return "Sun 3/60";
    break;
  case 0x23:
    return "4/3x0";
    break;
  case 0x24:
    return "4/4x0";
    break;
  caseCPU_SUN4M_60:
    return "4/690";
    break;
  case CPU_SUN4M_50:
      return "SS10/SS20";
    break; 
  case CPU_SUN4M_40:
    return "SUN4M_40";
    break;
  default:
      return "????";
    break;
  }
#endif /* i386 */
}
