/* $Id: global.h,v 1.15 2003/10/27 09:42:58 root Exp $ */

/* @(#)global.h	1.1    26 Feb 1993 */

/*
 ********************************************** 
 * global.h -- structures and functions       *
 * referenced by dumptool.c to load data      *
 * from the specified file to the screen      *
 *                                            *
 * Ramesh S Rao :: Artecon : 911403 : 104208  *
 * Stephen E. Kirkpatrick :: Artecon, Inc.    *
 **********************************************
 */ 

#define DUMPTOOL_VERSION "Artecon's DumpTool 1.2.2 FCS"

#define TRUE 1
#define FALSE 0

#define YES 1
#define NO 0

#define EMPTY_STRING ""
#define NUL '\0' 

#define SUNOS_5X 5
#define SUNOS_4X 4
#define LINUX_2X 2

#define BSD_DUMP "/usr/etc/dump"
#define SVR4_DUMP "/usr/sbin/ufsdump"
#define LINUX_DUMP "/sbin/dump"

#define RSH_CMD "/usr/bin/rsh"
#define RCP_CMD "/usr/bin/rcp"
#define SSH_CMD "/usr/bin/ssh"
#define SCP_CMD "/usr/bin/scp"

#if defined(__GLIBC__) || defined (__linux__)
#define TRUE_TEST_CMD "/bin/true"
#define MAIL_CMD "/bin/mail"
#define UNAME_CMD "/bin/uname"
#define PING_CMD_LINE "/bin/ping -c 1 %s > /dev/null"
#define LOCAL_FILESYSTEM_TYPE "ext2"
#define CRONTAB_CMD "/usr/bin/crontab"
#define GREP_CMD "/bin/grep"
#define DEFAULT_TAPE_DEVICE "/dev/nst0"
#define TAR_CMD "/bin/tar"

#else
#define TRUE_TEST_CMD "/bin/true"
#define MAIL_CMD "/bin/mailx"
#define UNAME_CMD "/bin/uname"
#define PING_CMD_LINE "/usr/sbin/ping %s 1 > /dev/null"
#define LOCAL_FILESYSTEM_TYPE "ufs"
#define CRONTAB_CMD "/bin/crontab"
#define GREP_CMD "/bin/grep"
#define DEFAULT_TAPE_DEVICE "/dev/rmt/0n"
#define TAR_CMD "/usr/sbin/tar"

#endif

#define ALL_DAYS_OF_WEEK (0x7f)   /* all bits except MSB high */
#define MAX_TAPE_TYPE 16          /* max. no of tape drives supported */
