/* $Id: file_data.h,v 1.3 2000/06/15 13:35:15 raistlin Exp $ */

/* @(#)file_data.h	1.1	26 Feb 1993 */

/* 
 * Definition of structure which contains pointers to our GUI setup routines.
 * Stephen E. Kirkpatrick :: Artecon, Inc.
 */

/*
 * function prototypes 
 */
int set_daily_check();
int set_daily_time();
int set_days_of_week();
int set_mail_check();
int set_mail_to();
int set_monthly_check();
int set_monthly_date();
int set_monthly_time();
int set_update_dumpdates();
int set_dump_level();
int set_unload_tape();
int set_tape_host();
int set_tape_device();
int set_tape_type();
int set_tape_size();
int set_tape_density();
int set_blocking_factor();
int set_dump_local();
int set_rcmd_type();
 
struct file_data
    {
     char *begin;      /* Beginning of file entries */
     int (*func)();    /* if beginning matches, function to call */
    } file_data [] =
        {
            { "#Daily check:",        set_daily_check  },
            { "#Daily time:",         set_daily_time   },
            { "#Days of week:",       set_days_of_week },
            { "#Mail check:",         set_mail_check   },
            { "#Mail to:",            set_mail_to      },
            { "#Monthly check:",      set_monthly_check},
            { "#Monthly date:",       set_monthly_date },
            { "#Monthly time:",       set_monthly_time },
            { "#Update dumpdates:",   set_update_dumpdates},
            { "#Dump level:",         set_dump_level   },
            { "#Unload tape:",        set_unload_tape  },
            { "#Tape host:",          set_tape_host    },
            { "#Tape name:",          set_tape_device  },
            { "#Tape type:",          set_tape_type    },
            { "#Tape size:",          set_tape_size    },
            { "#Tape density:",       set_tape_density },
            { "#Blocking factor:",    set_blocking_factor },
            { "#Force local dump:",   set_dump_local },
            { "#RCMD type:",          set_rcmd_type },
            {  NULL,                  NULL             }
        };
