static char rcsid[] = "$Id: dumptool_stubs.c,v 1.16 2003/10/27 10:45:26 root Exp $";

static char SccsId[ ] = "@(#)dumptool_stubs.c	1.3    05/03/96";

/*
 * dumptool_stubs.c - Notify and event callback function stubs.
 * This file was generated by `gxv' from `dumptool.G'.
 * Application specific code added by: Dax Murthy :: Artecon, Inc.
 * Modifications made by Stephen E. Kirkpatrick :: Artecon, Inc.
 * More Modifications made by Vincent S. Cojot :: coyote@step.polymtl.ca
 */

#include <stdio.h>
#include <sys/param.h>
#include <sys/types.h>
#include <sys/utsname.h>
#include <unistd.h>
#include <xview/xview.h>
#include <xview/panel.h>
#include <xview/textsw.h>
#include <xview/xv_xrect.h>
#include <xview/xv_version.h>
#include "dumptool.h"
#include "global.h"

/*
 * External functions.
 */
extern void load_script();                /* load data from file to screen */
extern void schedule_backup();            /* function to schedule backup */
extern void unschedule_backup();          /* function to unschedule backup */
extern void save_script();                /* function to save backup script */
extern int  yes_or_no(char *msg);         /* get a yes or no response from user  */
extern void generic_notifier(char *msg);  /* Put up a Notice with a single message */
extern void get_remote_filesystems();     /* get remote host's file systems */
extern void dumptool_frame_busy_true(void);
extern void dumptool_frame_busy_false(void);

/*
 * Notify callback function for `daily_check_box'.
 * This is invoked everytime the "Daily" check box is checked on and off.
 * This was modified to alter the values of "days of the week" too.
 */
void
do_daily(Panel_item item, int     value, Event *event)
{
    dumptool_base_objects *ip = (dumptool_base_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
    
    /* current value of daily_check_box is stored in `value' */
    /* 0x7f == All bits except MSB  high == 127 in decimal */
 
    /* If daily check box is selected, then select all days of week */
    if (value == 1)
    {
        (void)xv_set(Dumptool_base->days_of_week, PANEL_VALUE, ALL_DAYS_OF_WEEK, NULL);
        /* Make daily_time active */
        (void)xv_set(Dumptool_base->daily_time, PANEL_INACTIVE, FALSE, NULL);
    }
    else  /* Deselect all days of the week */
    {
        (void)xv_set(Dumptool_base->days_of_week, PANEL_VALUE, 0, NULL);
        /* Make daily_time inactive */
        (void)xv_set(Dumptool_base->daily_time, PANEL_INACTIVE, TRUE, NULL);
    }
}

/*
 * Notify callback function for `load_script_button'.
 * This is invoked when the "Load" button is pressed.
 */
void
do_load_script(Panel_item item, Event *event)
{
    dumptool_base_objects *ip = (dumptool_base_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
    
    /* Make sure a file name was specified. */
    if ((int)strcmp((char *)xv_get(Dumptool_base->script_filename, PANEL_VALUE), EMPTY_STRING) == 0)
    {
	    (void)generic_notifier("Please specify the Backup Script Filename.");
	    return;
    }

    /* Now for our own procedure that loads data into the screen */
    (void)dumptool_frame_busy_true();
    (void)load_script();
    (void)dumptool_frame_busy_false();
    
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	/* gxv_end_connections */

}

/*
 * Notify callback function for `save_script_button'.
 * This is invoked everytime the "Save" button is pressed.
 */
void
do_save_script(Panel_item item, Event *event)
{
    dumptool_base_objects *ip = (dumptool_base_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
    
    /* Make sure a file name was specified. */
    if ((int)strcmp((char *)xv_get(Dumptool_base->script_filename, PANEL_VALUE), EMPTY_STRING) == 0)
    {
	    (void)generic_notifier("Please specify the Backup Script Filename.");
	    return;
    }
 
    /* set the frame as busy and call our save function */
    (void)dumptool_frame_busy_true();
    (void)save_script();
    (void)dumptool_frame_busy_false();
    
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	/* gxv_end_connections */

}

/*
 * Notify callback function for `days_of_week'.
 * This is invoked everytime one of the "days of week" boxes is
 * selected / deselected. It also 'checks' or 'unchecks' the "daily"
 * box depending on the final value.
 */
void
do_days_of_week(Panel_item item, unsigned int value, Event *event)
{
    dumptool_base_objects *ip = (dumptool_base_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
    
    /* If all of the days are selected... */
    if (value == ALL_DAYS_OF_WEEK)
    {
        /* Check the Daily box. */
        (void)xv_set(Dumptool_base->daily_check_box, PANEL_VALUE, 1, NULL);
        return;
    }

    /* If one or more of the days is selected... */
    if (value != 0)
    {
        /* Uncheck the Daily box. */
        (void)xv_set(Dumptool_base->daily_check_box, PANEL_VALUE, 0, NULL);
        /* Make sure the daily_time is active. */
        (void)xv_set(Dumptool_base->daily_time, PANEL_INACTIVE, FALSE, NULL);
        return;
    }

    /* No days are selected, Deactivate the daily_time. */
    (void)xv_set(Dumptool_base->daily_time, PANEL_INACTIVE, TRUE, NULL);
    return;
}

/*
 * Notify callback function for `send_mail'.
 * This is invoked every time the send_mail box is checked on and off.
 * Depending on its value, it makes mail_to active or inactive.
 */
void
do_send_mail(Panel_item item, int     value, Event *event)
{
    dumptool_base_objects *ip = (dumptool_base_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
    
    /* If send_mail is unchecked... */
    if (value == 0) 
         /* deactivate mail_to */
        (void)xv_set(Dumptool_base->mail_to, PANEL_INACTIVE, TRUE, NULL);
    else        
        /* activate mail_to */
        (void)xv_set(Dumptool_base->mail_to, PANEL_INACTIVE, FALSE, NULL);
}

/*
 * Notify callback function for `monthly_check_box'.
 * This is invoked every time the Monthly box is checked on or off.
 * Makes the monthly date and time active or inactive depending on
 * the value of this check box (checked or unchecked).
 */
void
do_monthly(Panel_item item, int     value, Event *event)
{
    dumptool_base_objects *ip = (dumptool_base_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
    
    /* if this box is selected, activate monthly date and time */
    if ((int)xv_get(Dumptool_base->monthly_check_box, PANEL_VALUE) == 1)
    {
        (void)xv_set(Dumptool_base->monthly_date, PANEL_INACTIVE, FALSE, NULL);
        (void)xv_set(Dumptool_base->monthly_time, PANEL_INACTIVE, FALSE, NULL);
    }
    else    /* make them inactive again */
    {
        (void)xv_set(Dumptool_base->monthly_date, PANEL_INACTIVE, TRUE, NULL);
        (void)xv_set(Dumptool_base->monthly_time, PANEL_INACTIVE, TRUE, NULL);
    }
}

/*
 * Notify callback function for `schedule_button'.
 * This is called whenever you press the "Schedule" button.
 */
void
do_schedule(Panel_item item, Event *event)
{
    dumptool_base_objects *ip = (dumptool_base_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
    
    /* Make sure a file name was specified. */
    if ((int)strcmp((char *)xv_get(Dumptool_base->script_filename, PANEL_VALUE), EMPTY_STRING) == 0)
    {
        (void)generic_notifier("Please specify the Backup Script Filename.");
        return;
    }
    
    /* call our function to schedule the backup script */
    (void)dumptool_frame_busy_true();
    (void)schedule_backup();
    (void)dumptool_frame_busy_false();
    
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	/* gxv_end_connections */

}

/*
 * Notify callback function for `unschedule_button'.
 * This is called whenever you press the "Unschedule" button.
 */
void
do_unschedule(Panel_item item, Event *event)
{
    dumptool_base_objects *ip = (dumptool_base_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
    
    /* Make sure a file name was specified. */
    if ((int)strcmp((char *)xv_get(Dumptool_base->script_filename, PANEL_VALUE), EMPTY_STRING) == 0)
    {
        (void)generic_notifier("Please specify the Backup Script Filename.");
        return;
    }

    /* call our function to unschedule the backup file */
    (void)dumptool_frame_busy_true();
    (void)unschedule_backup();
    (void)dumptool_frame_busy_false();
    
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	/* gxv_end_connections */

}

/*
 * Notify callback function for `add_filesystem_button'.
 */
void
do_add_filesystem(Panel_item item, Event *event)
{
    dumptool_base_objects *ip = (dumptool_base_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
    
    if ((int)strlen((char *)xv_get(Dumptool_base->remote_hostname, PANEL_VALUE)) == 0) 
    {
        (void)generic_notifier("Please specify a Hostname.");
        return;
    }
 
    (void)xv_set(Dumptool_base->base, FRAME_LEFT_FOOTER, "Retrieving File System List Entries.... ", NULL);
    (void)dumptool_frame_busy_true();
    (void)get_remote_filesystems();
    (void)dumptool_frame_busy_false();
    (void)xv_set(Dumptool_base->base, FRAME_LEFT_FOOTER, "", NULL);
    
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	/* gxv_end_connections */

}

/*
 * Notify callback function for `tape_type'.
 * This is invoked everytime you change the type of tape device.
 * This sets the default values for tape size, density and blocking factor
 * for various types of tape used.
 */
void
do_tape_type(Panel_item item, int     value, Event *event)
{
    dumptool_base_objects *ip = (dumptool_base_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
    
    switch (value)
    {
        case 0: /* Exabyte 8200 */
            (void)xv_set(Dumptool_base->tape_size, PANEL_VALUE, 6250, NULL);
            (void)xv_set(Dumptool_base->blocking_factor, PANEL_VALUE, 126, NULL);
            (void)xv_set(Dumptool_base->tape_density, PANEL_VALUE, 28633, NULL);
            break;

        case 1: /* Exabyte 8205 */
        case 2: /* Exabyte 8500 */
        case 3: /* Exabyte 8500c */
        case 4: /* Exabyte 8505 */
            (void)xv_set(Dumptool_base->tape_size, PANEL_VALUE, 23000, NULL);
            (void)xv_set(Dumptool_base->blocking_factor, PANEL_VALUE, 126, NULL);
            (void)xv_set(Dumptool_base->tape_density, PANEL_VALUE, 28633, NULL);
            break;

        case 5: /* 4 mm - DAT */
            (void)xv_set(Dumptool_base->tape_size, PANEL_VALUE, 3125, NULL);
            (void)xv_set(Dumptool_base->blocking_factor, PANEL_VALUE, 126, NULL);
            (void)xv_set(Dumptool_base->tape_density, PANEL_VALUE, 28633, NULL);
            break;

        case 6: /* 4mm (DDS3) */
            (void)xv_set(Dumptool_base->tape_size, PANEL_VALUE, 9375, NULL);
            (void)xv_set(Dumptool_base->blocking_factor, PANEL_VALUE, 126, NULL);
            (void)xv_set(Dumptool_base->tape_density, PANEL_VALUE, 28633, NULL);
            break;

        case 7: /* 4mm (DDS4) */
            (void)xv_set(Dumptool_base->tape_size, PANEL_VALUE, 15625, NULL);
            (void)xv_set(Dumptool_base->blocking_factor, PANEL_VALUE, 126, NULL);
            (void)xv_set(Dumptool_base->tape_density, PANEL_VALUE, 28633, NULL);
            break;

        case 8: /* QIC 24 */
            (void)xv_set(Dumptool_base->tape_size, PANEL_VALUE, 600, NULL);
            (void)xv_set(Dumptool_base->blocking_factor, PANEL_VALUE, 126, NULL);
            (void)xv_set(Dumptool_base->tape_density, PANEL_VALUE, 1000, NULL);
            break;

        case 9: /* QIC 150 */
            (void)xv_set(Dumptool_base->tape_size, PANEL_VALUE, 1500, NULL);
            (void)xv_set(Dumptool_base->blocking_factor, PANEL_VALUE, 126, NULL);
            (void)xv_set(Dumptool_base->tape_density, PANEL_VALUE, 1000, NULL);
            break;

        case 10: /* QIC 525 */
            (void)xv_set(Dumptool_base->tape_size, PANEL_VALUE, 1020, NULL);
            (void)xv_set(Dumptool_base->blocking_factor, PANEL_VALUE, 126, NULL);
            (void)xv_set(Dumptool_base->tape_density, PANEL_VALUE, 16000, NULL);
            break;

        case 11: /* QIC 1000 */
            (void)xv_set(Dumptool_base->tape_size, PANEL_VALUE, 760, NULL);
            (void)xv_set(Dumptool_base->blocking_factor, PANEL_VALUE, 126, NULL);
            (void)xv_set(Dumptool_base->tape_density, PANEL_VALUE, 36000, NULL);
            break;

        case 12: /* QIC 1350 */
            (void)xv_set(Dumptool_base->tape_size, PANEL_VALUE, 760, NULL);
            (void)xv_set(Dumptool_base->blocking_factor, PANEL_VALUE, 126, NULL);
            (void)xv_set(Dumptool_base->tape_density, PANEL_VALUE, 51667, NULL);
            break;

        case 13: /* QIC 2100C */
            (void)xv_set(Dumptool_base->tape_size, PANEL_VALUE, 925, NULL);
            (void)xv_set(Dumptool_base->blocking_factor, PANEL_VALUE, 126, NULL);
            (void)xv_set(Dumptool_base->tape_density, PANEL_VALUE, 67773, NULL);
            break;

        case 14: /* DLT4000 */
            (void)xv_set(Dumptool_base->tape_size, PANEL_VALUE, 130000, NULL);
            (void)xv_set(Dumptool_base->blocking_factor, PANEL_VALUE, 126, NULL);
            (void)xv_set(Dumptool_base->tape_density, PANEL_VALUE, 62500, NULL);  
            break;

        case 15: /* DLT7000 */
            (void)xv_set(Dumptool_base->tape_size, PANEL_VALUE, 227500, NULL);
            (void)xv_set(Dumptool_base->blocking_factor, PANEL_VALUE, 126, NULL);
            (void)xv_set(Dumptool_base->tape_density, PANEL_VALUE, 62500, NULL);   
            break;

        case 16: /* DLT8000 */
            (void)xv_set(Dumptool_base->tape_size, PANEL_VALUE, 260000, NULL);
            (void)xv_set(Dumptool_base->blocking_factor, PANEL_VALUE, 126, NULL);
            (void)xv_set(Dumptool_base->tape_density, PANEL_VALUE, 62500, NULL); 
            break;
    }
    
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	/* gxv_end_connections */

}

/*
 * Notify callback function for `delete_filesystem'.
 */
void
do_delete_filesystem(Panel_item item, Event *event)
{
    dumptool_base_objects *ip = (dumptool_base_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
    
    int number_of_rows;
    int current_row;
    int selected = FALSE;
    char selected_entry[80];
    char message[80];
 
    number_of_rows = (int)xv_get(Dumptool_base->filesystem_list, PANEL_LIST_NROWS);

    (void)dumptool_frame_busy_true();

    for (current_row = number_of_rows - 1; current_row >= 0; current_row--) 
    {
        if ((int)xv_get(Dumptool_base->filesystem_list, PANEL_LIST_SELECTED, current_row))
        {
            selected = TRUE;
            (void)strcpy(selected_entry, 
                         (char *)xv_get(Dumptool_base->filesystem_list,
                                        PANEL_LIST_STRING, current_row));
            (void)sprintf(message, "Delete '%s' from the File System List?", selected_entry);
            if ((int)yes_or_no(message) == YES)
                (void)xv_set(Dumptool_base->filesystem_list, PANEL_LIST_DELETE, current_row, NULL);
        }
    }

    if ((number_of_rows != 0) && !(selected))
        (void)generic_notifier("Please select an entry from the File System List and try again.");
    
    (void)dumptool_frame_busy_false();


	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	/* gxv_end_connections */

}

/*
 * Notify callback function for `update_dumpdates'.
 */
void
do_update_dumpdates(Panel_item item, int     value, Event *event)
{
    dumptool_base_objects *ip = (dumptool_base_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
    
    /* If user tried to check "Update dumpdates" and user is NOT root... */
    if ((value == 1) && (getuid() != 0))
    {
        (void)generic_notifier("Only the 'root' user can update /etc/dumpdates.");
        (void)xv_set(Dumptool_base->update_dumpdates, PANEL_VALUE, 0, NULL);
    }

		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		/* gxv_end_connections */
}

/*
 * Notify callback function for `dump_local'.
 */
void
do_dump_local(Panel_item item, int value, Event *event)
{
	dumptool_base_objects *ip = (dumptool_base_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	short	i;
	
	struct utsname uname_host;
	char tmp_local_hostname[256];

    uname(&uname_host);
    strncpy(tmp_local_hostname,uname_host.nodename,256);
	
    if (value == 1)
    {
	(void)xv_set(Dumptool_base->tape_host, PANEL_VALUE, tmp_local_hostname, NULL);
        (void)xv_set(Dumptool_base->tape_host, PANEL_INACTIVE, TRUE, NULL);
        (void)xv_set(Dumptool_base->rcmd_type, PANEL_INACTIVE, TRUE, NULL);
    } else {
        (void)xv_set(Dumptool_base->tape_host, PANEL_INACTIVE, FALSE, NULL);
        (void)xv_set(Dumptool_base->rcmd_type, PANEL_INACTIVE, FALSE, NULL);
    }
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		/* gxv_end_connections */
}

/*
 * Notify callback function for `rcmd_type'.
 */
void
do_rcmd_type(Panel_item item, int value, Event *event)
{
	dumptool_base_objects *ip = (dumptool_base_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	/* fprintf(stderr, "dumptool: do_rcmd_type: value: %u\n", value); */
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	/* gxv_end_connections */

}
