#!/bin/sh
TAR_DIR=`basename $PWD`
FROM_DIR=`dirname $PWD`
echo "Using $TAR_DIR..."
TAR_FILE="${TAR_DIR}-`date '+%Y%m%d'`.tar.gz"
SRC_DIR=/usr/local/src

if [ "`uname -n`" != "ergoth" ]; then
	echo "Run this on dev host ergoth!"
	exit 1
fi

echo "Cleaning Up..."
gmake clean ; /bin/rm -f dumptool

echo "Using file ${TAR_FILE}..."
echo "Sleeping 2 secs..."
sleep 2
cd $FROM_DIR
gtar cvzf /tmp/${TAR_FILE} ${TAR_DIR}

if [ -z "${TAR_DIR}" ]; then
	echo "Error: TAR_DIR is empty!"
	exit 1
else
	echo "TAR_DIR is: ${TAR_DIR}"
fi

echo "Sleeping 2 secs..."
sleep 2

for ssh_host in ergoth thorbardin palanthas
do
	if [ "$ssh_host" != "ergoth" ]; then
		echo "Copying to: root@${ssh_host}"
		scp /tmp/${TAR_FILE} ${ssh_host}:/tmp/${TAR_FILE}
		GTAR=/bin/gtar
	else
		GTAR=/usr/local/bin/gtar
	fi
	echo "Extracting on: root@${ssh_host}"
	if [ "$ssh_host" != "ergoth" ]; then
		ssh -n ${ssh_host} -l root "$GTAR xvzf /tmp/${TAR_FILE} -C /usr/local/src;chown -R root:root ${SRC_DIR}/${TAR_DIR};/bin/rm -f /tmp/${TAR_FILE}"
	else
		ssh -n ${ssh_host} -l root "$GTAR xvzf /tmp/${TAR_FILE} -C /usr/local/src;chown -R root:root ${SRC_DIR}/${TAR_DIR}"
	fi
done
