
/*  @(#)dsdefs.h 1.3 02/02/27
 *
 *  External definitions needed by calctool from the libdeskset, libguide
 *  and libguidexv include files.
 *
 *  Copyright (c) 1987-2002, Sun Microsystems, Inc.  All Rights Reserved.
 *  Sun considers its source code as an unpublished, proprietary
 *  trade secret, and it is available only under strict license
 *  provisions.  This copyright notice is placed here only to protect
 *  Sun in the event the source is deemed a published work.  Dissassembly,
 *  decompilation, or other means of reducing the object code to human
 *  readable form is prohibited by the license agreement under which
 *  this code is provided to the user or company in possession of this
 *  copy.
 *
 *  RESTRICTED RIGHTS LEGEND: Use, duplication, or disclosure by the
 *  Government is subject to restrictions as set forth in subparagraph
 *  (c)(1)(ii) of the Rights in Technical Data and Computer Software
 *  clause at DFARS 52.227-7013 and in similar clauses in the FAR and
 *  NASA FAR Supplement.
 */

#ifndef __DSDEFS_H__
#define __DSDEFS_H__

#define OWTOOLKIT_WARNING_DISABLED

#include <xview/xview.h>
#include <xview/panel.h>
#include <X11/Xlib.h>
#include <X11/Xresource.h>

/* Definitions taken from .../libdeskset/<various>.h */

/* Location ops for ds_position_popup(). */

enum ds_location_op {
    DS_POPUP_RIGHT,     /* Place popup to right of baseframe */
    DS_POPUP_LEFT,      /* Place popup to left of baseframe */
    DS_POPUP_ABOVE,     /* Place popup above baseframe */
    DS_POPUP_BELOW,     /* Place popup below baseframe */
    DS_POPUP_LOR,       /* Place popup to right or left of baseframe */
    DS_POPUP_AOB,       /* Place popup above or below baseframe */
    DS_POPUP_CENTERED   /* Center popup within baseframe */
};

int ds_position_popup();
int ds_get_strwidth(XFontStruct *, char *);
int ds_center_items(Panel panel, int row, ...);

XFontStruct *ds_get_font(Display *, char *, int);
XrmDatabase ds_load_deskset_defs();
XrmDatabase ds_load_resources(Display *);
Xv_opaque ds_add_help(Xv_opaque, char *);
Xv_opaque ds_save_cmdline(Frame, int, char *[]);
Xv_opaque ds_save_resources(XrmDatabase);
Xv_opaque ds_set_frame_size(Xv_Window, int, int, int, int);

Rect *ds_get_frame_size(Xv_Window, int *, int *, int *, int *);

char *ds_get_resource(XrmDatabase, char *, char *);
char *ds_hostname(Display *);

void ds_beep(Display *);
void ds_expand_pathname(char *, char *);
void ds_get_geometry_size(char *, int *, int *);
void ds_put_resource(XrmDatabase *, char *, char *, char *);

#endif /* __DSDEFS_H__ */
