
/*  @(#)calctool_ui.h 1.4 02/02/27
 *
 *  User interface object and function declarations.
 *
 *  Copyright (c) 1987-2002, Sun Microsystems, Inc.  All Rights Reserved.
 *  Sun considers its source code as an unpublished, proprietary
 *  trade secret, and it is available only under strict license
 *  provisions.  This copyright notice is placed here only to protect
 *  Sun in the event the source is deemed a published work.  Dissassembly,
 *  decompilation, or other means of reducing the object code to human
 *  readable form is prohibited by the license agreement under which
 *  this code is provided to the user or company in possession of this
 *  copy.
 *
 *  RESTRICTED RIGHTS LEGEND: Use, duplication, or disclosure by the
 *  Government is subject to restrictions as set forth in subparagraph
 *  (c)(1)(ii) of the Rights in Technical Data and Computer Software
 *  clause at DFARS 52.227-7013 and in similar clauses in the FAR and
 *  NASA FAR Supplement.
 */

#ifndef __CALCTOOL_UI_H__
#define __CALCTOOL_UI_H__

#include <locale.h>

extern Attr_attribute INSTANCE;

extern Xv_opaque acc_menu_create(caddr_t, Xv_opaque);
extern Xv_opaque exch_menu_create(caddr_t, Xv_opaque);
extern Xv_opaque lshift_menu_create(caddr_t, Xv_opaque);
extern Xv_opaque base_menu_create(caddr_t, Xv_opaque);
extern Xv_opaque disp_menu_create(caddr_t, Xv_opaque);
extern Xv_opaque trig_menu_create(caddr_t, Xv_opaque);
extern Xv_opaque mode_menu_create(caddr_t, Xv_opaque);
extern Xv_opaque props_menu_create(caddr_t, Xv_opaque);
extern Xv_opaque rcl_menu_create(caddr_t, Xv_opaque);
extern Xv_opaque sto_menu_create(caddr_t, Xv_opaque);
extern Xv_opaque rshift_menu_create(caddr_t, Xv_opaque);

typedef struct {
    Xv_opaque kframe;
    Xv_opaque kcanvas;
} kframe_objects;

extern kframe_objects *kframe_objects_initialize(kframe_objects *, Xv_opaque);

typedef struct {
    Xv_opaque mframe;
    Xv_opaque mcanvas;
} mframe_objects;

extern mframe_objects *mframe_objects_initialize(mframe_objects *, Xv_opaque);

typedef struct {
    Xv_opaque Aframe;
    Xv_opaque Apanel;
    Xv_opaque Api_text;
    Xv_opaque Adummy;
    Xv_opaque Api_but;
    Xv_opaque Agroup;
} Aframe_objects;

extern Aframe_objects *Aframe_objects_initialize(Aframe_objects *, Xv_opaque);

extern Xv_opaque Aframe_Apanel_create(Aframe_objects *, Xv_opaque);

typedef struct {
    Xv_opaque rframe;
    Xv_opaque rcanvas;
} rframe_objects;

extern rframe_objects *rframe_objects_initialize(rframe_objects *, Xv_opaque);

typedef struct {
    Xv_opaque CFframe;
    Xv_opaque CFpanel;
    Xv_opaque CFpi_cftext;
    Xv_opaque CFpi_dtext;
    Xv_opaque CFpi_vtext;
    Xv_opaque CFpi_cbut;
    Xv_opaque CFgroup;
    Xv_opaque CFpi_fbut;
} CFframe_objects;

extern CFframe_objects *CFframe_objects_initialize(CFframe_objects *, 
                                                   Xv_opaque);

extern Xv_opaque CFframe_CFpanel_create(CFframe_objects *, Xv_opaque);

typedef struct {
    Xv_opaque Pframe;
    Xv_opaque Ppanel;
    Xv_opaque Pappearance;
    Xv_opaque Pdisplay;
    Xv_opaque Pstyle;
    Xv_opaque Pgroup2;
    Xv_opaque Papply;
    Xv_opaque Pdefaults;
    Xv_opaque Preset;
    Xv_opaque Pgroup1;
    Xv_opaque Pgroup3;
} Pframe_objects;

extern Pframe_objects *Pframe_objects_initialize(Pframe_objects *, Xv_opaque);

extern Xv_opaque Pframe_Ppanel_create(Pframe_objects *, Xv_opaque);

#endif /* __CALCTOOL_UI_H__ */
