
/*  @(#)calctool_ui.c 1.5 02/02/27
 *
 *  User interface object initialization functions.
 *
 *  Copyright (c) 1987-2002, Sun Microsystems, Inc.  All Rights Reserved.
 *  Sun considers its source code as an unpublished, proprietary
 *  trade secret, and it is available only under strict license
 *  provisions.  This copyright notice is placed here only to protect
 *  Sun in the event the source is deemed a published work.  Dissassembly,
 *  decompilation, or other means of reducing the object code to human
 *  readable form is prohibited by the license agreement under which
 *  this code is provided to the user or company in possession of this
 *  copy.
 *
 *  RESTRICTED RIGHTS LEGEND: Use, duplication, or disclosure by the
 *  Government is subject to restrictions as set forth in subparagraph
 *  (c)(1)(ii) of the Rights in Technical Data and Computer Software
 *  clause at DFARS 52.227-7013 and in similar clauses in the FAR and
 *  NASA FAR Supplement.
 */

#define OWTOOLKIT_WARNING_DISABLED

#include <stdio.h>
#include <sys/param.h>
#include <sys/types.h>
#include <xview/xview.h>
#include <xview/canvas.h>
#include <xview/panel.h>
#include <xview/scrollbar.h>
#include <xview/svrimage.h>
#include <xview/termsw.h>
#include <xview/text.h>
#include <xview/tty.h>
#include <xview/xv_xrect.h>
#include "calctool_ui.h"

#define DGET(s) dgettext("SUNW_DESKSET_CALCTOOL_LABEL", s)

/* Definitions taken from .../libguidexv/group.h */

static int         group_init();
static Xv_opaque   group_set();
static Xv_opaque   group_get();
static int         group_destroy();

typedef struct {
    Xv_generic_struct parent_data;
    Xv_opaque         private_data;
} Group_public;

static Xv_pkg group_pkg = {
    "Group",                    /* Package name */
    ATTR_PKG_UNUSED_LAST - 2,   /* Package ID */
    sizeof(Group_public),       /* Size of public struct */
    XV_GENERIC_OBJECT,          /* Subclass of XV_GENERIC_OBJECT */
    group_init,
    group_set,
    group_get,
    group_destroy,
    NULL                        /* No xv_find() */
};

#define GROUP &group_pkg

typedef Xv_opaque Group;

#define ATTR_PKG_GROUP               ATTR_PKG_UNUSED_LAST - 2
#define GROUP_ATTR(type, ordinal)    ATTR(ATTR_PKG_GROUP, type, ordinal)

/* Public attributes. */

typedef enum {
    GROUP_TYPE                = GROUP_ATTR(ATTR_ENUM,     1),     /* CSG */
    GROUP_ROWS                = GROUP_ATTR(ATTR_INT,      2),     /* CSG */
    GROUP_COLUMNS             = GROUP_ATTR(ATTR_INT,      3),     /* CSG */
    GROUP_HORIZONTAL_SPACING  = GROUP_ATTR(ATTR_INT,      4),     /* CSG */
    GROUP_VERTICAL_SPACING    = GROUP_ATTR(ATTR_INT,      5),     /* CSG */
    GROUP_ROW_ALIGNMENT       = GROUP_ATTR(ATTR_ENUM,     6),     /* CSG */
    GROUP_COLUMN_ALIGNMENT    = GROUP_ATTR(ATTR_ENUM,     7),     /* CSG */
    GROUP_MEMBERS = GROUP_ATTR(ATTR_LIST_INLINE(ATTR_NULL, ATTR_OPAQUE), 8), /*
CSG */
    GROUP_MEMBERS_PTR         = GROUP_ATTR(ATTR_OPAQUE,   9),     /* CSG */
    GROUP_ANCHOR_OBJ          = GROUP_ATTR(ATTR_OPAQUE,  10),     /* CSG */
    GROUP_ANCHOR_POINT        = GROUP_ATTR(ATTR_ENUM,    11),     /* CSG */
    GROUP_REFERENCE_POINT     = GROUP_ATTR(ATTR_ENUM,    12),     /* CSG */
    GROUP_HORIZONTAL_OFFSET   = GROUP_ATTR(ATTR_INT,     13),     /* CSG */
    GROUP_VERTICAL_OFFSET     = GROUP_ATTR(ATTR_INT,     14),     /* CSG */
    GROUP_PARENT              = GROUP_ATTR(ATTR_OPAQUE,  15),     /* --G */
    GROUP_LAYOUT              = GROUP_ATTR(ATTR_BOOLEAN, 16),     /* CSG */
    GROUP_REPLACE_MEMBER      = GROUP_ATTR(ATTR_OPAQUE_PAIR, 17)  /* -S- */
} Group_attr;
 
typedef enum {
    GROUP_NONE,
    GROUP_ROW,
    GROUP_COLUMN,
    GROUP_ROWCOLUMN
} GROUP_TYPES;
 
typedef enum {
    GROUP_LEFT_EDGES,
    GROUP_LABELS,
    GROUP_VERTICAL_CENTERS,
    GROUP_RIGHT_EDGES
} GROUP_COLUMN_ALIGNMENTS;
 
typedef enum {
    GROUP_TOP_EDGES,
    GROUP_HORIZONTAL_CENTERS,
    GROUP_BOTTOM_EDGES
} GROUP_ROW_ALIGNMENTS;

typedef enum {
    GROUP_NORTHWEST,
    GROUP_NORTH,
    GROUP_NORTHEAST,
    GROUP_WEST,
    GROUP_CENTER,
    GROUP_EAST,
    GROUP_SOUTHWEST,
    GROUP_SOUTH,
    GROUP_SOUTHEAST
} GROUP_COMPASS_POINTS;
 
/* Public functions. */
 
EXTERN_FUNCTION(void group_layout, (Group));
EXTERN_FUNCTION(void group_anchor, (Group));
 
 
/* Definitions taken from .../libguide/guide.h */
 
/* Types for the G_GROUP_TYPE attribute. */
 
typedef enum
{
    G_NONE,
    G_ROW,
    G_COLUMN,
    G_ROWCOLUMN
} G_GROUP_TYPES;

/* Definitions taken from .../libguidexv/group_impl.h */

typedef struct {
    Xv_object               public_self;
    G_GROUP_TYPES           group_type;
    Xv_opaque               *members;
    int                     cols;
    GROUP_COLUMN_ALIGNMENTS col_alignment;
    int                     rows;
    GROUP_ROW_ALIGNMENTS    row_alignment;
    int                     hspacing;
    int                     vspacing;
    Xv_opaque               anchor_obj;      /* Object anchored to */
    GROUP_COMPASS_POINTS    anchor_point;    /* Point on anchor obj */
    GROUP_COMPASS_POINTS    reference_point; /* Point on group */
    int                     hoffset;
    int                     voffset;
    Rect                    group_rect;
    Rect                    value_rect;
    int                     initial_x;
    int                     initial_y;
    unsigned int            flags;
} Group_private;

#define GROUP_PUBLIC(item)  XV_PUBLIC(item)
#define GROUP_PRIVATE(item) XV_PRIVATE(Group_private, Group_public, item)

typedef enum {
    CREATED  = (1L << 0),
    LAYOUT   = (1L << 1),
    INACTIVE = (1L << 2),
    SHOWING  = (1L << 3),
    ROWFIRST = (1L << 4),
    COLFIRST = (1L << 5)
} GROUP_FLAGS;

static Xv_opaque kframe_kframe_create(kframe_objects *, Xv_opaque);
static Xv_opaque kframe_kcanvas_create(kframe_objects *, Xv_opaque);

static Xv_opaque mframe_mframe_create(mframe_objects *, Xv_opaque);
static Xv_opaque mframe_mcanvas_create(mframe_objects *, Xv_opaque);

static Xv_opaque Aframe_Aframe_create(Aframe_objects *, Xv_opaque);
static Xv_opaque Aframe_Api_text_create(Aframe_objects *, Xv_opaque);
static Xv_opaque Aframe_Adummy_create(Aframe_objects *, Xv_opaque);
static Xv_opaque Aframe_Api_but_create(Aframe_objects *, Xv_opaque);
static Xv_opaque Aframe_Agroup_create(Aframe_objects *, Xv_opaque);

static Xv_opaque rframe_rframe_create(rframe_objects *, Xv_opaque);
static Xv_opaque rframe_rcanvas_create(rframe_objects *, Xv_opaque);

static Xv_opaque CFframe_CFframe_create(CFframe_objects *, Xv_opaque);
static Xv_opaque CFframe_CFpi_cftext_create(CFframe_objects *, Xv_opaque);
static Xv_opaque CFframe_CFpi_dtext_create(CFframe_objects *, Xv_opaque);
static Xv_opaque CFframe_CFpi_vtext_create(CFframe_objects *, Xv_opaque);
static Xv_opaque CFframe_CFpi_cbut_create(CFframe_objects *, Xv_opaque);
static Xv_opaque CFframe_CFgroup_create(CFframe_objects *, Xv_opaque);
static Xv_opaque CFframe_CFpi_fbut_create(CFframe_objects *, Xv_opaque);

static Xv_opaque Pframe_Pframe_create(Pframe_objects *, Xv_opaque);
static Xv_opaque Pframe_Pappearance_create(Pframe_objects *, Xv_opaque);
static Xv_opaque Pframe_Pdisplay_create(Pframe_objects *, Xv_opaque);
static Xv_opaque Pframe_Pstyle_create(Pframe_objects *, Xv_opaque);
static Xv_opaque Pframe_Pgroup2_create(Pframe_objects *, Xv_opaque);
static Xv_opaque Pframe_Papply_create(Pframe_objects *, Xv_opaque);
static Xv_opaque Pframe_Pdefaults_create(Pframe_objects *, Xv_opaque);
static Xv_opaque Pframe_Preset_create(Pframe_objects *, Xv_opaque);
static Xv_opaque Pframe_Pgroup1_create(Pframe_objects *, Xv_opaque);
static Xv_opaque Pframe_Pgroup3_create(Pframe_objects *, Xv_opaque);


/* Dummy function defintions from .../libguidexv/group.c */
 
/*ARGSUSED*/
static int
group_init(Xv_opaque owner, Group_public *group_public, Attr_avlist avlist)
{
    return(0);
}


/*ARGSUSED*/
static Xv_opaque
group_set(Group group_public, Attr_avlist avlist)
{
    return(0);
}


/*ARGSUSED*/
static Xv_opaque
group_get(Group_public *group_public, int *status,
          Attr_attribute attr, Attr_avlist args)
{
    return(0);
}


/*ARGSUSED*/
static int
group_destroy(Group_public *group_public, Destroy_status status)
{
    return(0);
}


/* Create object `acc_menu' in the specified instance. */

Xv_opaque
acc_menu_create(caddr_t ip, Xv_opaque owner)
{
    Xv_opaque obj;
    
    obj = xv_create(XV_NULL, MENU_COMMAND_MENU,
                    XV_KEY_DATA, INSTANCE, ip,
                    MENU_TITLE_ITEM, owner ? "" : DGET("Accuracy"),
                    MENU_ITEM,
                        XV_KEY_DATA, INSTANCE, ip,
                        MENU_STRING, DGET("0 radix places"),
                        NULL,
                    MENU_ITEM,
                        XV_KEY_DATA, INSTANCE, ip,
                        MENU_STRING, DGET("1 radix places"),
                        NULL,
                    MENU_ITEM,
                        XV_KEY_DATA, INSTANCE, ip,
                        MENU_STRING, DGET("2 radix places"),
                        NULL,
                    MENU_ITEM,
                        XV_KEY_DATA, INSTANCE, ip,
                        MENU_STRING, DGET("3 radix places"),
                        NULL,
                    MENU_ITEM,
                        XV_KEY_DATA, INSTANCE, ip,
                        MENU_STRING, DGET("4 radix places"),
                        NULL,
                    MENU_ITEM,
                        XV_KEY_DATA, INSTANCE, ip,
                        MENU_STRING, DGET("5 radix places"),
                        NULL,
                    MENU_ITEM,
                        XV_KEY_DATA, INSTANCE, ip,
                        MENU_STRING, DGET("6 radix places"),
                        NULL,
                    MENU_ITEM,
                        XV_KEY_DATA, INSTANCE, ip,
                        MENU_STRING, DGET("7 radix places"),
                        NULL,
                    MENU_ITEM,
                        XV_KEY_DATA, INSTANCE, ip,
                        MENU_STRING, DGET("8 radix places"),
                        NULL,
                    MENU_ITEM,
                        XV_KEY_DATA, INSTANCE, ip,
                        MENU_STRING, DGET("9 radix places"),
                        NULL,
                    MENU_GEN_PIN_WINDOW, owner, DGET("Accuracy"),
                    NULL);

    return(obj);
}


/* Create object `exch_menu' in the specified instance. */

Xv_opaque
exch_menu_create(caddr_t ip, Xv_opaque owner)
{
    Xv_opaque obj;
    
    obj = xv_create(XV_NULL, MENU_COMMAND_MENU,
                    XV_KEY_DATA, INSTANCE, ip,
                    MENU_TITLE_ITEM, owner ? "" : DGET("Exchange"),
                    MENU_ITEM,
                        XV_KEY_DATA, INSTANCE, ip,
                        MENU_STRING, DGET("Register 0"),
                        NULL,
                    MENU_ITEM,
                        XV_KEY_DATA, INSTANCE, ip,
                        MENU_STRING, DGET("Register 1"),
                        NULL,
                    MENU_ITEM,
                        XV_KEY_DATA, INSTANCE, ip,
                        MENU_STRING, DGET("Register 2"),
                        NULL,
                    MENU_ITEM,
                        XV_KEY_DATA, INSTANCE, ip,
                        MENU_STRING, DGET("Register 3"),
                        NULL,
                    MENU_ITEM,
                        XV_KEY_DATA, INSTANCE, ip,
                        MENU_STRING, DGET("Register 4"),
                        NULL,
                    MENU_ITEM,
                        XV_KEY_DATA, INSTANCE, ip,
                        MENU_STRING, DGET("Register 5"),
                        NULL,
                    MENU_ITEM,
                        XV_KEY_DATA, INSTANCE, ip,
                        MENU_STRING, DGET("Register 6"),
                        NULL,
                    MENU_ITEM,
                        XV_KEY_DATA, INSTANCE, ip,
                        MENU_STRING, DGET("Register 7"),
                        NULL,
                    MENU_ITEM,
                        XV_KEY_DATA, INSTANCE, ip,
                        MENU_STRING, DGET("Register 8"),
                        NULL,
                    MENU_ITEM,
                        XV_KEY_DATA, INSTANCE, ip,
                        MENU_STRING, DGET("Register 9"),
                        NULL,
                    MENU_GEN_PIN_WINDOW, owner, DGET("Exchange"),
                    NULL);

    return(obj);
}


/* Create object `lshift_menu' in the specified instance. */

Xv_opaque
lshift_menu_create(caddr_t ip, Xv_opaque owner)
{
    Xv_opaque obj;
    
    obj = xv_create(XV_NULL, MENU_COMMAND_MENU,
                    XV_KEY_DATA, INSTANCE, ip,
                    MENU_TITLE_ITEM, owner ? "" : DGET("Left shift"),
                    MENU_ITEM,
                        XV_KEY_DATA, INSTANCE, ip,
                        MENU_STRING, DGET("1 place"),
                        NULL,
                    MENU_ITEM,
                        XV_KEY_DATA, INSTANCE, ip,
                        MENU_STRING, DGET("2 places"),
                        NULL,
                    MENU_ITEM,
                        XV_KEY_DATA, INSTANCE, ip,
                        MENU_STRING, DGET("3 places"),
                        NULL,
                    MENU_ITEM,
                        XV_KEY_DATA, INSTANCE, ip,
                        MENU_STRING, DGET("4 places"),
                        NULL,
                    MENU_ITEM,
                        XV_KEY_DATA, INSTANCE, ip,
                        MENU_STRING, DGET("5 places"),
                        NULL,
                    MENU_ITEM,
                        XV_KEY_DATA, INSTANCE, ip,
                        MENU_STRING, DGET("6 places"),
                        NULL,
                    MENU_ITEM,
                        XV_KEY_DATA, INSTANCE, ip,
                        MENU_STRING, DGET("7 places"),
                        NULL,
                    MENU_ITEM,
                        XV_KEY_DATA, INSTANCE, ip,
                        MENU_STRING, DGET("8 places"),
                        NULL,
                    MENU_ITEM,
                        XV_KEY_DATA, INSTANCE, ip,
                        MENU_STRING, DGET("9 places"),
                        NULL,
                    MENU_ITEM,
                        XV_KEY_DATA, INSTANCE, ip,
                        MENU_STRING, DGET("10 places"),
                        NULL,
                    MENU_ITEM,
                        XV_KEY_DATA, INSTANCE, ip,
                        MENU_STRING, DGET("11 places"),
                        NULL,
                    MENU_ITEM,
                        XV_KEY_DATA, INSTANCE, ip,
                        MENU_STRING, DGET("12 places"),
                        NULL,
                    MENU_ITEM,
                        XV_KEY_DATA, INSTANCE, ip,
                        MENU_STRING, DGET("13 places"),
                        NULL,
                    MENU_ITEM,
                        XV_KEY_DATA, INSTANCE, ip,
                        MENU_STRING, DGET("14 places"),
                        NULL,
                    MENU_ITEM,
                        XV_KEY_DATA, INSTANCE, ip,
                        MENU_STRING, DGET("15 places"),
                        NULL,
                    MENU_GEN_PIN_WINDOW, owner, DGET("Left shift"),
                    NULL);

    return(obj);
}


/* Create object `base_menu' in the specified instance. */

Xv_opaque
base_menu_create(caddr_t ip, Xv_opaque owner)
{
    Xv_opaque obj;
    
    obj = xv_create(XV_NULL, MENU_COMMAND_MENU,
                    XV_KEY_DATA, INSTANCE, ip,
                    MENU_TITLE_ITEM, owner ? "" : DGET("Numeric base"),
                    MENU_ITEM,
                        XV_KEY_DATA, INSTANCE, ip,
                        MENU_STRING, DGET("Binary"),
                        NULL,
                    MENU_ITEM,
                        XV_KEY_DATA, INSTANCE, ip,
                        MENU_STRING, DGET("Octal"),
                        NULL,
                    MENU_ITEM,
                        XV_KEY_DATA, INSTANCE, ip,
                        MENU_STRING, DGET("Decimal"),
                        NULL,
                    MENU_ITEM,
                        XV_KEY_DATA, INSTANCE, ip,
                        MENU_STRING, DGET("Hexadecimal"),
                        NULL,
                    MENU_GEN_PIN_WINDOW, owner, DGET("Numeric base"),
                    NULL);

    return(obj);
}


/* Create object `disp_menu' in the specified instance. */

Xv_opaque
disp_menu_create(caddr_t ip, Xv_opaque owner)
{
    Xv_opaque obj;
    
    obj = xv_create(XV_NULL, MENU_COMMAND_MENU,
                    XV_KEY_DATA, INSTANCE, ip,
                    MENU_TITLE_ITEM, owner ? "" : DGET("Display type"),
                    MENU_ITEM,
                        XV_KEY_DATA, INSTANCE, ip,
                        MENU_STRING, DGET("Engineering"),
                        NULL,
                    MENU_ITEM,
                        XV_KEY_DATA, INSTANCE, ip,
                        MENU_STRING, DGET("Fixed point"),
                        NULL,
                    MENU_ITEM,
                        XV_KEY_DATA, INSTANCE, ip,
                        MENU_STRING, DGET("Scientific"),
                        NULL,
                    MENU_GEN_PIN_WINDOW, owner, DGET("Display type"),
                    NULL);

    return(obj);
}


/* Create object `trig_menu' in the specified instance. */

Xv_opaque
trig_menu_create(caddr_t ip, Xv_opaque owner)
{
    Xv_opaque obj;
    
    obj = xv_create(XV_NULL, MENU_COMMAND_MENU,
                    XV_KEY_DATA, INSTANCE, ip,
                    MENU_TITLE_ITEM, owner ? "" : DGET("Trigonometric type"),
                    MENU_ITEM,
                        XV_KEY_DATA, INSTANCE, ip,
                        MENU_STRING, DGET("Degrees"),
                        NULL,
                    MENU_ITEM,
                        XV_KEY_DATA, INSTANCE, ip,
                        MENU_STRING, DGET("Gradients"),
                        NULL,
                    MENU_ITEM,
                        XV_KEY_DATA, INSTANCE, ip,
                        MENU_STRING, DGET("Radians"),
                        NULL,
                    MENU_GEN_PIN_WINDOW, owner, DGET("Trigonometric type"),
                    NULL);

    return(obj);
}


/* Create object `mode_menu' in the specified instance. */

Xv_opaque
mode_menu_create(caddr_t ip, Xv_opaque owner)
{
    Xv_opaque obj;
    
    obj = xv_create(XV_NULL, MENU_COMMAND_MENU,
                    XV_KEY_DATA, INSTANCE, ip,
                    MENU_TITLE_ITEM, owner ? "" : DGET("Mode"),
                    MENU_ITEM,
                        XV_KEY_DATA, INSTANCE, ip,
                        MENU_STRING, DGET("Basic"),
                        NULL,
                    MENU_ITEM,
                        XV_KEY_DATA, INSTANCE, ip,
                        MENU_STRING, DGET("Financial"),
                        NULL,
                    MENU_ITEM,
                        XV_KEY_DATA, INSTANCE, ip,
                        MENU_STRING, DGET("Logical"),
                        NULL,
                    MENU_ITEM,
                        XV_KEY_DATA, INSTANCE, ip,
                        MENU_STRING, DGET("Scientific"),
                        NULL,
                    MENU_GEN_PIN_WINDOW, owner, DGET("Mode"),
                    NULL);

    return(obj);
}


/* Create object `props_menu' in the specified instance. */

Xv_opaque
props_menu_create(caddr_t ip, Xv_opaque owner)
{
    Xv_opaque obj;
    
    obj = xv_create(XV_NULL, MENU_COMMAND_MENU,
                    XV_KEY_DATA, INSTANCE, ip,
                    MENU_TITLE_ITEM, owner ? "" : DGET("Calculator"),
                    MENU_ITEM,
                        XV_KEY_DATA, INSTANCE, ip,
                        MENU_STRING, DGET("Properties..."),
                        NULL,
                    NULL);

    return(obj);
}

/* Create object `rcl_menu' in the specified instance. */

Xv_opaque
rcl_menu_create(caddr_t ip, Xv_opaque owner)
{
    Xv_opaque obj;
    
    obj = xv_create(XV_NULL, MENU_COMMAND_MENU,
                    XV_KEY_DATA, INSTANCE, ip,
                    MENU_TITLE_ITEM, owner ? "" : DGET("Retrieve"),
                    MENU_ITEM,
                        XV_KEY_DATA, INSTANCE, ip,
                        MENU_STRING, DGET("Register 0"),
                        NULL,
                    MENU_ITEM,
                        XV_KEY_DATA, INSTANCE, ip,
                        MENU_STRING, DGET("Register 1"),
                        NULL,
                    MENU_ITEM,
                        XV_KEY_DATA, INSTANCE, ip,
                        MENU_STRING, DGET("Register 2"),
                        NULL,
                    MENU_ITEM,
                        XV_KEY_DATA, INSTANCE, ip,
                        MENU_STRING, DGET("Register 3"),
                        NULL,
                    MENU_ITEM,
                        XV_KEY_DATA, INSTANCE, ip,
                        MENU_STRING, DGET("Register 4"),
                        NULL,
                    MENU_ITEM,
                        XV_KEY_DATA, INSTANCE, ip,
                        MENU_STRING, DGET("Register 5"),
                        NULL,
                    MENU_ITEM,
                        XV_KEY_DATA, INSTANCE, ip,
                        MENU_STRING, DGET("Register 6"),
                        NULL,
                    MENU_ITEM,
                        XV_KEY_DATA, INSTANCE, ip,
                        MENU_STRING, DGET("Register 7"),
                        NULL,
                    MENU_ITEM,
                        XV_KEY_DATA, INSTANCE, ip,
                        MENU_STRING, DGET("Register 8"),
                        NULL,
                    MENU_ITEM,
                        XV_KEY_DATA, INSTANCE, ip,
                        MENU_STRING, DGET("Register 9"),
                        NULL,
                    MENU_GEN_PIN_WINDOW, owner, DGET("Retrieve"),
                    NULL);

    return(obj);
}


/* Create object `sto_menu' in the specified instance. */

Xv_opaque
sto_menu_create(caddr_t ip, Xv_opaque owner)
{
    Xv_opaque obj;
    
    obj = xv_create(XV_NULL, MENU_COMMAND_MENU,
                    XV_KEY_DATA, INSTANCE, ip,
                    MENU_TITLE_ITEM, owner ? "" : DGET("Store"),
                    MENU_ITEM,
                        XV_KEY_DATA, INSTANCE, ip,
                        MENU_STRING, DGET("Register 0"),
                        NULL,
                    MENU_ITEM,
                        XV_KEY_DATA, INSTANCE, ip,
                        MENU_STRING, DGET("Register 1"),
                        NULL,
                    MENU_ITEM,
                        XV_KEY_DATA, INSTANCE, ip,
                        MENU_STRING, DGET("Register 2"),
                        NULL,
                    MENU_ITEM,
                        XV_KEY_DATA, INSTANCE, ip,
                        MENU_STRING, DGET("Register 3"),
                        NULL,
                    MENU_ITEM,
                        XV_KEY_DATA, INSTANCE, ip,
                        MENU_STRING, DGET("Register 4"),
                        NULL,
                    MENU_ITEM,
                        XV_KEY_DATA, INSTANCE, ip,
                        MENU_STRING, DGET("Register 5"),
                        NULL,
                    MENU_ITEM,
                        XV_KEY_DATA, INSTANCE, ip,
                        MENU_STRING, DGET("Register 6"),
                        NULL,
                    MENU_ITEM,
                        XV_KEY_DATA, INSTANCE, ip,
                        MENU_STRING, DGET("Register 7"),
                        NULL,
                    MENU_ITEM,
                        XV_KEY_DATA, INSTANCE, ip,
                        MENU_STRING, DGET("Register 8"),
                        NULL,
                    MENU_ITEM,
                        XV_KEY_DATA, INSTANCE, ip,
                        MENU_STRING, DGET("Register 9"),
                        NULL,
                    MENU_GEN_PIN_WINDOW, owner, DGET("Store"),
                    NULL);

    return(obj);
}


/* Create object `rshift_menu' in the specified instance. */

Xv_opaque
rshift_menu_create(caddr_t ip, Xv_opaque owner)
{
    Xv_opaque obj;
    
    obj = xv_create(XV_NULL, MENU_COMMAND_MENU,
                    XV_KEY_DATA, INSTANCE, ip,
                    MENU_TITLE_ITEM, owner ? "" : DGET("Right shift"),
                    MENU_ITEM,
                        XV_KEY_DATA, INSTANCE, ip,
                        MENU_STRING, DGET("1 place"),
                        NULL,
                    MENU_ITEM,
                        XV_KEY_DATA, INSTANCE, ip,
                        MENU_STRING, DGET("2 places"),
                        NULL,
                    MENU_ITEM,
                        XV_KEY_DATA, INSTANCE, ip,
                        MENU_STRING, DGET("3 places"),
                        NULL,
                    MENU_ITEM,
                        XV_KEY_DATA, INSTANCE, ip,
                        MENU_STRING, DGET("4 places"),
                        NULL,
                    MENU_ITEM,
                        XV_KEY_DATA, INSTANCE, ip,
                        MENU_STRING, DGET("5 places"),
                        NULL,
                    MENU_ITEM,
                        XV_KEY_DATA, INSTANCE, ip,
                        MENU_STRING, DGET("6 places"),
                        NULL,
                    MENU_ITEM,
                        XV_KEY_DATA, INSTANCE, ip,
                        MENU_STRING, DGET("7 places"),
                        NULL,
                    MENU_ITEM,
                        XV_KEY_DATA, INSTANCE, ip,
                        MENU_STRING, DGET("8 places"),
                        NULL,
                    MENU_ITEM,
                        XV_KEY_DATA, INSTANCE, ip,
                        MENU_STRING, DGET("9 places"),
                        NULL,
                    MENU_ITEM,
                        XV_KEY_DATA, INSTANCE, ip,
                        MENU_STRING, DGET("10 places"),
                        NULL,
                    MENU_ITEM,
                        XV_KEY_DATA, INSTANCE, ip,
                        MENU_STRING, DGET("11 places"),
                        NULL,
                    MENU_ITEM,
                        XV_KEY_DATA, INSTANCE, ip,
                        MENU_STRING, DGET("12 places"),
                        NULL,
                    MENU_ITEM,
                        XV_KEY_DATA, INSTANCE, ip,
                        MENU_STRING, DGET("13 places"),
                        NULL,
                    MENU_ITEM,
                        XV_KEY_DATA, INSTANCE, ip,
                        MENU_STRING, DGET("14 places"),
                        NULL,
                    MENU_ITEM,
                        XV_KEY_DATA, INSTANCE, ip,
                        MENU_STRING, DGET("15 places"),
                        NULL,
                    MENU_GEN_PIN_WINDOW, owner, DGET("Right shift"),
                    NULL);

    return(obj);
}



/* use command panel rather than ignoring it (as real gxv code does) */

static Xv_opaque
aquire_cmd_panel(void *ip, Xv_opaque owner)
{
    Xv_opaque obj = xv_get(owner, FRAME_CMD_PANEL);

    xv_set(obj, XV_KEY_DATA, INSTANCE, ip, NULL);

    return(obj);
}


/* Initialize an instance of object `kframe'. */

kframe_objects *
kframe_objects_initialize(kframe_objects *ip, Xv_opaque owner)
{
    if (!ip && !(ip = (kframe_objects *) calloc(1,sizeof (kframe_objects)))) {
        return((kframe_objects *) NULL);
    }
    if (!ip->kframe) {
        ip->kframe = kframe_kframe_create(ip, owner);
    }
    if (!ip->kcanvas) {
        ip->kcanvas = kframe_kcanvas_create(ip, ip->kframe);
    }

    return(ip);
}


/* Create object `kframe' in the specified instance. */

static Xv_opaque
kframe_kframe_create(kframe_objects *ip, Xv_opaque owner)
{
    extern Notify_value frame_interpose(Xv_window, Event *, 
                                        Notify_arg, Notify_event_type);

    Xv_opaque obj;
    Xv_opaque kframe_image;
    static unsigned short kframe_bits[] = {
#include "calctool.icon"
    };
    Xv_opaque kframe_image_mask;
    static unsigned short kframe_mask_bits[] = {
#include "calctool.mask.icon"
    };
    
    kframe_image = xv_create(XV_NULL, SERVER_IMAGE,
                             SERVER_IMAGE_DEPTH, 1,
                             SERVER_IMAGE_BITS, kframe_bits,
                             XV_WIDTH, 64,
                             XV_HEIGHT, 64,
                             NULL);
    kframe_image_mask = xv_create(XV_NULL, SERVER_IMAGE,
                                  SERVER_IMAGE_DEPTH, 1,
                                  SERVER_IMAGE_BITS, kframe_mask_bits,
                                  XV_WIDTH, 64,
                                  XV_HEIGHT, 64,
                                  NULL);
    obj = xv_create(owner, FRAME,
                    XV_KEY_DATA, INSTANCE, ip,
                    XV_WIDTH, 408,
                    XV_HEIGHT, 235,
                    XV_LABEL, DGET("Calctool"),
#ifdef OW_I18N
                    WIN_USE_IM, FALSE,
#endif /*OW_I18N*/
                    FRAME_SHOW_FOOTER, FALSE,
                    FRAME_SHOW_RESIZE_CORNER, TRUE,
                    FRAME_ICON, xv_create(XV_NULL, ICON,
                        ICON_IMAGE, kframe_image,
                        ICON_MASK_IMAGE, kframe_image_mask,
                        XV_LABEL, DGET("calculator"),
                        NULL),
                    NULL);
    xv_set(obj, WIN_CONSUME_EVENTS,
               WIN_MOUSE_BUTTONS,
               LOC_MOVE,
               LOC_DRAG,
               LOC_WINENTER,
               LOC_WINEXIT,
               WIN_ASCII_EVENTS,
               WIN_LEFT_KEYS,
               WIN_RIGHT_KEYS,
               WIN_TOP_KEYS,
               NULL, 
           NULL);
    notify_interpose_event_func(obj,
                                (Notify_func) frame_interpose, NOTIFY_SAFE);

    return(obj);
}


/* Create object `kcanvas' in the specified instance. */

static Xv_opaque
kframe_kcanvas_create(kframe_objects *ip, Xv_opaque owner)
{
    extern Notify_value canvas_proc(Xv_window, Event *, 
                                    Notify_arg, Notify_event_type);
    extern void canvas_repaint(Canvas, Xv_window, Display *, 
                               Window, Xv_xrectlist *);
    extern void canvas_resize(Canvas, int, int);
    Xv_opaque obj;
    
    obj = xv_create(owner, CANVAS,
                    XV_KEY_DATA, INSTANCE, ip,
                    XV_X, 0,
                    XV_Y, 0,
                    XV_WIDTH, WIN_EXTEND_TO_EDGE,
                    XV_HEIGHT, WIN_EXTEND_TO_EDGE,
                    CANVAS_REPAINT_PROC, canvas_repaint,
                    CANVAS_X_PAINT_WINDOW, TRUE,
                    CANVAS_RESIZE_PROC, canvas_resize,
                    NULL);
    xv_set(canvas_paint_window(obj), WIN_CONSUME_EVENTS,
               WIN_MOUSE_BUTTONS,
               LOC_MOVE,
               LOC_DRAG,
               LOC_WINENTER,
               LOC_WINEXIT,
               WIN_ASCII_EVENTS,
               WIN_LEFT_KEYS,
               WIN_RIGHT_KEYS,
               WIN_TOP_KEYS,
               NULL, 
           NULL);
    notify_interpose_event_func(canvas_paint_window(obj),
                                (Notify_func) canvas_proc, NOTIFY_SAFE);

    /* This line is here for backwards compatibility. It will be
     * removed for the next release.
     */

    xv_set(canvas_paint_window(obj), XV_KEY_DATA, INSTANCE, ip, NULL);

    return(obj);
}


/* Initialize an instance of object `mframe'. */

mframe_objects *
mframe_objects_initialize(mframe_objects *ip, Xv_opaque owner)
{
    if (!ip && !(ip = (mframe_objects *) calloc(1, sizeof(mframe_objects)))) {
        return((mframe_objects *) NULL);
    }
    if (!ip->mframe) {
        ip->mframe = mframe_mframe_create(ip, owner);
    }
    if (!ip->mcanvas) {
        ip->mcanvas = mframe_mcanvas_create(ip, ip->mframe);
    }

    return(ip);
}


/* Create object `mframe' in the specified instance. */

static Xv_opaque
mframe_mframe_create(mframe_objects *ip, Xv_opaque owner)
{
    Xv_opaque obj;
    
    obj = xv_create(owner, FRAME_CMD,
                    XV_KEY_DATA, INSTANCE, ip,
                    XV_WIDTH, 403,
                    XV_HEIGHT, 66,
                    XV_SHOW, FALSE,
                    FRAME_SHOW_FOOTER, FALSE,
                    FRAME_SHOW_RESIZE_CORNER, FALSE,
                    FRAME_CMD_PUSHPIN_IN, TRUE,
                    NULL);
    xv_set(xv_get(obj, FRAME_CMD_PANEL), WIN_SHOW, FALSE, NULL);

    return(obj);
}


/* Create object `mcanvas' in the specified instance. */

static Xv_opaque
mframe_mcanvas_create(mframe_objects *ip, Xv_opaque owner)
{
    extern Notify_value canvas_proc(Xv_window, Event *, 
                                    Notify_arg, Notify_event_type);
    extern void canvas_repaint(Canvas, Xv_window, Display *, 
                               Window, Xv_xrectlist *);
    extern void canvas_resize(Canvas, int, int);

    Xv_opaque obj;
    
    obj = xv_create(owner, CANVAS,
                    XV_KEY_DATA, INSTANCE, ip,
                    XV_X, 0,
                    XV_Y, 0,
                    XV_WIDTH, WIN_EXTEND_TO_EDGE,
                    XV_HEIGHT, WIN_EXTEND_TO_EDGE,
                    CANVAS_REPAINT_PROC, canvas_repaint,
                    CANVAS_X_PAINT_WINDOW, TRUE,
                    CANVAS_RESIZE_PROC, canvas_resize,
                    NULL);
    xv_set(canvas_paint_window(obj), WIN_CONSUME_EVENTS,
               WIN_MOUSE_BUTTONS,
               LOC_MOVE,
               LOC_DRAG,
               LOC_WINENTER,
               LOC_WINEXIT,
               WIN_ASCII_EVENTS,
               WIN_LEFT_KEYS,
               WIN_RIGHT_KEYS,
               WIN_TOP_KEYS,
               NULL, 
           NULL);
    notify_interpose_event_func(canvas_paint_window(obj),
                                (Notify_func) canvas_proc, NOTIFY_SAFE);

    /* This line is here for backwards compatibility. It will be
     * removed for the next release.
     */

    xv_set(canvas_paint_window(obj), XV_KEY_DATA, INSTANCE, ip, NULL);

    return(obj);
}


/* Initialize an instance of object `Aframe'.  */

Aframe_objects *
Aframe_objects_initialize(Aframe_objects *ip, Xv_opaque owner)
{
    if (!ip && !(ip = (Aframe_objects *) calloc(1, sizeof(Aframe_objects)))) {
        return((Aframe_objects *) NULL);
    }
    if (!ip->Aframe) {
        ip->Aframe = Aframe_Aframe_create(ip, owner);
    }
    if (!ip->Apanel) {
        ip->Apanel = aquire_cmd_panel(ip, ip->Aframe);
    }
    if (!ip->Api_text) {
        ip->Api_text = Aframe_Api_text_create(ip, ip->Apanel);
    }
    if (!ip->Adummy) {
        ip->Adummy = Aframe_Adummy_create(ip, ip->Apanel);
    }
    if (!ip->Api_but) {
        ip->Api_but = Aframe_Api_but_create(ip, ip->Apanel);
    }
    if (!ip->Agroup) {
        ip->Agroup = Aframe_Agroup_create(ip, ip->Apanel);
    }
    window_fit(ip->Apanel);
    window_fit(ip->Aframe);
    
    xv_set(ip->Apanel,
           XV_WIDTH, WIN_EXTEND_TO_EDGE,
           XV_HEIGHT, WIN_EXTEND_TO_EDGE,
           NULL);

    return(ip);
}


/* Create object `Aframe' in the specified instance. */

static Xv_opaque
Aframe_Aframe_create(Aframe_objects *ip, Xv_opaque owner)
{
    Xv_opaque obj;
    
    obj = xv_create(owner, FRAME_CMD,
                    XV_KEY_DATA, INSTANCE, ip,
                    XV_WIDTH, 156,
                    XV_HEIGHT, 85,
                    XV_LABEL, DGET("Get ASCII"),
#ifdef OW_I18N
                    WIN_USE_IM, FALSE,
#endif /*OW_I18N*/
                    XV_SHOW, FALSE,
                    FRAME_SHOW_FOOTER, FALSE,
                    FRAME_SHOW_RESIZE_CORNER, FALSE,
                    FRAME_CMD_PUSHPIN_IN, TRUE,
                    NULL);

    return(obj);
}


/* Create object `Api_text' in the specified instance. */

static Xv_opaque
Aframe_Api_text_create(Aframe_objects *ip, Xv_opaque owner)
{
    extern Panel_setting tshow_ascii(Panel_item, Event *);

    Xv_opaque obj;
    
    obj = xv_create(owner, PANEL_TEXT,
                    XV_KEY_DATA, INSTANCE, ip,
                    XV_X, 8,
                    XV_Y, 8,
                    PANEL_VALUE_DISPLAY_LENGTH, 1,
                    PANEL_VALUE_STORED_LENGTH, 1,
                    PANEL_LABEL_STRING, DGET("Character:"),
                    PANEL_LAYOUT, PANEL_HORIZONTAL,
                    PANEL_READ_ONLY, FALSE,
                    PANEL_NOTIFY_PROC, tshow_ascii,
                    NULL);

    return(obj);
}


/* Create object `Adummy' in the specified instance. */

static Xv_opaque
Aframe_Adummy_create(Aframe_objects *ip, Xv_opaque owner)
{
    Xv_opaque obj;
    
    obj = xv_create(owner, PANEL_MESSAGE,
                    XV_KEY_DATA, INSTANCE, ip,
                    XV_X, 25,
                    XV_Y, 36,
                    PANEL_LABEL_STRING, DGET("dummy"),
                    PANEL_LABEL_BOLD, TRUE,
                    XV_SHOW, FALSE,
                    NULL);

    return(obj);
}


/* Create object `Api_but' in the specified instance. */

static Xv_opaque
Aframe_Api_but_create(Aframe_objects *ip, Xv_opaque owner)
{
    extern Notify_value bshow_ascii(Panel_item, Event *);

    Xv_opaque obj;
    
    obj = xv_create(owner, PANEL_BUTTON,
                    XV_KEY_DATA, INSTANCE, ip,
                    XV_X, 24,
                    XV_Y, 62,
                    PANEL_LABEL_STRING, DGET("ASCII"),
                    PANEL_NOTIFY_PROC, bshow_ascii,
                    NULL);
    return(obj);
}


/* Create object `Agroup' in the specified instance. */

static Xv_opaque
Aframe_Agroup_create(Aframe_objects *ip, Xv_opaque owner)
{
    Xv_opaque obj;
    
    obj = xv_create(owner, GROUP,
                    XV_KEY_DATA, INSTANCE, ip,
                    XV_X, 8,
                    XV_Y, 8,
                    GROUP_TYPE, GROUP_COLUMN,
                    GROUP_MEMBERS,
                        ip->Api_text,
                        ip->Adummy,
                        ip->Api_but,
                        NULL,
                    GROUP_COLUMN_ALIGNMENT, GROUP_LABELS,
                    GROUP_VERTICAL_SPACING, 15,
                    NULL);
    return(obj);
}


/* Initialize an instance of object `rframe'.  */

rframe_objects *
rframe_objects_initialize(rframe_objects *ip, Xv_opaque owner)
{
    if (!ip && !(ip = (rframe_objects *) calloc(1, sizeof(rframe_objects)))) {
        return((rframe_objects *) NULL);
    }
    if (!ip->rframe) {
        ip->rframe = rframe_rframe_create(ip, owner);
    }
    if (!ip->rcanvas) {
        ip->rcanvas = rframe_rcanvas_create(ip, ip->rframe);
    }
    return(ip);
}


/* Create object `rframe' in the specified instance.  */

static Xv_opaque
rframe_rframe_create(rframe_objects *ip, Xv_opaque owner)
{
    Xv_opaque obj;
    
    obj = xv_create(owner, FRAME_CMD,
                    XV_KEY_DATA, INSTANCE, ip,
                    XV_WIDTH, 248,
                    XV_HEIGHT, 179,
                    XV_LABEL, DGET("Memory Registers"),
#ifdef OW_I18N
                    WIN_USE_IM, FALSE,
#endif /*OW_I18N*/
                    XV_SHOW, FALSE,
                    FRAME_SHOW_FOOTER, FALSE,
                    FRAME_SHOW_RESIZE_CORNER, FALSE,
                    FRAME_CMD_PUSHPIN_IN, TRUE,
                    NULL);
    xv_set(xv_get(obj, FRAME_CMD_PANEL), WIN_SHOW, FALSE, NULL);

    return(obj);
}


/* Create object `rcanvas' in the specified instance. */

static Xv_opaque
rframe_rcanvas_create(rframe_objects *ip, Xv_opaque owner)
{
    extern void canvas_repaint(Canvas, Xv_window, Display *, 
                               Window, Xv_xrectlist *);
    extern void canvas_resize(Canvas, int, int);
    Xv_opaque obj;
    
    obj = xv_create(owner, CANVAS,
                    XV_KEY_DATA, INSTANCE, ip,
                    XV_X, 0,
                    XV_Y, 0,
                    XV_WIDTH, WIN_EXTEND_TO_EDGE,
                    XV_HEIGHT, WIN_EXTEND_TO_EDGE,
                    CANVAS_REPAINT_PROC, canvas_repaint,
                    CANVAS_X_PAINT_WINDOW, TRUE,
                    CANVAS_RESIZE_PROC, canvas_resize,
                    NULL);
    xv_set(canvas_paint_window(obj), WIN_CONSUME_EVENTS,
               WIN_MOUSE_BUTTONS,
               LOC_MOVE,
               LOC_DRAG,
               LOC_WINENTER,
               LOC_WINEXIT,
               WIN_ASCII_EVENTS,
               WIN_LEFT_KEYS,
               WIN_RIGHT_KEYS,
               WIN_TOP_KEYS,
               NULL, 
           NULL);

    /* This line is here for backwards compatibility. It will be
     * removed for the next release.
     */

    xv_set(canvas_paint_window(obj), XV_KEY_DATA, INSTANCE, ip, NULL);

    return(obj);
}


/* Initialize an instance of object `CFframe'. */

CFframe_objects *
CFframe_objects_initialize(CFframe_objects *ip, Xv_opaque owner)
{
    if (!ip && 
        !(ip = (CFframe_objects *) calloc(1, sizeof (CFframe_objects)))) {
        return((CFframe_objects *) NULL);
    }
    if (!ip->CFframe) {
        ip->CFframe = CFframe_CFframe_create(ip, owner);
    }
    if (!ip->CFpanel) {
        ip->CFpanel = aquire_cmd_panel(ip, ip->CFframe);
    }
    if (!ip->CFpi_cftext) {
        ip->CFpi_cftext = CFframe_CFpi_cftext_create(ip, ip->CFpanel);
    }
    if (!ip->CFpi_dtext) {
        ip->CFpi_dtext = CFframe_CFpi_dtext_create(ip, ip->CFpanel);
    }
    if (!ip->CFpi_vtext) {
        ip->CFpi_vtext = CFframe_CFpi_vtext_create(ip, ip->CFpanel);
    }
    if (!ip->CFpi_cbut) {
        ip->CFpi_cbut = CFframe_CFpi_cbut_create(ip, ip->CFpanel);
    }
    if (!ip->CFgroup) {
        ip->CFgroup = CFframe_CFgroup_create(ip, ip->CFpanel);
    }
    if (!ip->CFpi_fbut) {
        ip->CFpi_fbut = CFframe_CFpi_fbut_create(ip, ip->CFpanel);
    }
    window_fit(ip->CFpanel);
    window_fit(ip->CFframe);
    
    xv_set(ip->CFpanel,
           XV_WIDTH, WIN_EXTEND_TO_EDGE,
           XV_HEIGHT, WIN_EXTEND_TO_EDGE,
           NULL);

    return(ip);
}


/* Create object `CFframe' in the specified instance. */

static Xv_opaque
CFframe_CFframe_create(CFframe_objects *ip, Xv_opaque owner)
{
    Xv_opaque obj;
    
    obj = xv_create(owner, FRAME_CMD,
                    XV_KEY_DATA, INSTANCE, ip,
                    XV_WIDTH, 254,
                    XV_HEIGHT, 141,
                    XV_LABEL, DGET("New Constant"),
#ifdef OW_I18N
                    WIN_USE_IM, TRUE,
#endif /*OW_I18N*/
                    XV_SHOW, FALSE,
                    FRAME_SHOW_FOOTER, FALSE,
                    FRAME_SHOW_RESIZE_CORNER, FALSE,
                    FRAME_CMD_PUSHPIN_IN, TRUE,
                    NULL);

    return(obj);
}


/* Create object `CFpi_cftext' in the specified instance.  */

static Xv_opaque
CFframe_CFpi_cftext_create(CFframe_objects *ip, Xv_opaque owner)
{
    Xv_opaque obj;
    
    obj = xv_create(owner, PANEL_TEXT,
                    XV_KEY_DATA, INSTANCE, ip,
                    XV_X, 31,
                    XV_Y, 8,
                    PANEL_VALUE_DISPLAY_LENGTH, 2,
                    PANEL_VALUE_STORED_LENGTH, 2,
                    PANEL_LABEL_STRING, DGET("Constant no:"),
                    PANEL_LAYOUT, PANEL_HORIZONTAL,
                    PANEL_READ_ONLY, FALSE,
                    NULL);

    return(obj);
}


/* Create object `CFpi_dtext' in the specified instance.  */

static Xv_opaque
CFframe_CFpi_dtext_create(CFframe_objects *ip, Xv_opaque owner)
{
    Xv_opaque obj;

    obj = xv_create(owner, PANEL_TEXT,
                    XV_KEY_DATA, INSTANCE, ip,
                    XV_X, 33,
                    XV_Y, 41,
                    PANEL_VALUE_DISPLAY_LENGTH, 22,
                    PANEL_VALUE_STORED_LENGTH, 256,
                    PANEL_LABEL_STRING, DGET("Description:"),
                    PANEL_LAYOUT, PANEL_HORIZONTAL,
                    PANEL_READ_ONLY, FALSE,
                    NULL);

    return(obj);
}


/* Create object `CFpi_vtext' in the specified instance. */

static Xv_opaque
CFframe_CFpi_vtext_create(CFframe_objects *ip, Xv_opaque owner)
{
    Xv_opaque obj;
    
    obj = xv_create(owner, PANEL_TEXT,
                    XV_KEY_DATA, INSTANCE, ip,
                    XV_X, 67,
                    XV_Y, 74,
                    PANEL_VALUE_DISPLAY_LENGTH, 22,
                    PANEL_VALUE_STORED_LENGTH, 256,
                    PANEL_LABEL_STRING, DGET("Value:"),
                    PANEL_LAYOUT, PANEL_HORIZONTAL,
                    PANEL_READ_ONLY, FALSE,
                    NULL);

    return(obj);
}


/* Create object `CFpi_cbut' in the specified instance. */

static Xv_opaque
CFframe_CFpi_cbut_create(CFframe_objects *ip, Xv_opaque owner)
{
    extern void write_cf_value(Panel_item, Event *);

    Xv_opaque obj;
    
    obj = xv_create(owner, PANEL_BUTTON,
                    XV_KEY_DATA, INSTANCE, ip,
                    XV_X, 12,
                    XV_Y, 107,
                    PANEL_LABEL_STRING, DGET("Enter Constant"),
                    PANEL_NOTIFY_PROC, write_cf_value,
                    NULL);

    return(obj);
}


/* Create object `CFgroup' in the specified instance. */

static Xv_opaque
CFframe_CFgroup_create(CFframe_objects *ip, Xv_opaque owner)
{
    Xv_opaque obj;
    
    obj = xv_create(owner, GROUP,
                    XV_KEY_DATA, INSTANCE, ip,
                    XV_X, 12,
                    XV_Y, 8,
                    GROUP_TYPE, GROUP_COLUMN,
                    GROUP_MEMBERS,
                        ip->CFpi_cftext,
                        ip->CFpi_dtext,
                        ip->CFpi_vtext,
                        ip->CFpi_cbut,
                        NULL,
                    GROUP_COLUMN_ALIGNMENT, GROUP_LABELS,
                    GROUP_VERTICAL_SPACING, 20,
                    NULL);
    return(obj);
}


/* Create object `CFpi_fbut' in the specified instance. */

static Xv_opaque
CFframe_CFpi_fbut_create(CFframe_objects *ip, Xv_opaque owner)
{
    extern void write_cf_value(Panel_item, Event *);

    Xv_opaque obj;
    
    obj = xv_create(owner, PANEL_BUTTON,
                    XV_KEY_DATA, INSTANCE, ip,
                    XV_X, 148,
                    XV_Y, 112,
                    PANEL_LABEL_STRING, DGET("Enter Function"),
                    PANEL_NOTIFY_PROC, write_cf_value,
                    NULL);

    return(obj);
}


/* Initialize an instance of object `Pframe'. */

Pframe_objects *
Pframe_objects_initialize(Pframe_objects *ip, Xv_opaque owner)
{
    if (!ip && !(ip = (Pframe_objects *) calloc(1, sizeof(Pframe_objects)))) {
        return((Pframe_objects *) NULL);
    }
    if (!ip->Pframe) {
        ip->Pframe = Pframe_Pframe_create(ip, owner);
    }
    if (!ip->Ppanel) {
        ip->Ppanel = aquire_cmd_panel(ip, ip->Pframe);
    }
    if (!ip->Pappearance) {
        ip->Pappearance = Pframe_Pappearance_create(ip, ip->Ppanel);
    }
    if (!ip->Pdisplay) {
        ip->Pdisplay = Pframe_Pdisplay_create(ip, ip->Ppanel);
    }
    if (!ip->Pstyle) {
        ip->Pstyle = Pframe_Pstyle_create(ip, ip->Ppanel);
    }
    if (!ip->Pgroup2) {
        ip->Pgroup2 = Pframe_Pgroup2_create(ip, ip->Ppanel);
    }
    if (!ip->Papply) {
        ip->Papply = Pframe_Papply_create(ip, ip->Ppanel);
    }
    if (!ip->Pdefaults) {
        ip->Pdefaults = Pframe_Pdefaults_create(ip, ip->Ppanel);
    }
    if (!ip->Preset) {
        ip->Preset = Pframe_Preset_create(ip, ip->Ppanel);
    }
    if (!ip->Pgroup1) {
        ip->Pgroup1 = Pframe_Pgroup1_create(ip, ip->Ppanel);
    }
    if (!ip->Pgroup3) {
        ip->Pgroup3 = Pframe_Pgroup3_create(ip, ip->Ppanel);
    }
    window_fit(ip->Ppanel);
    window_fit(ip->Pframe);
    
    xv_set(ip->Ppanel,
           XV_WIDTH, WIN_EXTEND_TO_EDGE,
           XV_HEIGHT, WIN_EXTEND_TO_EDGE,
           NULL);

    return(ip);
}


/* Create object `Pframe' in the specified instance. */

static Xv_opaque
Pframe_Pframe_create(Pframe_objects *ip, Xv_opaque owner)
{
    Xv_opaque obj;
    
    obj = xv_create(owner, FRAME_CMD,
                    XV_KEY_DATA, INSTANCE, ip,
                    XV_WIDTH, 241,
                    XV_HEIGHT, 171,
                    XV_LABEL, DGET("Calculator properties"),
#ifdef OW_I18N
                    WIN_USE_IM, FALSE,
#endif /*OW_I18N*/
                    XV_SHOW, FALSE,
                    FRAME_SHOW_FOOTER, FALSE,
                    FRAME_SHOW_RESIZE_CORNER, FALSE,
                    FRAME_CMD_PUSHPIN_IN, TRUE,
                    NULL);

    return(obj);
}


/* Create object `Pappearance' in the specified instance. */

static Xv_opaque
Pframe_Pappearance_create(Pframe_objects *ip, 
                                   Xv_opaque owner)
{
    Xv_opaque obj;
    
    obj = xv_create(owner, PANEL_CHOICE,
                    XV_KEY_DATA, INSTANCE, ip,
                    XV_X, 8,
                    XV_Y, 12,
                    PANEL_CHOICE_NROWS, 1,
                    PANEL_LAYOUT, PANEL_HORIZONTAL,
                    PANEL_CHOOSE_NONE, FALSE,
                    PANEL_LABEL_STRING, DGET("Appearance:"),
                    PANEL_CHOICE_STRINGS,
                        DGET("2D-look"),
                        DGET("3D-look"),
                        NULL,
                    NULL);

    return(obj);
}


/* Create object `Pdisplay' in the specified instance.  */

static Xv_opaque
Pframe_Pdisplay_create(Pframe_objects *ip, Xv_opaque owner)
{
    Xv_opaque obj;
    
    obj = xv_create(owner, PANEL_CHOICE,
                    XV_KEY_DATA, INSTANCE, ip,
                    XV_X, 32,
                    XV_Y, 48,
                    PANEL_CHOICE_NROWS, 1,
                    PANEL_LAYOUT, PANEL_HORIZONTAL,
                    PANEL_CHOOSE_NONE, FALSE,
                    PANEL_LABEL_STRING, DGET("Display:"),
                    PANEL_CHOICE_STRINGS,
                        DGET("color"),
                        DGET("monochrome"),
                        NULL,
                    NULL);

    return(obj);
}


/* Create object `Pstyle' in the specified instance.  */

static Xv_opaque
Pframe_Pstyle_create(Pframe_objects *ip, Xv_opaque owner)
{
    Xv_opaque obj;
    
    obj = xv_create(owner, PANEL_CHOICE,
                    XV_KEY_DATA, INSTANCE, ip,
                    XV_X, 44,
                    XV_Y, 84,
                    PANEL_CHOICE_NROWS, 1,
                    PANEL_LAYOUT, PANEL_HORIZONTAL,
                    PANEL_CHOOSE_NONE, FALSE,
                    PANEL_LABEL_STRING, DGET("Style:"),
                    PANEL_CHOICE_STRINGS,
                        DGET("left-handed"),
                        DGET("right-handed"),
                        NULL,
                    NULL);
    return(obj);
}


/* Create object `Pgroup2' in the specified instance. */

static Xv_opaque
Pframe_Pgroup2_create(Pframe_objects *ip, Xv_opaque owner)
{
    Xv_opaque obj;
    
    obj = xv_create(owner, GROUP,
                    XV_KEY_DATA, INSTANCE, ip,
                    XV_X, 8,
                    XV_Y, 12,
                    GROUP_TYPE, GROUP_COLUMN,
                    GROUP_MEMBERS,
                        ip->Pappearance,
                        ip->Pdisplay,
                        ip->Pstyle,
                        NULL,
                    GROUP_COLUMN_ALIGNMENT, GROUP_LABELS,
                    GROUP_VERTICAL_SPACING, 15,
                    NULL);

    return(obj);
}

/* Create object `Papply' in the specified instance. */

static Xv_opaque
Pframe_Papply_create(Pframe_objects *ip, Xv_opaque owner)
{
    extern void prop_apply(Panel_item, Event *);
    Xv_opaque obj;
    
    obj = xv_create(owner, PANEL_BUTTON,
                    XV_KEY_DATA, INSTANCE, ip,
                    XV_X, 17,
                    XV_Y, 140,
                    PANEL_LABEL_STRING, DGET("Apply"),
                    PANEL_NOTIFY_PROC, prop_apply,
                    NULL);

    return(obj);
}


/* Create object `Pdefaults' in the specified instance. */

static Xv_opaque
Pframe_Pdefaults_create(Pframe_objects *ip, Xv_opaque owner)
{
    extern void prop_defaults(Panel_item, Event *);
    Xv_opaque obj;
    
    obj = xv_create(owner, PANEL_BUTTON,
                    XV_KEY_DATA, INSTANCE, ip,
                    XV_X, 71,
                    XV_Y, 140,
                    PANEL_LABEL_STRING, DGET("Save as Defaults"),
                    PANEL_NOTIFY_PROC, prop_defaults,
                    NULL);

    return(obj);
}


/* Create object `Preset' in the specified instance. */

static Xv_opaque
Pframe_Preset_create(Pframe_objects *ip, Xv_opaque owner)
{
    extern void prop_reset(Panel_item, Event *);
    Xv_opaque obj;
    
    obj = xv_create(owner, PANEL_BUTTON,
                    XV_KEY_DATA, INSTANCE, ip,
                    XV_X, 180,
                    XV_Y, 140,
                    PANEL_LABEL_STRING, DGET("Reset"),
                    PANEL_NOTIFY_PROC, prop_reset,
                    NULL);

    return(obj);
}


/* Create object `Pgroup1' in the specified instance. */

static Xv_opaque
Pframe_Pgroup1_create(Pframe_objects *ip, Xv_opaque owner)
{
    Xv_opaque obj;
    
    obj = xv_create(owner, GROUP,
                    XV_KEY_DATA, INSTANCE, ip,
                    XV_X, 17,
                    XV_Y, 140,
                    GROUP_TYPE, GROUP_ROW,
                    GROUP_MEMBERS,
                        ip->Papply,
                        ip->Pdefaults,
                        ip->Preset,
                        NULL,
                    GROUP_ROW_ALIGNMENT, GROUP_HORIZONTAL_CENTERS,
                    GROUP_HORIZONTAL_SPACING, 10,
                    NULL);

    return(obj);
}


/* Create object `Pgroup3' in the specified instance. */

static Xv_opaque
Pframe_Pgroup3_create(Pframe_objects *ip, Xv_opaque owner)
{
    Xv_opaque obj;
    
    obj = xv_create(owner, GROUP,
                    XV_KEY_DATA, INSTANCE, ip,
                    XV_X, 8,
                    XV_Y, 12,
                    GROUP_TYPE, GROUP_COLUMN,
                    GROUP_MEMBERS,
                        ip->Pgroup2,
                        ip->Pgroup1,
                        NULL,
                    GROUP_COLUMN_ALIGNMENT, GROUP_VERTICAL_CENTERS,
                    GROUP_VERTICAL_SPACING, 35,
                    NULL);

    return(obj);
}
