/* WorkBone CD Rom Player interface for WorkMan
 *
 * Here I have only copied over the volume control routines
 * from workman. This should be merged to be calls to the same routines
 * in the future
 *
 */

#include <stdlib.h>
#include <stdio.h>
#include <fcntl.h>
#include <string.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/ioctl.h>
#include <signal.h>
#include <sys/utsname.h>
#include <unistd.h>
#include <termios.h>
#include <mntent.h>
#include <getopt.h>
#include <errno.h>
#include "config.h"
#include "struct.h"
#include "cdrom.h"

#ifdef OSS_SUPPORT
#include <linux/soundcard.h>
#define CD_CHANNEL SOUND_MIXER_CD
#endif

int cur_balance = 10;
int norm_volume = 100;
int last_volume = -1;
 
#ifdef OSS_SUPPORT
int mixer;
char mixer_dev_name[20];
#endif

int change_volume(int updown)
{
	int	vol, newvol, bal, uscal;

#ifdef OSS_SUPPORT
	int	left, right;

	if( mixer >= 0 )
	  {
		// Read volume
	  	if( ioctl( mixer, MIXER_READ( CD_CHANNEL ), &vol ) == -1 )
	  	{
	  		perror( "MIXER_READ" );
	  		left = right = 0;
	  	}
		right = 0x007f & ( vol >> 8 );
		left = 0x007f & vol;
		uscal = left/5;
		uscal = uscal > 1 ? uscal : 1;

		// Increase volume
		right=right+updown*uscal;
		left=left+updown*uscal;

		// Write volume
		left = left < 0 ? 0 : left > 100 ? 100 : left;
		right = right < 0 ? 0 : right > 100 ? 100 : right;

		vol = ( 0x007f & left ) | ( 0x7f00 & ( right << 8 ) );
		if( ioctl( mixer, MIXER_WRITE( CD_CHANNEL ), &vol ) == -1 )
		  {
		  	perror( "MIXER_WRITE" );
		  	return ( -1 );
		  }
		return ( left );
	  }
#endif

	// Reading the volume only works once
	if ( last_volume < 0 )
	  last_volume = read_initial_volume( norm_volume );
	uscal = last_volume/5;
	uscal = uscal > 1 ? uscal : 1;
	bal = cur_balance;
	newvol = last_volume+updown*uscal;
	newvol = newvol < 0 ? 0 : newvol > 100 ? 100 : newvol;
	cd_volume(newvol, bal, norm_volume );
	last_volume = newvol;
	return ( newvol );
}

