/*      @(#)server.h 20.62 99/10/26 SMI      */

/*
 *	(c) Copyright 1989 Sun Microsystems, Inc. Sun design patents 
 *	pending in the U.S. and foreign countries. See LEGAL_NOTICE 
 *	file for terms of the license.
 */

#ifndef xview_server_DEFINED
#define xview_server_DEFINED

/*
 ***********************************************************************
 *			Include Files
 ***********************************************************************
 */

#include <xview/generic.h>

/*
 ***********************************************************************
 *			Definitions and Macros
 ***********************************************************************
 */

/*
 * PUBLIC #defines 
 */

#ifndef XV_ATTRIBUTES_ONLY
#define	SERVER				&xv_server_pkg
#endif /* ~XV_ATTRIBUTES_ONLY */

/*
 * PRIVATE #defines 
 */

#define RECT_STRUCT_SIZE		4
#define	SERVER_ATTR(type, ordinal)	ATTR(ATTR_PKG_SERVER, type, ordinal)

/*
 ***********************************************************************
 *		Typedefs, Enumerations, and Structures
 ***********************************************************************
 */

typedef enum kbd_cmds_values {
    KBD_CMDS_SUNVIEW1 = 0,
    KBD_CMDS_BASIC = 1,
    KBD_CMDS_FULL = 2
} Kbd_cmds_value;

#ifndef XV_ATTRIBUTES_ONLY

typedef	Xv_opaque 	Xv_Server;
typedef	Xv_opaque 	Xv_server;

typedef struct {
    Xv_generic_struct	parent;
    Xv_opaque		private_data;
} Xv_server_struct;

#endif /* ~XV_ATTRIBUTES_ONLY */

typedef enum {
	/* Public attributes */
	SERVER_ATOM			= SERVER_ATTR(ATTR_LONG,	108),
	SERVER_ATOM_NAME		= SERVER_ATTR(ATTR_OPAQUE,	109),
	SERVER_ATOM_DATA		= SERVER_ATTR(ATTR_OPAQUE,	113),
	SERVER_CHORDING_TIMEOUT		= SERVER_ATTR(ATTR_INT,		242),
	SERVER_CHORD_MENU		= SERVER_ATTR(ATTR_INT,		244),
	SERVER_EXTENSION_PROC		= SERVER_ATTR(ATTR_FUNCTION_PTR,4),
	SERVER_NTH_SCREEN		= SERVER_ATTR(ATTR_INT_PAIR,	 2),
        SERVER_RESOURCE_DB              = SERVER_ATTR(ATTR_OPAQUE,      246),
	SERVER_SYNC			= SERVER_ATTR(ATTR_BOOLEAN,	32),
	SERVER_SYNC_AND_PROCESS_EVENTS	= SERVER_ATTR(ATTR_NO_VALUE,	33),
	SERVER_EXTERNAL_XEVENT_PROC     = SERVER_ATTR(ATTR_OPAQUE_PAIR, 20),
	SERVER_EXTERNAL_XEVENT_MASK     = SERVER_ATTR(ATTR_OPAQUE_TRIPLE, 22),

	/* Private attributes */
	SERVER_ASCII_KEYSTATE		= SERVER_ATTR(ATTR_OPAQUE,	 7),
	SERVER_ASCII_MAP		= SERVER_ATTR(ATTR_OPAQUE,	12),
	SERVER_ASCII_TO_KEYCODE_MAP	= SERVER_ATTR(ATTR_OPAQUE,	 6),
	SERVER_CUT_KEYSYM		= SERVER_ATTR(ATTR_INT,		10),
	SERVER_FONT_WITH_NAME		= SERVER_ATTR(ATTR_STRING, 	 11),
	SERVER_JOURNAL_SYNC_EVENT 	= SERVER_ATTR(ATTR_INT,		38),
	SERVER_JOURNALLING		= SERVER_ATTR(ATTR_BOOLEAN,	36),
	SERVER_KEY_EVENTS_MAP 		= SERVER_ATTR(ATTR_OPAQUE,	 5),
	SERVER_NONASCII_KEYSTATE	= SERVER_ATTR(ATTR_OPAQUE,	 8),
	SERVER_PASTE_KEYSYM		= SERVER_ATTR(ATTR_INT,		16),
	SERVER_SEMANTIC_MAP		= SERVER_ATTR(ATTR_OPAQUE,	14),
	SERVER_XV_MAP 			= SERVER_ATTR(ATTR_OPAQUE,	13),
	SERVER_COMPOSE_STATUS           = SERVER_ATTR(ATTR_OPAQUE,      15),
	SERVER_PRIVATE_XEVENT_PROC      = SERVER_ATTR(ATTR_OPAQUE_PAIR, 23),
	SERVER_PRIVATE_XEVENT_MASK      = SERVER_ATTR(ATTR_OPAQUE_TRIPLE, 24),
	SERVER_CLEAR_MODIFIERS     	= SERVER_ATTR(ATTR_INT,		50),
        /* ACC_XVIEW */
	SERVER_ACCELERATOR_MAP		= SERVER_ATTR(ATTR_OPAQUE,	101),
	SERVER_ADD_ACCELERATOR_MAP	= SERVER_ATTR(ATTR_OPAQUE_PAIR, 104),
	SERVER_REMOVE_ACCELERATOR_MAP	= SERVER_ATTR(ATTR_OPAQUE_PAIR, 106),
        /* ACC_XVIEW */
	SERVER_DISPLAY_CONTEXT		= SERVER_ATTR(ATTR_INT,		111),
#ifdef OW_I18N
	SERVER_COMPOUND_TEXT            = SERVER_ATTR(ATTR_OPAQUE, 	249),
#endif /* OW_I18N */

	/* Private attributes that may be deleted in future revisions */
	SERVER_WM_RESCALE		= SERVER_ATTR(ATTR_OPAQUE,	25),
	SERVER_WM_RESCALE_STATE		= SERVER_ATTR(ATTR_OPAQUE,	17),
	SERVER_WM_STATE			= SERVER_ATTR(ATTR_OPAQUE,	21),
	SERVER_WM_TAKE_FOCUS		= SERVER_ATTR(ATTR_OPAQUE,	30),
	SERVER_WM_WINDOW_MOVED		= SERVER_ATTR(ATTR_OPAQUE,	28),
	SERVER_WM_WIN_ATTR		= SERVER_ATTR(ATTR_OPAQUE,	34),
	SERVER_WM_ADD_DECOR		= SERVER_ATTR(ATTR_OPAQUE,	35),
	SERVER_WM_DELETE_DECOR		= SERVER_ATTR(ATTR_OPAQUE,	40),
	SERVER_WM_DECOR_CLOSE		= SERVER_ATTR(ATTR_OPAQUE,	45),
	SERVER_WM_DECOR_FOOTER		= SERVER_ATTR(ATTR_OPAQUE,	55),
	SERVER_WM_DECOR_RESIZE		= SERVER_ATTR(ATTR_OPAQUE,	60),
	SERVER_WM_DECOR_HEADER		= SERVER_ATTR(ATTR_OPAQUE,	65),
	SERVER_WM_DECOR_OK		= SERVER_ATTR(ATTR_OPAQUE,	70),
	SERVER_WM_DECOR_PIN		= SERVER_ATTR(ATTR_OPAQUE,	75),
	SERVER_WM_SCALE_SMALL		= SERVER_ATTR(ATTR_OPAQUE,	80),
	SERVER_WM_SCALE_MEDIUM		= SERVER_ATTR(ATTR_OPAQUE,	85),
	SERVER_WM_SCALE_LARGE		= SERVER_ATTR(ATTR_OPAQUE,	90),
	SERVER_WM_SCALE_XLARGE		= SERVER_ATTR(ATTR_OPAQUE,	95),
	SERVER_WM_PIN_STATE		= SERVER_ATTR(ATTR_OPAQUE,	100),
	SERVER_WM_WIN_BUSY		= SERVER_ATTR(ATTR_OPAQUE,	105),
	SERVER_DND_ACK_KEY		= SERVER_ATTR(ATTR_INT,		107),
	SERVER_WM_WINMSG_STATE		= SERVER_ATTR(ATTR_OPAQUE,	110),
	SERVER_WM_WINMSG_ERROR		= SERVER_ATTR(ATTR_OPAQUE,	115),
	SERVER_WM_WT_BASE		= SERVER_ATTR(ATTR_OPAQUE,	121),
	SERVER_WM_WT_CMD		= SERVER_ATTR(ATTR_OPAQUE,	125),
	SERVER_WM_WT_PROP		= SERVER_ATTR(ATTR_OPAQUE,	130),
	SERVER_WM_WT_HELP		= SERVER_ATTR(ATTR_OPAQUE,	135),
	SERVER_WM_WT_NOTICE		= SERVER_ATTR(ATTR_OPAQUE,	140),
	SERVER_WM_WT_OTHER		= SERVER_ATTR(ATTR_OPAQUE,	145),
	SERVER_WM_MENU_FULL		= SERVER_ATTR(ATTR_OPAQUE,	150),
	SERVER_WM_MENU_LIMITED		= SERVER_ATTR(ATTR_OPAQUE,	155),
	SERVER_WM_NONE			= SERVER_ATTR(ATTR_OPAQUE,	160),
	SERVER_WM_PIN_IN		= SERVER_ATTR(ATTR_OPAQUE,	165),
	SERVER_WM_PIN_OUT		= SERVER_ATTR(ATTR_OPAQUE,	170),
	SERVER_DO_DRAG_MOVE		= SERVER_ATTR(ATTR_OPAQUE,	120),
	SERVER_DO_DRAG_COPY		= SERVER_ATTR(ATTR_OPAQUE,	122),
	SERVER_DO_DRAG_LOAD		= SERVER_ATTR(ATTR_OPAQUE,	123),
	SERVER_JOURNAL_SYNC_ATOM 	= SERVER_ATTR(ATTR_INT,		125),
	SERVER_WM_DISMISS		= SERVER_ATTR(ATTR_OPAQUE,	200),
	SERVER_WM_SAVE_YOURSELF		= SERVER_ATTR(ATTR_OPAQUE,	210),
	SERVER_WM_DEFAULT_BUTTON        = SERVER_ATTR(ATTR_OPAQUE,      220),
	SERVER_WM_PROTOCOLS		= SERVER_ATTR(ATTR_OPAQUE,	225),
	SERVER_WM_DELETE_WINDOW		= SERVER_ATTR(ATTR_OPAQUE,	230),
	SERVER_WM_COMMAND		= SERVER_ATTR(ATTR_OPAQUE,	235),
	SERVER_WM_CHANGE_STATE		= SERVER_ATTR(ATTR_OPAQUE,	240),
	SERVER_MOUSE_BUTTONS		= SERVER_ATTR(ATTR_SHORT,       250),
	SERVER_BUTTON2_MOD		= SERVER_ATTR(ATTR_INT,		252),
	SERVER_BUTTON3_MOD		= SERVER_ATTR(ATTR_INT,		254),
	SERVER_META_MOD_MASK		= SERVER_ATTR(ATTR_INT,		  9),
	SERVER_ALT_MOD_MASK		= SERVER_ATTR(ATTR_INT,		248),
	SERVER_NUM_LOCK_MOD_MASK	= SERVER_ATTR(ATTR_INT,		247),
	SERVER_SEL_MOD_MASK		= SERVER_ATTR(ATTR_INT,		251),
	SERVER_FOCUS_TIMESTAMP   	= SERVER_ATTR(ATTR_INT,		203)
} Server_attr;

/*
 ***********************************************************************
 *				Globals
 ***********************************************************************
 */

/*
 * PUBLIC variables 
 */
extern Xv_Server	xv_default_server;

/*
 * PRIVATE variables 
 */
#ifndef XV_ATTRIBUTES_ONLY
extern Xv_pkg		xv_server_pkg;
#endif /* ~XV_ATTRIBUTES_ONLY */

#endif /* ~xview_server_DEFINED */
#ifdef _LP64
#error "Creating 64-bit applications in XView is not supported"
#endif /* _LP64 */
#ifndef OWTOOLKIT_WARNING_DISABLED
#warning  "OpenWindows XView(TM) and OLIT toolkits may no longer be supported in a future release. You may want to migrate to the Motif toolkit.  To disable the warning message, use #define OWTOOLKIT_WARNING_DISABLED or -D."
#endif /* OWTOOLKIT_WARNING_DISABLED */
