#ifndef _LIBGOLIT_H
#define _LIBGOLIT_H

#pragma	ident	"@(#)libgolit.h	2.12	92/03/04 include SMI"	/* GOLIT	*/

/*
 * This file is a product of Sun Microsystems, Inc. and is provided for
 * unrestricted use provided that this legend is included on all tape
 * media and as a part of the software program in whole or part.  Users
 * may copy or modify this file without charge, but are not authorized to
 * license or distribute it to anyone else except as part of a product
 * or program developed by the user.
 * 
 * THIS FILE IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
 * WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 * 
 * This file is provided with no support and without any obligation on the
 * part of Sun Microsystems, Inc. to assist in its use, correction,
 * modification or enhancement.
 * 
 * SUN MICROSYSTEMS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
 * INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY THIS FILE
 * OR ANY PART THEREOF.
 * 
 * In no event will Sun Microsystems, Inc. be liable for any lost revenue
 * or profits or other special, indirect and consequential damages, even
 * if Sun has been advised of the possibility of such damages.
 * 
 * Sun Microsystems, Inc.
 * 2550 Garcia Avenue
 * Mountain View, California  94043
 */

/*
 * @(#)libgolit.h	2.12 92/03/04 Copyright 1991 Sun Microsystems
 */

#if	defined(__STDC__) || defined(__cplusplus)

#define	ExternCallbackProc(n) 					\
	extern	void n ( Widget, XtPointer, XtPointer )

#define	ExternCreateProc(n)				       \
	extern	Widget n ( String, GolitWidgetDescPtr, \
				   Widget, ArgList, Cardinal,  \
				   XtPointer )

#define	ExternShellCreateProc(n)			\
	extern	Widget n ( String, String, 	\
				   GolitWidgetDescPtr, 	\
				   Display *, ArgList,	\
				   Cardinal, XtPointer )

#else	/* __STDC__ || __cplusplus */

#define ExternCallbackProc(n)                                   \
        extern  void n ()

#define ExternCreateProc(n)                                    \
        extern  Widget n () 
 
#define ExternShellCreateProc(n)                        \
        extern  Widget n ()

#endif	/* __STDC__ || __cplusplus */


#define ExternWidgetDescPtr(n)  extern  GolitWidgetDescPtr      n

typedef	struct _golit_widget_desc *WidgetDescPtr, *GolitWidgetDescPtr;

OLBeginFunctionPrototypeBlock


#if     defined(__STDC__) || defined(__cplusplus)

extern Widget
GolitNameToWidget ( Widget, String );
	/* Widget,		root		*/
	/* String,		name		*/

extern Widget
GolitFetchLastWidgetID ( GolitWidgetDescPtr );
	/* register GolitWidgetDescPtr,		wdp			*/

extern XtVarArgsList
GolitMergeArgLists ( GolitWidgetDescPtr, ArgList, Cardinal);
	/* register GolitWidgetDescPtr,		wdp			*/
	/* ArgList,				override_args		*/
	/* Cardinal,				num_override_args	*/

extern Widget
GolitFetchWidget (String, GolitWidgetDescPtr, Widget, ArgList, 
			  Cardinal, XtPointer);
	/* String,				name		*/
	/* register GolitWidgetDescPtr,		wdp		*/
	/* Widget,				parent		*/
	/* ArgList,				args		*/
	/* Cardinal,				num_args	*/
	/* XtPointer,				closure		*/

extern Widget
GolitFetchWidgetUnmanaged (String, GolitWidgetDescPtr, Widget, ArgList,
				   Cardinal, XtPointer);
	/* String,				name		*/
	/* register GolitWidgetDescPtr,		wdp		*/
	/* Widget,				parent		*/
	/* ArgList,				args		*/
	/* Cardinal,				num_args	*/
	/* XtPointer,				closure		*/

extern Widget
GolitFetchChildren (String, GolitWidgetDescPtr, Widget, ArgList,
			    Cardinal, XtPointer);
	/* String,				name		*/
	/* register GolitWidgetDescPtr,		wdp		*/
	/* Widget,				parent		*/
	/* ArgList,				args		*/
	/* Cardinal,				num_args	*/
	/* XtPointer,				closure		*/

extern Widget
GolitFetchChildrenUnmanaged (String, GolitWidgetDescPtr, Widget,
				     ArgList, Cardinal, XtPointer);
	/* String,				name		*/
	/* register GolitWidgetDescPtr,		wdp		*/
	/* Widget,				parent		*/
	/* ArgList,				args		*/
	/* Cardinal,				num_args	*/
	/* XtPointer,				closure		*/

extern Widget
GolitFetchPopups (String, GolitWidgetDescPtr, Widget, ArgList,
			  Cardinal, XtPointer);
	/* String,				name		*/
	/* register GolitWidgetDescPtr,		wdp		*/
	/* Widget,				parent		*/
	/* ArgList,				args		*/
	/* Cardinal,				num_args	*/
	/* XtPointer,				closure		*/

extern Widget
GolitFetchPopupsUnmanaged (String, GolitWidgetDescPtr, Widget,
				   ArgList, Cardinal, XtPointer);
	/* String,				name		*/
	/* register GolitWidgetDescPtr,		wdp		*/
	/* Widget,				parent		*/
	/* ArgList,				args		*/
	/* Cardinal,				num_args	*/
	/* XtPointer,				closure		*/

extern Widget
GolitFetchWidgetHier (String, GolitWidgetDescPtr, Widget, ArgList,
			      Cardinal, XtPointer);
	/* String,				name		*/
	/* register GolitWidgetDescPtr,		wdp		*/
	/* Widget,				parent		*/
	/* ArgList,				args		*/
	/* Cardinal,				num_args	*/
	/* XtPointer,				closure		*/

extern Widget
GolitFetchWidgetHierUnmanaged (String, GolitWidgetDescPtr, Widget,
				       ArgList, Cardinal, XtPointer);
	/* String,				name		*/
	/* register GolitWidgetDescPtr,		wdp		*/
	/* Widget,				parent		*/
	/* ArgList,				args		*/
	/* Cardinal,				num_args	*/
	/* XtPointer,				closure		*/

extern Widget
GolitFetchShellHier (String, String, GolitWidgetDescPtr, Display *,
			     ArgList, Cardinal, XtPointer);
	/* String,				app_name	*/
	/* String,				app_class	*/
	/* register GolitWidgetDescPtr,		wdp		*/
	/* Display,				*dpy		*/
	/* ArgList,				args		*/
	/* Cardinal,				num_args	*/
	/* XtPointer,				closure		*/

typedef Widget
(*GolitWidgetCreateProc) (String, GolitWidgetDescPtr, Widget, ArgList,
				  Cardinal, XtPointer);
	/* String,				name		*/
	/* register GolitWidgetDescPtr,		wdp		*/
	/* Widget,				parent		*/
	/* ArgList,				args		*/
	/* Cardinal,				num_args	*/
	/* XtPointer,				closure		*/


typedef Widget
(*GolitShellWidgetCreateProc) ( String, String, GolitWidgetDescPtr,
					Display *, ArgList, 
					Cardinal, XtPointer);
	/* String,				app_name	*/
	/* String,				app_class	*/
	/* register GolitWidgetDescPtr,		wdp		*/
	/* Display,				*dpy		*/
	/* ArgList,				args		*/
	/* Cardinal,				num_args	*/
	/* XtPointer,				closure		*/

#else	/* __STDC__ || _cplusplus */


extern Widget
GolitNameToWidget ();
 
extern Widget
GolitFetchLastWidgetID ();
 
extern XtVarArgsList
GolitMergeArgLists ();
 
extern Widget
GolitFetchWidget ();
 
extern Widget
GolitFetchWidgetUnmanaged ();

extern Widget
GolitFetchChildren ();
 
extern Widget
GolitFetchChildrenUnmanaged ();
 
extern Widget
GolitFetchPopups ();
 
extern Widget
GolitFetchPopupsUnmanaged ();
 
extern Widget
GolitFetchWidgetHier ();

extern Widget
GolitFetchWidgetHierUnmanaged ();
 
extern Widget
GolitFetchShellHier ();
 
typedef Widget
(*GolitWidgetCreateProc) ();
 
typedef Widget
(*GolitShellWidgetCreateProc) ();

#endif	/* __STDC__ || __cplusplus */


extern	GolitWidgetCreateProc		_GolitWDDefaultCPList[];

extern	GolitShellWidgetCreateProc	_GolitWDDefaultShellCPList[];

extern	GolitWidgetCreateProc		_GolitWDDefaultUnmanagedCPList[];

extern	GolitWidgetCreateProc		_GolitWDOnlyCreatedCPList[];

extern	GolitWidgetCreateProc		_GolitWDChildrenOnlyCPList[];

extern	GolitWidgetCreateProc		_GolitWDMenuButtonCPList[];

extern	GolitWidgetCreateProc		_GolitWDPopupWindowCPList[];

#if	defined (__STDC__) || defined(__cplusplus)

extern Widget
GolitPopupWindowCreateProc (String, GolitWidgetDescPtr, Widget, 
				    ArgList, Cardinal, XtPointer);
	/* String,				name		*/
	/* register GolitWidgetDescPtr,		wdp		*/
	/* Widget,				parent		*/
	/* ArgList,				args		*/
	/* Cardinal,				num_args	*/
	/* XtPointer,				closure		*/

extern Widget
GolitMenuButtonCreateProc (String, GolitWidgetDescPtr, Widget, 
				   ArgList, Cardinal, XtPointer);
	/* String,				name		*/
	/* register GolitWidgetDescPtr,		wdp		*/
	/* Widget,				parent		*/
	/* ArgList,				args		*/
	/* Cardinal,				num_args	*/
	/* XtPointer,				closure		*/

#else   /* __STDC__ || __cplusplus */

extern Widget
GolitPopupWindowCreateProc ();

extern Widget
GolitMenuButtonCreateProc ();

#endif	/* __STDC__ || __cplusplus */

OLEndFunctionPrototypeBlock
#endif	_LIBGOLIT_H
