/*****************************************************************************
 * rubbertile.c: Demonstrate the RubberTile widget
 *
 *         From:
 *                   The X Window System, 
 *            Programming and Applications with Xt
 *                   OPEN LOOK Edition
 *         by
 *              Douglas Young & John Pew
 *              Prentice Hall, 1993
 *
 *              Example described on pages: 
 *
 *
 *  Copyright 1993 by Prentice Hall
 *  All Rights Reserved
 *
 * This code is based on the OPEN LOOK Intrinsics Toolkit (OLIT) and 
 * the X Window System
 *
 * Permission to use, copy, modify, and distribute this software for 
 * any purpose and without fee is hereby granted, provided that the above
 * copyright notice appear in all copies and that both the copyright notice
 * and this permission notice appear in supporting documentation.
 *
 * Prentice Hall and the authors disclaim all warranties with regard to 
 * this software, including all implied warranties of merchantability and 
 * fitness.
 * In no event shall Prentice Hall or the authors be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from 
 * loss of use, data or profits, whether in an action of contract, negligence 
 * or other tortious action, arising out of or in connection with the use 
 * or performance of this software.
 *
 * OPEN LOOK is a trademark of UNIX System Laboratories.
 * X Window System is a trademark of the Massachusetts Institute of Technology
 ****************************************************************************/

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <Xol/OpenLook.h>
#include <Xol/RubberTile.h>
#include <Xol/RectButton.h>
#include <stdio.h>

void
main(unsigned int argc, char **argv)
{
  XtAppContext app;
  Widget       toplevel, base, rt[3], rb[9];
  int          i, j;
  char         name[16];

  OlToolkitInitialize((XtPointer)NULL);
  OlSetDefaultTextFormat(OL_SB_STR_REP);
  toplevel = XtAppInitialize(&app, "Rubbertile", NULL, 0, &argc, 
			     argv, NULL, NULL, 0);
  /*
   * Create the base RubberTile widget.
   */
  base = XtVaCreateManagedWidget("base", rubberTileWidgetClass, 
                                 toplevel, NULL);
  /*
   * Create the 3 rubbertile widgets that are childen of base.
   */
  for(i=0;i<3;i++) {
    sprintf(name, "rt%d", i + 1);
    rt[i] = XtVaCreateManagedWidget(name, rubberTileWidgetClass, 
                                    base,
				    XtNorientation, OL_HORIZONTAL,
				    NULL);
    /*
     * Create 3 rectbutton widgets as children of each rubbertile.
     */
    for(j=0;j<3;j++) {
      sprintf(name, "rb%d", (i * 3) + j + 1);
      rb[(i * 3)+j] = XtVaCreateManagedWidget(name, 
                                              rectButtonWidgetClass, 
                                              rt[i], NULL);
    }
  }

  XtRealizeWidget(toplevel);
  XtAppMainLoop(app);
}
