//
// Header file for "xdf"
// by Georg C. F. Greve
//
//

/*{{{  Definitions  */
#define VERSION "XDiskFree V1.3.02 Linux/Solaris"
#define STRLENGTH 60

#define TOTAL 0
#define FULL 1
#define FREE 2

#define ERROR -1
#define OK 0

/*}}}*/

/*{{{  Class definitions  */
class Partition{
public:
  Partition(){name = 0; gauge = 0; last_value = 0; status = TRUE; max_value = 0; last_max_value = 0; last_value = 0;counter = 1;color = TRUE;};
  ~Partition(){if (name != 0) delete name;};

public:
  char* name;
  char panelname[45];
  
  char string_maxsize[STRLENGTH];
  char string_size[STRLENGTH];
  char string_freesize[STRLENGTH];

  Panel_item name_item;
  Panel_item maxsize_item;
  Panel_item fillsize_item;
  Panel_item freesize_item;
  Panel_item gauge;

  int status;
  int last_status;
  double max_value;
  double last_value;
  double last_max_value;

  int counter;
  int color;

};
/*}}}*/

/*{{{  Variables  */
char* prgname;
FILE* fd_fstab;
FILE* fd_mtab;
#if defined(__sun__) && !defined(__linux__)
struct vfstab* vfs_table;
struct mnttab* mnt_table;
struct statvfs stat_buffer;
#else
struct mntent* table;
struct statfs stat_buffer;
#endif
int mountpoints, ret, row;
Partition* par_table[50];
struct itimerval timer;


#ifdef NO_ISO9660
int no_iso9660 = TRUE;
#else
int no_iso9660 = FALSE;
#endif

#ifdef NO_NFS
int no_nfs = TRUE;
#else
int no_nfs = FALSE;
#endif

#ifdef FULL_AS_PERCENT
int full_as_percent = TRUE;
#else
int full_as_percent = FALSE;
#endif

#ifdef FREE_AS_PERCENT
int free_as_percent = TRUE;
#else
int free_as_percent = FALSE;
#endif

double meglim = MEGLIM * 1024 * 1024;
double giglim = GIGLIM * 1024 * 1024 * 1024;

int kprec = KPREC;
int megprec = MEGPREC;
int gigprec = GIGPREC;

int pprec = PPREC;

#ifdef TITLE_STRINGS
int title = TRUE;
#else
int title = FALSE;
#endif

double critical=WARN;

/* XView stuff  */
Frame frame;
Panel panel;



/*}}}*/

/*{{{  User defaults & commandline options  */

static int opTableEntries = 10;
static XrmOptionDescRec opTable[] = {
  {"-mlim", "*mlim",    XrmoptionSepArg,        (caddr_t) MEGLIM },
  {"-glim", "*glim",    XrmoptionSepArg,        (caddr_t) GIGLIM },

  {"-kprec", "*kprec",    XrmoptionSepArg,        (caddr_t) KPREC },
  {"-mprec", "*mprec",    XrmoptionSepArg,        (caddr_t) MEGPREC },
  {"-gprec", "*gprec",    XrmoptionSepArg,        (caddr_t) GIGPREC },
  {"-pprec", "*pprec",    XrmoptionSepArg,        (caddr_t) PPREC },

  {"-dused", "*dused", XrmoptionSepArg,        (caddr_t) NULL},
  {"-dfree", "*dfree", XrmoptionSepArg,        (caddr_t) NULL},

  {"-titlestrings","*titlestrings", XrmoptionSepArg,        (caddr_t) NULL},

  {"-warn","*warn", XrmoptionSepArg,        (caddr_t) NULL},
};

XrmDatabase rDB;                                        //Database for resource manager
XrmDatabase commandlineDB;                     //Database for commandline
XrmDatabase localDB;                                  //Database for conf. file
/*}}}*/


/*{{{  Subroutines  */
void quit();
inline void create_label(char*,const double);
Notify_value timer_routine();
void create_size_string(char*, double, double, int);
void Usage();
int parseUseroptions(int* argc, register char* argv[]);
void getHomeDir( char* );
double evalNumber( char*, int );

/*}}}*/
