/* xdf version 1.3 Dec 21st 1997
   by Georg C. F. Greve (greve@fusebox.hanse.de)
   */   
 
/*{{{  Header  */   
                              
/* Standard C++ includes */
#include <stdio.h>   
#include <iostream.h>
#include <strstream.h>  
#ifdef __linux__
#include <syscall.h>
#endif
#include <sys/param.h>
#include <sys/types.h>
#ifdef __sun__
#include <sys/vfs.h>
#else
#include <linux/fs.h>
#endif 
#include <unistd.h>
#include <ctype.h>
#include <pwd.h>
#include <stdlib.h>
#include <assert.h> 
#ifdef __sun__
#include <sys/mnttab.h>
#include <sys/mntent.h>
#include <sys/vfstab.h>
#else
#include <mntent.h>
#endif  
#include <sys/mount.h>
#include <sys/vfs.h>
                              
/* Xlib includes */
#include <X11/Xlib.h>
#include <X11/Xresource.h>
#include <xview/xview.h>
#include <xview/frame.h>
#include <xview/panel.h>
#include <xview/notify.h>
#include <xview/cms.h>
#include <xview/svrimage.h>
 
#include "config.H" 
#include "xdf.H"
#include "galaxy.xbm"
/*}}}*/
 
/*{{{  Initialisation (Main)  */
int main(int argc, char* argv[]){

struct mnttab* mnt_table;
FILE* myfstab;
int ret,no_nfs=0,no_iso9660=0;


#ifdef __sun__
	myfstab = fopen(MNTTAB,"r");
	while((ret = getmntent(myfstab,mnt_table)) >= 0 ) {
	   if ( ret == 0
	       && mnt_table->mnt_mountp != NULL
	       && mnt_table->mnt_fstype != NULL ) {
	     if ( strcmp( "swap", mnt_table->mnt_mountp) && strcmp( "/proc", mnt_table->mnt_mountp)
	         && ( strcmp( "nfs", mnt_table->mnt_fstype ) || ( ! no_nfs ) )
	         && ( strcmp( "hsfs", mnt_table->mnt_fstype ) || ( ! no_iso9660 ) )
	         && ( strcmp( "fd", mnt_table->mnt_fstype ) )
	         ){
		printf("#: |%s|, |%s|\n", mnt_table->mnt_mountp, mnt_table->mnt_fstype);
	  	}
	    }
	}
	fclose(myfstab);

#endif
}
