/* $Id: services.c,v 1.2 1999/03/18 12:46:59 root Exp $ */

/*
 * Large parts taken from the olwm program 
 * Copyright Tomas Stephanson Ellemtel 1992
 */

/*
 *      (c) Copyright 1989, 1990 Sun Microsystems, Inc. Sun design patents
 *      pending in the U.S. and foreign countries. See LEGAL_NOTICE
 *      file for terms of the license.
 */

/*
        LEGAL_NOTICE

	Any use of this source code must include, in the user documentation 
	and internal comments to the code, notices to the end user as  
	follows:


	(c) Copyright 1989 Sun Microsystems, Inc. Sun design patents
	pending in the U.S. and foreign countries. OPEN LOOK is a 
	trademark of AT&T. Used by written permission of the owners.


 	(c) Copyright Bigelow & Holmes 1986, 1985. Lucida is a registered 
	trademark of Bigelow & Holmes. Permission to use the Lucida 
	trademark is hereby granted only in association with the images 
	and fonts described in this file.



	SUN MICROSYSTEMS, INC., AT&T, AND BIGELOW & HOLMES 
	MAKE NO REPRESENTATIONS ABOUT THE SUITABILITY OF
 	THIS SOURCE CODE FOR ANY PURPOSE. IT IS PROVIDED "AS IS" 
	WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND. 
	SUN  MICROSYSTEMS, INC., AT&T AND BIGELOW  & HOLMES, 
	SEVERALLY AND INDIVIDUALLY, DISCLAIM ALL WARRANTIES 
	WITH REGARD TO THIS SOURCE CODE, INCLUDING ALL IMPLIED
	WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
	PARTICULAR PURPOSE. IN NO EVENT SHALL SUN MICROSYSTEMS,
	INC., AT&T OR BIGELOW & HOLMES BE LIABLE FOR ANY
	SPECIAL, INDIRECT, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
	OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA 	
	OR PROFITS, WHETHER IN AN ACTION OF  CONTRACT, NEGLIGENCE
	OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
	WITH THE USE OR PERFORMANCE OF THIS SOURCE CODE.

*/
#ident	"@(#)services.c	26.36	91/09/14 SMI"


#include <stdio.h>
#ifdef SYSV
#include <string.h>
#else
#include <strings.h>
#endif
#include <errno.h>
#include <xview/xview.h>
#include <xview/notify.h>

#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/resource.h>

extern	char		*getenv();
extern Frame Fframe;

/*
 * Execute a command by handing it to /bin/sh.
 */
static int
execCommand(cmd)
     char *cmd;
{
    char *args[4];
    int pid;
    static Notify_value  wait_func();

    args[0] = "/bin/sh";
    args[1] = "-c";
    args[2] = cmd;
    args[3] = NULL;

    pid = fork();
    if (pid == -1) {
	perror("olwm: fork");
	return 1;
    } else if (pid == 0) {
	/* child */
#if defined(SYSV) || defined(__linux)
	setpgrp();
#else
	setpgrp(0, getpid());
	if (setsid() == -1) {
	  perror("rootmenu");
	  exit(1);
	}
#endif
	execvp(args[0], args);
	perror("olwm: exec");
	exit(1);
    } else {			/* parent */
      notify_set_wait3_func(Fframe,wait_func,pid);
    }
    return 0;
}


static Notify_value
wait_func(client,pid,status,rusage)
     Notify_client	client;
     int		pid;
     union wait		*status;
     struct rusage	*rusage;
{

  return(NOTIFY_IGNORED);
}

/***************************************************************************
* Command execution
****************************************************************************/

/*
 * AppMenuFunc -- called when a command is listed as the item selected on
 *      the olwm menu
 */
/*ARGSUSED*/
int
DoAppMenuFunc(cmd)
     char *cmd;
{
	return execCommand(cmd);
}


/***************************************************************************
* Properties
****************************************************************************/

#define WORKSPACEPROPS "props"

/*
 * PropertiesFunc -- called when the "Properties ..." item has been selected 
 * on the root menu.  REMIND: this and AppMenuFunc should be merged.
 */
/*ARGSUSED*/
int
DoPropertiesFunc()
{
	return execCommand(WORKSPACEPROPS);
}
