/* $Id: getconsole.c,v 1.2 1999/03/18 12:46:59 root Exp $ */

/* 
 * Get who is logged on on the console
 * Copyright Tomas Stephanson Ellemtel 1992
 */


#include <stdio.h>
#include <time.h>
#include <sys/stat.h>
#include <pwd.h>

#define TRUE  1
#define FALSE 0

#ifndef MIN
#define MIN(x, y) ( ((x) < (y)) ? (x) : (y) )
#endif


#ifndef MAX
#define MAX(x, y) ( ((x) > (y)) ? (x) : (y) )
#endif

#if defined(i386)
#ifndef __linux__
# define DEVMOUSE "/dev/kdmouse"
#else
# define DEVMOUSE "/dev/mouse"
#endif
#else
# define DEVMOUSE "/dev/mouse"
#endif


char *getTime();

time_t Now;

char *
getConsole(busy)
     int *busy;
{
  struct stat cb,mb,kb;
  struct passwd *pw;
  time_t mouse_idletime;
  time_t kbd_idletime;
  time_t idletime;
  static char str[50];
  
  (void)time(&Now);


  if (stat("/dev/console", &cb) < 0) {
    perror("rootmenu /dev/console");
    exit(1);
  }

  if (stat(DEVMOUSE, &mb) < 0) {
    perror("rootmenu /dev/mouse");
    exit(1);
  }

#if defined(sparc)
  if (stat("/dev/kbd", &kb) < 0) {
    perror("rootmenu /dev/kbd");
    exit(1);
  }
#endif

  /* used mouse after login */

  if ( cb.st_atime > mb.st_atime ) {
    return("Nobody on console");
  }

  pw = getpwuid(cb.st_uid);
  mouse_idletime = Now < mb.st_atime ? 0 : Now - mb.st_atime;
  kbd_idletime = Now < kb.st_atime ? 0 : Now - kb.st_atime;

  idletime = MIN(mouse_idletime,kbd_idletime);

  sprintf(str,"%s %s",pw->pw_name,getTime(idletime,busy));

  return str;
}




char *
getTime(tim,busy)
     time_t tim;
     int 	*busy;
{
  static char str[20];
  struct tm *delta;

  str[0] = '\0';
  *busy = FALSE;

  delta = gmtime(&tim);
  if ( delta->tm_mday - 1  ) {
    sprintf(str,"Idle %d day%s",
	    delta->tm_mday - 1,
	    (delta->tm_mday == 2 ? "" : "s"));
    return str;
  }    
  if ( delta->tm_hour) {
    sprintf(str,"Idle %2d hour%s",
	    delta->tm_hour,
	    (delta->tm_hour == 1 ? "" : "s"));
    return str;
  }
  if ( delta->tm_min) {
    sprintf(str,"Idle %d min%s",
	    delta->tm_min,
	    (delta->tm_min == 1 ? "" : "s"));
    return str;
  }
  *busy = TRUE;
  return "Working";
}

