/*
 * Copyright (c) 1993 Thomas W. Corson
 * Copyright (c) 1993 VetMark Systems, Inc. d.b.a Information Dynamics
 *
 * Permission to use, copy, modify, distribute, and sell this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the names of
 * Thomas W. Corson, VetMark Systems, or Information Dynamics may not be used 
 * in any advertising or publicity relating to the software without the 
 * specific, prior written permission of Thomas W. Corson and VetMark Systems.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 * 
 * IN NO EVENT SHALL THOMAS W. CORSON OR VETMARK SYSTEMS, INC. BE LIABLE FOR
 * ANY SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF 
 * LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE 
 * OF THIS SOFTWARE.
 */

/*
 * faxtool_stubs.c - Notify and event callback function stubs.
 * This file was generated by `gxv' from `faxtool.G'.
 */

#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <xview/xview.h>
#include <xview/panel.h>
#include <xview/notice.h>
#include <xview/font.h>
#include <group.h>
#include <gfm.h>
#include <pwd.h>
#include "faxtool_ui.h"
#include "faxtool.h"
#include <xview/dragdrop.h>
#include <xview/cursor.h>
#include <gdd.h>

#ifndef TRACE
#define	fputs(x, y)
#define fprintf(x, y, z)
#endif
#include <sys/param.h>
#include <sys/types.h>
#include <xview/textsw.h>
#include <xview/xv_xrect.h>

void	send_button_notify(Panel_item, Event *);
void	clear_button_notify(Panel_item, Event *);
void	reset_button_notify(Panel_item, Event *);
void	all_jobs_notify(Panel_item, int, Event *);
void	receive_queue_notify(Panel_item, int, Event *);
void	send_queue_notify(Panel_item, int, Event *);
void	main_panel_resize_notify(Xv_window, Event *, Notify_arg, Notify_event_type);
void	directory_popup_resize(Xv_window, Event *, Notify_arg, Notify_event_type);
void	prop_apply_notify(Panel_item item, Event *event);


/*
 * Global object definitions.
 */

faxtool_window1_objects		*Faxtool_window1;
faxtool_prop_popup_objects	*Faxtool_prop_popup;
faxtool_directory_popup_objects	*Faxtool_directory_popup;
gfm_popup_objects		*gfm_popup;
char				new_path[PATHLEN + 1] = "./";
char				*args[MAXARGS];
Xv_font				fw_font = (Xv_font) NULL;

static int			rcv_queue = FALSE;
static boolean			first = TRUE;

struct {
	int	cover;
	char	fax[NUMLEN + 1];
	char	to[TXTLEN + 1];
	char	company[TXTLEN + 1];
	char	re[TXTLEN + 1];
	char	comments[COMLEN + 1];
	int	nfiles;
	char	files[MAXFILE][TXTLEN + 1];
	int	resolution;
	int	page_size;
	int	notify;
	int	time;
	int	time_unit;
} fax_send;

struct {
	char	fax[NUMLEN + 1];
	char	name[NUMLEN + 1];
	char	company[NUMLEN + 1];
} dir;

Defaults	def;

#ifdef MAIN

/*
 * Instance XV_KEY_DATA key.  An instance is a set of related
 * user interface objects.  A pointer to an object's instance
 * is stored under this key in every object.  This must be a
 * global variable.
 */
Attr_attribute	INSTANCE;

main(int argc, char **argv)
{
	Frame		frame,
			owner[MAX_POPUPS];
	Panel		panel_tab[10],
			*panels,
			panel,
			last_panel = 0;
	Group		group_tab[10],
			list_tab[10],
			*groups,
			*list_groups,
			list_group,
			frame_objects;
	Panel_item	item,
			list[MAX_LISTS_PER_PANEL];
	int		nlists = 0,
			save_width,
			i,
			j;
	boolean		dual_controls = FALSE;
	struct passwd	*pw = getpwuid(getuid());
	char		rc_file[PATHLEN + 1];
	FILE		*rc;
	char		locale_path[133],
			header[41],
			*str;

	/*
	 * Initialize XView.
	 */

	if ((str = getenv("FAXTOOLHOME")))
	{
		strncpy(locale_path, str, 132);
	}

	else
	{
		strncpy(locale_path, "/usr/openwin/lib", 132);
	}

	strncat(locale_path, "/locale", 132);

	xv_init(XV_USE_LOCALE, TRUE,
		XV_LOCALE_DIR, locale_path,
		XV_LC_DISPLAY_LANG, getenv("LANG"),
		XV_INIT_ARGC_PTR_ARGV, &argc, argv, NULL);
	INSTANCE = xv_unique_key();
	
	/*
	 * Initialize user interface components.
	 * Do NOT edit the object initializations by hand.
	 */

	Faxtool_window1 = faxtool_window1_objects_initialize(NULL, NULL);
	Faxtool_directory_popup = faxtool_directory_popup_objects_initialize(NULL, Faxtool_window1->window1);
	Faxtool_prop_popup = faxtool_prop_popup_objects_initialize(NULL, Faxtool_window1->window1);

	gfm_popup = gfm_initialize(NULL, Faxtool_window1->window1, 
				   dgettext("faxtool_stubs_labels", "Files To Send"));

	frame = Faxtool_window1->window1;
	
	panel_tab[0] = Faxtool_window1->status_controls;
	group_tab[0] = Faxtool_window1->status_objects;
	list_tab[0] = Faxtool_window1->job_queue_objects;
	panel_tab[1] = Faxtool_window1->top_controls;
	group_tab[1] = Faxtool_window1->top_objects;
	list_tab[1] = 0;
	panel_tab[2] = Faxtool_window1->send_controls;
	group_tab[2] = Faxtool_window1->send_objects;
	list_tab[2] = Faxtool_window1->file_objects;
	panel_tab[3] = Faxtool_directory_popup->directory_controls;
	group_tab[3] = Faxtool_directory_popup->dir_objects;
	list_tab[3] = Faxtool_directory_popup->dir_list_objects;
	panel_tab[4] = Faxtool_prop_popup->prop_controls;
	group_tab[4] = Faxtool_prop_popup->prop_objects;
	list_tab[4] = 0;
	panel_tab[5] = 0;
	group_tab[5] = 0;
	list_tab[5] = 0;

	xv_set(frame, 
		XV_KEY_DATA, PANELS_LIST, &panel_tab, 
		XV_KEY_DATA, GROUPS_LIST, &group_tab, 
		XV_KEY_DATA, LISTS_LIST, &list_tab, 
		NULL);

	panels = (Panel *) xv_get(frame, XV_KEY_DATA, PANELS_LIST);
	groups = (Group *) xv_get(frame, XV_KEY_DATA, GROUPS_LIST);
	list_groups = (Group *) xv_get(frame, XV_KEY_DATA, LISTS_LIST);

	for (i = 0 ; (* panels); panels++, i++)
	{
		owner[i] = (Frame) xv_get((* panels), XV_OWNER);

		if (i && (owner[i] == owner[i-1]))
			dual_controls = TRUE;
	}

	panels = (Panel *) xv_get(frame, XV_KEY_DATA, PANELS_LIST);

	for (i = 0 ; 
	     (* panels); 
	     last_panel = panel, panels++, groups++, list_groups, i++)
	{
		panel = (* panels);
		frame_objects = (* groups);
		list_group = (*list_groups);
		frame = owner[i];

		/* Save Original Height and Width of Panel and List 
		   for resizing later*/
	
		xv_set(frame, 
			XV_KEY_DATA, ORIG_HEIGHT, 
				(int) xv_get(frame, XV_HEIGHT), 
			XV_KEY_DATA, LAST_HEIGHT, 
				(int) xv_get(frame, XV_HEIGHT), 
			XV_KEY_DATA, ORIG_WIDTH, 
				save_width = (int) xv_get(frame, XV_WIDTH), 
			XV_KEY_DATA, LAST_WIDTH, 
				save_width, 
			NULL);

		if (!frame_objects)
			continue;

		/*  Set Fixed Width Font needed for 
		 *  Scrolling List Alignment
		 */
	
		if (!fw_font)
		{
			fw_font = (Xv_Font) xv_find(frame, FONT,
						    FONT_FAMILY, 
						      FONT_FAMILY_LUCIDA_FIXEDWIDTH,
						    FONT_SCALE, 
						     (int) xv_get((Xv_Font) xv_get(panel, PANEL_FONT), 
							          FONT_SCALE),
						    NULL);
		}
	
		xv_set(panel, PANEL_FONT, fw_font, NULL);

		if (panel == Faxtool_window1->status_controls)
		{
			xv_set(Faxtool_window1->jobs_list, 
				PANEL_LIST_WIDTH, 0, 
				NULL);
		}

		else if (panel == Faxtool_directory_popup->directory_controls)
		{
			xv_set(Faxtool_directory_popup->directory_list, 
				PANEL_LIST_WIDTH, 0, 
				PANEL_LIST_INSERT_DUPLICATE, FALSE, 
				PANEL_LIST_SORT, PANEL_FORWARD,
				NULL);
		}

		/* Find all Lists 					*/

		nlists = 0;

		PANEL_EACH_ITEM(panel, item)

		switch ((Panel_item_type) xv_get(item, PANEL_ITEM_CLASS))
		{

		case PANEL_LIST_ITEM:

			if (nlists < MAX_LISTS_PER_PANEL)
				list[nlists++] = item;
			break;
		}

		PANEL_END_EACH
	
		/* Lay out Panel once before resizing Lists		*/

		if (panel != Faxtool_window1->status_controls)
		{
			fprintf(stderr, "faxtool: main: layout %d\n", panel);
	
			layout_objects(frame, panel, 
					list_group ? list_group : frame_objects, 
					frame_objects);
		}

		if (dual_controls && (i > 1) && (owner[i] == owner[i - 1]))
		{
			xv_set(panel, 
			       XV_WIDTH, (int) xv_get(last_panel, XV_WIDTH), 
			       NULL);
		}

		/* Resize all Lists for this Panel			*/

		for (j = 0; j < nlists; j++)
		{
			xv_set(frame, 
				XV_KEY_DATA, LAST_WIDTH, save_width, 
				NULL);
	
			xv_set(list[j],
				XV_KEY_DATA, ORIG_HEIGHT, 
				(int) xv_get(list[j], 
					     PANEL_LIST_DISPLAY_ROWS), 
				XV_KEY_DATA, LAST_HEIGHT, 
				(int) xv_get(list[j], 
					     PANEL_LIST_DISPLAY_ROWS), 
				XV_KEY_DATA, ORIG_WIDTH, 
				(int) xv_get(list[j], PANEL_LIST_WIDTH), 
				XV_KEY_DATA, LAST_WIDTH, 
				(int) xv_get(list[j], PANEL_LIST_WIDTH), 
				XV_KEY_DATA, PANEL_LIST_SORT, PANEL_FORWARD,
				NULL);
		
			xv_set(list[j],
			       PANEL_LIST_WIDTH, 
				scale_list_width(frame, list[j], 
						 nlists > 1 ? 
							SCALE_RELATIVE :
							SCALE_ABSOLUTE),
			       NULL);
	
			group_layout(which_group(list[j], frame_objects));
	
			xv_set(list[j], 
				XV_KEY_DATA, ORIG_HEIGHT, 
				(int) xv_get(list[j], 
					     PANEL_LIST_DISPLAY_ROWS), 
				XV_KEY_DATA, LAST_HEIGHT, 
				(int) xv_get(list[j], 
					     PANEL_LIST_DISPLAY_ROWS), 
				XV_KEY_DATA, ORIG_WIDTH, 
				(int) xv_get(list[j], PANEL_LIST_WIDTH), 
				XV_KEY_DATA, LAST_WIDTH, 
				(int) xv_get(list[j], PANEL_LIST_WIDTH), 
				NULL);

		}

		xv_set(panel,
			XV_WIDTH, WIN_EXTEND_TO_EDGE,
			NULL);

		group_layout(frame_objects);

		/* Reset Attributes for the Frame to current values	*/

		xv_set(frame, 
			XV_KEY_DATA, ORIG_HEIGHT, 
				(int) xv_get(frame, XV_HEIGHT), 
			XV_KEY_DATA, LAST_HEIGHT, 
				(int) xv_get(frame, XV_HEIGHT), 
			XV_KEY_DATA, ORIG_WIDTH, 
				(int) xv_get(frame, XV_WIDTH), 
			XV_KEY_DATA, LAST_WIDTH, 
				(int) xv_get(frame, XV_WIDTH), 
			NULL);
	}

	xv_set(Faxtool_window1->status_controls,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		NULL);

	group_anchor(Faxtool_window1->status_objects);

	xv_set(Faxtool_window1->send_controls,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		NULL);

	sprintf(header, 
		dgettext("faxtool_stubs_labels", "FaxTool - Version: %d.%d"), 
		V_MAJOR, V_MINOR);

	xv_set(Faxtool_window1->window1,
		FRAME_LABEL, header,
		NULL);

	group_anchor(Faxtool_window1->send_objects);

	group_anchor(Faxtool_window1->top_objects);
	panel_paint(Faxtool_window1->top_controls, PANEL_CLEAR);
	
	strncpy(rc_file, pw->pw_dir, PATHLEN);
	strncat(rc_file, "/.faxtoolrc", PATHLEN);

	if ((rc = fopen(rc_file, "r")) == (FILE *) NULL)
	{
		if ((rc = fopen(rc_file, "w")) == (FILE *) NULL)
		{
			perror(dgettext("faxtool_stubs_labels", "faxtool: fopen: "));
			exit(-1);
		}

		store_defaults(Faxtool_prop_popup, rc);
		fclose(rc);

		if ((rc = fopen(rc_file, "r")) == (FILE *) NULL)
		{
			perror(dgettext("faxtool_stubs_labels", "faxtool: fopen: "));
			exit(-1);
		}

	}

	load_defaults(Faxtool_prop_popup, rc);
	load_directory(Faxtool_directory_popup->directory_list, rc);
	fclose(rc);

	/*
	 * Turn control over to XView.
	 */

	gdd_init_dragdrop(Faxtool_window1->window1);
	bindtextdomain("faxtool_ui_labels", locale_path);
	bindtextdomain("faxtool_stubs_labels", locale_path);
	bindtextdomain("faxtool_labels", locale_path);
	xv_main_loop(Faxtool_window1->window1);
	exit(0);
}

#endif


/*
 * Notify callback function for `status_mode__button'.
 */
void
faxtool_window1_status_mode__button_notify_callback(Panel_item item, Event *event)
{
	faxtool_window1_objects *ip = (faxtool_window1_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	fputs("faxtool: faxtool_window1_status_mode__button_notify_callback\n", stderr);
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */
	/* gxv_end_connections */

}

/*
 * Notify callback function for `cover'.
 */
void
faxtool_window1_cover_notify_callback(Panel_item item, int	 value, Event *event)
{
	faxtool_window1_objects *ip = (faxtool_window1_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	fprintf(stderr, "faxtool: faxtool_window1_cover_notify_callback: value: %u\n", value);
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	if (value == 1)
	{
		xv_set(Faxtool_window1->add_dir_button, PANEL_INACTIVE, FALSE, NULL);
	}
	
	if (value == 0)
	{
		xv_set(Faxtool_window1->add_dir_button, PANEL_INACTIVE, TRUE, NULL);
	}
	
	if (value == 0)
	{
		xv_set(Faxtool_window1->to, PANEL_INACTIVE, TRUE, NULL);
	}
	
	if (value == 1)
	{
		xv_set(Faxtool_window1->to, PANEL_INACTIVE, FALSE, NULL);
	}
	
	if (value == 0)
	{
		xv_set(Faxtool_window1->company, PANEL_INACTIVE, TRUE, NULL);
	}
	
	if (value == 1)
	{
		xv_set(Faxtool_window1->company, PANEL_INACTIVE, FALSE, NULL);
	}
	
	if (value == 0)
	{
		xv_set(Faxtool_window1->re, PANEL_INACTIVE, TRUE, NULL);
	}
	
	if (value == 1)
	{
		xv_set(Faxtool_window1->re, PANEL_INACTIVE, FALSE, NULL);
	}
	
	if (value == 0)
	{
		xv_set(Faxtool_window1->comments, PANEL_INACTIVE, TRUE, NULL);
	}
	
	if (value == 1)
	{
		xv_set(Faxtool_window1->comments, PANEL_INACTIVE, FALSE, NULL);
	}
	
	/* gxv_end_connections */

}

/*
 * Notify callback function for `files_button'.
 */
void
browse_button_notify(Panel_item item, Event *event)
{
	faxtool_window1_objects *ip = (faxtool_window1_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	fputs("faxtool: browse_button_notify\n", stderr);

	gfm_set_action(gfm_popup, dgettext("faxtool_stubs_labels", "Add To List"));

	gfm_activate(gfm_popup, (char *) NULL, (char *) NULL, NULL,
		     add_file_to_send, NULL, GFM_DEFAULT);

	fputs("faxtool: browse_button_notify: layout send_controls\n", stderr);

	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	/* gxv_end_connections */

}

/*
 * Notify callback function for `send_button'.
 */
void
faxtool_window1_send_button_notify_callback(Panel_item item, Event *event)
{
	faxtool_window1_objects *ip = (faxtool_window1_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	char			dest[TXTLEN + 1],
				send_time[TXTLEN + 1],
				**arg = &args[0];
	int			i, nrows, time;
	Cover			cover_info;

	fputs("faxtool: faxtool_window1_send_button_notify_callback\n", stderr);

	if (!validate_fax(ip, &cover_info))
	{
		return;
	}
	
	(*arg++) = "sendfax";

	if ((int) xv_get(ip->cover, PANEL_VALUE))
	{
		if (strcmp(cover_info.company, "") != 0)
		{
			(*arg++) = "-x";
			(*arg++) = cover_info.company;
		}

		if (strcmp(cover_info.comments, "") != 0)
		{
			(*arg++) = "-c";
			(*arg++) = cover_info.comments;
		}

		if (strcmp(cover_info.re, "") != 0)
		{
			(*arg++) = "-r";
			(*arg++) = cover_info.re;
		}
	}

	else
	{
		(*arg++) = "-n";
	}

	(*arg++) = "-d";

	dest[0] = NULL;

	if (strcmp(cover_info.name, "") != 0)
	{
		strncpy(dest, cover_info.name, TXTLEN);
		strncat(dest, "@", TXTLEN);
	}

	strncat(dest, cover_info.fax_number, TXTLEN);
	(*arg++) = dest;

	if (strcmp(def.server, "") != 0)
	{
		(*arg++) = "-h";
		(*arg++) = def.server;
	}

	switch ((int) xv_get(ip->resolution, PANEL_VALUE))
	{
	case 0:
		(*arg++) = "-l";
		break;
	case 1:
		(*arg++) = "-m";
		break;
	}

	switch ((int) xv_get(ip->page_size, PANEL_VALUE))
	{
	case 0:
		break;
	case 1:
		(*arg++) = "-A";
		break;
	case 2:
		(*arg++) = "-B";
		break;
	}

	switch ((int) xv_get(ip->notify, PANEL_VALUE))
	{
	case 0:
		break;
	case 1:
		(*arg++) = "-D";
		break;
	case 2:
		(*arg++) = "-R";
		break;
	case 3:
		(*arg++) = "-D";
		(*arg++) = "-R";
		break;
	}

	if (time = (int) xv_get(ip->time, PANEL_VALUE))
	{
		(*arg++) = "-a";
		sprintf(send_time, "now + %d ", time);

		switch ((int) xv_get(ip->time_unit, PANEL_VALUE))
		{
		case 0:
			strcat(send_time, "minutes");
			break;
		case 1:
			strcat(send_time, "hours");
			break;
		}

		(*arg++) = send_time;
	}

	nrows = (int) xv_get(ip->file_list, PANEL_LIST_NROWS);
	for (i = 0; i < nrows; i++)
	{
		(*arg++) = (char *) xv_get(ip->file_list, PANEL_LIST_STRING, i);
	}

	xv_set(ip->window1, 
	FRAME_LEFT_FOOTER, dgettext("faxtool_stubs_labels", "Queueing Fax for Transmission..."), 
	NULL);

	(*arg) = 0;
	do_command(args, read_pipe_to_footer);

	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	send_button_notify(item, event);
	
	/* gxv_end_connections */

}

/*
 * User-defined action for `send_button'.
 */
void
send_button_notify(Panel_item item, Event *event)
{
	fputs("faxtool: send_button_notify\n", stderr);
}

/*
 * Notify callback function for `preview_button'.
 */
void
preview_button_notify(Panel_item item, Event *event)
{
	faxtool_window1_objects *ip = (faxtool_window1_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	char			command[COMLEN + 1],
				files[COMLEN + 1],
				*tmpfile = (char *) NULL,
				**arg = &args[0];
	int			i, nrows;
	struct passwd		*my_passwd = getpwuid(getuid());
	Cover			cover_info;

	fputs("faxtool: preview_button_notify\n", stderr);

	if (!validate_fax(ip, &cover_info))
	{
		return;
	}
	
	if (xv_get(ip->cover, PANEL_VALUE))
	{
		(*arg++) = "/bin/sh";
		(*arg++) = "-c";

		tmpfile = tempnam("/tmp", "faxt");

		sprintf(command, 
			"faxcover -t \"%s\" -x \"%s\" -c \"%s\" -r \"%s\" -f \"%s\" -n \"%s\" > %s",
			cover_info.name,
			cover_info.company,
			cover_info.comments,
			cover_info.re,
			my_passwd->pw_gecos,
			cover_info.fax_number,
			tmpfile);

		xv_set(ip->window1, 
			FRAME_LEFT_FOOTER, dgettext("faxtool_stubs_labels", "Preparing Cover Page..."), 
			NULL);

		(*arg++) = command;
		(*arg) = 0;
		do_command(args, read_pipe_to_footer);

		strcpy(files, tmpfile); 
		strcat(files, " ");
	}

	else
	{
		strcpy(files, ""); 
	}

	arg = &args[0];

	(*arg++) = "/bin/sh";
	(*arg++) = "-c";

	nrows = (int) xv_get(ip->file_list, PANEL_LIST_NROWS);
	for (i = 0; i < nrows; i++)
	{
		strcat(files, (char *) xv_get(ip->file_list, 
						PANEL_LIST_STRING, i));
		strcat(files, " ");
	}

/*	sprintf(command, "pageview -dir %s %s", new_path, files); */
/*	sprintf(command, "cd %s; cat %s  | pageview -", 
			new_path, files); */

	sprintf(command, "%s %s", def.preview_cmd, files);

	if (tmpfile)
	{
		strcat(command, "; rm -f ");
		strcat(command, tmpfile);
	}

	xv_set(ip->window1, 
		FRAME_LEFT_FOOTER, dgettext("faxtool_stubs_labels", "Previewing Fax..."), 
		NULL);

	(*arg++) = command;
	(*arg) = 0;
	do_command(args, read_pipe_to_footer);

	xv_set(ip->window1, 
		FRAME_LEFT_FOOTER, "", 
		NULL);

	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	/* gxv_end_connections */

}

/*
 * Notify callback function for `clear_button'.
 */
void
faxtool_window1_clear_button_notify_callback(Panel_item item, Event *event)
{
	faxtool_window1_objects *ip = (faxtool_window1_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	int	i;
	
	fputs("faxtool: faxtool_window1_clear_button_notify_callback\n", stderr);
	
	fax_send.cover = (int) xv_get(ip->cover, PANEL_VALUE);
	strcpy(fax_send.fax, (char *) xv_get(ip->fax, PANEL_VALUE));
	strcpy(fax_send.to, (char *) xv_get(ip->to, PANEL_VALUE));
	strcpy(fax_send.company, (char *) xv_get(ip->company, PANEL_VALUE));
	strcpy(fax_send.re, (char *) xv_get(ip->re, PANEL_VALUE));
	strcpy(fax_send.comments, (char *) xv_get(ip->comments, PANEL_VALUE));

	fax_send.nfiles = (int) xv_get(ip-> file_list, PANEL_LIST_NROWS);
	for (i = 0; i < fax_send.nfiles; i++)
	{
		strcpy(fax_send.files[i], 
			(char *) xv_get(ip->file_list, PANEL_LIST_STRING, 0));

		xv_set(ip->file_list, PANEL_LIST_DELETE, 0, NULL);
	}

	fax_send.resolution = (int) xv_get(ip->resolution, PANEL_VALUE);
	fax_send.page_size = (int) xv_get(ip->page_size, PANEL_VALUE);
	fax_send.notify = (int) xv_get(ip->notify, PANEL_VALUE);
	fax_send.time = (int) xv_get(ip->time, PANEL_VALUE);
	fax_send.time_unit = (int) xv_get(ip->time_unit, PANEL_VALUE);

	xv_set(ip->cover, PANEL_VALUE, 1, NULL);
	xv_set(ip->fax, PANEL_VALUE, "", NULL);
	xv_set(ip->to, PANEL_VALUE, "", NULL);
	xv_set(ip->company, PANEL_VALUE, "", NULL);
	xv_set(ip->re, PANEL_VALUE, "", NULL);
	xv_set(ip->comments, PANEL_VALUE, "", NULL);
	xv_set(ip->to, 
		PANEL_VALUE, "", 
		PANEL_INACTIVE, FALSE, 
		NULL);
	xv_set(ip->company, 
		PANEL_VALUE, "", 
		PANEL_INACTIVE, FALSE, 
		NULL);
	xv_set(ip->re, 
		PANEL_VALUE, "", 
		PANEL_INACTIVE, FALSE, 
		NULL);
	xv_set(ip->comments, 
		PANEL_VALUE, "", 
		PANEL_INACTIVE, FALSE, 
		NULL);
	xv_set(ip->add_dir_button, 
		PANEL_INACTIVE, FALSE, 
		NULL);
	xv_set(ip->resolution, PANEL_VALUE, 0, NULL);
	xv_set(ip->page_size, PANEL_VALUE, 0, NULL);
	xv_set(ip->notify, PANEL_VALUE, 0, NULL);
	xv_set(ip->time, PANEL_VALUE, 0, NULL);
	xv_set(ip->time_unit, PANEL_VALUE, 0, NULL);

	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	clear_button_notify(item, event);
	
	/* gxv_end_connections */

}

/*
 * User-defined action for `clear_button'.
 */
void
clear_button_notify(Panel_item item, Event *event)
{
	fputs("faxtool: clear_button_notify\n", stderr);

}

/*
 * Notify callback function for `reset_button'.
 */
void
faxtool_window1_reset_button_notify_callback(Panel_item item, Event *event)
{
	faxtool_window1_objects *ip = (faxtool_window1_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	int			i;
	
	fputs("faxtool: faxtool_window1_reset_button_notify_callback\n", stderr);
	
	xv_set(ip->cover, PANEL_VALUE, fax_send.cover, NULL);
	xv_set(ip->fax, PANEL_VALUE, fax_send.fax, NULL);
	xv_set(ip->to, 
		PANEL_VALUE, fax_send.to, 
		PANEL_INACTIVE, !fax_send.cover, 
		NULL);
	xv_set(ip->company, 
		PANEL_VALUE, fax_send.company, 
		PANEL_INACTIVE, !fax_send.cover, 
		NULL);
	xv_set(ip->re, 
		PANEL_VALUE, fax_send.re, 
		PANEL_INACTIVE, !fax_send.cover, 
		NULL);
	xv_set(ip->comments, 
		PANEL_VALUE, fax_send.comments, 
		PANEL_INACTIVE, !fax_send.cover, 
		NULL);

	for (i = 0; i < fax_send.nfiles; i++)
	{
		xv_set(ip->file_list, 
			PANEL_LIST_STRING, i, fax_send.files[i],
			NULL);
	}

	xv_set(ip->resolution, PANEL_VALUE, fax_send.resolution, NULL);
	xv_set(ip->page_size, PANEL_VALUE, fax_send.page_size, NULL);
	xv_set(ip->notify, PANEL_VALUE, fax_send.notify, NULL);
	xv_set(ip->time, PANEL_VALUE, fax_send.time, NULL);
	xv_set(ip->time_unit, PANEL_VALUE, fax_send.time_unit, NULL);

	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	reset_button_notify(item, event);
	
	/* gxv_end_connections */

}

/*
 * User-defined action for `reset_button'.
 */
void
reset_button_notify(Panel_item item, Event *event)
{
	fputs("faxtool: reset_button_notify\n", stderr);

}

/*
 * Notify callback function for `jobs_list'.
 */
int
jobs_list_notify(Panel_item item, char *string, Xv_opaque client_data, Panel_list_op op, Event *event, int row)
{
	faxtool_window1_objects *ip = (faxtool_window1_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	char			file[NUMLEN + 1],
				date[NUMLEN + 1],
				time[NUMLEN + 1],
				path[PATHLEN + 1],
				filepath[PATHLEN + 1];
	struct stat		statbuf,
				statdir;
	int			uid = getuid(),
				gid = getgid();
	
	switch(op) {
	case PANEL_LIST_OP_DESELECT:
		fprintf(stderr, "faxtool: jobs_list_notify: PANEL_LIST_OP_DESELECT: %s\n",string);

		xv_set(ip->job_queue_right_buttons, 
			PANEL_INACTIVE, TRUE, NULL);

		if (!rcv_queue)
		{
			xv_set(ip->status_lower_objects, 
				PANEL_INACTIVE, TRUE, NULL);
		}

		else
		{
			xv_set(ip->job_queue_left_buttons, 
				PANEL_INACTIVE, TRUE, NULL);
		}

		break;

	case PANEL_LIST_OP_SELECT:
		fprintf(stderr, "faxtool: jobs_list_notify: PANEL_LIST_OP_SELECT: %s\n",string);

		if (!rcv_queue)
		{
			xv_set(ip->job_queue_right_buttons, 
				PANEL_INACTIVE, FALSE, NULL);

			xv_set(ip->status_lower_objects, 
				PANEL_INACTIVE, FALSE, NULL);

			xv_set(ip->status_send_time_objects, 
			       PANEL_INACTIVE, 
			       ((int) xv_get(ip->status_send_mode, PANEL_VALUE) 
					== 1) ? FALSE : TRUE,
			       NULL);
		}

		else
		{
			sscanf((char *) xv_get(item, 
						PANEL_LIST_STRING, 
						(int) xv_get(item, 
							PANEL_LIST_FIRST_SELECTED)),
				"%s %s %s", date, time, file);

			sprintf(path, "%s/recvq", def.spool_dir);
			strncpy(filepath, path, PATHLEN);
			strncat(filepath, "/", PATHLEN);
			strncat(filepath, file, PATHLEN);

			if (access(filepath, F_OK) == 0)
			{
				if ((access(path, W_OK) == 0)
				 && (access(filepath, W_OK) == 0))
				{
					xv_set(ip->delete_button, 
						PANEL_INACTIVE, FALSE, NULL);
				}
	
				else
				{
					xv_set(ip->delete_button, 
						PANEL_INACTIVE, TRUE, NULL);
				}

				if (access(filepath, R_OK) == 0)
				{
					xv_set(ip->job_queue_left_buttons, 
						PANEL_INACTIVE, FALSE, NULL);
				}
		
				else
				{
					xv_set(ip->job_queue_left_buttons, 
						PANEL_INACTIVE, TRUE, NULL);
				}
			}
		}

		break;

	case PANEL_LIST_OP_VALIDATE:
		fprintf(stderr, "faxtool: jobs_list_notify: PANEL_LIST_OP_VALIDATE: %s\n",string);
		break;

	case PANEL_LIST_OP_DELETE:
		fprintf(stderr, "faxtool: jobs_list_notify: PANEL_LIST_OP_DELETE: %s\n",string);
		break;
	}
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	/* gxv_end_connections */

	return XV_OK;
}

/*
 * Notify callback function for `modify_button'.
 */
void
modify_button_notify(Panel_item item, Event *event)
{
	faxtool_window1_objects *ip = (faxtool_window1_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	char			**arg = &args[0],
				msg[TXTLEN + 1],
				send_time[TXTLEN + 1],
				job[NUMLEN + 1];
	int			row, time;
	
	fputs("faxtool: modify_button_notify\n", stderr);
	
	row = (int) xv_get(ip->jobs_list, PANEL_LIST_FIRST_SELECTED);

	(*arg++) = "faxalter";

	(*arg++) = "-h";
	(*arg++) = def.server;

	switch ((int) xv_get(ip->status_send_mode, PANEL_VALUE))
	{
	case -1:

		break;

	case 0:

		(*arg++) = "-p";
		break;

	case 1:

		if (time = (int) xv_get(ip->status_send_time, PANEL_VALUE))
		{
			(*arg++) = "-a";
	
			sprintf(send_time, "now + %d ", time);
	
			switch ((int) xv_get(ip->status_send_time_unit, 
					     PANEL_VALUE))
			{
			case 0:
				strcat(send_time, "minutes");
				break;

			case 1:
				strcat(send_time, "hours");
				break;
			}
	
			(*arg++) = send_time;
		}
	}

	switch ((int) xv_get(ip->status_notify, PANEL_VALUE))
	{
	case -1:

		break;

	case 0:

		(*arg++) = "-Q";
		break;

	case 1:

		(*arg++) = "-D";
		break;

	case 2:

		(*arg++) = "-R";
		break;

	case 3:

		(*arg++) = "-D";
		(*arg++) = "-R";
		break;
	}

	sscanf((char *) xv_get(ip->jobs_list, PANEL_LIST_STRING, row), 
		"%s", job);
	(*arg++) = job;

	sprintf(msg, dgettext("faxtool_stubs_labels", "Modifying Job %s..."), job); 
	xv_set(ip->window1, 
		FRAME_LEFT_FOOTER, msg, 
		NULL);

	(*arg) = 0;
	do_command(args, read_pipe_to_footer);

	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	/* gxv_end_connections */

}

/*
 * Notify callback function for `delete_button'.
 */
void
delete_button_notify(Panel_item item, Event *event)
{
	faxtool_window1_objects *ip = (faxtool_window1_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	char			**arg = &args[0],
				msg[TXTLEN + 1],
				path[PATHLEN + 1],
				date[NUMLEN + 1],
				time[NUMLEN + 1],
				job[NUMLEN + 1];
	int			row;
	
	fputs("faxtool: delete_button_notify\n", stderr);
	
	row = (int) xv_get(ip->jobs_list, PANEL_LIST_FIRST_SELECTED);

	if (!rcv_queue)
	{
		(*arg++) = "faxrm";
	
		(*arg++) = "-h";
		(*arg++) = def.server;

		sscanf((char *) xv_get(ip->jobs_list, PANEL_LIST_STRING, row), 
			"%s", job);
		(*arg++) = job;

		sprintf(msg, dgettext("faxtool_stubs_labels", "Deleting Job %s..."), job); 
		xv_set(ip->window1, 
			FRAME_LEFT_FOOTER, msg, 
			NULL);

		(*arg) = 0;
		do_command(args, read_pipe_to_footer);

		xv_set(ip->jobs_list, PANEL_LIST_DELETE, row, NULL);
	}

	else
	{
		sscanf((char *) xv_get(ip->jobs_list, PANEL_LIST_STRING, row), 
			"%s %s %s", date, time, job);

		sprintf(path, "%s/recvq/%s", def.spool_dir, job);

		sprintf(msg, dgettext("faxtool_stubs_labels", "Deleting Fax %s..."), job); 
		xv_set(ip->window1, 
			FRAME_LEFT_FOOTER, msg, 
			NULL);

		if (remove(path))
		{
			perror(dgettext("faxtool_stubs_labels", "faxtool: delete: "));
			xv_set(ip->window1, 
				FRAME_LEFT_FOOTER, dgettext("faxtool_stubs_labels", "Delete Failed!"), 
				NULL);
		}

		else
		{
			xv_set(ip->jobs_list, PANEL_LIST_DELETE, row, NULL);

		}
	}

	xv_set(ip->job_queue_right_buttons, PANEL_INACTIVE, TRUE, NULL);
	xv_set(ip->job_queue_left_buttons, PANEL_INACTIVE, TRUE, NULL);
	xv_set(ip->status_lower_objects, PANEL_INACTIVE, TRUE, NULL);

	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	/* gxv_end_connections */

}

/*
 * Notify callback function for `status_send_mode'.
 */
void
faxtool_window1_status_send_mode_notify_callback(Panel_item item, int	 value, Event *event)
{
	faxtool_window1_objects *ip = (faxtool_window1_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	fprintf(stderr, "faxtool: faxtool_window1_status_send_mode_notify_callback: value: %u\n", value);
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	if (value == 0)
	{
		xv_set(Faxtool_window1->status_send_time_objects, PANEL_INACTIVE, TRUE, NULL);
	}
	
	if (value == 1)
	{
		xv_set(Faxtool_window1->status_send_time_objects, PANEL_INACTIVE, FALSE, NULL);
	}
	
	/* gxv_end_connections */

	if (value == -1)
	{
		xv_set(Faxtool_window1->status_send_time_objects, PANEL_INACTIVE, TRUE, NULL);
	}
}

/*
 * Drop callback function for `drop_target'.
 */
void
drop_notify(Xv_opaque item, Event *event, GDD_DROP_INFO *drop_info)
{
	faxtool_window1_objects *ip = (faxtool_window1_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	int			nrows;
	char			line[PATHLEN + 1];
	
	fputs("faxtool: drop_notify\n", stderr);
	fputs("Successful Drop. GDD_DROP_INFO contents:\n", stderr);
#ifdef TRACE
	gdd_print_drop_info(drop_info);
#endif

	nrows = (int) xv_get(ip->file_list, PANEL_LIST_NROWS);

	if (drop_info->tmpfile && *(drop_info->tmpfile))
	{
		sprintf(line, "%s (%s)", 
			drop_info->tmpfile, drop_info->app_name);

		xv_set(ip->file_list, 
			PANEL_LIST_INSERT, nrows,
			PANEL_LIST_STRING, nrows, line,
			NULL);
	}
	
	else if (drop_info->filename && *(drop_info->filename))
	{
		xv_set(ip->file_list, 
			PANEL_LIST_INSERT, nrows,
			PANEL_LIST_STRING, nrows, drop_info->filename,
			NULL);
	}

	if ((int) xv_get(Faxtool_window1->mode, PANEL_VALUE))
	{
		xv_set(Faxtool_window1->send_controls, XV_SHOW, TRUE, NULL);
		xv_set(Faxtool_window1->status_controls, XV_SHOW, FALSE, NULL);
		xv_set(Faxtool_window1->mode, PANEL_VALUE, 0, NULL);
	}

	if ((int) xv_get(Faxtool_window1->window1, FRAME_CLOSED))
	{
		xv_set(Faxtool_window1->window1, FRAME_CLOSED, FALSE);
	}

	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	/* gxv_end_connections */

}

/*
 * Notify callback function for `mode'.
 */
void
faxtool_window1_mode_notify_callback(Panel_item item, int	 value, Event *event)
{
	faxtool_window1_objects *ip = (faxtool_window1_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	int			send_width,
				send_height,
				status_width,
				status_height;
	static boolean		resize = TRUE;
	
	fprintf(stderr, "faxtool: faxtool_window1_mode_notify_callback: value: %u\n", value);
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	if (value == 0)
	{
		xv_set(Faxtool_window1->send_controls, XV_SHOW, TRUE, NULL);
	}
	
	if (value == 1)
	{
		xv_set(Faxtool_window1->status_controls, XV_SHOW, TRUE, NULL);
	}
	
	/* gxv_end_connections */

	if ((value == 1) && resize)
	{
		resize = FALSE;

		layout_objects(ip->window1, ip->status_controls, 
				ip->job_queue_objects, 
				ip->status_objects);
	
		send_width = (int) xv_get(ip->send_controls, XV_WIDTH);
		send_height = (int) xv_get(ip->send_controls, XV_HEIGHT);
	
		status_width = (int) xv_get(ip->status_controls, XV_WIDTH);
		status_height = (int) xv_get(ip->status_controls, XV_HEIGHT);
	
		xv_set(ip->status_controls,
			XV_WIDTH, 
				send_width > status_width ? send_width : WIN_EXTEND_TO_EDGE,
			XV_HEIGHT,
				send_height > status_height ? send_height : WIN_EXTEND_TO_EDGE,
			NULL);
	
		group_anchor(ip->status_objects);
		group_anchor(ip->send_objects);
	}
}

/*
 * Notify callback function for `query_type'.
 */
void
faxtool_window1_query_type_notify_callback(Panel_item item, int	 value, Event *event)
{
	faxtool_window1_objects *ip = (faxtool_window1_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	int			send_width,
				send_height,
				status_width,
				status_height;
	
	fprintf(stderr, "faxtool: faxtool_window1_query_type_notify_callback: value: %u\n", value);

	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	if (value == 0)
	{
		receive_queue_notify(item, value, event);
	}
	
	if (value == 1)
	{
		send_queue_notify(item, value, event);
	}
	
	/* gxv_end_connections */

	fputs("faxtool: faxtool_window1_query_type_notify_callback: layout status_controls\n", stderr);
/*
	layout_objects(ip->window1, ip->status_controls, 
		       ip->job_queue_objects, ip->status_objects);

	send_width = (int) xv_get(ip->send_controls, XV_WIDTH);
	send_height = (int) xv_get(ip->send_controls, XV_HEIGHT);

	status_width = (int) xv_get(ip->status_controls, XV_WIDTH);
	status_height = (int) xv_get(ip->status_controls, XV_HEIGHT);

	xv_set(ip->status_controls,
		XV_WIDTH, 
			send_width > status_width ? send_width : WIN_EXTEND_TO_EDGE,
		XV_HEIGHT,
			send_height > status_height ? send_height : WIN_EXTEND_TO_EDGE,
		NULL);

	group_layout(ip->send_objects);

	group_anchor(ip->status_objects);
*/
}

/*
 * Notify callback function for `query_mode'.
 */
void
faxtool_window1_query_mode_notify_callback(Panel_item item, int	 value, Event *event)
{
	faxtool_window1_objects *ip = (faxtool_window1_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	fprintf(stderr, "faxtool: faxtool_window1_query_mode_notify_callback: value: %u\n", value);

	if (value == 0)
	{
		xv_set(ip->query_type, PANEL_VALUE, 1, NULL);
	}
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	if (value == 0)
	{
		all_jobs_notify(item, value, event);
	}
	
	if (value == 0)
	{
		xv_set(Faxtool_window1->query_type, PANEL_INACTIVE, TRUE, NULL);
	}
	
	if (value == 1)
	{
		xv_set(Faxtool_window1->query_type, PANEL_INACTIVE, FALSE, NULL);
	}
	
	/* gxv_end_connections */

}

/*
 * Notify callback function for `props_button'.
 */
void
prop_button_notify(Panel_item item, Event *event)
{
	faxtool_window1_objects *ip = (faxtool_window1_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	fputs("faxtool: prop_button_notify\n", stderr);
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */
	/* gxv_end_connections */

}

/*
 * Notify callback function for `status_view_button'.
 */
void
view_button_notify(Panel_item item, Event *event)
{
	faxtool_window1_objects *ip = (faxtool_window1_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	char			command[COMLEN + 1],
				file[PATHLEN + 1],
				date[NUMLEN + 1],
				time[NUMLEN + 1],
				*tmpfile = tempnam("/tmp", "faxt"),
				**arg = &args[0];
	int			row;
	
	fputs("faxtool: view_button_notify\n", stderr);

	arg = &args[0];

	(*arg++) = "/bin/sh";
	(*arg++) = "-c";

	row = (int) xv_get(ip->jobs_list, PANEL_LIST_FIRST_SELECTED);

	sscanf((char *) xv_get(ip->jobs_list, PANEL_LIST_STRING, row), 
		"%s %s %s", date, time, file);

	sprintf(command, 
		"fax2ps %s/recvq/%s 2> /dev/null 1> %s; %s %s; rm -f %s", 
		def.spool_dir, file, tmpfile, def.view_cmd, tmpfile, tmpfile);

	xv_set(ip->window1, 
		FRAME_LEFT_FOOTER, dgettext("faxtool_stubs_labels", "Viewing Fax..."), 
		NULL);

	(*arg++) = command;
	(*arg) = 0;
	do_command(args, read_pipe_to_footer);

	xv_set(ip->window1, 
		FRAME_LEFT_FOOTER, "", 
		NULL);
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	/* gxv_end_connections */

}

/*
 * Notify callback function for `status_print_button'.
 */
void
print_button_notify(Panel_item item, Event *event)
{
	faxtool_window1_objects *ip = (faxtool_window1_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	char			command[COMLEN + 1],
				date[NUMLEN + 1],
				time[NUMLEN + 1],
				file[PATHLEN + 1],
				**arg = &args[0];
	int			row;
	
	fputs("faxtool: print_button_notify\n", stderr);

	arg = &args[0];

	(*arg++) = "/bin/sh";
	(*arg++) = "-c";

	row = (int) xv_get(ip->jobs_list, PANEL_LIST_FIRST_SELECTED);

	sscanf((char *) xv_get(ip->jobs_list, PANEL_LIST_STRING, row),
 		"%s %s %s", date, time, file);


	sprintf(command, 
		"fax2ps %s/recvq/%s 2> /dev/null | %s", 
		def.spool_dir, file, def.print_cmd);

	xv_set(ip->window1, 
		FRAME_LEFT_FOOTER, dgettext("faxtool_stubs_labels", "Printing Fax..."), 
		NULL);

	(*arg++) = command;
	(*arg) = 0;
	do_command(args, read_pipe_to_footer);

	xv_set(ip->window1, 
		FRAME_LEFT_FOOTER, "", 
		NULL);
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	/* gxv_end_connections */

}

/*
 * Notify callback function for `props_button'.
 */
void
faxtool_window1_props_button_notify_callback(Panel_item item, Event *event)
{
	faxtool_window1_objects *ip = (faxtool_window1_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	fputs("faxtool: faxtool_window1_props_button_notify_callback\n", stderr);
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	xv_set(Faxtool_prop_popup->prop_popup, XV_SHOW, TRUE, NULL);
	
	/* gxv_end_connections */

}

/*
 * User-defined action for `query_mode'.
 */
void
all_jobs_notify(Panel_item item, int	 value, Event *event)
{
	char			**arg = &args[0];
	int			i, nrows;

	fputs("faxtool: all_jobs_notify\n", stderr);
	
	nrows = (int) xv_get(Faxtool_window1->jobs_list, PANEL_LIST_NROWS);
	for (i = 0; i < nrows; i++)
	{
		xv_set(Faxtool_window1->jobs_list, PANEL_LIST_DELETE, 0, NULL);
	}
	
	rcv_queue = FALSE;

	(*arg++) = "faxstat";

	(*arg++) = "-h";
	(*arg++) = def.server;

	(*arg++) = "-a";

	xv_set(Faxtool_window1->window1, 
	FRAME_LEFT_FOOTER, dgettext("faxtool_stubs_labels", "Updating Status..."), 
	NULL);

	xv_set(Faxtool_window1->jobs_list,
		PANEL_LIST_TITLE, 
		dgettext("faxtool_stubs_labels", "Job  Modem Destination     Time-To-Send     Sender         Status               "), 
		NULL);

	fputs("faxtool: all_jobs_notify: layout status_controls\n", stderr);
/*
	layout_objects(Faxtool_window1->window1, Faxtool_window1->status_controls, 
		       Faxtool_window1->job_queue_objects, 
		       Faxtool_window1->status_objects);

	xv_set(Faxtool_window1->status_controls,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		NULL);

	group_layout(Faxtool_window1->send_objects);
*/
	group_anchor(Faxtool_window1->status_objects);

	(*arg) = 0;
	do_command(args, read_pipe_to_list);

	xv_set(Faxtool_window1->job_queue_right_buttons, 
		PANEL_INACTIVE, TRUE, NULL);

	xv_set(Faxtool_window1->job_queue_left_buttons, 
		PANEL_INACTIVE, TRUE, NULL);

	xv_set(Faxtool_window1->status_lower_objects, 
		PANEL_INACTIVE, TRUE, NULL);
}

/*
 * User-defined action for `query_type'.
 */
void
receive_queue_notify(Panel_item item, int	 value, Event *event)
{
	int			i, nrows;

	fputs("faxtool: receive_queue_notify\n", stderr);

	nrows = (int) xv_get(Faxtool_window1->jobs_list, PANEL_LIST_NROWS);
	for (i = 0; i < nrows; i++)
	{
		xv_set(Faxtool_window1->jobs_list, PANEL_LIST_DELETE, 0, NULL);
	}
	
	rcv_queue = TRUE;

	load_recv_queue(Faxtool_window1);

	xv_set(Faxtool_window1->job_queue_right_buttons, 
		PANEL_INACTIVE, TRUE, NULL);

	xv_set(Faxtool_window1->job_queue_left_buttons, 
		PANEL_INACTIVE, TRUE, NULL);

	xv_set(Faxtool_window1->status_lower_objects, 
		PANEL_INACTIVE, TRUE, NULL);
}

/*
 * User-defined action for `query_type'.
 */
void
send_queue_notify(Panel_item item, int	 value, Event *event)
{
	char			**arg = &args[0];
	int			i, nrows;

	fputs("faxtool: send_queue_notify\n", stderr);

	nrows = (int) xv_get(Faxtool_window1->jobs_list, PANEL_LIST_NROWS);
	for (i = 0; i < nrows; i++)
	{
		xv_set(Faxtool_window1->jobs_list, PANEL_LIST_DELETE, 0, NULL);
	}
	
	rcv_queue = FALSE;

	(*arg++) = "faxstat";

	(*arg++) = "-h";
	(*arg++) = def.server;

	xv_set(Faxtool_window1->window1, 
		FRAME_LEFT_FOOTER, dgettext("faxtool_stubs_labels", "Updating Status..."), 
		NULL);

	xv_set(Faxtool_window1->jobs_list,
		PANEL_LIST_TITLE, 
		dgettext("faxtool_stubs_labels", "Job  Modem Destination     Time-To-Send     Sender         Status               "), 
		NULL);

	(*arg) = 0;
	do_command(args, read_pipe_to_list);

	xv_set(Faxtool_window1->job_queue_right_buttons, 
		PANEL_INACTIVE, TRUE, NULL);

	xv_set(Faxtool_window1->job_queue_left_buttons, 
		PANEL_INACTIVE, TRUE, NULL);

	xv_set(Faxtool_window1->status_lower_objects, 
		PANEL_INACTIVE, TRUE, NULL);
}

/*
 * Event callback function for `window1'.
 */
Notify_value
faxtool_window1_event_callback(Xv_window win, Event *event, Notify_arg arg, Notify_event_type type)
{
	faxtool_window1_objects *ip = (faxtool_window1_objects *) xv_get(win, XV_KEY_DATA, INSTANCE);
	
	fprintf(stderr, "faxtool: faxtool_window1_event_callback: event %d\n", event_id(event));
	
	if (first && (event_id(event) == WIN_MAP_NOTIFY))
	{
		first = FALSE;
	}

	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	if (event_action(event) == WIN_RESIZE)
	{
		main_panel_resize_notify(win, event, arg, type);
	}
	
	/* gxv_end_connections */

	return notify_next_event_func(win, (Notify_event) event, arg, type);
}

/*
 * User-defined action for `window1'.
 */
void
main_panel_resize_notify(Xv_window win, Event *event, Notify_arg arg, Notify_event_type type)
{
	faxtool_window1_objects *ip = (faxtool_window1_objects *) xv_get(win, XV_KEY_DATA, INSTANCE);
	int			save_height,
				save_width,
				send_width,
				send_height,
				status_width,
				status_height;
	
	fprintf(stderr, "faxtool: main_panel_resize_notify: event %d\n", event_id(event));

	if (!first)
	{
		save_height = (int) xv_get(ip->window1, XV_KEY_DATA, LAST_HEIGHT);
		save_width = (int) xv_get(ip->window1, XV_KEY_DATA, LAST_WIDTH);
#ifdef TRACE		
		fprintf(stderr, 
			"faxtool: main_panel_resize_notify: resizing send_controls\n");
#endif	
		panel_resize(ip->send_controls, ip->send_objects);
	
		xv_set(ip->window1, XV_KEY_DATA, LAST_HEIGHT, save_height, NULL);
		xv_set(ip->window1, XV_KEY_DATA, LAST_WIDTH, save_width, NULL);
#ifdef TRACE	
		fprintf(stderr, 
			"faxtool: main_panel_resize_notify: resizing status_controls\n");
#endif	
		panel_resize(ip->status_controls, ip->status_objects);
	
		send_width = (int) xv_get(ip->send_controls, XV_WIDTH);
		send_height = (int) xv_get(ip->send_controls, XV_HEIGHT);
	
		status_width = (int) xv_get(ip->status_controls, XV_WIDTH);
		status_height = (int) xv_get(ip->status_controls, XV_HEIGHT);
	
		xv_set(ip->status_controls,
			XV_WIDTH, 
			send_width > status_width ? send_width : WIN_EXTEND_TO_EDGE,
			XV_HEIGHT,
			send_height > status_height ? send_height : WIN_EXTEND_TO_EDGE,
			NULL);
	
		group_anchor(ip->status_objects);
	
		xv_set(ip->send_controls,
			XV_WIDTH, 
			status_width > send_width ? status_width : WIN_EXTEND_TO_EDGE,
			XV_HEIGHT,
			status_height > send_height ? status_height : WIN_EXTEND_TO_EDGE,
			NULL);
	
		group_anchor(ip->send_objects);
	
		xv_set(ip->top_controls, 
			XV_WIDTH, WIN_EXTEND_TO_EDGE, 
			NULL);
	
		group_anchor(ip->top_objects);
		panel_paint(ip->top_controls, PANEL_CLEAR);
	}
}

/*
 * Notify callback function for `directory_button'.
 */
void
faxtool_window1_directory_button_notify_callback(Panel_item item, Event *event)
{
	faxtool_window1_objects *ip = (faxtool_window1_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	static boolean		resize = TRUE;
	
	fputs("faxtool: faxtool_window1_directory_button_notify_callback\n", stderr);
	
	if (resize)
	{
		resize = FALSE;

		layout_objects(Faxtool_directory_popup->directory_popup, 
				Faxtool_directory_popup->directory_controls, 
				Faxtool_directory_popup->dir_list_objects, 
				Faxtool_directory_popup->dir_objects);
	}

	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	xv_set(Faxtool_directory_popup->directory_popup, FRAME_CMD_PUSHPIN_IN, TRUE, NULL);
	xv_set(Faxtool_directory_popup->directory_popup, XV_SHOW, TRUE, NULL);
	
	/* gxv_end_connections */

}

/*
 * Notify callback function for `add_dir_button'.
 */
void
add_dir_notify(Panel_item item, Event *event)
{
	faxtool_window1_objects *ip = (faxtool_window1_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	char				buf[TXTLEN + 1];
	int				row;
		
	fputs("faxtool: add_dir_notify\n", stderr);
	
	strncpy(dir.fax, (char *) xv_get(ip->fax, PANEL_VALUE), NUMLEN);
	strncpy(dir.name, (char *) xv_get(ip->to, PANEL_VALUE), NUMLEN);
	strncpy(dir.company, (char *) xv_get(ip->company, PANEL_VALUE), NUMLEN);

	xv_set(ip->window1, 
		FRAME_LEFT_FOOTER, "", 
		NULL);

	if ((strcmp(dir.fax, "") != 0)
	 && ((strcmp(dir.name, "") != 0) || (strcmp(dir.company, "") != 0)))
	{
		sprintf(buf, "%-25s%-25s%-25s", dir.name, dir.company, dir.fax);
		
		xv_set(Faxtool_directory_popup->directory_list,
			PANEL_LIST_SELECT, 
			  (int) xv_get(Faxtool_directory_popup->directory_list, 
				       PANEL_LIST_FIRST_SELECTED),
			  FALSE,
			PANEL_LIST_INSERT_DUPLICATE, FALSE, 
			PANEL_LIST_INSERT, 
			row = (int) xv_get(Faxtool_directory_popup->directory_list, 
					   PANEL_LIST_NROWS),
			PANEL_LIST_FONT, row, fw_font,
			PANEL_LIST_STRING, row, buf,
			PANEL_LIST_SELECT, row, TRUE,
			PANEL_LIST_SORT, PANEL_FORWARD,
			NULL);

		/* This ridiculous kluge is needed because 
		   PANEL_LIST_INSERT_DUPLICATE does not work right!	*/

		if ((char *) xv_get(Faxtool_directory_popup->directory_list,
				    PANEL_LIST_STRING, 
				    row = (int) xv_get(Faxtool_directory_popup->directory_list, 
				      		       PANEL_LIST_FIRST_SELECTED))
		 == (char *) NULL)

		{
			xv_set(Faxtool_directory_popup->directory_list,
				PANEL_LIST_DELETE, row,
				NULL);
		}

		xv_set(Faxtool_directory_popup->dir_name, 
			PANEL_VALUE, dir.name, 
			NULL);
		xv_set(Faxtool_directory_popup->dir_company, 
			PANEL_VALUE, dir.company, 
			NULL);
		xv_set(Faxtool_directory_popup->dir_fax, 
			PANEL_VALUE, dir.fax, 
			NULL);

		xv_set(Faxtool_directory_popup->dir_select_button, 
			PANEL_INACTIVE, FALSE, 
			NULL);
		xv_set(Faxtool_directory_popup->dir_buttons, 
			PANEL_INACTIVE, FALSE, 
			NULL);

	}

	else
	{
		xv_set(ip->window1, 
			FRAME_LEFT_FOOTER, 
			dgettext("faxtool_stubs_labels", "You must specify a Fax Number and a Name or Company!"), 
			NULL);
	}

	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	/* gxv_end_connections */

}

/*
 * Notify callback function for `dir_add_button'.
 */
void
dir_add_notify(Panel_item item, Event *event)
{
	faxtool_directory_popup_objects *ip = (faxtool_directory_popup_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	char				buf[TXTLEN + 1];
	int				row;
	
	fputs("faxtool: dir_add_notify\n", stderr);
	
	strncpy(dir.fax, (char *) xv_get(ip->dir_fax, PANEL_VALUE), NUMLEN);
	strncpy(dir.name, (char *) xv_get(ip->dir_name, PANEL_VALUE), NUMLEN);
	strncpy(dir.company, (char *) xv_get(ip->dir_company, PANEL_VALUE), NUMLEN);

	xv_set(ip->directory_popup, 
		FRAME_LEFT_FOOTER, "", 
		NULL);

	if ((strcmp(dir.fax, "") != 0)
	 && ((strcmp(dir.name, "") != 0) || (strcmp(dir.company, "") != 0)))
	{
		sprintf(buf, "%-25s%-25s%-25s", dir.name, dir.company, dir.fax);
		
		xv_set(ip->directory_list,
			PANEL_LIST_SELECT, 
			(int) xv_get(ip->directory_list, PANEL_LIST_FIRST_SELECTED),
			FALSE,
			PANEL_LIST_INSERT_DUPLICATE, FALSE, 
			PANEL_LIST_INSERT, 
			  row = (int) xv_get(ip->directory_list, PANEL_LIST_NROWS),
			PANEL_LIST_FONT, row, fw_font,
			PANEL_LIST_STRING, row, buf,
			PANEL_LIST_SELECT, row, TRUE,
			PANEL_LIST_SORT, PANEL_FORWARD,
			NULL);

			/* This ridiculous kluge is needed because 
			   PANEL_LIST_INSERT_DUPLICATE does not work right!	*/
	
			if ((char *) xv_get(Faxtool_directory_popup->directory_list,
					    PANEL_LIST_STRING, 
						row = (int) xv_get(Faxtool_directory_popup->directory_list, 
							PANEL_LIST_FIRST_SELECTED))
			 == (char *) NULL)
	
			{
				xv_set(Faxtool_directory_popup->directory_list,
					PANEL_LIST_DELETE, row,
					NULL);
			}

	}

	else
	{
		xv_set(ip->directory_popup, 
			FRAME_LEFT_FOOTER, 
			dgettext("faxtool_stubs_labels", "You must specify a Fax Number and a Name or Company!"), 
			NULL);
	}

	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	/* gxv_end_connections */

}

/*
 * Notify callback function for `dir_change_button'.
 */
void
dir_change_notify(Panel_item item, Event *event)
{
	faxtool_directory_popup_objects *ip = (faxtool_directory_popup_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	char				buf[TXTLEN + 1];
		
	fputs("faxtool: dir_change_notify\n", stderr);
	
	strncpy(dir.fax, (char *) xv_get(ip->dir_fax, PANEL_VALUE), NUMLEN);
	strncpy(dir.name, (char *) xv_get(ip->dir_name, PANEL_VALUE), NUMLEN);
	strncpy(dir.company, (char *) xv_get(ip->dir_company, PANEL_VALUE), NUMLEN);

	xv_set(ip->directory_popup, 
		FRAME_LEFT_FOOTER, "", 
		NULL);

	if ((strcmp(dir.fax, "") != 0)
	 && ((strcmp(dir.name, "") != 0) || (strcmp(dir.company, "") != 0)))
	{
		sprintf(buf, "%-25s%-25s%-25s", dir.name, dir.company, dir.fax);
		
		xv_set(ip->directory_list,
			PANEL_LIST_STRING, 
				(int) xv_get(ip->directory_list, 
						PANEL_LIST_FIRST_SELECTED), 
				buf,
			NULL);
	}

	else
	{
		xv_set(ip->directory_popup, 
			FRAME_LEFT_FOOTER, 
			dgettext("faxtool_stubs_labels", "You must specify a Fax Number and a Name or Company!"), 
			NULL);
	}

	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	/* gxv_end_connections */

}

/*
 * Notify callback function for `dir_delete_button'.
 */
void
dir_delete_notify(Panel_item item, Event *event)
{
	faxtool_directory_popup_objects *ip = (faxtool_directory_popup_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	fputs("faxtool: dir_delete_notify\n", stderr);
	
	xv_set(ip->directory_list,
		PANEL_LIST_DELETE, 
			(int) xv_get(ip->directory_list, PANEL_LIST_FIRST_SELECTED),
		NULL);

	xv_set(ip->dir_name, PANEL_VALUE, "", NULL);
	xv_set(ip->dir_company, PANEL_VALUE, "", NULL);
	xv_set(ip->dir_fax, PANEL_VALUE, "", NULL);

	xv_set(ip->dir_select_button, PANEL_INACTIVE, TRUE, NULL);
	xv_set(ip->dir_change_button, PANEL_INACTIVE, TRUE, NULL);
	xv_set(ip->dir_delete_button, PANEL_INACTIVE, TRUE, NULL);

	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	/* gxv_end_connections */

}

/*
 * Notify callback function for `directory_list'.
 */
int
directory_list_notify(Panel_item item, char *string, Xv_opaque client_data, Panel_list_op op, Event *event, int row)
{
	faxtool_directory_popup_objects *ip = (faxtool_directory_popup_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	switch(op) {
	case PANEL_LIST_OP_DESELECT:
		fprintf(stderr, "faxtool: directory_list_notify: PANEL_LIST_OP_DESELECT: %s\n",string);

		xv_set(ip->dir_name, PANEL_VALUE, "", NULL);
		xv_set(ip->dir_company, PANEL_VALUE, "", NULL);
		xv_set(ip->dir_fax, PANEL_VALUE, "", NULL);

		xv_set(ip->dir_select_button, PANEL_INACTIVE, TRUE, NULL);
		xv_set(ip->dir_change_button, PANEL_INACTIVE, TRUE, NULL);
		xv_set(ip->dir_delete_button, PANEL_INACTIVE, TRUE, NULL);

		break;

	case PANEL_LIST_OP_SELECT:
		fprintf(stderr, "faxtool: directory_list_notify: PANEL_LIST_OP_SELECT: %s\n",string);

		sscanf((char *) xv_get(item, PANEL_LIST_STRING, 
				(int) xv_get(item, PANEL_LIST_FIRST_SELECTED)), 
			"%25c%25c%25c", 
			dir.name, dir.company, dir.fax);

		trim_string(dir.name);
		trim_string(dir.company);
		trim_string(dir.fax);

		xv_set(ip->dir_name, PANEL_VALUE, dir.name, NULL);
		xv_set(ip->dir_company, PANEL_VALUE, dir.company, NULL);
		xv_set(ip->dir_fax, PANEL_VALUE, dir.fax, NULL);

		xv_set(ip->dir_select_button, PANEL_INACTIVE, FALSE, NULL);
		xv_set(ip->dir_buttons, PANEL_INACTIVE, FALSE, NULL);

		break;

	case PANEL_LIST_OP_VALIDATE:
		fprintf(stderr, "faxtool: directory_list_notify: PANEL_LIST_OP_VALIDATE: %s\n",string);
		break;

	case PANEL_LIST_OP_DELETE:
		fprintf(stderr, "faxtool: directory_list_notify: PANEL_LIST_OP_DELETE: %s\n",string);
		break;
	}
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	/* gxv_end_connections */

	return XV_OK;
}

/*
 * Event callback function for `directory_popup'.
 */
Notify_value
faxtool_directory_popup_event_callback(Xv_window win, Event *event, Notify_arg arg, Notify_event_type type)
{
	faxtool_directory_popup_objects *ip = (faxtool_directory_popup_objects *) xv_get(win, XV_KEY_DATA, INSTANCE);
	
	fprintf(stderr, "faxtool: faxtool_directory_popup_event_callback: event %d\n", event_id(event));
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	if (event_action(event) == WIN_RESIZE)
	{
		directory_popup_resize(win, event, arg, type);
	}
	
	/* gxv_end_connections */

	return notify_next_event_func(win, (Notify_event) event, arg, type);
}

/*
 * User-defined action for `directory_popup'.
 */
void
directory_popup_resize(Xv_window win, Event *event, Notify_arg arg, Notify_event_type type)
{
	faxtool_directory_popup_objects *ip = (faxtool_directory_popup_objects *) xv_get(win, XV_KEY_DATA, INSTANCE);
	
	fprintf(stderr, "faxtool: directory_popup_resize: event %d\n", event_id(event));

	panel_resize(ip->directory_controls, ip->dir_objects);

}

/*
 * Notify callback function for `dir_select_button'.
 */
void
dir_select_button_notify(Panel_item item, Event *event)
{
	faxtool_directory_popup_objects *ip = (faxtool_directory_popup_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	fputs("faxtool: dir_select_button_notify\n", stderr);

	xv_set(Faxtool_window1->fax, 
		PANEL_VALUE, (char *) xv_get(ip->dir_fax, PANEL_VALUE), 
		NULL);
	
	xv_set(Faxtool_window1->to, 
		PANEL_VALUE, (char *) xv_get(ip->dir_name, PANEL_VALUE), 
		NULL);
	
	xv_set(Faxtool_window1->company, 
		PANEL_VALUE, (char *) xv_get(ip->dir_company, PANEL_VALUE), 
		NULL);
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	/* gxv_end_connections */

}

/*
 * Notify callback function for `dir_save_button'.
 */
void
dir_save_button_notify(Panel_item item, Event *event)
{
	faxtool_directory_popup_objects *ip = (faxtool_directory_popup_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	fputs("faxtool: dir_save_button_notify\n", stderr);

	if (item == Faxtool_prop_popup->prop_save_button)
	{
		prop_apply_notify(Faxtool_prop_popup->prop_apply_button, event);
	}

	save_rc();
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	/* gxv_end_connections */

}

/*
 * Notify callback function for `dir_clear_button'.
 */
void
dir_clear_button_notify(Panel_item item, Event *event)
{
	faxtool_directory_popup_objects *ip = (faxtool_directory_popup_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	fputs("faxtool: dir_clear_button_notify\n", stderr);
	
	strncpy(dir.fax, (char *) xv_get(ip->dir_fax, PANEL_VALUE), NUMLEN);
	strncpy(dir.name, (char *) xv_get(ip->dir_name, PANEL_VALUE), NUMLEN);
	strncpy(dir.company, (char *) xv_get(ip->dir_company, PANEL_VALUE), NUMLEN);

	xv_set(ip->dir_name, PANEL_VALUE, "", NULL);
	xv_set(ip->dir_company, PANEL_VALUE, "", NULL);
	xv_set(ip->dir_fax, PANEL_VALUE, "", NULL);

	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	/* gxv_end_connections */

}

/*
 * Notify callback function for `dir_reset_button'.
 */
void
dir_reset_button_notify(Panel_item item, Event *event)
{
	faxtool_directory_popup_objects *ip = (faxtool_directory_popup_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	fputs("faxtool: dir_reset_button_notify\n", stderr);
	
	xv_set(ip->dir_name, PANEL_VALUE, dir.name, NULL);
	xv_set(ip->dir_company, PANEL_VALUE, dir.company, NULL);
	xv_set(ip->dir_fax, PANEL_VALUE, dir.fax, NULL);

	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	/* gxv_end_connections */

}

/*
 * Notify callback function for `prop_apply_button'.
 */
void
prop_apply_notify(Panel_item item, Event *event)
{
	faxtool_prop_popup_objects *ip = (faxtool_prop_popup_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	fputs("faxtool: prop_apply_notify\n", stderr);

	strncpy(def.server, (char *) xv_get(ip->fax_host, PANEL_VALUE), NUMLEN);
	strncpy(def.spool_dir, (char *) xv_get(ip->fax_dir, PANEL_VALUE), PATHLEN);
	strncpy(def.view_cmd, (char *) xv_get(ip->view_cmd, PANEL_VALUE), TXTLEN);
	strncpy(def.print_cmd, (char *) xv_get(ip->print_cmd, PANEL_VALUE), TXTLEN);
	strncpy(def.preview_cmd, (char *) xv_get(ip->preview_cmd, PANEL_VALUE), 
		TXTLEN);

	check_remote();
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	/* gxv_end_connections */

}

/*
 * Notify callback function for `prop_clear_button'.
 */
void
prop_clear_notify(Panel_item item, Event *event)
{
	faxtool_prop_popup_objects *ip = (faxtool_prop_popup_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	fputs("faxtool: prop_clear_notify\n", stderr);

	xv_set(ip->fax_host, PANEL_VALUE, "", NULL);
	xv_set(ip->fax_dir, PANEL_VALUE, "", NULL);
	xv_set(ip->view_cmd, PANEL_VALUE, "", NULL);
	xv_set(ip->print_cmd, PANEL_VALUE, "", NULL);
	xv_set(ip->preview_cmd, PANEL_VALUE, "", NULL);
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	/* gxv_end_connections */

}

/*
 * Notify callback function for `prop_reset_button'.
 */
void
prop_reset_notify(Panel_item item, Event *event)
{
	faxtool_prop_popup_objects *ip = (faxtool_prop_popup_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	fputs("faxtool: prop_reset_notify\n", stderr);
	
	xv_set(ip->fax_host, PANEL_VALUE, def.server, NULL);
	xv_set(ip->fax_dir, PANEL_VALUE, def.spool_dir, NULL);
	xv_set(ip->view_cmd, PANEL_VALUE, def.view_cmd, NULL);
	xv_set(ip->print_cmd, PANEL_VALUE, def.print_cmd, NULL);
	xv_set(ip->preview_cmd, PANEL_VALUE, def.preview_cmd, NULL);
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	/* gxv_end_connections */

}
