static char rcsid[] = "$Id: dumptool_extra_ui.c,v 1.18 2000/06/22 11:57:04 raistlin Exp $";

/*
 * dumptool_ui.c - User interface object initialization functions.
 * This file was generated by `gxv' from `dumptool.G'.
 * DO NOT EDIT BY HAND.
 */

#include <stdio.h>
#include <libgen.h>
#if defined(__GLIBC__) || defined (__linux__)
#include <string.h>
#endif
#include <sys/param.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <xview/xview.h>
#include <xview/canvas.h>
#include <xview/panel.h>
#include <xview/scrollbar.h>
#include <xview/svrimage.h>
#include <xview/termsw.h>
#include <xview/text.h>
#include <xview/tty.h>
#include <xview/xv_xrect.h>
#include <gcm.h>
#include "dumptool.h"
#include "global.h"

#if defined XV_VERSION_NUMBER && XV_VERSION_NUMBER >= 3200
#include <xview/file_chsr.h>

/*
 * External functions.
 */
extern void load_script();                /* load data from file to screen */
extern void save_script();                /* function to save backup script */
extern int  yes_or_no(char *msg);         /* get a yes or no response from user  */
extern void generic_notifier(char *msg);  /* Put up a Notice with a single message */
extern void dumptool_frame_busy_true(void);
extern void dumptool_frame_busy_false(void);
extern char * dumptool_basename(char *filename);
extern char * dumptool_dirname(char *filename);

/*
 * Initialize an instance of object `base'.
 */
dumptool_base_extra_objects *
dumptool_base_extra_objects_initialize(dumptool_base_extra_objects *ip, Xv_opaque owner)
{
	extern void		do_open_chooser_script(Panel_item, Event *);
	extern void		do_save_chooser_script(Panel_item, Event *);

	if (!ip && !(ip = (dumptool_base_extra_objects *) calloc(1, sizeof (dumptool_base_extra_objects))))
		return (dumptool_base_extra_objects *) NULL;
	if (!ip->open_chooser)
		ip->open_chooser = dumptool_base_extra_open_chooser_create(ip, ip->open_chooser);
	if (!ip->save_chooser)
		ip->save_chooser = dumptool_base_extra_save_chooser_create(ip, ip->save_chooser);
	if (!ip->saveas_chooser)
		ip->saveas_chooser = dumptool_base_extra_saveas_chooser_create(ip, ip->saveas_chooser);

	/* Override Save script and Load script callbacks before returning so we can call the
	  chooser-specific functions if we're running XView >= 3.2 */
	xv_set(Dumptool_base->load_script_button, PANEL_NOTIFY_PROC, do_open_chooser_script, NULL);
	xv_set(Dumptool_base->save_script_button, PANEL_NOTIFY_PROC, do_save_chooser_script, NULL);

	return ip;
}

/*
 * Create object `open_chooser' in the specified instance.
 */
Xv_opaque
dumptool_base_extra_open_chooser_create(dumptool_base_extra_objects *ip, Xv_opaque owner)
{
	extern int	dumptool_open_chooser_callback(Panel_item, unsigned int, Event *);
	extern void	chooser_cancel_proc(Panel_item, Event *);
	extern void	chooser_destroy_proc(Frame);
	Xv_opaque	obj;
	
	obj = xv_create(owner, FILE_CHOOSER_OPEN_DIALOG,
		XV_KEY_DATA, EXTRA_INSTANCE, ip,
		XV_LABEL,			"Dumptool: Open Script file",
		XV_HELP_DATA, 			"dumptool:open_chooser_area",
		FILE_CHOOSER_NOTIFY_FUNC,	dumptool_open_chooser_callback,
		FRAME_DONE_PROC,		chooser_destroy_proc,
		FILE_CHOOSER_AUTO_UPDATE,	TRUE,
		NULL);

	/* Override PANEL_NOTIFY_PROC for Cancel button to allow us to unfreeze base_frame */
	xv_set(
	    xv_get(obj,FILE_CHOOSER_CHILD,FILE_CHOOSER_CANCEL_BUTTON_CHILD,NULL),
	    PANEL_NOTIFY_PROC,chooser_cancel_proc,
	    NULL);

	return obj;
}

/*
 * Create object `save_chooser' in the specified instance.
 */
Xv_opaque
dumptool_base_extra_save_chooser_create(dumptool_base_extra_objects *ip, Xv_opaque owner)
{
	extern int	dumptool_save_chooser_callback(Panel_item, unsigned int, Event *);
	extern void	chooser_cancel_proc(Panel_item, Event *);
	extern void	chooser_destroy_proc(Frame);
	Xv_opaque	obj;
	
	obj = xv_create(owner, FILE_CHOOSER_SAVE_DIALOG,
		XV_KEY_DATA, EXTRA_INSTANCE, ip,
		XV_LABEL,			"Dumptool: Save Script file",
		XV_HELP_DATA, 			"dumptool:save_chooser_area",
		FILE_CHOOSER_NOTIFY_FUNC,	dumptool_save_chooser_callback,
		FRAME_DONE_PROC,		chooser_destroy_proc,
		FILE_CHOOSER_AUTO_UPDATE,	TRUE,
		FILE_CHOOSER_NO_CONFIRM,	TRUE,
		NULL);

	/* Override PANEL_NOTIFY_PROC for Cancel button to allow us to unfreeze base_frame */
	xv_set(
	    xv_get(obj,FILE_CHOOSER_CHILD,FILE_CHOOSER_CANCEL_BUTTON_CHILD,NULL),
	    PANEL_NOTIFY_PROC,chooser_cancel_proc,
	    NULL);

	return obj;
}

/*
 * Create object `saveas_chooser' in the specified instance.
 */
Xv_opaque
dumptool_base_extra_saveas_chooser_create(dumptool_base_extra_objects *ip, Xv_opaque owner)
{
	extern int	dumptool_save_chooser_callback(Panel_item, unsigned int, Event *);
	extern void	chooser_cancel_proc(Panel_item, Event *);
	extern void	chooser_destroy_proc(Frame);
	Xv_opaque	obj;
	
	obj = xv_create(owner, FILE_CHOOSER_SAVEAS_DIALOG,
		XV_KEY_DATA, EXTRA_INSTANCE, ip,
		XV_LABEL,			"Dumptool: Save Script file as...",
		XV_HELP_DATA, 			"dumptool:saveas_chooser_area",
		FILE_CHOOSER_NOTIFY_FUNC,	dumptool_save_chooser_callback,
		FRAME_DONE_PROC,		chooser_destroy_proc,
		FILE_CHOOSER_AUTO_UPDATE,	TRUE,
		FILE_CHOOSER_NO_CONFIRM,	TRUE,
		NULL);

	/* Override PANEL_NOTIFY_PROC for Cancel button to allow us to unfreeze base_frame */
	xv_set(
	    xv_get(obj,FILE_CHOOSER_CHILD,FILE_CHOOSER_CANCEL_BUTTON_CHILD,NULL),
	    PANEL_NOTIFY_PROC,chooser_cancel_proc,
	    NULL);

	return obj;
}

/*
 * Notify callback function for `load_script_button'.
 * This is invoked when the "Load" button is pressed and XV_VERSION_NUMBER >= 3200.
 */
void
do_open_chooser_script(Panel_item item, Event *event)
{
    struct stat *stat_info;
    dumptool_base_objects *ip = (dumptool_base_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
    extern void do_open_chooser_path_update(void);
    extern void do_save_chooser_path_update(void);
    extern void do_saveas_chooser_path_update(void);

    /* Allocate memory for the  stat_info structure. */
    stat_info = (struct stat *)malloc(sizeof(struct stat));

    /* Main frame goes busy */    
    (void)dumptool_frame_busy_true();

    /* Update FILE_CHOOSER list anyway... */
    xv_set(Dumptool_base_extra->open_chooser, FILE_CHOOSER_UPDATE, NULL);

    /* Make sure a file name was specified... */
    if ((int)strcmp((char *)xv_get(Dumptool_base->script_filename, PANEL_VALUE), EMPTY_STRING) == 0)
    {
	xv_set(Dumptool_base_extra->open_chooser, XV_SHOW, TRUE, NULL);
    } else {
        /* If filename exists and is a file... */
        if ( ((int)stat((char *)xv_get(Dumptool_base->script_filename, PANEL_VALUE), stat_info) == 0) &&
	(int)((stat_info->st_mode & S_IFMT) == S_IFREG) ) {

           /* Copy file name to 'Save' and 'SaveAs' FILE_CHOOSER */
	   do_save_chooser_path_update();
	   do_saveas_chooser_path_update();

           /* Now for our own procedure that loads data into the screen */
           (void)load_script();
           (void)dumptool_frame_busy_false();
	
        } else {
	    /* If we have a directory in the GUI, please the user by changing to that directory.. :) */
	    if ((int)(stat_info->st_mode & S_IFMT) == S_IFDIR) {
		xv_set(Dumptool_base_extra->open_chooser,
		    FILE_CHOOSER_DIRECTORY,
		    (char *)xv_get(Dumptool_base->script_filename, PANEL_VALUE),
		    NULL);
	    }
	        
	    xv_set(Dumptool_base_extra->open_chooser, XV_SHOW, TRUE, NULL);

       }
    }

}

/*
 * Notify callback function for `save_script_button'.
 * This is invoked everytime the "Save" button is pressed and XV_VERSION_NUMBER >= 3200.
 */
void
do_save_chooser_script(Panel_item item, Event *event)
{
    struct stat *stat_info;
    dumptool_base_objects *ip = (dumptool_base_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
    extern void do_open_chooser_path_update(void);
    extern void do_save_chooser_path_update(void);
    extern void do_saveas_chooser_path_update(void);
    
    /* Allocate memory for the  stat_info structure. */
    stat_info = (struct stat *)malloc(sizeof(struct stat));

    /* Main frame goes busy */    
    (void)dumptool_frame_busy_true();

    /* Update FILE_CHOOSER list anyway... */
    xv_set(Dumptool_base_extra->save_chooser, FILE_CHOOSER_UPDATE, NULL);

    /* Make sure a file name was specified. It it already exists, save_script() will deal
    with it...*/
    if ((int)strcmp((char *)xv_get(Dumptool_base->script_filename, PANEL_VALUE), EMPTY_STRING) == 0)
    {
        xv_set(Dumptool_base_extra->save_chooser, XV_SHOW, TRUE, NULL);
    } else {
	/* If filename does not exist or is an existing -file-... */
	if ( ((int)stat((char *)xv_get(Dumptool_base->script_filename, PANEL_VALUE), stat_info) != 0) ||
	(int)((stat_info->st_mode & S_IFMT) == S_IFREG) ) {

	    /* Copy file name to 'Open' and 'SaveAs' FILE_CHOOSER */
	   do_open_chooser_path_update();
	   do_saveas_chooser_path_update();
 
	    /* set the frame as busy and call our save function */
	    (void)save_script();
	    (void)dumptool_frame_busy_false();

	} else {
	    /* If we have a directory in the GUI, please the user by changing to that directory.. :) */
	    if ((int)(stat_info->st_mode & S_IFMT) == S_IFDIR) {
		xv_set(Dumptool_base_extra->save_chooser,
		    FILE_CHOOSER_DIRECTORY,
		    (char *)xv_get(Dumptool_base->script_filename, PANEL_VALUE),
		    NULL);
	    }
	        
	    xv_set(Dumptool_base_extra->save_chooser, XV_SHOW, TRUE, NULL);

       }
    }    
}

/*
 * Notify callback function for `saveas_script_button'.
 * This is invoked everytime the "Saveas" GUI appears and XV_VERSION_NUMBER >= 3200.
 */
void
do_saveas_chooser_script(Panel_item item, Event *event)
{
    struct stat *stat_info;
    dumptool_base_objects *ip = (dumptool_base_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
    extern void do_open_chooser_path_update(void);
    extern void do_save_chooser_path_update(void);
    extern void do_saveas_chooser_path_update(void);

    /* Force appearance of chooser...*/
    xv_set(Dumptool_base_extra->saveas_chooser, XV_SHOW, TRUE, NULL);

    /* Update FILE_CHOOSER list anyway... */
    xv_set(Dumptool_base_extra->saveas_chooser, FILE_CHOOSER_UPDATE, NULL);

    /* Allocate memory for the  stat_info structure. */
    stat_info = (struct stat *)malloc(sizeof(struct stat));

    /* Main frame goes busy */    
    (void)dumptool_frame_busy_true();

    /* Make sure a file name was specified. It it already exists, save_script() will deal
    with it...*/
    if ((int)strcmp((char *)xv_get(Dumptool_base->script_filename, PANEL_VALUE), EMPTY_STRING) == 0)
    {
        xv_set(Dumptool_base_extra->saveas_chooser, XV_SHOW, TRUE, NULL);
    } else {
	/* If filename does not exist or is an existing -file-... */
	if ( ((int)stat((char *)xv_get(Dumptool_base->script_filename, PANEL_VALUE), stat_info) != 0) ||
	(int)((stat_info->st_mode & S_IFMT) == S_IFREG) ) {

	    /* Copy file name to 'Open' and 'Save' FILE_CHOOSER */
	   do_open_chooser_path_update();
	   do_save_chooser_path_update();
  
	    /* set the frame as busy and call our save function */
	    (void)save_script();

	    (void)dumptool_frame_busy_false();
	} else {
	    /* If we have a directory in the GUI, please the user by changing to that directory.. :) */
	    if ((int)(stat_info->st_mode & S_IFMT) == S_IFDIR) {
		xv_set(Dumptool_base_extra->saveas_chooser,
		    FILE_CHOOSER_DIRECTORY,
		    (char *)xv_get(Dumptool_base->script_filename, PANEL_VALUE),
		    NULL);
	    }
	        
	    xv_set(Dumptool_base_extra->saveas_chooser, XV_SHOW, TRUE, NULL);

       }
    }    
}
/*
 * Picked the 'Load script' button
 */
int
dumptool_open_chooser_callback(File_chooser fc, char *path, char *file, Xv_opaque client_data )
{
    /* dumptool_base_extra_objects *ui = (dumptool_base_extra_objects *)xv_get(fc, XV_KEY_DATA, EXTRA_INSTANCE); */
    char buf[256] = "";

    (void)dumptool_frame_busy_true();

    xv_set(Dumptool_base->script_filename,
	   PANEL_VALUE, path,
	   NULL);

    /* Set current doc name on the Save and Saveas popups and script_filename PANEL. */
    xv_set(Dumptool_base->script_filename, PANEL_VALUE, path);
    xv_set(Dumptool_base_extra->save_chooser, FILE_CHOOSER_DOC_NAME, file, NULL);
    (void) sprintf(buf, "%s.1", path);
    xv_set(Dumptool_base_extra->saveas_chooser, FILE_CHOOSER_DOC_NAME, buf, NULL);

    /* Set current PATH on the Save and Saveas popups. */
    (void) sprintf(buf,"%s", (char*)xv_get(
	    xv_get(Dumptool_base_extra->open_chooser,FILE_CHOOSER_CHILD,FILE_CHOOSER_CURRENT_FOLDER_CHILD,NULL),
		PANEL_VALUE,
		NULL) );
    xv_set(Dumptool_base_extra->save_chooser,FILE_CHOOSER_DIRECTORY,buf,NULL);
    xv_set(Dumptool_base_extra->saveas_chooser,FILE_CHOOSER_DIRECTORY,buf,NULL);
 
    /* Dismiss window before any further work.. */
    xv_set(fc,XV_SHOW,FALSE,NULL);

    /* Update FILE_CHOOSER list anyway... */
    xv_set(fc, FILE_CHOOSER_UPDATE, NULL);

    /* Now for our own procedure that loads data into the screen */
    (void)load_script();

    (void)dumptool_frame_busy_false();

    return XV_OK;
}

/*
 * Picked the 'Save script' button
 */
int
dumptool_save_chooser_callback( File_chooser fc, char *path, struct stat *stats )
{
    /* dumptool_base_extra_objects *ui = (dumptool_base_extra_objects *)xv_get(fc, XV_KEY_DATA, EXTRA_INSTANCE); */
    char buf[256] = "";
    char file[256] = "";
    unsigned success;

    (void)dumptool_frame_busy_true();

    /* created a new file, update the list */
    /* if ( !stats ) */

    /* Set current doc name on the Open and Saveas popups and script_filename PANEL. */
    (void) sprintf(file, "%s",(char*)xv_get(Dumptool_base_extra->save_chooser, FILE_CHOOSER_DOC_NAME, NULL) );
    xv_set(Dumptool_base->script_filename, PANEL_VALUE, path);
    xv_set(Dumptool_base_extra->open_chooser, FILE_CHOOSER_DOC_NAME, file, NULL);
    (void) sprintf(buf, "%s.1", file);
    xv_set(Dumptool_base_extra->saveas_chooser, FILE_CHOOSER_DOC_NAME, buf, NULL);

    /* Set current PATH on the Open and Saveas popups. */
    (void) sprintf(buf,"%s", (char*)xv_get(
	    xv_get(Dumptool_base_extra->save_chooser,FILE_CHOOSER_CHILD,FILE_CHOOSER_CURRENT_FOLDER_CHILD,NULL),
		PANEL_VALUE,
		NULL) );
    xv_set(Dumptool_base_extra->open_chooser,FILE_CHOOSER_DIRECTORY,buf,NULL);
    xv_set(Dumptool_base_extra->saveas_chooser,FILE_CHOOSER_DIRECTORY,buf,NULL);

    /* Dismiss window before any further work.. */
    xv_set(fc,XV_SHOW,FALSE,NULL);

    /* Update FILE_CHOOSER list anyway... */
    xv_set(fc, FILE_CHOOSER_UPDATE, NULL);

    /* set the frame as busy and call our save function */
    (void)save_script();

    (void)dumptool_frame_busy_false();

    return XV_OK;
}

/*
 * Copy PATH and FILE to 'Open' FILE CHOOSER for easier interface management.
 */
void
do_open_chooser_path_update(void)
{
    char scratch[256];    /* scratchpad */

    (void)strcpy(scratch, (char *)xv_get(Dumptool_base->script_filename, PANEL_VALUE));
        xv_set(Dumptool_base_extra->open_chooser,
            FILE_CHOOSER_DOC_NAME, dumptool_basename(scratch),
            NULL);
    (void)strcpy(scratch, (char *)xv_get(Dumptool_base->script_filename, PANEL_VALUE));
        xv_set(Dumptool_base_extra->open_chooser,
            FILE_CHOOSER_DIRECTORY, dumptool_dirname(scratch),
            NULL);
}

/*
 * Copy PATH and FILE to 'Save' FILE CHOOSER from script_filename
 * for easier interface management.
 */
void
do_save_chooser_path_update(void)
{
    char scratch[256];    /* scratchpad */

    (void)strcpy(scratch, (char *)xv_get(Dumptool_base->script_filename, PANEL_VALUE));
        xv_set(Dumptool_base_extra->save_chooser,
            FILE_CHOOSER_DOC_NAME, dumptool_basename(scratch),
            NULL);
    (void)strcpy(scratch, (char *)xv_get(Dumptool_base->script_filename, PANEL_VALUE));
        xv_set(Dumptool_base_extra->save_chooser,
            FILE_CHOOSER_DIRECTORY, dumptool_dirname(scratch),
            NULL);
}

/*
 * Copy PATH and FILE to 'SaveAs' FILE CHOOSER for easier interface management.
 */
void
do_saveas_chooser_path_update(void)
{
    char scratch[256];    /* scratchpad */

    (void)strcpy(scratch, (char *)xv_get(Dumptool_base->script_filename, PANEL_VALUE));
        xv_set(Dumptool_base_extra->saveas_chooser,
            FILE_CHOOSER_DOC_NAME, dumptool_basename(scratch),
            NULL);
    (void)strcpy(scratch, (char *)xv_get(Dumptool_base->script_filename, PANEL_VALUE));
        xv_set(Dumptool_base_extra->saveas_chooser,
            FILE_CHOOSER_DIRECTORY, dumptool_dirname(scratch),
            NULL);
}

/*
 * Notify proc to let us unfreeze the main frame if the user chooses to cancel
 * the FILE_CHOOSER frame....
 */
void
chooser_cancel_proc(Panel_item item, Event *event)
{
	(void)dumptool_frame_busy_false();
}

/*
 * Notify proc to let us unfreeze the main frame if the user chooses to destroy
 * the FILE_CHOOSER frame....
 */
void
chooser_destroy_proc(Frame frame)
{
	/* Sub Frame must be manually destroyed/hidden */
	xv_set (frame, XV_SHOW, FALSE, NULL);
	(void)dumptool_frame_busy_false();
}

#endif /* XV_VERSION_NUMBER */
