;GIL-3
(
(
	:type                   :menu
	:name                   disk_list
	:help                   ""
	:columns                1
	:menu-type              :command
	:menu-handler           nil
	:menu-title             ""
	:menu-item-labels       ("artecon: /dev/rsd0a" )
	:menu-item-label-types  (:string )
	:menu-item-states       (:active )
	:menu-item-defaults     (nil )
	:initial-selections     (nil )
	:menu-item-handlers     (nil )
	:menu-item-menus        (nil )
	:menu-item-colors       ("" )
	:pinnable               t
	:user-data              ()
	:actions                ()
)
(
	:type                   :base-window
	:name                   base
	:owner                  nil
	:width                  658
	:height                 589
	:background-color       ""
	:foreground-color       ""
	:label                  "DumpTool : Artecon's Dump Utility"
	:label-type             :string
	:initial-state          :open
	:show-footer            t
	:resizable              nil
	:icon-file              "dumptool.icon"
	:icon-label             ""
	:icon-mask-file         "dumptool_mask.icon"
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   main_control_area
	:owner                  base
	:help                   "This is the DumpTool main control area.  Place
the mouse pointer over any object and press the
<Help> or <F1> key."
	:x                      0
	:y                      0
	:width                  658
	:height                 589
	:background-color       "BG1"
	:foreground-color       "Black"
	:initial-state          :visible
	:show-border            nil
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   dump_schedule_title
	:owner                  main_control_area
	:help                   "Set up your DumpTool schedule parameters below."
	:x                      136
	:y                      14
	:width                  107
	:height                 13
	:foreground-color       "Black"
	:label                  "Dump Schedule"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   script_filename
	:owner                  main_control_area
	:help                   "INPUT the name of the Backup Script file.  The 
file will be created if it does not already exist.

The is the script (program) that gets executed
at the scheduled time."
	:x                      405
	:y                      14
	:width                  232
	:height                 32
	:value-x                405
	:value-y                31
	:value-length           29
	:stored-length          256
	:rows                   3
	:foreground-color       "Black"
	:text-type              :alphanumeric
	:label                  "Backup Script Filename:"
	:label-type             :string
	:layout-type            :vertical
	:value-underlined       t
	:initial-value          ""
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :setting
	:name                   daily_check_box
	:owner                  main_control_area
	:help                   "Click SELECT in this box if you would like the 
backup to occur each day of the week."
	:x                      84
	:y                      40
	:width                  62
	:height                 23
	:value-x                128
	:value-y                40
	:rows                   1
	:columns                0
	:layout-type            :horizontal
	:foreground-color       ""
	:setting-type           :check
	:selection-required     t
	:label                  "Daily"
	:label-type             :string
	:notify-handler         do_daily
	:event-handler          nil
	:choices                ("" )
	:choice-label-types     (:string )
	:choice-colors          ("" )
	:initial-selections     (t )
	:initial-state          :active
	:user-data              ()
	:actions                (
		(
		:from                   (base daily_check_box)
		:when                   (Notify )
		:to                     (base daily_check_box)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (do_daily)
		)
	)
)
(
	:type                   :text-field
	:name                   daily_time
	:owner                  main_control_area
	:help                   "INPUT the time that the backup is to occur on 
each selected day.

Use a 24-hour clock format.

Examples:  2115   (9:15 PM)
           0830   (8:30 AM)
           1200   (12:00 Noon)
           0000   (12:00 Midnight)"
	:x                      220
	:y                      44
	:width                  94
	:height                 15
	:value-x                266
	:value-y                44
	:value-length           4
	:stored-length          4
	:rows                   3
	:foreground-color       "Black"
	:text-type              :alphanumeric
	:label                  "Time:"
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          "2200"
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   load_script_button
	:owner                  main_control_area
	:help                   "Click SELECT on this button to load the specified 
Backup Script."
	:x                      423
	:y                      57
	:width                  85
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "Load Script"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         do_load_script
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (base load_script_button)
		:when                   (Notify )
		:to                     (base load_script_button)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (do_load_script)
		)
	)
)
(
	:type                   :button
	:name                   save_script_button
	:owner                  main_control_area
	:help                   "Click SELECT on this button to save the specified 
Backup Script.

The Save function may take awhile as each input 
field is checked for accuracy.  Please be patient.

After saving the file, you will be asked if you 
would like to schedule the backup job for 
automatic execution (assuming that you have chosen a daily or monthly backup)."
	:x                      537
	:y                      57
	:width                  85
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "Save Script"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         do_save_script
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (base save_script_button)
		:when                   (Notify )
		:to                     (base save_script_button)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (do_save_script)
		)
	)
)
(
	:type                   :setting
	:name                   days_of_week
	:owner                  main_control_area
	:help                   "Click SELECT on each day of the week that you 
would like your backup to occur.

Note: Click SELECT in the \"Daily\" box to select 
every day of the week."
	:x                      20
	:y                      80
	:width                  335
	:height                 23
	:value-x                20
	:value-y                80
	:rows                   1
	:columns                0
	:layout-type            :horizontal
	:foreground-color       "Black"
	:setting-type           :nonexclusive
	:selection-required     t
	:label                  ""
	:label-type             :string
	:notify-handler         do_days_of_week
	:event-handler          nil
	:choices                ("Sun" "Mon" "Tue" "Wed" "Thu" "Fri" "Sat" )
	:choice-label-types     (:string :string :string :string :string :string :string )
	:choice-colors          ("" "" "" "" "" "" "" )
	:initial-selections     (t t t t t t t )
	:initial-state          :active
	:user-data              ()
	:actions                (
		(
		:from                   (base days_of_week)
		:when                   (Notify )
		:to                     (base days_of_week)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (do_days_of_week)
		)
	)
)
(
	:type                   :setting
	:name                   send_mail
	:owner                  main_control_area
	:help                   "Click SELECT in this box if you would like the 
backup job logfile to be mailed to a particular 
user (i.e. the System Administrator)."
	:x                      405
	:y                      120
	:width                  204
	:height                 23
	:value-x                591
	:value-y                120
	:rows                   1
	:columns                0
	:layout-type            :horizontal
	:foreground-color       ""
	:setting-type           :check
	:selection-required     t
	:label                  "Send Mail When Complete"
	:label-type             :string
	:notify-handler         do_send_mail
	:event-handler          nil
	:choices                ("" )
	:choice-label-types     (:string )
	:choice-colors          ("" )
	:initial-selections     (t )
	:initial-state          :active
	:user-data              ()
	:actions                (
		(
		:from                   (base send_mail)
		:when                   (Notify )
		:to                     (base send_mail)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (do_send_mail)
		)
	)
)
(
	:type                   :setting
	:name                   monthly_check_box
	:owner                  main_control_area
	:help                   "Click SELECT in this box if you would like the 
backup to occur once a month."
	:x                      24
	:y                      128
	:width                  82
	:height                 23
	:value-x                88
	:value-y                128
	:rows                   1
	:columns                0
	:layout-type            :horizontal
	:foreground-color       ""
	:setting-type           :check
	:selection-required     t
	:label                  "Monthly"
	:label-type             :string
	:notify-handler         do_monthly
	:event-handler          nil
	:choices                ("" )
	:choice-label-types     (:string )
	:choice-colors          ("" )
	:initial-selections     (nil )
	:initial-state          :active
	:user-data              ()
	:actions                (
		(
		:from                   (base monthly_check_box)
		:when                   (Notify )
		:to                     (base monthly_check_box)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (do_monthly)
		)
	)
)
(
	:type                   :text-field
	:name                   monthly_date
	:owner                  main_control_area
	:help                   "INPUT the date that you would like your monthly
backup to occur.

You may either type in the date or use the arrow 
buttons to set the date.

Note: A date of 28 or less will ensure that the 
backup occurs each month since there is no month 
with less than 28 days."
	:x                      136
	:y                      132
	:width                  93
	:height                 15
	:value-x                178
	:value-y                132
	:value-length           2
	:stored-length          2
	:rows                   3
	:foreground-color       ""
	:text-type              :numeric
	:label                  "Date:"
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:max-value              31
	:min-value              1
	:initial-value          28
	:initial-state          :inactive
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   monthly_time
	:owner                  main_control_area
	:help                   "INPUT the time that the backup is to occur on the
given day each month.  

Use a 24-hour clock format.

Examples:  2115   (9:15 PM)
           0830   (8:30 AM)
           1200   (12:00 Noon)
           0000   (12:00 Midnight)"
	:x                      263
	:y                      132
	:width                  94
	:height                 15
	:value-x                309
	:value-y                132
	:value-length           4
	:stored-length          4
	:rows                   3
	:foreground-color       ""
	:text-type              :alphanumeric
	:label                  "Time:"
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          "2200"
	:initial-state          :inactive
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   mail_to
	:owner                  main_control_area
	:help                   "INPUT the email address of the person to which the logfile should be mailed.

Examples:   root
            root@sparky
            joe@sundown

Note: A copy of the logfile is also placed in the
file /var/spool/dumptool/dumptool.log.MMDDYY
where
    MM = Month
    DD = Day
    YY = Year
that the backup occurred.

It is up to the user to periodically remove these
files in order to reclaim disk space."
	:x                      405
	:y                      156
	:width                  230
	:height                 15
	:value-x                467
	:value-y                156
	:value-length           21
	:stored-length          80
	:rows                   3
	:foreground-color       ""
	:text-type              :alphanumeric
	:label                  "Mail To:"
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          ""
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   schedule_button
	:owner                  main_control_area
	:help                   "Click SELECT on this button to have your backup 
job scheduled for automatic execution using cron."
	:x                      96
	:y                      172
	:width                  73
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Schedule"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         do_schedule
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (base schedule_button)
		:when                   (Notify )
		:to                     (base schedule_button)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (do_schedule)
		)
	)
)
(
	:type                   :button
	:name                   unschedule_button
	:owner                  main_control_area
	:help                   "Click SELECT on this button to have your backup 
job removed from the automatic execution schedule.  
In other words, remove the crontab entry."
	:x                      200
	:y                      172
	:width                  89
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "Unschedule"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         do_unschedule
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (base unschedule_button)
		:when                   (Notify )
		:to                     (base unschedule_button)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (do_unschedule)
		)
	)
)
(
	:type                   :setting
	:name                   dump_local
	:owner                  main_control_area
	:help                   "Click SELECT in this box if you would like the 
backup job logfile to be mailed to a particular 
user (i.e. the System Administrator)."
	:x                      405
	:y                      203
	:width                  192
	:height                 23
	:value-x                579
	:value-y                203
	:rows                   1
	:columns                0
	:layout-type            :horizontal
	:foreground-color       ""
	:setting-type           :check
	:selection-required     t
	:label                  "Dump locally (no RCMD)"
	:label-type             :string
	:notify-handler         do_dump_local
	:event-handler          nil
	:choices                ("" )
	:choice-label-types     (:string )
	:choice-colors          ("" )
	:initial-selections     (nil )
	:initial-state          :active
	:user-data              ()
	:actions                (
		(
		:from                   (base dump_local)
		:when                   (Notify )
		:to                     (base dump_local)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (do_dump_local)
		)
	)
)
(
	:type                   :text-field
	:name                   remote_hostname
	:owner                  main_control_area
	:help                   "INPUT the hostname of the system from which you
wish to retrieve file system entries.

For example, if you would like to backup the
file systems located on machine \"jupiter\", you 
would input the following:

Hostname: jupiter

Then click SELECT on \"Add File System\" to add
jupiter's file systems to the File System List\"."
	:x                      147
	:y                      223
	:width                  224
	:height                 15
	:value-x                227
	:value-y                223
	:value-length           18
	:stored-length          80
	:rows                   3
	:foreground-color       ""
	:text-type              :alphanumeric
	:label                  "Hostname:"
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          ""
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   tape_host
	:owner                  main_control_area
	:help                   "INPUT the name of the machine (hostname) on which 
the tape drive is installed.  All file system
backups will be saved to this machine's tape drive.

Note: The hostname of each system whose 
file systems are being backed up must be added to 
the /.rhosts file on the Tape Host's system.

For example:
If you are backing up the file system
\"sundown:/dev/sd0h /home\" onto a tape drive 
located on host \"sunburn\", then you should add 
\"sundown\" to the /.rhosts file on host \"sunburn\"."
	:x                      405
	:y                      231
	:width                  232
	:height                 15
	:value-x                485
	:value-y                231
	:value-length           19
	:stored-length          80
	:rows                   3
	:foreground-color       ""
	:text-type              :alphanumeric
	:label                  "Tape Host:"
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          ""
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   add_filesystem_button
	:owner                  main_control_area
	:help                   "Click SELECT on this button to retrieve the 
file system entries for any accessible host on 
the network. 

You should first enter a valid hostname in the 
\"Hostname\" field.  After retrieving  the 
file systems of the specified host, dumptool will 
display them in the File System List."
	:x                      19
	:y                      238
	:width                  116
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Add File System"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         do_add_filesystem
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (base add_filesystem_button)
		:when                   (Notify )
		:to                     (base add_filesystem_button)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (do_add_filesystem)
		)
	)
)
(
	:type                   :text-field
	:name                   tape_device
	:owner                  main_control_area
	:help                   "INPUT the tape drive device name.

Examples: (for Solaris 1.X systems.)
/dev/rst0  (First SCSI tape drive - rewind)
/dev/nrst1 (Second SCSI tape drive - no rewind)

Examples: (for Solaris 2.X systems.)
/dev/rmt/0 (First SCSI tape drive - rewind)
/dev/rmt/1n (Second SCSI tape drive - no rewind)

Note: Using the \"rewind\" device will cause the 
tape drive to rewind the tape after EACH dump.  
If you are putting multiple file systems on one 
tape MAKE SURE you specify the \"no rewind\" device."
	:x                      405
	:y                      259
	:width                  231
	:height                 15
	:value-x                500
	:value-y                259
	:value-length           17
	:stored-length          80
	:rows                   3
	:foreground-color       ""
	:text-type              :alphanumeric
	:label                  "Tape Device:"
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          ""
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   remote_mount_point
	:owner                  main_control_area
	:help                   "If you would like to add an entry for a specific 
remote file system, INPUT the file system mount
point here.

For example, if you would like to backup the
/data1 file system located on machine \"jupiter\"
you would input the following:

Hostname: jupiter
Mount Point: /data1

Then click SELECT on \"Add File System\" to add this
file system to the File System List\". "
	:x                      134
	:y                      260
	:width                  237
	:height                 15
	:value-x                227
	:value-y                260
	:value-length           18
	:stored-length          80
	:rows                   3
	:foreground-color       ""
	:text-type              :alphanumeric
	:label                  "Mount Point:"
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          ""
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :setting
	:name                   rcmd_type
	:owner                  main_control_area
	:help                   "Decide wether to use rsh (remsh) or ssh (ssh1)
to contact the remote host. This can be very
useful if you decide that a .rhosts is not allowed
for user root. ssh is more secure but dosen't
come with SunOS or Linux.
"
	:x                      405
	:y                      282
	:width                  231
	:height                 23
	:value-x                491
	:value-y                282
	:rows                   0
	:columns                1
	:layout-type            :horizontal
	:foreground-color       ""
	:setting-type           :stack
	:selection-required     t
	:label                  "RCMD Type"
	:label-type             :string
	:notify-handler         do_rcmd_type
	:event-handler          nil
	:choices                ("rsh (/usr/bin/rsh)" "ssh (/usr/bin/ssh)" )
	:choice-label-types     (:string :string )
	:choice-colors          ("" "" )
	:choice-defaults        (nil t )
	:initial-selections     (nil nil )
	:initial-state          :active
	:user-data              ()
	:actions                (
		(
		:from                   (base rcmd_type)
		:when                   (Notify )
		:to                     (base rcmd_type)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (do_rcmd_type)
		)
	)
)
(
	:type                   :scrolling-list
	:name                   filesystem_list
	:owner                  main_control_area
	:help                   "This is the list of all file systems, local and 
remote, that will be backed up.  By default, all 
the local file systems are listed when dumptool 
is invoked.

Note: The hostname of the local system must be 
added to the /.rhosts file of each remote system
whose file systems are included here.  Also, the 
local hostname must be added to the /.rhosts file 
on the local system."
	:x                      20
	:y                      290
	:width                  345
	:height                 253
	:value-x                20
	:value-y                307
	:rows                   12
	:foreground-color       "Black"
	:label                  "File System List:"
	:title                  ""
	:label-type             :string
	:layout-type            :vertical
	:read-only              t
	:multiple-selections    t
	:selection-required     nil
	:initial-state          :active
	:droppable              nil
	:default-drop-site      nil
	:menu                   nil
	:notify-handler         nil
	:event-handler          nil
	:initial-list-values    ()
	:initial-list-glyphs    ()
	:initial-selections     ()
	:user-data              ()
	:actions                ()
)
(
	:type                   :setting
	:name                   tape_type
	:owner                  main_control_area
	:help                   "Use the pulldown menu to SELECT the type of tape 
drive to be used for backups.  The default size, 
density and blocking factor will be shown.

Supported Tape Drives:  
Exabyte 8200 (8mm-2.3GB-Full height)
Exabyte 8205 (8mm-5GB/compressed-Half height)
Exabyte 8500 (8mm-5GB-Full height)
Exabyte 8500c (8mm-10GB/compressed-Full height)
Exabyte 8505 (8mm-10GB/compressed-Half height)
4mm (DAT)
1/2\" 1600 BPI
1/2\" 6250 BPI
QIC 24
QIC 150
QIC 525
QIC 1000
QIC 1350
QIC 2100C"
	:x                      405
	:y                      330
	:width                  206
	:height                 23
	:value-x                485
	:value-y                330
	:rows                   0
	:columns                1
	:layout-type            :horizontal
	:foreground-color       ""
	:setting-type           :stack
	:selection-required     t
	:label                  "Tape Type"
	:label-type             :string
	:notify-handler         do_tape_type
	:event-handler          nil
	:choices                ("Exabyte 8200" "Exabyte 8205" "Exabyte 8500" "Exabyte 8500c" "Exabyte 8505" "4mm (DAT)" "4mm (DDS3)" "4mm (DDS4)" "QIC 24" "QIC 150" "QIC 525" "QIC 1000" "QIC 1350" "QIC 2100C" "DLT4000" "DLT7000" "DLT8000" )
	:choice-label-types     (:string :string :string :string :string :string :string :string :string :string :string :string :string :string :string :string :string )
	:choice-colors          ("" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" )
	:choice-defaults        (nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil )
	:initial-selections     (nil nil t nil nil nil nil nil nil nil nil nil nil nil nil nil nil )
	:initial-state          :active
	:user-data              ()
	:actions                (
		(
		:from                   (base tape_type)
		:when                   (Notify )
		:to                     (base tape_type)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (do_tape_type)
		)
	)
)
(
	:type                   :text-field
	:name                   tape_size
	:owner                  main_control_area
	:help                   "INPUT the tape length (in feet).  This number is
usually not the true length of the tape.  The 
combination of Tape Size and Tape Density is
used to determine how much data will fit on one
tape.

A default size is given for the chosen tape drive 
type.  Our tests have shown this number to work 
well with the chosen tape drive.

You may change the size by typing in a new number 
or by using the arrows to set the desired number."
	:x                      423
	:y                      363
	:width                  200
	:height                 15
	:value-x                500
	:value-y                363
	:value-length           11
	:stored-length          80
	:rows                   3
	:foreground-color       ""
	:text-type              :numeric
	:label                  "Tape Size:"
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:max-value              400000
	:min-value              0
	:initial-value          23000
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   tape_density
	:owner                  main_control_area
	:help                   "INPUT the tape density (in bits per inch).  This 
number is usually not the true density of the 
tape.  The combination of Tape Density and Tape 
Size is used to determine how much data will fit 
on one tape.

A default density is given for the chosen tape 
drive type.  Our tests have shown this number to 
work well with the chosen tape drive.

You may change the density by typing in a new
number or by using the arrows to set the desired 
value."
	:x                      423
	:y                      388
	:width                  201
	:height                 15
	:value-x                525
	:value-y                388
	:value-length           8
	:stored-length          80
	:rows                   3
	:foreground-color       ""
	:text-type              :numeric
	:label                  "Tape Density:"
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:max-value              100000
	:min-value              0
	:initial-value          28633
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   blocking_factor
	:owner                  main_control_area
	:help                   "Input the tape blocking factor.  This is the 
number of 512 byte blocks that are sent to the
Tape Device during each write.

A default blocking factor is given for the chosen 
tape drive type.  Our tests have shown this number
to work well with the chosen tape drive.

You may change the blocking factor by typing in a 
new number or by using the arrows to set the
desired value."
	:x                      423
	:y                      413
	:width                  202
	:height                 15
	:value-x                542
	:value-y                413
	:value-length           6
	:stored-length          6
	:rows                   3
	:foreground-color       ""
	:text-type              :numeric
	:label                  "Blocking Factor: "
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:max-value              512
	:min-value              20
	:initial-value          126
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   dump_level
	:owner                  main_control_area
	:help                   "INPUT the \"dump level\" for this backup job.
 
All files in the file system that have been 
modified since the last dump at a lower dump level
are backed up.  For instance, if you  did  a 
\"level 2\" dump on Monday, followed by a \"level 4\"
dump on Tuesday, a subsequent \"level 3\" dump on
Wednesday would  contain  all  files  modified or 
added since the \"level 2\" (Monday) backup.  A 
\"level 0\" dump copies the entire file system to 
the Tape Drive. 

You may either type in the dump level or use the
arrow buttons to set the correct value."
	:x                      405
	:y                      480
	:width                  164
	:height                 15
	:value-x                498
	:value-y                480
	:value-length           1
	:stored-length          2
	:rows                   3
	:foreground-color       ""
	:text-type              :numeric
	:label                  "Dump Level:"
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:max-value              9
	:min-value              0
	:initial-value          0
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :setting
	:name                   update_dumpdates
	:owner                  main_control_area
	:help                   "Click SELECT in this box to add an entry to the
/etc/dumpdates file for each file system 
successfully backed up.  This entry includes the 
file system name, date, and dump level.

"
	:x                      405
	:y                      508
	:width                  156
	:height                 23
	:value-x                543
	:value-y                508
	:rows                   1
	:columns                0
	:layout-type            :horizontal
	:foreground-color       ""
	:setting-type           :check
	:selection-required     t
	:label                  "Update Dumpdates"
	:label-type             :string
	:notify-handler         do_update_dumpdates
	:event-handler          nil
	:choices                ("" )
	:choice-label-types     (:string )
	:choice-colors          ("" )
	:initial-selections     (nil )
	:initial-state          :active
	:user-data              ()
	:actions                (
		(
		:from                   (base update_dumpdates)
		:when                   (Notify )
		:to                     (base update_dumpdates)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (do_update_dumpdates)
		)
	)
)
(
	:type                   :setting
	:name                   unload_tape
	:owner                  main_control_area
	:help                   "Click SELECT on this box to make the tape go 
offline at the end of the backup job.

Different tape drives react differently to the 
offline command.  The 8mm and 4mm drives will 
rewind and eject the tape.  The 1/2\" drives will 
rewind and unload the tape.  The QIC drives will  
be placed in a state such that the tape cannot be 
accessed."
	:x                      405
	:y                      539
	:width                  193
	:height                 23
	:value-x                580
	:value-y                539
	:rows                   1
	:columns                0
	:layout-type            :horizontal
	:foreground-color       ""
	:setting-type           :check
	:selection-required     t
	:label                  "Unload Tape When Done"
	:label-type             :string
	:notify-handler         nil
	:event-handler          nil
	:choices                ("" )
	:choice-label-types     (:string )
	:choice-colors          ("" )
	:initial-selections     (nil )
	:initial-state          :active
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   delete_filesystem
	:owner                  main_control_area
	:help                   "Click SELECT on this button to delete one or more 
entries from the File System List.

You must first SELECT one or more file systems in 
the File System List."
	:x                      128
	:y                      554
	:width                  131
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Delete File System"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         do_delete_filesystem
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (base delete_filesystem)
		:when                   (Notify )
		:to                     (base delete_filesystem)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (do_delete_filesystem)
		)
	)
)
)
