h10615
s 00001/00001/01774
d D 1.6 96/05/21 15:38:36 root 9 5
c Fixed the problem caused by misusing dirname.  Ken X.
e
s 00001/00002/01776
d R 1.8 96/05/21 12:41:28 root 8 7
c 
e
s 00001/00001/01777
d R 1.7 96/05/21 11:39:45 root 7 6
c 
e
s 00004/00001/01774
d R 1.6 96/05/21 11:01:49 root 6 5
c Fixed dirname returnnig . problem.  Ken X.
e
s 00002/00001/01773
d D 1.5 96/05/16 10:13:35 root 5 4
c Do not append "c" option to DLT2000xt.  Ken X.
e
s 00003/00003/01771
d D 1.4 96/05/13 11:10:17 root 4 3
c Do not append "c: option for Mammoth. Ken X.
e
s 00005/00001/01769
d D 1.3 96/05/03 09:34:34 root 3 2
c Do not append "c" option for DLT4000(it uses variable length).
e
s 00000/00000/01770
d D 1.2 96/04/03 14:46:56 cho 2 1
c 
e
s 01770/00000/00000
d D 1.1 93/02/26 16:23:33 stepkirk 1 0
c date and time created 93/02/26 16:23:33 by stepkirk
e
u
U
f e 0
t
T
I 1
D 4
static char SccsId[ ] = "%W%    %G%";
E 4
I 4
static char SccsId[ ] = "@(#)dumptool.c	1.2    04/03/96";
E 4

/*
 * dumptool.c - Contains main() for project dumptool
 * This file was generated by `gxv'.
 * Application specific code added by Dax Murthy :: Artecon, Inc.
 * Modifications made by Stephen E. Kirkpatrick :: Artecon, Inc.
 */


#include <stdio.h>
#include <sys/param.h>
#include <sys/types.h>
#include <unistd.h>
#include <libgen.h>
#include <sys/systeminfo.h>
#include <sys/stat.h>
#include <sys/mntent.h>
#include <sys/mnttab.h>
#include <sys/socket.h>
#include <netdb.h>
#include <xview/xview.h>
#include <xview/panel.h>
#include <xview/textsw.h>
#include <xview/xv_xrect.h>
#include <xview/notice.h>
#include "dumptool.h"
#include "global.h"
#include "file_data.h"
#include "dumptool_ui.h"

/*
 * function prototypes
 */
void multi_generic_notifier(char *msg1, char *msg2, char *msg3, char *msg4);
void generic_notifier(char *msg);
void schedule_backup();
void unschedule_backup();
int check_for_errors();
int valid_time_format(char *time);
void get_local_filesystems();
void save_script();
void write_commands();
void load_script();
void strip_string(char *str);
void clean_up(char *line);
void create_cron_entry();
int yes_or_no(char *msg);
int multi_yes_or_no(char *msg1, char *msg2, char *msg3, char *msg4);
void get_remote_filesystems();
int check_host_availability(char *hostname);
int get_remote_host_release(char *remote_hostname);

/*
 * Global variables
 */
static int saved_once = FALSE;       /* file has not been saved even once */
static char local_hostname[256];     /* Hostname of local machine */
static int local_host_release;       /* O.S. Release number of the local machine */
static int tape_host_release;        /* O.S. Release number of the tape_host machine */

/*
 * External variable declarations.
 */
dumptool_base_objects    *Dumptool_base;

#ifdef MAIN

/*
 * Instance XV_KEY_DATA key.  An instance is a set of related
 * user interface objects.  A pointer to an object's instance
 * is stored under this key in every object.  This must be a
 * global variable.
 */
Attr_attribute    INSTANCE;

/*
 * main for project dumptool
 */
void
main(int argc, char **argv)
{
    char scratch[128];    /* scratchpad */

    /*
     * Get the local hostname and OS release.
     */
    (void)sysinfo(SI_HOSTNAME, local_hostname, sizeof(local_hostname));
    (void)sysinfo(SI_RELEASE, scratch, sizeof(scratch));
    local_host_release = (int)atoi(scratch);

    /*
     * Initialize XView.
     */
    xv_init(XV_INIT_ARGC_PTR_ARGV, &argc, argv, NULL);
    INSTANCE = xv_unique_key();
    
    /*
     * Initialize user interface components.
     * Do NOT edit the object initializations by hand.
     */
    Dumptool_base = dumptool_base_objects_initialize(NULL, NULL);

    /* "Mail To" defaults to user at local system */
    (void)sprintf(scratch,"%s@%s", (char *)cuserid(NULL), local_hostname);
    (void)xv_set(Dumptool_base->mail_to, PANEL_VALUE, scratch, NULL);

    /* Set the default tape device */
    (void)xv_set(Dumptool_base->tape_device, PANEL_VALUE, DEFAULT_TAPE_DEVICE, NULL);
    /* tape_host defaults to local_hostname */
    (void)xv_set(Dumptool_base->tape_host, PANEL_VALUE, local_hostname, NULL);
 
    /* get the local host's file systems */
    (void)get_local_filesystems();
    
    /*
     * Turn control over to XView.
     */
    xv_main_loop(Dumptool_base->base);
    exit(0);
}

#endif

/*
 * DumpTool functions.
 */

/*
 * Function multi_generic_notifier()
 * Display a NOTICE with up to four character strings.
 *
 * Arguments -- Four character strings: for four messages to be displayed.
 * Returns   -- none
 */
void
multi_generic_notifier(char *msg1, char *msg2, char *msg3, char *msg4)
{
    Xv_notice notice; 
    int notice_status; 
 
    notice = (Xv_notice)xv_create(Dumptool_base->base, NOTICE, 
        NOTICE_MESSAGE_STRINGS, 
            msg1, 
            msg2, 
            msg3, 
            msg4, 
        NULL,  
        NOTICE_BUTTON_YES, "OK", 
        NOTICE_STATUS, &notice_status, 
        XV_SHOW, TRUE,    
        NULL); 
 
    switch (notice_status) 
    {   
        case NOTICE_YES: 
            return;
    } 
    (void)xv_destroy_safe(notice);
}


/*
 * Function generic_notifier()
 * Display a NOTICE with the specified message.
 *
 * Arguments -- Character string: for the message to be displayed
 * Returns   -- none
 */
void
generic_notifier(char *msg)
{
    Xv_notice notice;
    int notice_status;

    notice = (Xv_notice)xv_create(Dumptool_base->base, NOTICE,
        NOTICE_MESSAGE_STRINGS,
            msg,
        NULL,
        NOTICE_BUTTON_YES, "OK",
        NOTICE_STATUS, &notice_status,
        XV_SHOW, TRUE,
        NULL);

    switch (notice_status)
    {
        case NOTICE_YES:
            return;
    }
    (void)xv_destroy_safe(notice);
}

/* Function schedule_backup()
 * This function checks for any possible invalid entries and then 
 * goes on to call the create_cron_entry function to put this script
 * in the crontab file.
 * Arguments -- none
 * Returns   -- none
 */
void
schedule_backup()
 {
    /* If user tries to schedule even before saving, warn him/her */
    if (saved_once == FALSE)
    {
        (void)generic_notifier("Please Save Script before scheduling.");
        return;
    }

    /* If no day is selected and the Monthly box is not checked... */
    if (((int)xv_get(Dumptool_base->days_of_week, PANEL_VALUE) == 0) &&
        ((int)xv_get(Dumptool_base->monthly_check_box, PANEL_VALUE) == 0))
    {
        (void)multi_generic_notifier(
            "You must first select either a daily or",
            "Monthly backup before this Backup Script",
            "can be scheduled for automatic execution.",
            "");
        return;
    }

    /* Check all GUI fields for input errors. */
    if ((int)check_for_errors() != 0)
    {
        /* clear the frame footer */
        (void)xv_set(Dumptool_base->base, FRAME_LEFT_FOOTER, "", NULL);
        return;
    }

    /* Remove cronttab entry if present, and re-schedule this */
    (void)xv_set(Dumptool_base->base, FRAME_LEFT_FOOTER, "", NULL);
    (void)create_cron_entry();
 }


/* Function unschedule_backup()
 * This function removes an entry from the "crontab" file
 * thus unscheduling the specified backup script.
 *
 * Arguments -- none
 * Returns   -- none
 */
void
unschedule_backup()
{
    char command[256];
    char temp_file[L_tmpnam];

    /* Make sure an entry exists for the current Backup Script. */
    (void)sprintf(command, "/usr/bin/crontab -l | /usr/bin/grep %s > /dev/null", 
            (char *)xv_get(Dumptool_base->script_filename, PANEL_VALUE));
    if ((int)system(command) != 0)
    {
        (void)generic_notifier("This Backup Script is not currently scheduled.");
        (void)xv_set(Dumptool_base->base, FRAME_LEFT_FOOTER, "", NULL);
        return;
    }

    /* make sure this is what the user really wants */
    if ((int)yes_or_no("Are you sure you want to unschedule this Backup Script?") == NO) 
        return;

    /* Generate a temporary filename. */
    (void)tmpnam(temp_file);

    /* Make a copy of the crontab file without this entry */
    (void)sprintf(command, "/usr/bin/crontab -l | /usr/bin/grep -v %s > %s", 
                  (char *)xv_get(Dumptool_base->script_filename, PANEL_VALUE), temp_file);
    (void)system(command);

    /* Make it the new crontab file. */
    (void)sprintf(command, "/usr/bin/crontab %s", temp_file); 
    (void)system(command); 

    /* Remove the temporary file. */
    (void)unlink(temp_file);

    (void)xv_set(Dumptool_base->base, FRAME_LEFT_FOOTER, "Backup Script Unscheduled.", NULL);
}

    
/*
 * Check each GUI field for input errors.
 *
 * Arguments -- none
 * Returns   -- FALSE if no errors are found
 *              TRUE if errors are encountered
 */
int
check_for_errors()
{
    char error_msg[80];
    char tape_device[32];

    /* If one or more days of the week have been selected... */ 
    if ((int)xv_get(Dumptool_base->days_of_week, PANEL_VALUE) > 0)
    {
        /* Make sure something has been entered in the time field. */
        if ((int)strcmp((char *)xv_get(Dumptool_base->daily_time, PANEL_VALUE), EMPTY_STRING) == 0)
        {
            (void)generic_notifier("Please specify the Daily Time.");
            return(TRUE);
        }

        /* Make sure the time is valid. */
        if (!(int)valid_time_format((char *)xv_get(Dumptool_base->daily_time, PANEL_VALUE)))
        {
            (void)multi_generic_notifier(
                "Invalid Daily Time format.",
                "Use 24-hour clock format.",
                "Min: 0000   Max: 2359",
                "Example: 2130 (backup starts at 9:30 pm.)");
            return(TRUE);
        }
    }

    /* If the Monthly box is checked... */
    if ((int)xv_get(Dumptool_base->monthly_check_box, PANEL_VALUE) == 1)
    {
        if ((int)xv_get(Dumptool_base->monthly_date, PANEL_VALUE) > 28)
        {
            (void)multi_generic_notifier(
                "Warning: You have chosen a Monthly backup Date",
                "that does not occur every month of the year.",
                "Choosing a date between the 1st and 28th",
                "will assure you of a backup every month.");
        }

        /* Make sure the Monthly Time is also entered. */
        if ((int)strcmp((char *)xv_get(Dumptool_base->monthly_time, PANEL_VALUE), EMPTY_STRING) == 0)
        {
            (void)generic_notifier("Please specify a Monthly Time when the backup should occur.");
            return(TRUE);
        }
    
        /* Make sure the Monthly Time has the right format */
        if (!(int)valid_time_format((char *)xv_get(Dumptool_base->monthly_time, PANEL_VALUE)))
        {
            (void)multi_generic_notifier(
                "Invalid Monthly Time format",
                "Use 24-hour clock format.",
                "Min: 0000   Max: 2359",
                "Example: 2130 (backup starts at 9:30 pm.)");
            return(TRUE);
        }
    }

    /* If send_mail box is checked... */
    if ((int)xv_get(Dumptool_base->send_mail,PANEL_VALUE) == 1)
    {
        /* If no mail address has been specified. */
        if ((int)strcmp((char *)xv_get(Dumptool_base->mail_to, PANEL_VALUE), EMPTY_STRING) == 0)
        {
            (void)generic_notifier("Please enter an email address in the Mail To: field.");
            return(TRUE);
        }
    }

    /* If there are no entries in the File System List... */
    if ((int)xv_get(Dumptool_base->filesystem_list, PANEL_LIST_NROWS) < 1)
    {
        (void)generic_notifier("Please specify one or more File Systems to be backed up.");
        return(TRUE);
    }

    /* Make sure the tape host and tape device are valid */
    (void)xv_set(Dumptool_base->base, FRAME_LEFT_FOOTER, "Validating Tape Host...", NULL);
    /* If Tape Host is not the local host... */
    if ((int)strcmp(local_hostname, (char *)xv_get(Dumptool_base->tape_host, PANEL_VALUE)) != 0)
    {
        if ((int)check_host_availability((char *)xv_get(Dumptool_base->tape_host, PANEL_VALUE)) == 0)
        {
            (void)xv_set(Dumptool_base->base, FRAME_LEFT_FOOTER, "", NULL);
            return(TRUE);
        }
        else
            tape_host_release = (int)get_remote_host_release((char *)xv_get(Dumptool_base->tape_host, PANEL_VALUE));
        (void)xv_set(Dumptool_base->base, FRAME_LEFT_FOOTER, "", NULL);
    }
    else  /* Tape host = local host */
    {
        if ((int)check_host_availability((char *)xv_get(Dumptool_base->tape_host, PANEL_VALUE)) == 0)
        {
            (void)xv_set(Dumptool_base->base, FRAME_LEFT_FOOTER, "", NULL);
            return(TRUE);
        }
        else
            tape_host_release = local_host_release;
        (void)xv_set(Dumptool_base->base, FRAME_LEFT_FOOTER, "", NULL);
    }

    /* Validate Tape Device */
    /* If the Tape Device field is empty... */
    (void)strcpy(tape_device, (char *)xv_get(Dumptool_base->tape_device, PANEL_VALUE));
    if ((int)strcmp(tape_device, EMPTY_STRING) == 0)
    {
        if (tape_host_release == SUNOS_4X)
            (void)strcpy(error_msg, "Example: /dev/rst0");
        else /* SunOS 5.X */
            (void)strcpy(error_msg, "Example: /dev/rmt/0n");

        (void)multi_generic_notifier(
            "Please enter the Tape Device name.",
            "",
            error_msg,
            "");
        return(TRUE);
    }
    /* The Tape Device should have the "no rewind" option specified */
    if (tape_host_release == SUNOS_4X)
    {
        if ((int)strncmp(tape_device, "/dev/n", 6) != 0)
        {
            (void)multi_generic_notifier(
                "Tape Device should have the 'n' (no rewind) option specified.",
                "",
                "Example: /dev/nrst0",
                "");
            return(TRUE);
        }
    }
    else /* SunOS 5.x */
    {
        if (tape_device[(int)strlen(tape_device) - 1] != 'n')
        {
            (void)multi_generic_notifier(
                "Tape Device should have the 'n' (no rewind) option specified.",
                "",
                "Example: /dev/rmt/0n",
                "");
            return(TRUE);
        }
    }

    /* Everything seems to be ok -- return FALSE for success */
    return(FALSE);
} 


/*
 * This function checks to see if the time specified
 * as its argument conforms to 24-hour std format 
 *
 * Arguments -- charac. string: for time value
 * Returns   -- TRUE if valid time format
 *              FALSE if invalid time format
 */
int
valid_time_format(char *time)
{
    /* Make sure we have four characters. */
    if (((int)strlen(time) != 4) || ((int)atoi(time) > 2359))
        return(FALSE);

    if (*time < '0' || *time > '2')  /** Check first digit **/
        return(FALSE);
    time++;
    if (*time < '0' || *time > '9')  /** Check second digit **/
        return(FALSE);
    time++;
    if (*time < '0' || *time > '5')  /** Check third digit **/
        return(FALSE);
    time++;
    if (*time < '0' || *time > '9')  /** Check fourth digit **/
        return(FALSE);

    /* Everything looks OK, return TRUE */
    return(TRUE);
 }

/*
 * Retrieve and display the local file systems.
 */
void
get_local_filesystems()
{
    int list_position = 0;
    struct mnttab *mnttab_entry;
    FILE *mnttab_stream;
    char filesystem_list_entry[100];
    char error_msg[80];
    char error_msg2[80];

    if ((mnttab_stream = (FILE *)fopen(MNTTAB, "r")) == NULL)
    {
        (void)sprintf(error_msg, "Error opening %s.", MNTTAB);
        (void)sprintf(error_msg2, "Check permissions on %s and try again.", MNTTAB);
        (void)multi_generic_notifier(
            error_msg,
            "",
            error_msg2,
            "");
        exit(1);
    }

    /* Allocate memory for the  mnttab_entry structure. */
    mnttab_entry = (struct mnttab *)malloc(sizeof(struct mnttab));

    while ((int)getmntent(mnttab_stream, mnttab_entry) != -1)
    {
        if ((int)strcmp(mnttab_entry->mnt_fstype, MNTTYPE_UFS) == 0)
        {
            (void)strcpy(filesystem_list_entry, local_hostname);
            (void)strcat(filesystem_list_entry, ":");
            (void)strcat(filesystem_list_entry, mnttab_entry->mnt_special);
            (void)strcat(filesystem_list_entry, "   ");
            (void)strcat(filesystem_list_entry, mnttab_entry->mnt_mountp);
            (void)xv_set(Dumptool_base->filesystem_list,
                PANEL_LIST_INSERT, list_position,
                PANEL_LIST_STRING, list_position, filesystem_list_entry,
                NULL);
            list_position++;
        }
    }
}


/*
 * This function writes out the actual backup script 
 * 
 * Arguments -- none
 * Returns   -- none
 */
void
save_script()
{
    FILE *backup_script;
    struct stat *stat_info;
    char error_msg[80];
    int counter;   

    /* If input error found in the GUI fields... */
    if ((int)check_for_errors() != 0)
    {
       (void)xv_set(Dumptool_base->base, FRAME_LEFT_FOOTER, "", NULL);
       return;
    }

    /* Allocate memory for the  stat_info structure. */
    stat_info = (struct stat *)malloc(sizeof(struct stat));

    /* If script_filename already exists... */
    if ((int)stat((char *)xv_get(Dumptool_base->script_filename, PANEL_VALUE), stat_info) == 0)
    {
        (void)sprintf(error_msg, "The file \'%s\' already exists.", 
                      (char *)xv_get(Dumptool_base->script_filename, PANEL_VALUE));
        if ((int)multi_yes_or_no(error_msg, "", "Would you like to overwrite the file?", "") == NO)
            return;
    }

    /* If we can't open script_filename... */
    if ((backup_script = (FILE *)fopen((char *)xv_get(Dumptool_base->script_filename, PANEL_VALUE), "w")) == NULL)
    {
        (void)sprintf(error_msg, "Error opening %s.", (char *)xv_get(Dumptool_base->script_filename, PANEL_VALUE));
        (void)multi_generic_notifier(
            error_msg,
            "",
            "Try a different Backup Script Filename.",
            "");
        return;
    }

    /* Start writing out the comments... */
    (void)fputs("#!/usr/bin/csh -f\n", backup_script);
    (void)fputs("#\n", backup_script);
    (void)fputs("# This file was automatically generated by Artecon's DumpTool.\n", backup_script);
    (void)fputs("# Edit at your own risk.\n", backup_script);
    (void)fputs("#\n", backup_script);

    (void)fputs("#Daily check: ", backup_script);
    (void)fprintf(backup_script, "%d\n", (int)xv_get(Dumptool_base->daily_check_box, PANEL_VALUE));

    /* Make an entry for daily time iff days_of_week is non-zero */
    if ((int)xv_get(Dumptool_base->days_of_week, PANEL_VALUE) > 0)
    {
        (void)fputs("#Daily time: ", backup_script);
        (void)fprintf(backup_script, "%s\n",(char *)xv_get( Dumptool_base->daily_time, PANEL_VALUE));
    }

    (void)fputs("#Days of week: ", backup_script);
    (void)fprintf(backup_script, "%d(0x%x)\n",
        (int)xv_get(Dumptool_base->days_of_week, PANEL_VALUE),
        (int)xv_get(Dumptool_base->days_of_week, PANEL_VALUE));

    /* For each day of the week... */
    for (counter = 0; counter < 7; counter++)
    {
        int today;
   
        /* Enter Selected as 1 and Deselected as 0 */
        today = ((int)(xv_get(Dumptool_base->days_of_week, PANEL_VALUE) & (1 << counter)) != 0);
        (void)fprintf(backup_script, "#%s %d\n", (char *)xv_get(Dumptool_base->days_of_week, PANEL_CHOICE_STRING, counter), today);
    }
   
    (void)fprintf(backup_script, "#Monthly check: %d\n", (int)xv_get(Dumptool_base->monthly_check_box, PANEL_VALUE));

    /* Monthly date and time should be entered only if Monthly box has been checked. */
    if ((int)xv_get(Dumptool_base->monthly_check_box, PANEL_VALUE) == 1)
    {
        (void)fprintf(backup_script, "#Monthly date: %d\n", (int)xv_get(Dumptool_base->monthly_date, PANEL_VALUE));
        (void)fprintf(backup_script, "#Monthly time: %s\n", (char *)xv_get(Dumptool_base->monthly_time, PANEL_VALUE));
    }
   
    (void)fprintf(backup_script, "#Mail check: %d\n", (int)xv_get(Dumptool_base->send_mail, PANEL_VALUE));
   
    /* Make an entry for "Mail to:" only if send_mail is checked */
    if ((int)xv_get(Dumptool_base->send_mail, PANEL_VALUE) == 1)
        (void)fprintf(backup_script, "#Mail to: %s\n", (char *)xv_get(Dumptool_base->mail_to, PANEL_VALUE));
   
    (void)fprintf(backup_script, "#Update dumpdates: %d\n", (int)xv_get(Dumptool_base->update_dumpdates, PANEL_VALUE));
   
    (void)fprintf(backup_script, "#Dump level: %d\n", (int)xv_get(Dumptool_base->dump_level, PANEL_VALUE));
   
    (void)fprintf(backup_script, "#Unload tape: %d\n", (int)xv_get(Dumptool_base->unload_tape, PANEL_VALUE));
   
    (void)fprintf(backup_script, "#Tape host: %s\n", (char *)xv_get(Dumptool_base->tape_host, PANEL_VALUE));
   
    (void)fprintf(backup_script, "#Tape name: %s\n", (char *)xv_get(Dumptool_base->tape_device, PANEL_VALUE));

    (void)fprintf(backup_script, "#Tape type: %d\n", (int)xv_get(Dumptool_base->tape_type, PANEL_VALUE));

    (void)fprintf(backup_script, "#Tape size: %d\n", (int)xv_get(Dumptool_base->tape_size, PANEL_VALUE));

    (void)fprintf(backup_script, "#Tape density: %d\n", (int)xv_get(Dumptool_base->tape_density, PANEL_VALUE));

    (void)fprintf(backup_script, "#Blocking factor: %d\n", (int)xv_get(Dumptool_base->blocking_factor, PANEL_VALUE));

    /* Save the list of file systems to be backed up. */
    (void)fputs("#File list:\n", backup_script);

    /* Print them one by one */
    for (counter = 0; counter< (int)xv_get(Dumptool_base->filesystem_list, PANEL_LIST_NROWS); counter++)
        (void)fprintf(backup_script, "#%s\n", (char *)xv_get(Dumptool_base->filesystem_list, PANEL_LIST_STRING, counter));
   
    (void)fputs("#EOF\n", backup_script);
   
    (void)fclose(backup_script);

    /* That's it for the comments, now for the actual commmands... */
    (void)write_commands();
   
    /* Setup for automatic execution if user so desires. */
    if ((int)yes_or_no("Do you want to schedule the backup for automatic execution?") == YES)
    {
        /* If no day is selected and the Monthly box is not checked... */
        if (((int)xv_get(Dumptool_base->days_of_week, PANEL_VALUE) == 0) &&
            ((int)xv_get(Dumptool_base->monthly_check_box, PANEL_VALUE) == 0))
        {
            (void)multi_generic_notifier(
                "You must first select either a daily or",
                "Monthly backup before this Backup Script",
                "can be scheduled for automatic execution.",
                "");
            return;
        }
        (void)create_cron_entry();
    }
}
   
/*
 * Function write_commands()
 * This function writes out the executable part of the 
 * backup script after the comments
 *
 * Arguments -- none
 * Returns   -- none 
 */
void
write_commands()
{
    FILE *backup_script;
    char dump_options[128];      /* for dump options */
    char arg_list[128];          /* for args to these options */
    char options_and_args[256];  /* dump_options + arg_list */
    char error_msg[80];
    char scratch[128];           /* scratchpad */
    int  counter;

    /** If no backup script file, oops **/

    if ((backup_script = (FILE *)fopen((char *)xv_get(Dumptool_base->script_filename, PANEL_VALUE), "a")) == NULL)
    {
        (void)sprintf(error_msg, "Cannot open %s.  Please check the file's permissions and try again.", 
            (char *)xv_get(Dumptool_base->script_filename, PANEL_VALUE));
        (void)generic_notifier(error_msg);
        return;
    }

    (void)fputs("#\n", backup_script);

    (void)fputs("# Start of commands\n", backup_script);
    (void)fputs("#\n", backup_script);

    /* Now gather all the dump options we set */

    /* Dump level */
    (void)sprintf(dump_options, "%d", (int)xv_get(Dumptool_base->dump_level, PANEL_VALUE));

    /* Blocking factor */
    (void)strcat(dump_options, "b");
    (void)sprintf(scratch, " %d", (int)xv_get(Dumptool_base->blocking_factor, PANEL_VALUE));
    (void)strcpy(arg_list, scratch);

    /* HACK Alert. Change this in the next release! */
    /* Set the 'c' option if tape_type is NOT 1/2". */
D 3
    if ((int)strncmp((char *)xv_get(Dumptool_base->tape_type, PANEL_CHOICE_STRING, (int)xv_get(Dumptool_base->tape_type, PANEL_VALUE)), "1/2", 3) != 0)
E 3
I 3
D 4

E 4
/*    if ((int)strncmp((char *)xv_get(Dumptool_base->tape_type, PANEL_CHOICE_STRING, (int)xv_get(Dumptool_base->tape_type, PANEL_VALUE)), "1/2", 3) != 0)  */

    if (((int)strncmp((char *)xv_get(Dumptool_base->tape_type, PANEL_CHOICE_STRING, (int)xv_get(Dumptool_base->tape_type, PANEL_VALUE)), "1/2", 3) != 0) && \
D 4
       ((int)strncmp((char *)xv_get(Dumptool_base->tape_type, PANEL_CHOICE_STRING, (int)xv_get(Dumptool_base->tape_type, PANEL_VALUE)), "DLT4000", 6) != 0))
E 4
I 4
       ((int)strncmp((char *)xv_get(Dumptool_base->tape_type, PANEL_CHOICE_STRING, (int)xv_get(Dumptool_base->tape_type, PANEL_VALUE)), "DLT4000", 6) != 0) && \
D 5
       ((int)strncmp((char *)xv_get(Dumptool_base->tape_type, PANEL_CHOICE_STRING, (int)xv_get(Dumptool_base->tape_type, PANEL_VALUE)), "Mammoth", 7) != 0))
E 5
I 5
       ((int)strncmp((char *)xv_get(Dumptool_base->tape_type, PANEL_CHOICE_STRING, (int)xv_get(Dumptool_base->tape_type, PANEL_VALUE)), "Mammoth", 7) != 0) && \
       ((int)strncmp((char *)xv_get(Dumptool_base->tape_type, PANEL_CHOICE_STRING, (int)xv_get(Dumptool_base->tape_type, PANEL_VALUE)), "DLT2000", 6) != 0))
E 5
E 4
E 3
        (void)strcat(dump_options, "c");

    /* Tape density */
    (void)strcat(dump_options, "d");
    (void)sprintf(scratch, " %d", (int)xv_get(Dumptool_base->tape_density, PANEL_VALUE));
    (void)strcat(arg_list, scratch);

    /* Tape size */
    (void)strcat(dump_options, "s");
    (void)sprintf(scratch, " %d", (int)xv_get(Dumptool_base->tape_size, PANEL_VALUE));
    (void)strcat(arg_list, scratch);

    /* File (Tape device or stdout) to dump to. */
    (void)strcat(dump_options, "f");

    /* Update dumpdates */
    if ((int)xv_get(Dumptool_base->update_dumpdates, PANEL_VALUE) == 1)
        (void)strcat(dump_options, "u");

    /* Combine options and arguments. */
    (void)strcpy(options_and_args, dump_options);
    (void)strcat(options_and_args, arg_list);

    /* Setup the Backup Script's global variables. */
    (void)fputs("# Define Global Variables\n", backup_script);
    (void)fprintf(backup_script, "setenv TAPEDEV \"%s\"\n", (char *)xv_get(Dumptool_base->tape_device, PANEL_VALUE));
    (void)fprintf(backup_script, "setenv TAPEHOST \"%s\"\n", (char *)xv_get(Dumptool_base->tape_host, PANEL_VALUE));
    (void)fprintf(backup_script, "setenv DUMPOPS \"%s\"\n", options_and_args);
    (void)fputs("setenv TODAY \"`date '+%m%d%y'`\"\n", backup_script);
    (void)fputs("setenv LOGFILE \"/var/spool/dumptool/dumptool.log.${TODAY}\"\n", backup_script);
    (void)fputs("setenv TEMPFILE \"/tmp/dumptool.templog.$$\"\n", backup_script);
    (void)fputs("#\n", backup_script);

    /* Add a banner line to the TEMPFILE. */
    (void)fputs("/usr/bin/echo \"###############################################\" >>& ${TEMPFILE}\n", backup_script);
    (void)fputs("/usr/bin/echo \"DumpTool Job Starting on \"`date '+%D'`\" at \"`date '+%T'`\".\" >>& ${TEMPFILE}\n", backup_script);
    (void)fputs("/usr/bin/echo \"###############################################\" >>& ${TEMPFILE}\n", backup_script);
    (void)fputs("#\n", backup_script);

    (void)fputs("(echo '--- REWINDING tape --- ') >>& ${TEMPFILE}\n", backup_script) ;
    (void)fprintf(backup_script, "(%s -n ${TAPEHOST} /usr/bin/mt -f ${TAPEDEV} rewind) >>& ${TEMPFILE}\n", RSH_CMD); 
    (void)fputs("#\n", backup_script);

    /* Copy the Backup Script File onto the tape for future reference. */
    (void)fputs("(echo '--- TARing scriptfile ---  ') >>& ${TEMPFILE}\n", backup_script);
    /* we need to TAR only the filename, not with full pathname */
    (void)strcpy(scratch, (char *)xv_get(Dumptool_base->script_filename, PANEL_VALUE));
D 9
    if ((int)strcmp((char *)dirname(scratch), EMPTY_STRING) != 0)
E 9
I 9
    if ((int)strcmp((char *)dirname(scratch), ".") != 0)
E 9
        (void)fprintf(backup_script, "cd %s\n", scratch);
    (void)strcpy(scratch, (char *)xv_get(Dumptool_base->script_filename, PANEL_VALUE));
    (void)fprintf(backup_script, "(%s cvf - %s | %s ${TAPEHOST} /usr/bin/dd of=${TAPEDEV}) >>& ${TEMPFILE}\n",
      TAR_CMD, (char *)basename(scratch), RSH_CMD) ;
    (void)fputs("#\n", backup_script);

    /* For each file system in the File System List... */
    for (counter = 0; counter < (int)xv_get(Dumptool_base->filesystem_list, PANEL_LIST_NROWS); counter++)
    {
        char fs_hostname[128];   /* The file system's hostname. */
        char fs_diskpart[128];   /* The file system's disk partition. */
        char dump_cmd[20];       /* BSD or SVR4 dump command? */
        char *tmp_ptr;           /* A generic char pointer */
        int index = 0;

        (void)strcpy(scratch, (char *)xv_get(Dumptool_base->filesystem_list, PANEL_LIST_STRING, counter));

        tmp_ptr = scratch;

        /* First, grab fs_hostname... */
        while (*tmp_ptr != ':')
            fs_hostname[index++] = *tmp_ptr++;
        fs_hostname[index] = '\0';

        /* Skip past the ":" and rest the index. */
        tmp_ptr++;
        index = 0;

        /* Now grab the fs_diskpart... */
        while (*tmp_ptr != ' ')
            fs_diskpart[index++] = *tmp_ptr++;
        fs_diskpart[index] = '\0';

        (void)fprintf(backup_script, "(echo \"--- Dumping %s:%s to ${TAPEHOST}:${TAPEDEV} ---\") >>& ${TEMPFILE}\n", fs_hostname, fs_diskpart);

        /* If it's a BSD machine, use dump, else use ufsdump... */
        if ((int)get_remote_host_release(fs_hostname) == SUNOS_4X)
            (void)strcpy(dump_cmd, BSD_DUMP);
        else
            (void)strcpy(dump_cmd, SVR4_DUMP);

        (void)fprintf(backup_script, "(%s -n %s %s ${DUMPOPS} ${TAPEHOST}:${TAPEDEV} %s  ) >>& ${TEMPFILE}\n",
            RSH_CMD, fs_hostname, dump_cmd, fs_diskpart);
        (void)fputs("#\n", backup_script);
    }

    (void)fputs("(echo '--- REWINDING tape --- ') >>& ${TEMPFILE}\n", backup_script);
    (void)fprintf(backup_script, "(%s -n ${TAPEHOST} /usr/bin/mt -f ${TAPEDEV} rewind) >>& ${TEMPFILE}\n", RSH_CMD); 
    (void)fputs("#\n", backup_script);

    /* Perform "Tape Unload" if requested... */
    if ((int)xv_get(Dumptool_base->unload_tape, PANEL_VALUE) == 1)
    {
        (void)fprintf(backup_script, "(%s -n ${TAPEHOST} /usr/bin/mt -f ${TAPEDEV} offline) >>& ${TEMPFILE}\n", RSH_CMD); 
        (void)fputs("#\n", backup_script);
    }

    /* If the user  requested that mail be sent... */
    if ((int)xv_get(Dumptool_base->send_mail, PANEL_VALUE) == 1)
    {
        (void)fprintf(backup_script, "/usr/bin/cat ${TEMPFILE} | %s -s \"Output from DumpTool\" %s\n",
        MAIL_CMD, (char*)xv_get(Dumptool_base->mail_to, PANEL_VALUE));
        (void)fputs("#\n", backup_script);
    }

    /* Concatenate the TEMPFILE to the end of today's LOGFILE. */
    (void)fputs("/usr/bin/cat ${TEMPFILE} >> ${LOGFILE}\n", backup_script);
    (void)fputs("#\n", backup_script);

    /* Delete the TEMPFILE. */
    (void)fputs("/usr/bin/rm -f ${TEMPFILE}\n", backup_script);
    (void)fputs("#\n", backup_script);

    (void)fputs("# End of commands\n", backup_script);

    (void)fclose(backup_script);

    /* Make the Backup Script executable. */
    (void)chmod((char *)xv_get(Dumptool_base->script_filename, PANEL_VALUE), S_IRWXU);

    /* Inform the user that we are done. */
    (void)xv_set(Dumptool_base->base, FRAME_LEFT_FOOTER, "Backup Script Saved.", NULL);
   
    /** Indicate that the file has been saved atleast once **/
    saved_once = TRUE;
}

/* Function load_script()
 * This is executed if the user presses the `load' button
 * 
 * Arguments -- none
 * Returns   -- none
 */
void
load_script()
{
    FILE *backup_script;
    struct stat *stat_info;
    char error_msg[80];
    char error_msg2[80];
    int counter;
    int current_lineno = 0;   /* The Backup Script lineno that we are currently working on. */
    int fs_count = 0;         /* Current row number for file system list */ 
    char line[256];           /* Hold a line from the script file */

    /* Allocate memory for the  stat_info structure. */
    stat_info = (struct stat *)malloc(sizeof(struct stat));

    /* If script_filename does not exist... */
    if ((int)stat((char *)xv_get(Dumptool_base->script_filename, PANEL_VALUE), stat_info) != 0)
    {
        (void)sprintf(error_msg, "The file \'%s\' does not exist.", (char *)xv_get(Dumptool_base->script_filename, PANEL_VALUE));
        (void)multi_generic_notifier(
            error_msg,
            "",
            "Please enter the correct Backup Script Filename and try again.",
            "");
        return;
    }

    if ((backup_script = (FILE *)fopen((char *)xv_get(Dumptool_base->script_filename, PANEL_VALUE), "r")) == NULL)
    {
        (void)sprintf(error_msg, "Cannot open %s.  Please check the file's permissions and try again.", 
            (char *)xv_get(Dumptool_base->script_filename, PANEL_VALUE));
        (void)generic_notifier(error_msg);
        return;
    }

    /* Read the first line. */
    (void)fgets(line, sizeof(line), backup_script); 
    current_lineno++;

    /* Until we read "#File list"... */
    while ((int)strncmp(line, "#File list", (int)strlen("#File list")) != 0)
    {
        /* First character in each line should be a "#" */
        if (line[0] != '#')
        {
            (void)fclose(backup_script);
            (void)sprintf(error_msg, "The file \'%s\' is not in DumpTool format.",
                (char *)xv_get(Dumptool_base->script_filename, PANEL_VALUE));
            (void)sprintf(error_msg2, "I do not understand line %d.", current_lineno);
            (void)multi_generic_notifier(
                error_msg,
                error_msg2,
                "",
                "Load aborted.");
            return;
        }
         
        /* if there is no ':' in this line, get the next line */
        if ((char *)strstr(line, ":") == NULL)
        {
            (void)fgets(line, sizeof(line), backup_script);
            current_lineno++;
            continue;
        }
         
        /* Read and act on each line. */
        /* file_data is defined in global.h */
        for (counter = 0; file_data[counter].begin != NULL; counter++)
        {
            if ((int)strncmp(file_data[counter].begin, line, (int)strlen(file_data[counter].begin)) == 0)
            {   
                if (!(int)(*file_data[counter].func)(line))
                {
                    (void)fclose(backup_script);
                    (void)sprintf(error_msg, "The file \'%s\' is not in DumpTool format.",
                        (char *)xv_get(Dumptool_base->script_filename, PANEL_VALUE));
                    (void)sprintf(error_msg2, "I do not understand line %d.", current_lineno);
                    (void)multi_generic_notifier(
                        error_msg,
                        error_msg2,
                        "",
                        "Load aborted.");
                    return;
                }
                break ;
            }
        }

        (void)fgets(line, sizeof(line), backup_script);
        current_lineno++;
    }

    /* Delete the existing File System List entries. */
    for (counter = (int)xv_get(Dumptool_base->filesystem_list, PANEL_LIST_NROWS); counter > 0; counter--)
        (void)xv_set(Dumptool_base->filesystem_list, PANEL_LIST_DELETE, counter - 1, NULL);

    /* Read the File System List entries from the Backup Script... */
    (void)fgets(line, sizeof(line), backup_script);
    current_lineno++;
    while ((int)strncmp(line, "#EOF", 4) != 0)
    {
        /* Delete the '#' and '\n' from the input. */
        (void)clean_up(line);
        (void)xv_set(Dumptool_base->filesystem_list, PANEL_LIST_STRING, fs_count, line, NULL);
        fs_count++ ;
        (void)fgets(line, sizeof(line), backup_script);
        current_lineno++;
    }

    /* Close the file. */
    (void)fclose(backup_script);

    /* Script has been saved. */
    saved_once = TRUE; 
}

/*
 * Function strip_string()
 * This function takes a line as input and strips off undesired chars.
 * It strips up to and including the ': ' and the newline. 
 * This function is used when loading data from a DumpTool Backup Script.
 *
 * Arguments -- charac. string (line)
 */
void
strip_string(char *str)
{
    char scratch[128];

    /* Strip off the beginning - up to the ':' */
    (void)strcpy(scratch, (char *)strstr(str, ":"));

    /* Now get rid of the leading ": " and newline. */
    (void)sscanf(scratch, ": %s", str);
}

/*
 * Strip the leading '#' and the trailing '\n' off the specified string.
 */
void
clean_up(char *line)
{
    char scratch[128];
    int i;
    int j=0;
 
    /* line[0] is a '#' so leave that out and start from line[1] */
    for (i = 1; line[i] != '\n'; i++)
        scratch[j++] = line[i];
    /* Eliminate the '\n'. */
    scratch[j] = NUL;

    (void)strcpy(line, scratch);
 }

/*
 * Function create_cron_entry()
 * This function actually makes an entry in the "crontab" file
 * and restarts cron to make the changes effective
 *
 * Arguments -- none
 * Returns   -- none
 */
void
create_cron_entry()
{
    char command[256];    /** to execute a system command **/
    char minute[3]; 
    char hour[3];
    char day_of_the_month[3];
    char monthly_hour[3];
    char monthly_minute[3];
    char days_of_the_week[20] = "";
    char scratch[30];
    char temp_file[L_tmpnam];
    char temp_file2[L_tmpnam];
    FILE *temp_file_stream;
    int counter;

    /* Generate temporary file names. */
    (void)tmpnam(temp_file);
    (void)tmpnam(temp_file2);

    /* Remove any current cron entry for this Backup Script. */
    (void)sprintf(command, "/usr/bin/crontab -l | /usr/bin/grep -v %s > %s",
        (char *)xv_get(Dumptool_base->script_filename, PANEL_VALUE), temp_file);
    (void)system(command);

    /* Remove the empty lines */
    (void)sprintf(command, "/usr/bin/awk '{if (NF != \"0\") print ($0) > \"%s\"}' %s", temp_file2, temp_file);
    (void)system(command);

    /* Open the temporary cron file. */
    temp_file_stream = (FILE *)fopen(temp_file2, "a");

    /* Now from the user supplied info, determine when this should be executed */

    /* If one or more days of the week have been selected... */
    if ((int)xv_get(Dumptool_base->days_of_week, PANEL_VALUE) > 0)
    {
        /* daily hour and minute */    
        (void)strcpy(scratch, (char *)xv_get(Dumptool_base->daily_time, PANEL_VALUE));
        /* scratch is now of the form NNNN where the first two denotes the hour and the last two denotes the minute */
        /* Pull out hour */
        hour[0] = scratch[0];
        hour[1] = scratch[1];
        hour[2] = '\0';
        /* Pull out minute */
        minute[0] = scratch[2];
        minute[1] = scratch[3];
        minute[2] = '\0';

        /* Fill in the days_of_the_week... */
        for (counter = 0; counter < 7; counter++)
            /* If the day is selected... */
            if (((int)xv_get(Dumptool_base->days_of_week, PANEL_VALUE) & (1 << counter)) != 0)
            {
                (void)sprintf(scratch, "%d,", counter);
                (void)strcat(days_of_the_week, scratch);
            }
 
        /* Remove the trailing comma. */
        days_of_the_week[(int)strlen(days_of_the_week)-1] = '\0';

        /* Write out the entry. */
        (void)fprintf(temp_file_stream, "%s %s * * %s %s\n",
            minute, hour, days_of_the_week, (char *)xv_get(Dumptool_base->script_filename, PANEL_VALUE));
    }

    /* If the Monthly box is checked... */
    if ((int)xv_get(Dumptool_base->monthly_check_box, PANEL_VALUE) == 1)
    {
        /* monthly hour and minute */
        (void)strcpy(scratch, (char *)xv_get(Dumptool_base->monthly_time, PANEL_VALUE));
        /* scratch is now of the form NNNN where the first two denotes the hour and the last two denotes the minute */
        /* Pull out hour */
        monthly_hour[0] = scratch[0];
        monthly_hour[1] = scratch[1];
        monthly_hour[2] = '\0';
        /* Pull out minute */
        monthly_minute[0] = scratch[2];
        monthly_minute[1] = scratch[3];
        monthly_minute[2] = '\0';

        /* get monthly date */
        (void)sprintf(day_of_the_month, "%d", (int)xv_get(Dumptool_base->monthly_date, PANEL_VALUE));

        /* Write out the entry. */
        (void)fprintf(temp_file_stream, "%s %s %s * * %s\n",
            monthly_minute, monthly_hour, day_of_the_month, (char *)xv_get(Dumptool_base->script_filename, PANEL_VALUE));
    }
    
    /* Close the temporary cron file. */
    (void)fclose(temp_file_stream);

    /* Make the new cron entries known to cron. */
    (void)sprintf(command, "/usr/bin/crontab %s", temp_file2);
    (void)system(command); 

    /* Remove the temporary files */
    (void)unlink(temp_file);
    (void)unlink(temp_file2);

    /** Inform user **/
    (void)xv_set(Dumptool_base->base, FRAME_LEFT_FOOTER, "Backup Script Scheduled.", NULL);
}

/*
 * Get a YES or NO response from the user.
 * One message line allowed.
 */
int 
yes_or_no(char *msg)
{
    Xv_notice notice;
    int notice_status;

    notice = (Xv_notice)xv_create(Dumptool_base->base, NOTICE,
        NOTICE_MESSAGE_STRINGS,
            msg,
        NULL,
        NOTICE_BUTTON_YES, "Yes",
        NOTICE_BUTTON_NO, "No", 
        NOTICE_STATUS, &notice_status,
        XV_SHOW, TRUE,
        NULL);

    switch (notice_status)
    {
        case NOTICE_YES:
            return(YES);

        case NOTICE_NO:
            return(NO);
    }
    (void)xv_destroy_safe(notice);
}

/*
 * Get a YES or NO response from the user.
 * Four message lines allowed.
 */
int 
multi_yes_or_no(char *msg1, char *msg2, char *msg3, char *msg4)
{
    Xv_notice notice;
    int notice_status;

    notice = (Xv_notice)xv_create(Dumptool_base->base, NOTICE,
        NOTICE_MESSAGE_STRINGS,
            msg1,
            msg2,
            msg3,
            msg4,
        NULL,
        NOTICE_BUTTON_YES, "Yes",
        NOTICE_BUTTON_NO, "No", 
        NOTICE_STATUS, &notice_status,
        XV_SHOW, TRUE,
        NULL);

    switch (notice_status)
    {
        case NOTICE_YES:
            return(YES);

        case NOTICE_NO:
            return(NO);
    }
    (void)xv_destroy_safe(notice);
}

/*
 * Retrieve list of mounted file systems for specified remote host.
 * Display them in the File System List. 
 */
void
get_remote_filesystems()
{
    char temp_file[L_tmpnam];
    char filesystem_type[5];  /* File System type: ufs (SVR4) or 4.2 (BSD) */
    char mounttab_file[15];    /* Name of mounttab file: /etc/mnttab (SVR4) or /etc/mtab (BSD) */
    char command[200];
    int matched = FALSE;
    char error_msg[80];
    char error_msg2[80];
    struct stat stat_buf;
    struct mnttab *mnttab_entry;
    FILE *mnttab_stream;
    char filesystem_list_entry[100];

    /* Generate a temporary file name. */
    (void)tmpnam(temp_file);

    /* If remote_hostname is not local_host... */
    if ((int)strcmp(local_hostname, (char *)xv_get(Dumptool_base->remote_hostname, PANEL_VALUE)) != 0)
    {
        if ((int)check_host_availability((char *)xv_get(Dumptool_base->remote_hostname, PANEL_VALUE)) == FALSE)
            return;

        /* If remote_hostname release is SUNOS_5X... */
        if ((int)get_remote_host_release((char *)xv_get(Dumptool_base->remote_hostname, PANEL_VALUE)) == SUNOS_5X)
        {
            (void)strcpy(filesystem_type, "ufs");
            (void)strcpy(mounttab_file, "/etc/mnttab");
            (void)sprintf(command, "%s %s:%s %s 2>> /dev/null", 
                RCP_CMD, (char *)xv_get(Dumptool_base->remote_hostname, PANEL_VALUE), mounttab_file, temp_file);
        }
        else /* SUNOS_4X */
        {
            (void)strcpy(filesystem_type, "4.2");
            (void)strcpy(mounttab_file, "/etc/mtab");
            (void)sprintf(command, "%s %s:%s %s 2>> /dev/null",
                RCP_CMD, (char *)xv_get(Dumptool_base->remote_hostname, PANEL_VALUE), mounttab_file, temp_file);
        }

        /* Retrieve the remote mnttab/mtab file. */
        (void)system(command);

        /* If the remote copy failed... */
        if ((int)stat(temp_file, &stat_buf) < 0)
        {
            (void)sprintf(error_msg, "Unable to get '%s' file from host '%s'\n", 
                mounttab_file, (char *)xv_get(Dumptool_base->remote_hostname, PANEL_VALUE));
            (void)generic_notifier(error_msg);
            return;
        }

        /* Open the mounttab file for reading... */
        mnttab_stream = (FILE *)fopen(temp_file, "r");
    }
    else
    {
        if ((mnttab_stream = (FILE *)fopen(MNTTAB, "r")) == NULL)
        {
            (void)sprintf(error_msg, "Error opening %s.", MNTTAB);
            (void)sprintf(error_msg2, "Check permissions on %s and try again.", MNTTAB);
            (void)multi_generic_notifier(
                error_msg,
                "",
                error_msg2,
                "");
            return;
        }
        (void)strcpy(filesystem_type, LOCAL_FILESYSTEM_TYPE);
    }

    /* Allocate memory for the  mnttab_entry structure. */
    mnttab_entry = (struct mnttab *)malloc(sizeof(struct mnttab));

    /* If a particular remote_mount_point is specified... */
    if ((int)strlen((char *)xv_get(Dumptool_base->remote_mount_point, PANEL_VALUE)) != 0)
    {
        /* While there are more entries in the mounttab file... */
        while ((int)getmntent(mnttab_stream, mnttab_entry) != -1)
            if (((int)strcmp(mnttab_entry->mnt_fstype, filesystem_type) == 0) &&
                ((int)strcmp(mnttab_entry->mnt_mountp, (char *)xv_get(Dumptool_base->remote_mount_point, PANEL_VALUE)) == 0))
            {
                (void)strcpy(filesystem_list_entry, (char *)xv_get(Dumptool_base->remote_hostname, PANEL_VALUE));
                (void)strcat(filesystem_list_entry, ":");
                (void)strcat(filesystem_list_entry, mnttab_entry->mnt_special);
                (void)strcat(filesystem_list_entry, "  ");
                (void)strcat(filesystem_list_entry, mnttab_entry->mnt_mountp);
                (void)xv_set(Dumptool_base->filesystem_list,
                    PANEL_LIST_INSERT,     (int)xv_get(Dumptool_base->filesystem_list, PANEL_LIST_NROWS),
                    PANEL_LIST_STRING,     (int)xv_get(Dumptool_base->filesystem_list, PANEL_LIST_NROWS), filesystem_list_entry,
                    NULL);

                /* We've found the desired entry.  We can stop looking. */
                matched = TRUE;
                break;
            }

        /* If we couldn't find the desired file system... */
        if (!matched)
        {
            (void)sprintf(error_msg, "There is no '%s' file system on host '%s'.\n", 
                (char *)xv_get(Dumptool_base->remote_mount_point, PANEL_VALUE),
                (char *)xv_get(Dumptool_base->remote_hostname, PANEL_VALUE));
            (void)generic_notifier(error_msg);
            return;
        }
    }
    else  /* Get all file systems... */
        while ((int)getmntent(mnttab_stream, mnttab_entry) != -1)
            if ((int)strcmp(mnttab_entry->mnt_fstype, filesystem_type) == 0)
            {
                (void)strcpy(filesystem_list_entry, (char *)xv_get(Dumptool_base->remote_hostname, PANEL_VALUE));
                (void)strcat(filesystem_list_entry, ":");
                (void)strcat(filesystem_list_entry, mnttab_entry->mnt_special);
                (void)strcat(filesystem_list_entry, "  ");
                (void)strcat(filesystem_list_entry, mnttab_entry->mnt_mountp);
                (void)xv_set(Dumptool_base->filesystem_list,
                    PANEL_LIST_INSERT,     (int)xv_get(Dumptool_base->filesystem_list, PANEL_LIST_NROWS),
                    PANEL_LIST_STRING,     (int)xv_get(Dumptool_base->filesystem_list, PANEL_LIST_NROWS), filesystem_list_entry,
                    NULL);
            }

    /* Close the mounttab file. */
    (void)fclose(mnttab_stream);

    /* Remove the temporary file */
    (void)unlink(temp_file);
}

/*
 * Check if the host is valid and accessible
 *
 * Arguments -- none
 * Returns   -- FALSE if errors encountered
 *              TRUE if no errors 
 */
int
check_host_availability(char *hostname)
{
    char command[150];
    char error_msg[80];
    char error_msg2[80];

    /* If hostname is unknown to us... */
    if ((struct hostent *)gethostbyname(hostname) == NULL)
    {
        (void)sprintf(error_msg, "The machine '%s' is unknown to me.\n", hostname);
        (void)generic_notifier(error_msg);
        return(FALSE);
    }

    /* Can we see the host on the network? */
    (void)sprintf(command, PING_CMD_LINE, hostname);
    if ((int)system(command) != 0) 
    {
        (void)sprintf(error_msg, "The machine '%s' is not alive on the network.\n", hostname);
        (void)generic_notifier(error_msg);
        return(FALSE);
    }

    /* Do we have permission to "use" the host?  */
    (void)sprintf(command, "%s -n %s /usr/bin/true 2>/dev/null", RSH_CMD, hostname);
    if ((int)system(command) != 0)
    {
        (void)sprintf(error_msg, "The machine '%s' is not accessible to me.", hostname);
        (void)sprintf(error_msg2, "Please add '%s' to the $HOME/.rhosts file on host '%s'.", local_hostname, hostname);
        (void)multi_generic_notifier(
            error_msg,
            "",
            error_msg2,
            "'$HOME' is the home directory of the DumpTool user (i.e. '/' for root).");
        return(FALSE);
    }

    /* OK - Return success */
    return(TRUE);
}

/* 
 * Get the O.S. release number of the remote host specified.
 * Return the Major Release number (4 or 5).
 */
int
get_remote_host_release(char *remote_hostname)
{
    char temp_file[L_tmpnam];
    FILE *temp_file_stream;
    char command[150];
    int release;

    /* Generate a temporary filename. */
    (void)tmpnam(temp_file);

    /* Generate the command which will give us the remote OS release. */
    (void)sprintf(command, "%s -n %s 'set a=`/usr/bin/uname -r`; echo \"$a\"' > %s", RSH_CMD, remote_hostname, temp_file);
    (void)system(command);

    /* Make the command executable. */
    (void)chmod(temp_file, S_IRWXU);

    temp_file_stream = (FILE *)fopen(temp_file, "r");
    release = (int)((int)getc(temp_file_stream) - '0');
    (void)fclose(temp_file_stream);

    /* Remove the temporary file. */
    (void)unlink(temp_file);

    /* Return the OS Release. */
    return(release);
}

/* 
 * These routines set up the GUI fields per the data in the Backup Script. */

/*
 * Function set_daily_check()
 * This function sets the value for `daily_check_box'.
 *
 * Returns   -- FALSE on failure
 *              TRUE on success
 */
int
set_daily_check(char *line)
{
    (void)strip_string(line);

    /* since this is a check box, valid entries are 0 and 1 */
    if (line[0] != '0' && line[0] != '1')
        return(FALSE);

    (void)xv_set(Dumptool_base->daily_check_box, PANEL_VALUE, (int)atoi(line), NULL);

    /* If this value is set, we need to highlight the time field... */
    if (line[0] == '1')
        (void)xv_set(Dumptool_base->daily_time, PANEL_INACTIVE, FALSE, NULL);
    else
        (void)xv_set(Dumptool_base->daily_time, PANEL_INACTIVE, TRUE, NULL);

    return(TRUE);
}

/*
 * Function set_monthly_check()
 * This function sets the value for `monthly_check_box'.
 *
 * Returns   -- FALSE on failure
 *              TRUE on success
 */
int
set_monthly_check(char *line)
{
    (void)strip_string(line);

    /* since this is a check box, valid entries are 0 and 1 */
    if (line[0] != '0' && line[0] != '1')
        return(FALSE);

    (void)xv_set(Dumptool_base->monthly_check_box, PANEL_VALUE, (int)atoi(line), NULL);

    /* highlight monthly date and time if this is checked */
    if (line[0] == '1')
    {
        (void)xv_set(Dumptool_base->monthly_date, PANEL_INACTIVE, FALSE, NULL);
        (void)xv_set(Dumptool_base->monthly_time, PANEL_INACTIVE, FALSE, NULL);
    }
    else
    {
        (void)xv_set(Dumptool_base->monthly_date, PANEL_INACTIVE, TRUE, NULL);
        (void)xv_set(Dumptool_base->monthly_time, PANEL_INACTIVE, TRUE, NULL);
    }

    return(TRUE);
}

/*
 * Function set_daily_time()
 * This function sets the value for `daily_time'
 *
 * Returns   -- TRUE on success 
 */
int
set_daily_time(char *line)
{
    (void)strip_string(line);

    if (!(int)valid_time_format(line))
        return(FALSE);

    /* Since this is a string, we just set it and return success */
    (void)xv_set(Dumptool_base->daily_time, PANEL_VALUE, line, NULL);

    return(TRUE);
}

/*
 * Function set_days_of_week()
 * This function sets the values for `days_of_week'.
 *
 * Returns   -- FALSE on failure
 *              TRUE on success
 */
int
set_days_of_week(char *line)
{
    (void)strip_string(line);

    /* This field can only take values between 0x00 and ALL_DAYS_OF_WEEK */
    /* That would be between 0 and 127 in decimal */
    if (((int)atoi(line) < 0) || ((int)atoi(line) > 127))
        return(FALSE);

    (void)xv_set(Dumptool_base->days_of_week, PANEL_VALUE, (int)atoi(line), NULL);

    /* If this value is not zero, then turn on daily time field */
    if ((int)atoi(line) > 0)
        (void)xv_set(Dumptool_base->daily_time, PANEL_INACTIVE, FALSE, NULL) ;
    else
        (void)xv_set(Dumptool_base->daily_time, PANEL_INACTIVE, TRUE, NULL) ;

    return(TRUE);
}


/*
 * Function set_mail_check() 
 * This function sets the value for `send_mail'.
 *
 * Returns   -- FALSE on failure
 *              TRUE on success
 */
int
set_mail_check(char *line)
{
    (void)strip_string (line);

    /* Since this is mail_check, valid entries are 0 and 1 */
    if (line[0] != '0' && line[0] != '1')
        return(FALSE);

    (void)xv_set(Dumptool_base->send_mail, PANEL_VALUE, (int)atoi(line), NULL);

    /* If this value is checked, then turn on the mail_to option */
    if (line[0] == '1')
        (void)xv_set(Dumptool_base->mail_to, PANEL_INACTIVE, FALSE, NULL);
    else
        (void)xv_set(Dumptool_base->mail_to, PANEL_INACTIVE, TRUE, NULL);

    return(TRUE);
}


/*
 * Function set_mail_to()
 * This one fills in the email address of the mail recipient.
 *
 * Returns   -- TRUE on success 
 */
int
set_mail_to(char *line)
{
    (void)strip_string(line);

    /* mail_to is a string, so just load it and return success */
    (void)xv_set(Dumptool_base->mail_to, PANEL_VALUE, line, NULL);

    return(TRUE);
}

/*
 * Function set_monthly_date()
 * This function sets the monthly_date that the backup is to occur.
 *
 * Returns   -- FALSE on failure
 *              TRUE on success
 */
int
set_monthly_date(char *line)
{
    (void)strip_string(line);

    /* If no value was specified, just return success */
    if (line[0] == 0)
    {
        (void)xv_set(Dumptool_base->monthly_date, PANEL_VALUE, line, NULL);
        return(TRUE);
     }
    /* Though this is a string, the numeric value should be 0<x<32 */
    if (((int)atoi(line) < 1) || ((int)atoi(line) > 31))
        return(FALSE);

    (void)xv_set(Dumptool_base->monthly_date, PANEL_VALUE, (int)atoi(line), NULL);

    return(TRUE);
}

/*
 * Function set_monthly_time()
 * This function sets the `monthly_time'.
 *
 * Returns   -- FALSE on failure
 *              TRUE on success
 */
int
set_monthly_time(char *line)
{
    (void)strip_string(line);

    if (!(int)valid_time_format(line))
        return(FALSE);

    (void)xv_set(Dumptool_base->monthly_time, PANEL_VALUE, line, NULL);

    return(TRUE);
}

/*
 * Function set_update_dumpdates()
 * This function sets the `update_dumpdates' box.
 *
 * Returns   -- FALSE on failure
 *              TRUE on success
 */
int
set_update_dumpdates(char *line)
{
    (void)strip_string(line);

    /* A check box is either 0 or 1 */
    if ((line[0] != '0') && (line[0] != '1'))
        return(FALSE);

    (void)xv_set(Dumptool_base->update_dumpdates, PANEL_VALUE, (int)atoi(line), NULL);

    return(TRUE);
}

/*
 * Function set_dump_level()
 * This function sets the dump level value for the backup
 *
 * Returns   -- FALSE on failure
 *              TRUE on success
 */
int
set_dump_level(char *line)
{
    (void)strip_string(line);

    /* This should be a value between 0 and 9 */
    if (((int)atoi(line) < 0) || ((int)atoi(line) > 9))
        return(FALSE);

    (void)xv_set(Dumptool_base->dump_level, PANEL_VALUE, (int)atoi(line), NULL);

    return(TRUE);
}

/* Function set_unload_tape()
 * This function sets the unload_tape box
 *
 * Returns   -- FALSE on failure 
 *              TRUE on success
 */
int
set_unload_tape(char *line)
{
    (void)strip_string(line); 

    if ((line[0] != '0') && (line[0] != '1')) 
        return(FALSE);

    (void)xv_set(Dumptool_base->unload_tape, PANEL_VALUE, (int)atoi(line), NULL);

    return(TRUE);
}

/* Function set_tape_host()
 * This function sets the tape hostname field 
 *
 * Returns   -- FALSE on failure 
 *              TRUE on success
 */
int
set_tape_host(char *line)
{
    (void)strip_string(line); 

    (void)xv_set(Dumptool_base->tape_host, PANEL_VALUE, line, NULL);

    return(TRUE);
}

/* Function set_tape_device()
 * This function sets the tape device field
 *
 * Returns   -- FALSE on failure 
 *              TRUE on success
 */

int
set_tape_device(char *line)
{
    (void)strip_string(line); 

    (void)xv_set(Dumptool_base->tape_device, PANEL_VALUE, line, NULL);

    return(TRUE);
}

/* Function set_tape_type()
 * This function sets the tape type field
 *
 * Returns   -- FALSE on failure 
 *              TRUE on success
 */
int
set_tape_type(char *line)
{
    (void)strip_string(line); 

    if (((int)atoi(line) < 0) || ((int)atoi(line) > MAX_TAPE_TYPE))
        return(FALSE);

    (void)xv_set(Dumptool_base->tape_type, PANEL_VALUE, (int)atoi(line), NULL);

    return(TRUE);
}

/* Function set_tape_size()
 * This function sets the tape size field
 *
 * Returns   -- FALSE on failure 
 *              TRUE on success
 */
int
set_tape_size(char *line)
{
    (void)strip_string(line);

    /* Tape size cannot be negative */
    if ((int)atoi(line) < 0)
        return(FALSE);

    (void)xv_set(Dumptool_base->tape_size, PANEL_VALUE, (int)atoi(line), NULL);

    return(TRUE);
}

/* Function set_tape_density()
 * This function sets the tape density field
 *
 * Returns   -- FALSE on failure 
 *              TRUE on success
 */
int
set_tape_density(char *line)
{
    (void)strip_string(line);

    /* Tape density cannot be negative */
    if ((int)atoi(line) < 0)
        return(FALSE);

    (void)xv_set(Dumptool_base->tape_density, PANEL_VALUE, (int)atoi(line), NULL);

    return(TRUE);
}

/* Function set_blocking_factor()
 * This function sets the blocking factor field
 *
 * Returns   -- FALSE on failure 
 *              TRUE on success
 */
int
set_blocking_factor(char *line)
{
    (void)strip_string(line);

    /* Blocking factor cannot be less than 20 */
    if ((int)atoi(line) < 20)
        return(FALSE);

    (void)xv_set(Dumptool_base->blocking_factor, PANEL_VALUE, (int)atoi(line), NULL);

    return(TRUE);
}
E 1
