.TH disktool 1 "29 Aug 1994"
.SH NAME
disktool \- Ver 2.0 \- monitor filesystems for full conditions
.SH SYNOPSIS
.B disktool
[
.BI "\-d "
] [
.BI "\-h " 
] [
.BI "\-i " int
] [
.BI "\-l " int
] [
.BI "\-s " int
] [
.BI "\-c " string
] [
.BI "\-r " int
] [
.BI "\-u "
] [
.BI "\-t " int
]
.BI "filesystem "
[[
.BI "\-t " int
]
.BI "filesystem"
]...
.SH DESCRIPTION
.I disktool
is an XView program that monitors up to 64 filesystems simultaneously
and alerts the user when a filesystem has reached a critical amount of
available space. Many of the command line options can be adjusted
"on the fly" by clicking the right mouse button on a gauge.
A pop-up will allow you to make changes to the polling interval
time (in seconds), the layout mode (horizontal/vertical), number
of gauges per row/column and spacing of gauges (in pixels). The 
apply button must be pressed for the options applicable to gauge
layout to take effect. The display units and critical threshold
can also be adjusted on a per gauge basis (the default) or globally
to all of the gauges thru the pull down menu on the Apply button.
You may also specify a unix command to be called when any
filesystem being monitored becomes critical (ie. reaches its'
threshold). Two shell variables are passed to the system call,
DISK = the filesystem name and BYTES = number of MBs/KBs left
available on that filesystem. A toggle is also provided for
"un-iconifying" when a threshold has been met or surpassed. This
signaling can be repeated every so many polls by specifying the
repeat cmdline option or by setting the Repeat Signal value on the
Properties pop-up window.
The icon also changes between "critical" and "OK" situations as well 
as indicate the name of the host machine disktool is running on. A
timestamp on the left footer of the frame indicates the last time
the filesystem(s) being monitored were polled for available space.
A middle mouse button click will force an immediate filesystem poll
at any time.
.SH KEYBOARD ACCELERATORS
Keyboard accelerators allow quick access to some of the configurable
parameters controlling disktool's appearance and function.
.TP
.BI "+,-"
these, respectively, increase and decrease the polling interval by
10 seconds with each keypress.
.TP
.BI "="
this displays the current polling interval in the left footer for
a second before returning to the timestamp label.
.TP
.BI "h,v"
these, respectively, change to horizontal and vertical gauge layout.
.TP
.BI "p"
this forces an immediate filesystem poll to update all the gauge
values.
.TP
.BI "q,x"
either of these will cause disktool to quit.
.SH OPTIONS
The following options can be given on the command line as
indicated or with just the first letter following the dash.
.TP
.BI "\-c, \-cmd " string
spcify a unix command line that is executed when a filesystem being
monitored goes critical.
.TP
.BI "\-d, \-delta "
this causes deltas to be displayed showing a positive or negative
change in disk space since the last poll. By default, Green indicating
increase and red indicating decrease.
.TP
.BI "\-h, \-horizontal "
specifies the panel layout (default is vertical).
.TP
.BI "\-i, \-interval " int
frequency in seconds for polling filesystems for available
space (default is 180).
.TP
.BI "\-l, \-lineup " int
number of gauges to lineup before starting a new row
or column (default is 10).
.TP
.BI "\-r, \-repeat " int
the integer argument specifies every how many polls before re-signaling
of a critical filesystem. If this value is  set to 0 (the default), the
critical signal only happens once, when the filesystem first goes 
critical.
.TP
.BI "\-s, \-spacing " int
gauge spacing in screen pixels. Default is 0, which causes 
auto-calculation of spacing.
.TP
.BI "\-u, \-used "
reverses the gauge displays to show disk space used instead of 
the default, disk space available.
.TP
.BI "\-t, \-threshold " int
defines the amount of available space in MBytes to be considered
critical for the following filesystems. This can be tailored 
individually after startup. If the value passed contains a 'K',
it will be evaluated as Kbytes.
.TP
.BI "filesystem "
name of the filesystem to be monitored. Up to 64 filesystems can be
specified on the command line, delimited by spaces.
.SH "EXAMPLES"
To execute disktool with a polling interval of 60 secs, a new column
after every 5 gauges, gauge spacing set to 75 pixels, deltas displayed,
a threshold of 10 MBs and of all home partitions, the command would be:
.TP
.BI "% disktool -i 60 -l 5 -s 75 -d -t 10 /home[0-9]*"
.BI
.SH ""
To monitor the first two filesystems with a threshold set to 30 MBs
and the next two filesystems with a threshold of 5700 KBs, the command
would be:
.TP
.BI "% disktool -t 30 /home01 /home02 -t 5700K /home03 /home04"
.BI
.SH ""
To add the hostname of the machine disktool was invoked from and
monitor disk partitions "/home01" and "/home02" and execute a shell
script called "notify_users", the command would be:
.TP
.BI "% disktool -Wl `hostname` /home01 /home02 -c notify_users"
.BI
.SH ""
"-Wl" being a command line argument valid for most XVIEW applications.
.BI
.SH "ENVIRONMENT VARIABLES"
.IP DISPLAY
Default display.
.SH FILES
.IP .openwin-init
Command line options are saved with a "SAVE_WORKSPACE".
.BI
.SH SEE ALSO
xview
.BI
.SH "AUTHOR"
Shaun M. Finn,
.IR sfinn@thecore.com
