.\" $Id: workmandb.man,v 1.3.4.1 2003/05/12 09:00:00 ossk Exp $
.TH workmandb 5 "12/5/92"
.SH NAME
workmanrc, workmandb \- database and preferences files for workman
.SH SYNOPSIS
.B $\s-2HOME\s+2/.workmanrc
or value of \s-2WORKMANRC\s+2 variable
.LP
.B $\s-2HOME\s+2/.workmandb
or value(s) of \s-2WORKMANDB\s+2 variable
.SH DESCRIPTION
.LP
The \fB.workmandb\fP file stores information about compact discs.  It is
generated by
.IR workman (1)
based on user input.  Its companion file, \fB.workmanrc\fP, stores the
general user preferences and the user
preferences  for each disc.  The distinction between the two is
that \fB.workmandb\fP contains only the hard information about a CD (the disc
name, artist, track titles, etc.) and is often shared among several
users.  \fB.workmanrc\fP, on the other hand, contains settings like the 
user's email address sent to the CDDB server, the default
volumes of particular tracks, the numbers of tracks to be avoided, and
so forth.  Each user generally maintains a private \fB.workmanrc\fP,
even if a shared \fB.workmandb\fP is being used.
.LP
Though
.IR workman (1)
stores different information in each file,
both files have an identical format; most of this manual page will
not distinguish between the two.  Each line of the file is of the form
.LP
[s-]keyword	[\fIoptional whitespace-separated arguments\fP]
.LP
Empty lines are ignored.  Lines starting with unrecognized keywords are
retained and written back out verbatim when the database is saved.  The
program preserves the ordering of unrecognized lines, and their positions
relative to the track information.  This
allows the database to be extended to hold any sort of information desired
by the user.
.LP
Keywords that begin with "s-" apply to sections rather than tracks.  See
the \fBsections\fP keyword below.  A CD entry with "s-" keywords must
have a \fBsections\fP keyword as well.  This is done for backward
compatibility and will disappear eventually, and in any case only applies
to keywords found in \fB.workmandb\fP (the assumption is that users
won't downgrade the versions they run, so \fB.workmanrc\fP doesn't need
to be backward-compatible.)
.LP
Some keywords are delimiters that modify the meanings of keywords that
follow; others are position-independent and may occur anywhere in the
file.  (In general, the position-independent keywords are concerned with
settings for the tool as a whole, rather than for a particular disc.)
.LP
The keywords, and their arguments, follow.  All numeric arguments are in
decimal unless otherwise specified.
.SS Initial Keywords
These keywords must appear before the first CD's entry, and represent
global settings for the tool.  They are usually found in \fB.workmanrc\fP.
.TP
\fBwhendone eject\fP | \fBstop\fP | \fBrepeat\fP
Select the default action taken by
.IR workman (1)
when a CD is finished playing.  The default is \fBstop\fP.
.TP
\fBplaynew\fP
If specified,
.IR workman (1)
will play unknown CDs (those not listed in \fB.workmanrc\fP) when they're
inserted.
.TP
\fBcddbprotocol\fP \fBcddbp\fP | \fBhttp\fP | \fBproxy\fP
Protocol to be used for CDDB requests.
.IR workman(1)
can either use the CDDBP or the HTTP protocol. PROXY
denotes the use of a proxy server for CDDBP requests.
If this keyword is not set 
.IR workman(1)
does not use CDDB support. 
.TP
\fBcddbserver\fP \fIhost\fP[\fI:port\fP]
name of the CDDB server to be used, e.g. freedb.freedb.org. 
If \fIport\fP is not provided we use port 
888 for CDDBP requests and port 80 for HTTP requests.
.TP
\fBcddbmailaddress\fP \fIemail-address\fP
This is the user's email address that will be sent to the CDDB 
server. It must be given in the form \fIuser@host\fP. If this 
address is not provided an identification based
on the login name and the hostname will be sent.
.TP
\fBcddbpathtocgi\fP \fIpath\fP
If the HTTP protocol is used this keyword provides the path to 
the CGI script answering the CDDB requests. This is usually 
/~cddb/cddb.cgi
.TP
\fBcddbproxy\fP \fIhost\fP[\fI:port\fP]
The name of a proxy that can be used for CDDB requests. If
\fIport\fP is not provided port 80 will be used. 
.SS CD Information
The rest of the keywords describe specific CDs.
.TP
\fBtracks\fI \fIntracks start1 start2 ... startn length\fP
This keyword delimits the start of a particular CD's entry (and thus
the end of the previous entry.)  Its
arguments contain the information used to distinguish one disc from
another.  The first argument, \fIntracks\fP, is the number of tracks
on the CD.  For each of those tracks, there is a \fIstart\fP value,
which is the starting frame of the track (a frame is approximately
1/75th of a second.)  The final argument is the length of the CD in
seconds.
.TP
\fBsections\fP \fInsects start1 start2 ... startn\fP
.IR Workman (1)
allows the user to split a CD's physical tracks into smaller virtual tracks
called sections.
The \fBsections\fP keyword, which must immediately follow \fBtracks\fP,
defines the starting positions of the sections.  Sections are inserted into
the track list, and track numbers are adjusted accordingly, e.g. section 1.2
as presented to the user is represented as track 2 in the database file.
If the sections listed in \fB.workmandb\fP and \fB.workmanrc\fP
differ, \fB.workmandb\fP takes precedence, and sections listed only
in \fB.workmanrc\fP are discarded.
.TP
\fBcdname\fP \fIname\fP
The name of the current disc, as supplied by the user.
.TP
\fBartist\fP \fIname\fP
The artist's name for the current disc, as supplied by the user.
.TP
\fBplaymode\fP \fImode\fP
The default play mode for the CD is \fImode\fP, a numeric value.  0 is
the "normal" play mode (play all tracks sequentially) and 1 is "shuffle"
mode.  If \fImode\fP is 2 or greater, the default play sequence is a
playlist (\fImode\fP 2 meaning the first playlist, 3 meaning the second,
etc.)
.TP
\fBautoplay\fP
If \fBautoplay\fP is present, this CD will begin playing immediately
when it is inserted.
.TP
\fBcdvolume\fP \fIvolume\fP
The default play volume of the CD, a value from 0 to 32.  If \fIvolume\fP is 0,
the CD has no default volume (since 0 is the default, \fBcdvolume\fP will
usually not be present in that case.)
.TP
\fBplaylist\fP \fIname number track1 track2 ...\fP
Define a playlist for the current CD.  The \fIname\fP does not contain any
whitespace; whitespace is converted to "_" on output and "_" is converted
to whitespace on input.  (See the \s-2BUGS\s+2 section.)  The \fInumber\fP
argument is the number of tracks contained in the playlist; the rest of
the line is a list of track numbers.  Playlists are ordered; see the
\fBplaymode\fP keyword above.
.TP
\fBtrack\fP [\fIname\fP]
The name of a track.  This delimits the start of a
track's information.
The \fIname\fP argument is optional; it will not be present unless the
user has supplied a track name.  This line may be divided into display
lines with the "//" token.  Additionally, a display line beginning with
"+" indicates that the rest of the display line contains a replacement
disc title (usually the name of a group of tracks,
such as "Symphony No. 2" on a disc
with more than one piece of music.)  A display line beginning with "@"
replaces the artist's name for the track.  If "+" or "@" is the only
character on a display line,
.IR workman (1)
will use the title or artist from the previous track, searching backwards
as necessary.  If a display line is empty, the corresponding display line
from the previous track is used.
.TP
\fBcontinue\fP
The current track is a continuation of the previous one (e.g. the
second movement of a symphony.)
.TP
\fBdontplay\fP \fItrack\fP
Don't play a track (specified by number) unless it's specifically requested
by the user.
.TP
\fBvolume\fP \fItrack\fP \fIvolume\fP
The default play volume for \fItrack\fP, specified by number.  \fIvolume\fP
is a number from 0 to 32.  See \fBcdvolume\fP above.
.TP
\fBmark\fP \fIframe\fP \fImark-id\fP
Define a mark.  Marks with IDs other than \fBSTART\fP and \fBEND\fP are
currently
ignored.  Those two marks represent the start and end of the part of
the CD to be repeated (as set from the Goodies popup) respectively.  The
\fIframe\fP value is an absolute frame number.
.SH EXAMPLE
The first example is a \fB.workmandb\fP entry for a hypothetical disc.  At
least, I hope it's hypothetical.
.IP
.ll +4i
tracks 6 150 10341 20449 45117 100104 150100 1609
.br
cdname Amazing Accordion Tunes - The Early Years
.br
artist The Hemophiliacs
.br
track Polka 'Till the Sun Goes Down
.br
track I've Got Rocks In My Heart, Baby...
.br
track ...But I Still Get Stoned On You
.br
continue
.br
track You Never Know How Late It Is Until the Clock Strikes Blue
.br
track +The Big Exhibition//@Mussorgsky//IX. La Cabane//Allegro
.br
track +//@////Andante mosso
.br
continue
.ll -4i
.LP
The third track is a continuation of the second.
The fifth
track is an excerpt from a larger work, originally written by someone
else; it has a two-line track title.  The sixth track is a continuation of
the fifth; it uses the same title and artist, and the first line of the
track title is the same, but the second is different.
.LP
The \fB.workmanrc\fP entry for the same CD might look like:
.IP
tracks 6 150 10341 20449 45117 100104 150100 1609
.br
cdvolume 32
.br
playmode 1
.br
playlist Originals 3 2 3 1
.br
autoplay
.br
dontplay 4
.br
volume 3 20
.LP
The \fBtracks\fP line, naturally, is the same in both files, since it
identifies which CD the entry is for.  This CD plays at maximum volume
in shuffle mode by default.  It has one playlist with tracks 2, 3, and
1.  When inserted, it will start up automatically.  Track 4 is particularly
unpleasant, so the user never wants to hear it.  And track 3 should be
played more quietly than the others.
.SH SEE ALSO
.BR workman (1)
.SH BUGS
The \fBplaylist\fP keyword is not well thought-out.  The \fIname\fP should
go at the end of the line, so it can contain whitespace or whatever else
the user likes.
.LP
The file updating algorithm used by
.IR workman (1)
leaves big holes (consisting of empty lines) in the database files.  It
makes an attempt to fill the holes when possible rather than growing
the files.
