/*   WorkBone CD Rom Player Software

     Copyright (c) 1994  Thomas McWilliams 
     Changes (c) 1996 Dirk F"orsterling aka milliByte
    
     This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation; either version 2, or (at your option)
     any later version.
     
     This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.
     
     You should have received a copy of the GNU General Public License
     along with this program; if not, write to the Free Software
     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/


#ifdef WBLAZY
#define WBS_DELAY 2
#define WBU_DELAY 0
#endif

#ifndef WBS_DELAY
#define WBS_DELAY 1
#endif

#ifndef WBU_DELAY
#define WBU_DELAY 0
#endif

#define UPCUR "\033[1A"
#define REVON "\033[7m"
#define REVOF "\033[27m"

/* kernel 1.0 uses different escape sequence for pc character set */
#define OGON "\033(U"
#define OGOF "\033(B"
#define GON "\033[11m"
#define GOF "\033[10m"

#define MTAB "        "
#define MTAB3 MTAB MTAB
#define ROW0 MTAB3 "\x19                          \x19\n"
#define ROWV MTAB3 "\x19          /\\    \\/        \x19\n"
#define ROW1 MTAB3 "\x19    \x5b\x5d    ||    |\x3e    C   \x19\n"
#define ROW11 MTAB3 "\x19                      D   \x19\n"
#define ROW2 MTAB3 "\x19    |\x3c    \x4c\x3e    \x3e|    B   \x19\n"
#define ROW3 MTAB3 "\x19    \x3c\x3c    \x12\x5e    \x3e\x3e   " REVON " R " REVOF "  \x19\n"
#define ROW31 MTAB3 "\x19                     " REVON " E " REVOF "  \x19\n"
#define ROW4 MTAB3 "\x19   " REVON "   quit   " REVOF "   " REVON " ? " REVOF "  " REVON " T " REVOF "  \x19\n"
#define HLIN1 "\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12"
#define HLIN2 "\x12\x12\x12\x12\x12\x12"
#define HDR "\x16 number pad \x15"
#define ROWT MTAB3 "\x18" HLIN2 HDR HLIN2 "\x18\n" 
#define ROWB MTAB3 "\x17" HLIN1 HLIN1 "\x17\n" "%s\n" UPCUR "\r"

#define AROW0 MTAB3 "|                          |\n"
#define AROWV MTAB3 "|          /\\    \\/        |\n"
#define AROW1 MTAB3 "|    []    ||    |>    C   |\n"
#define AROW11 MTAB3 "|                      D   |\n"
#define AROW2 MTAB3 "|    |<    L>    >|    B   |\n"
#define AROW3 MTAB3 "|    <<    -^    >>    R   |\n"
#define AROW31 MTAB3 "|                      E   |\n"
#define AROW4 MTAB3 "|    quit         ?    T   |\n"
#define AHLIN1 "-------------"
#define AHLIN2 "------"
#define AHDR "| number pad |"
#define AROWT MTAB3 "+" AHLIN2 AHDR AHLIN2 "+\n" 
#define AROWB MTAB3 "+" AHLIN1 AHLIN1 "+\n" "\n" UPCUR "\r"

const char *glst[] =
  {
    "\x5b\x5d", "\tstop (7)                   ",
    "||", "\tpause/resume (8)",
    "|\x3e", "\tplay (9)",
    "|\x3c", "\tprevious selection (4)",
    "\x3e|", "\tnext selection (6)",
    "\x4c\x3e", "\tre-start current selection (5)",
    "\x3c\x3c", "\tgo backward 15 seconds (1)",
    "\x3e\x3e", "\tgo foreward 15 seconds (3)",
    "\x12\x5e", "\tabort workbone, eject (2)",
    "/\\", "\tincrease volume (*)",
    "\\/", "\tdecrease volume (/)",
    "CDB", "\tshow title list from CDDB (+)",
    "quit", "\texit workbone (music continues) (0)",
    "?", "\tdisplay help screen (.)",
    "RET", "\treturn to main screen (<-')", NULL};
 const char *alst[] =
  {
    "[]", "\tstop (7)                   ",
    "||", "\tpause/resume (8)",
    "|>", "\tplay (9)",
    "|<", "\tprevious selection (4)",
    ">|", "\tnext selection (6)",
    "L>", "\tre-start current selection (5)",
    "<<", "\tgo backward 15 seconds (1)",
    ">>", "\tgo foreward 15 seconds (3)",
    "-^", "\tabort workbone, eject (2)",
    "/\\", "\tincrease volume (*)",
    "\\/", "\tdecrease volume (/)",
    "CDB", "\tshow title list from CDDB (+)",
    "quit", "\texit workbone (music continues) (0)",
    "?", "\tdisplay help screen (.)",
    "RET", "\treturn to main screen (<-')", NULL};

#ifndef TRUE
#define TRUE 1
#define FALSE 0
#endif

void show_terms( const char **p );

extern char *cd_device;
