#pragma	ident	"@(#)libgolit.c	2.12	92/03/04 libgolit SMI"	/* GOLIT	*/
/*
 * This file is a product of Sun Microsystems, Inc. and is provided for
 * unrestricted use provided that this legend is included on all tape
 * media and as a part of the software program in whole or part.  Users
 * may copy or modify this file without charge, but are not authorized to
 * license or distribute it to anyone else except as part of a product
 * or program developed by the user.
 * 
 * THIS FILE IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
 * WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 * 
 * This file is provided with no support and without any obligation on the
 * part of Sun Microsystems, Inc. to assist in its use, correction,
 * modification or enhancement.
 * 
 * SUN MICROSYSTEMS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
 * INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY THIS FILE
 * OR ANY PART THEREOF.
 * 
 * In no event will Sun Microsystems, Inc. be liable for any lost revenue
 * or profits or other special, indirect and consequential damages, even
 * if Sun has been advised of the possibility of such damages.
 * 
 * Sun Microsystems, Inc.
 * 2550 Garcia Avenue
 * Mountain View, California  94043
 */

#ifndef lint
static char     sccsid[] = "@(#)libgolit.c	2.8 8/14/91 Copyright 1991 Sun Microsystems";
#endif

#include <X11/IntrinsicP.h>
#include <X11/CoreP.h>
#include <X11/Shell.h>
#include <Xol/OpenLook.h>
#include <libgolitI.h>
#include <string.h>
#include <varargs.h>

int	GolitRTVersion = GolitVersion; /* version of library */

/**************************** utility functions *****************************/

/*************************
 *
 * _GolitWarning
 *
 *************************/

#define	AppCtxFromWidget(w)	(((w) != (Widget)NULL)			  \
					? XtWidgetToApplicationContext(w) \
					: _XtDefaultAppContext(w))

static char *GolitNullWidgetDesc  = "Widget Desc is NULL";
static char *GolitNullWidgetID    = "Widget ID is NULL";
static char *GolitNullCreateProcs = "Create Proc list is NULL";
static char *GolitVersionMismatch = "WidgetDesc veresion != RT version";
static char *GolitFetchWDOnShell  = "Widget CreateProc called on Shell WidgetDesc";

static char *_GolitErrorTypeStr = " widget name '%s', descriptor name '%s'";

static void
#if	defined(__STDC__)
_GolitWarning ( Widget widget, GolitWidgetDescPtr wdp, String name )
#else	
_GolitWarning ( widget, wdp, name )
	Widget			widget;
	GolitWidgetDescPtr 	wdp;
	String			name;
#endif	/* __STDC__*/
{
	static char 	*_GolitWarningClass   = "GolitRTWarning";
	static String	buf[2];
	Cardinal	num = 2;
	
	extern	XtAppContext	_XtDefaultAppContext();
	
	buf[0] = (String)(widget ? widget->core.name   : "NULL");
	buf[1] = (String)(wdp    ? GolitWDPtrName(wdp) : "NULL");

	XtAppWarningMsg(AppCtxFromWidget(widget), name, _GolitErrorTypeStr, 
		        _GolitWarningClass, name, buf, &num);

}

/*************************
 *
 * _GolitError
 *
 *************************/


static void
#if     defined(__STDC__) 
_GolitError ( Widget widget, GolitWidgetDescPtr wdp, String name )
#else
_GolitError ( widget, wdp, name )
	Widget			widget;
	GolitWidgetDescPtr	wdp;
	String			name;
#endif 	/* __STDC__*/
{
	static char 	*_GolitErrorClass   = "GolitRTError";
	static String	buf[2];
	Cardinal	num = 2;
	
	extern	XtAppContext	_XtDefaultAppContext();

	buf[0] = (String)(widget ? widget->core.name   : "NULL");
	buf[1] = (String)(wdp    ? GolitWDPtrName(wdp) : "NULL");

	XtAppWarningMsg(AppCtxFromWidget(widget), name, _GolitErrorTypeStr, 
		        _GolitErrorClass, name, buf, &num);

	exit(1);
}

/*************************
 *
 * _GolitWDNumSiblings
 *
 *************************/

int
#if     defined(__STDC__)  
_GolitWDNumSiblings ( GolitWidgetDescPtr wdp )
#else
_GolitWDNumSiblings ( wdp )
	register GolitWidgetDescPtr	wdp;
#endif
{
	register int n = 0;

	ForAllSiblings(wdp, wdp) n++;

	return (n);
}


/*************************
 *
 * _GolitWDNumChildren
 *
 *************************/

int
#if     defined(__STDC__)  
_GolitWDNumChildren ( GolitWidgetDescPtr wdp )
#else
_GolitWDNumChildren ( wdp )
	register GolitWidgetDescPtr	wdp;
#endif	/* __STDC__ */
{
	register int n = 0;

	ForAllChildren(wdp, wdp) n++;

	return (n);
}


/*************************
 *
 * _GolitWDNumPopups
 *
 *************************/

int
#if     defined(__STDC__)  
_GolitWDNumPopups ( GolitWidgetDescPtr wdp )
#else
_GolitWDNumPopups ( wdp )
	register GolitWidgetDescPtr	wdp;
#endif  /* __STDC__ */
{
	register int n = 0;

	ForAllPopups(wdp, wdp) n++;

	return (n);
}


/*************************
 *
 * _GolitWDNumArgs
 *
 *************************/

int
#if     defined(__STDC__)   
_GolitWDNumArgs ( GolitWidgetDescPtr wdp )
#else
_GolitWDNumArgs ( wdp )
	register GolitWidgetDescPtr	wdp;
#endif  /* __STDC__ */ 
{
	register ArgList	arg;
	register int		n = 0;

	ForAllArgs(arg, wdp) n++;

	return (n);
}


/*************************
 *
 * _GolitWDNumTypedArgs
 *
 *************************/

int
#if     defined(__STDC__)
_GolitWDNumTypedArgs ( GolitWidgetDescPtr wdp )
#else
_GolitWDNumTypedArgs ( wdp )
	register GolitWidgetDescPtr	wdp;
#endif  /* __STDC__ */
{
	register XtTypedArgList	arg;
	register int		n = 0;

	ForAllTypedArgs(arg, wdp) n++;

	return (n);
}


/*************************
 *
 * _GolitWDNumCallbacks
 *
 *************************/

int
#if     defined(__STDC__)
_GolitWDNumCallbacks ( GolitWidgetDescPtr wdp )
#else
_GolitWDNumCallbacks ( wdp )
	register GolitWidgetDescPtr	wdp;
#endif  /* __STDC__ */
{
	register GolitCallbackInfoPtr	cbs;
	register int			n = 0;

	ForAllCallbacks(cbs, wdp) n++;

	return (n);
}



/*************************
 *
 * _GolitWDNumCreateProcs
 *
 *************************/

int
#if     defined(__STDC__)
_GolitWDNumCreateProcs ( GolitWidgetDescPtr wdp )
#else
_GolitWDNumCreateProcs ( wdp )
	register GolitWidgetDescPtr	wdp;
#endif  /* __STDC__ */
{
	register _GolitWCProcList	cps;
	register int			n = 0;

	ForAllCreateProcs(cps, wdp) n++;

	return (n);
}


/*************************
 *
 * _GolitWDIsSubclass
 *
 *************************/

Boolean
#if     defined(__STDC__)
_GolitWDIsSubclass ( GolitWidgetDescPtr wdp, WidgetClass widget_class )
#else
_GolitWDIsSubclass ( wdp, widget_class )
	GolitWidgetDescPtr	wdp;
	register WidgetClass	widget_class;
#endif  /* __STDC__ */ 
{
	register WidgetClass class = *GolitWDPtrWidgetClass(wdp);

	while (class != (WidgetClass)NULL) {
		if (class == widget_class) 
			return (Boolean)True;
		else
			class = class->core_class.superclass;
	}

	return (Boolean)False;
}

/*************************
 *
 * GolitCallNextCreateProc
 *
 *************************/

Widget
#if     defined(__STDC__)
GolitCallNextCreateProc ( String name, GolitWidgetDescPtr wdp, Widget parent,
                                   ArgList args, Cardinal num_args, XtPointer closure)
#else
GolitCallNextCreateProc (name, wdp, parent,
				   args, num_args, closure)
	String				name;
	register GolitWidgetDescPtr	wdp;
	Widget				parent;
	ArgList				args;
	Cardinal			num_args;
	XtPointer			closure;
#endif  /* __STDC__ */
{
	Widget		w = (Widget)(-1);
	unsigned int	last_idx = GolitWDPtrCpIdx(wdp);

	if (!CreateProcListNULL(wdp) &&
	    (int)GolitWDPtrCpIdx(wdp) < (2 << BitsInCpIdx)) {
		last_idx++;
		w = CreateProc(name, wdp, parent, args, num_args, closure);
		_DecrWDPtrCpIdx(wdp);
	}

	if (!CreateProcListNULL(wdp) &&
	    GolitWDPtrCreateProcs(wdp)[last_idx] == (_GolitWCProc)NULL) {
		GolitWDPtrCpIdx(wdp) = 0;
	}

	return (w);
}

/*************************
 *
 * GolitOKToDoRealCreate
 *
 *************************/

Boolean
#if     defined(__STDC__) 
GolitOKToDoRealCreate ( GolitWidgetDescPtr wdp, GolitWidgetCreateProc this_cp, ... )
#else
GolitOKToDoRealCreate (wdp, this_cp, va_alist)
	GolitWidgetDescPtr	wdp;
	GolitWidgetCreateProc	this_cp;
 	va_dcl	
#endif	/* __STDC__ */
{
	GolitWidgetCreateProc	synonym;
	va_list			ap;

	if (CreateProcListNULL(wdp) 				||
	    (int)GolitWDPtrCpIdx(wdp) >= (2 << BitsInCpIdx)     ||
	    GolitWDPtrCreateProcs(wdp)[GolitWDPtrCpIdx(wdp)] ==
	    (_GolitWCProc)this_cp)
		return (True);

	va_start(ap);

	while ((synonym = (GolitWidgetCreateProc)
				va_arg(ap, GolitWidgetCreateProc)) !=
	       (GolitWidgetCreateProc)NULL)
		if (GolitWDPtrCreateProcs(wdp)[GolitWDPtrCpIdx(wdp)] ==
		    (_GolitWCProc)synonym)
			return ((Boolean)True);
		
	va_end(ap);

	return ((Boolean)False);
}

/*************************
 *
 * GolitMergeArgLists
 *
 *************************/

static int
#if     defined(__STDC__)
_compar ( int *first, int *second )
#else
_compar ( first, second )
	int	*first;
	int 	*second;
#endif  /* __STDC__ */ 
{
#define	ArgListName(p)	(char *)((*((ArgList *)(p)))->name)

	return strcmp(ArgListName(first), ArgListName(second));
#undef	ArgListName
}

XtVarArgsList
#if     defined(__STDC__) 
GolitMergeArgLists ( GolitWidgetDescPtr wdp, ArgList override_args, Cardinal num_override_args)
#else
GolitMergeArgLists ( wdp, override_args, num_override_args)
	register GolitWidgetDescPtr	wdp;
	ArgList				override_args;
	Cardinal			num_override_args;
#endif  /* __STDC__ */ 
{
	XtTypedArgList	 list, lp;
	Cardinal	 num_args  = _GolitWDNumArgs(wdp);
	Cardinal	 num_targs = _GolitWDNumTypedArgs(wdp);
	Cardinal	 tot_args  = num_override_args + num_args + num_targs;
	ArgList		 stack_cache[32], *cache;
	XtTypedArgList	 targs;
	register ArgList *p, *pp, q;

	if (tot_args == 0) return (XtVarArgsList)NULL;

	if (tot_args > (sizeof(stack_cache) / sizeof(stack_cache[0])))
		p = cache = (ArgList *)XtCalloc(tot_args, sizeof(ArgList));
	else
		p = cache = stack_cache;

	ForAllArgs(q, wdp) *p++ = q;

	ForAllTypedArgs(targs, wdp) *p++ = (ArgList)targs;

	for (q = override_args; q < override_args + num_override_args; q++)
		*p++ = q;

	qsort((char *)cache, tot_args, sizeof(ArgList), _compar);

	lp = list = (XtTypedArgList)XtCalloc(tot_args + 1, sizeof(XtTypedArg));

#define	IsArg(p, args, num)	((p) >= (args) && p < (args) + (num))

#define	IsTypedArg(p, wdp)						\
	((XtTypedArgList)(p) >= GolitWDPtrTypedArgs(wdp) &&		\
	 (XtTypedArgList)(p) < GolitWDPtrTypedArgs(wdp) + num_targs)

	for (pp = p = cache; p < cache + tot_args; lp++, p = ++pp) {
		while(pp < cache + tot_args &&
		      strcmp((*p)->name, (*pp)->name) == 0) pp++;
		if (p == --pp) {
				lp->name = (char *)((*p)->name);
			if (IsTypedArg(*p, wdp)) {
				lp->type  = ((XtTypedArgList)(*p))->type;
				lp->value = ((XtTypedArgList)(*p))->value;
				lp->size  = ((XtTypedArgList)(*p))->size;
			} else {
				lp->value = (*p)->value;
				lp->type = (String)NULL;
				lp->size = NULL;
			}
		} else {
			Boolean	typed, override;

			typed = override = False;
			q = (ArgList)NULL;

			for (; p <= pp; p++) {
				if (!(typed || override) &&
				    IsArg(*p, GolitWDPtrArgs(wdp), num_args) &&
				    *p > q) {
					q = *p;
					continue;
				}
				if (!override && IsTypedArg(*p, wdp) &&
				    *p > q) {
					typed = (Boolean)True;
					q = *p;
					continue;
				}
				if (IsArg(*p, override_args, num_override_args)
				    && *p > q) {
					override = (Boolean)True;
					q = *p;
					continue;
				}
			}

			lp->name  = (char*)(q->name);
			if (typed) {
				lp->type  = ((XtTypedArgList)q)->type;
				lp->value = ((XtTypedArgList)(*p))->value;
				lp->size  = ((XtTypedArgList)q)->size;
			} else {
				lp->type = (String)NULL;
				lp->size = NULL;
				lp->value = q->value;
			}
		}
	}

	lp->name  = (String)NULL;
	lp->type  = (String)NULL;
	lp->value = (XtArgVal)NULL;
	lp->size  = NULL;

	if (cache != stack_cache)
		XtFree((char *)cache);

	return ((XtVarArgsList)list);

#undef	IsArg
#undef	IsTypedArg
}


/*************************
 *
 * _GolitInstallCBsOnWidget
 *
 *************************/

#if	defined(__STDC__) || defined(__cplusplus)
extern	void OlAddCallback (Widget, String, XtCallbackProc, XtPointer);

void	(*GolitInstallCBProc) (Widget,
				      String,
				      XtCallbackProc,
				      XtPointer) = OlAddCallback;
#else   /* __STDC__ || __cplusplus */ 
extern  void OlAddCallback (); 

void    (*GolitInstallCBProc) () = OlAddCallback;
#endif  /* __STDC__ || __cplusplus */ 

void
#if     defined(__STDC__)
_GolitInstallCBsOnWidget ( Widget widget, GolitWidgetDescPtr wdp, XtPointer default_closure )
#else
_GolitInstallCBsOnWidget ( widget, wdp, default_closure )
	register Widget			widget;
	register GolitWidgetDescPtr	wdp;
	XtPointer			default_closure;
#endif	/* __STDC__ */
{
	register GolitCallbackInfoPtr	cb;

	ForAllCallbacks(cb, wdp) {
		register XtPointer	clos;
		clos = ((GolitCbIPtrCallbackRecClosure(cb) == (XtPointer)NULL)
				? default_closure
				: GolitCbIPtrCallbackRecClosure(cb));

		(*GolitInstallCBProc)(widget, GolitCbIPtrCallbackName(cb),
			      	      GolitCbIPtrCallbackRecProc(cb), clos);
	}
 }

/*************************
 *
 * _GolitFetchWDArgs
 *
 *************************/

ArgList
#if     defined(__STDC__) 
_GolitFetchWDArgs ( GolitWidgetDescPtr wdp )
#else
_GolitFetchWDArgs ( wdp )
	 register GolitWidgetDescPtr	wdp;
#endif  /* __STDC__ */ 
{
	return GolitWDPtrArgs(wdp);
}

/*************************
 *
 * _GolitFetchWDTypedArgs
 *
 *************************/

XtTypedArgList
#if     defined(__STDC__)  
_GolitFetchWDTypedArgs ( GolitWidgetDescPtr wdp )
#else
_GolitFetchWDTypedArgs ( wdp )
	 register GolitWidgetDescPtr	wdp;
#endif  /* __STDC__ */  
{
	return GolitWDPtrTypedArgs(wdp);
}

/*************************
 *
 * _GolitResetCpIdx
 *
 *************************/

void
#if     defined(__STDC__)   
_GolitResetCpIdx ( GolitWidgetDescPtr wdp )
#else
_GolitResetCpIdx ( wdp )
	 register GolitWidgetDescPtr	wdp;
#endif  /* __STDC__ */  
{
	GolitWDPtrCpIdx(wdp) = 0;
}

/*************************
 *
 * _GolitIncrCpIdx
 *
 *************************/

int
#if     defined(__STDC__)    
_GolitIncrCpIdx ( GolitWidgetDescPtr wdp )
#else
_GolitIncrCpIdx ( wdp )
	 register GolitWidgetDescPtr	wdp;
#endif  /* __STDC__ */   
{
	return _IncrWDPtrCpIdx(wdp);
}


/*************************
 *
 * _GolitDecrCpIdx
 *
 *************************/

int
#if     defined(__STDC__)    
_GolitDecrCpIdx ( GolitWidgetDescPtr wdp )
#else
_GolitDecrCpIdx ( wdp )
	 register GolitWidgetDescPtr	wdp;
#endif  /* __STDC__ */    
{
	return _DecrWDPtrCpIdx(wdp);
}

/*************************
 *
 * _GolitFetchWDWidgetClass
 *
 *************************/

WidgetClass
#if     defined(__STDC__)     
_GolitFetchWDWidgetClass ( GolitWidgetDescPtr wdp )
#else
_GolitFetchWDWidgetClass ( wdp )
	 register GolitWidgetDescPtr	wdp;
#endif  /* __STDC__ */     
{
	return *GolitWDPtrWidgetClass(wdp);
}

/************************** user entry points *****************************/

/*************************
 *
 * GolitNameToWidget
 *
 *************************/

Widget
#if     defined(__STDC__)      
GolitNameToWidget ( Widget root, String name )
#else
GolitNameToWidget ( root, name )
	Widget		root;
	String		name;
#endif  /* __STDC__ */      
{
	Widget	w;
	char	*buf,
		*didx = (char *)NULL,
		*sidx = (char *)NULL,
		*idx;

	if ((sidx = strrchr((char *)name, '*')) == (char *)NULL &&
	    (didx = strrchr((char *)name, '.')) == (char *)NULL) {
		buf = XtCalloc(strlen(name) + 2, sizeof(char));
		strcpy(buf, "*");
		strcat(buf, name);
		sidx = buf;
	} else {
		buf = (char *)name;
		if (sidx) sidx = buf + (sidx - name);
		if (didx) didx = buf + (didx - name);
	}

	if ((w = XtNameToWidget(root, buf)) != (Widget)NULL) {
		if (buf != name)
			XtFree(buf);
		return (w);
	}

	idx = ((sidx > didx) ? sidx : didx) + 1;

	for (w = root; w != (Widget)NULL; w = XtParent(w)) {
		root = w;
		if (XtIsShell(w)) {
			if (strcmp(XtName(w), idx) == 0 ||
			    (w = XtNameToWidget(root, buf)) != (Widget)NULL) {
				if (buf != name)
                        		XtFree(buf);
                		return (w);

			}
			w = root;
		}
	}

	w = XtNameToWidget(root, buf);

	if (buf != name)
		XtFree(buf);

	return (w);
}

/*************************
 *
 * GolitFetchLastWidgetID
 *
 *************************/

Widget
#if	defined(__STDC__)
GolitFetchLastWidgetID ( GolitWidgetDescPtr wdp )
#else
GolitFetchLastWidgetID ( wdp )
	register GolitWidgetDescPtr	wdp;
#endif	/* __STDC__ */
{
	if (wdp == (GolitWidgetDescPtr)NULL) {
		_GolitWarning((Widget)NULL, wdp, GolitNullWidgetDesc);
			     
		return ((Widget)NULL);
	}

	return (GolitWDPtrLastWidgetCreated(wdp));
}

/*************************
 *
 * GolitFetchWidget
 *
 *************************/

Widget
#if     defined(__STDC__)
GolitFetchWidget (String name, GolitWidgetDescPtr wdp, Widget parent, 
			ArgList args, Cardinal num_args, XtPointer closure)
#else
GolitFetchWidget (name, wdp, parent, args, num_args, closure)
	String				name;
	register GolitWidgetDescPtr	wdp;
	Widget				parent;
	ArgList				args;
	Cardinal			num_args;
	XtPointer			closure;
#endif  /* __STDC__ */ 
{
	Widget	w = (Widget)NULL;
#if	defined(__STDC__) 
	Widget	(*xt_proc) (const char *, WidgetClass, Widget, ...);
#else	/* __STDC__ */
	Widget	(*xt_proc) ();
#endif	/* __STDC__ */

	Boolean	key;

	if (wdp == (GolitWidgetDescPtr)NULL) {
		_GolitWarning(parent, wdp, GolitNullWidgetDesc);
			     
		return (w);
	}

	if (parent == (Widget)NULL) {
		_GolitWarning(parent, wdp, GolitNullWidgetID);
		return (w);
	}

#ifdef	CHECKVERSION
	if (GolitWDPtrVersion(wdp) != GoltRTVersion) {
		_GolitWarning(parent, wdp, GolitVersionMismatch); 
	}
#endif

	if (GolitWDPtrIsShell(wdp) || (!GolitWDPtrIsPopupShell(wdp) &&
	    (GolitWDPtrIsShell(wdp) =
		 _GolitWDIsSubclass(wdp, shellWidgetClass)))) {
		_GolitError(parent, wdp, GolitFetchWDOnShell);
	}

	key = (GolitWDPtrCpIdx(wdp) == (unsigned int)0);

	if (CreateProcListNULL(wdp) ||
	    DoRealCreate(wdp, GolitFetchWidget) ||
	    DoRealCreate(wdp, GolitFetchWidgetUnmanaged)) {
		XtVarArgsList	list = GolitMergeArgLists(wdp, args, num_args);

		if (GolitWDPtrIsPopupShell(wdp) || 
		    (GolitWDPtrIsPopupShell(wdp) =
		     _GolitWDIsSubclass(wdp, shellWidgetClass))) {
			xt_proc = XtVaCreatePopupShell;
		} else {
			xt_proc = ((GolitWDPtrCreateUnmanaged(wdp) ||
				  DoRealCreate(wdp, GolitFetchWidgetUnmanaged))
					? XtVaCreateWidget
					: XtVaCreateManagedWidget);
		}

		if (name == (String)NULL || *name == '\0')
			name = GolitWDPtrName(wdp);

		if (list) {
			w = (*xt_proc)(name, *GolitWDPtrWidgetClass(wdp),
				       parent, XtVaNestedList, (ArgList)list,
				       NULL);
		} else {
			w = (*xt_proc)(name, *GolitWDPtrWidgetClass(wdp),
				       parent, NULL);
		}

		if (w == (Widget)NULL) {
			_GolitWarning(parent, wdp, GolitNullWidgetID);
			return (w);
		}

		GolitWDPtrLastWidgetCreated(wdp) = w;

		_GolitInstallCBsOnWidget(w, wdp, closure);

		if (list != (XtVarArgsList)NULL)
			XtFree((char *)list);
	} else {
		w = CreateProc(name, wdp, parent, args, num_args, closure);
		_DecrWDPtrCpIdx(wdp);
	}
	    
	if (key) GolitWDPtrCpIdx(wdp) = 0;

	return (w);
}


/*************************
 *
 * GolitFetchWidgetUmanaged
 *
 *************************/

Widget
#if	defined(__STDC__)
GolitFetchWidgetUnmanaged ( String name, GolitWidgetDescPtr wdp, Widget parent, 
				ArgList args, Cardinal num_args, XtPointer closure)
#else
GolitFetchWidgetUnmanaged (name, wdp, parent, args, num_args, closure)
	String				name;
	register GolitWidgetDescPtr	wdp;
	Widget				parent;
	ArgList				args;
	Cardinal			num_args;
	XtPointer			closure;
#endif	/*__STDC__*/
{
	Boolean 	save = (Boolean)GolitWDPtrCreateUnmanaged(wdp);
	Widget		w;

	GolitWDPtrCreateUnmanaged(wdp) = True;
	w = GolitFetchWidget(name, wdp, parent, args, num_args, closure);
	GolitWDPtrCreateUnmanaged(wdp) = save;

	return (w);
}




/*************************
 *
 * _GolitFetchWDSiblings
 *
 *************************/

Widget*
#if	defined(__STDC__)
_GolitFetchWDSiblings (String name, GolitWidgetDescPtr wdp, Widget parent, 
				ArgList args, Cardinal num_args,
                                 GolitWidgetCreateProc create_proc, XtPointer closure)
#else
_GolitFetchWDSiblings (name, wdp, parent, args, num_args, 
				 create_proc, closure)
	String				name;
	register GolitWidgetDescPtr	wdp;
	Widget				parent;
	ArgList				args;
	Cardinal			num_args;
	GolitWidgetCreateProc		create_proc;
	XtPointer			closure;
#endif	/*__STDC__*/
{
	Cardinal			num_siblings;
	Cardinal			n = 0;
	Widget				*siblings = (Widget *)NULL;
	register GolitWidgetDescPtr	sibling;

	if (wdp == (GolitWidgetDescPtr)NULL) {
		_GolitWarning(parent, wdp, GolitNullWidgetDesc);
		return (siblings);
	}
		
	num_siblings = _GolitWDNumSiblings(wdp);
	if (num_siblings == (Cardinal)0) {
		_GolitWarning(parent, wdp, GolitNullWidgetDesc);
		return (siblings);
	}

	siblings = (Widget *)XtCalloc(num_siblings + 1, sizeof(Widget));

	ForAllSiblings(sibling, wdp) {
		Widget	w;

		GolitWDPtrCpIdx(sibling) = 0;

		w = GolitFetchWidget((String)NULL, sibling, parent, args,
				     num_args, closure);

		GolitWDPtrCpIdx(sibling) = 0;

		if (w != (Widget)NULL) siblings[n++] = w;
	}

	if (n == 0) {
		XtFree((char *)siblings);
		siblings = (Widget *)NULL;
	} else {
		siblings[n] = (Widget)NULL;
	}
	
	return (siblings);
}


/*************************
 *
 * GolitFetchChildren
 *
 *************************/

Widget
#if	defined(__STDC__)
GolitFetchChildren (String name, GolitWidgetDescPtr wdp, Widget parent, 
			ArgList args, Cardinal num_args, XtPointer closure)
#else
GolitFetchChildren (name, wdp, parent, args, num_args, closure)
	String				name;
	register GolitWidgetDescPtr	wdp;
	Widget				parent;
	ArgList				args;
	Cardinal			num_args;
	XtPointer			closure;
#endif	/*__STDC__*/
{
	Widget	*children;

	if (wdp == (GolitWidgetDescPtr)NULL ||
	    GolitWDPtrChildren(wdp) == (GolitWidgetDescPtr)NULL) {
		return ((Widget)NULL);
	}


	if (parent == (Widget)NULL) {
		_GolitWarning(parent, wdp, GolitNullWidgetID);
		return (parent);
	}

#ifdef	CHECKVERSION
	if (GolitWDPtrVersion(wdp) != GoltRTVersion) {
		_GolitWarning(parent, wdp, GolitVersionMismatch); 
	}
#endif

	if (GolitWDPtrIsShell(wdp) || (!GolitWDPtrIsPopupShell(wdp) &&
	    (GolitWDPtrIsShell(wdp) =
		 _GolitWDIsSubclass(wdp, shellWidgetClass)))) {
		_GolitError(parent, wdp, GolitFetchWDOnShell);
	}

	children = _GolitFetchWDSiblings((String)NULL,
					 GolitWDPtrChildren(wdp),
					 parent,
					 args, num_args,
					 GolitFetchWidget,
					 closure);

	if (children != (Widget *)NULL) {
		XtFree((char *)children);
	} else {
		parent = (Widget)NULL;
	}

	return (parent);
}


/*************************
 *
 * GolitFetchChildrenUnmanaged
 *
 *************************/

Widget
#if	defined(__STDC__)
GolitFetchChildrenUnmanaged (String name, GolitWidgetDescPtr wdp, Widget parent,
                        ArgList args, Cardinal num_args, XtPointer closure)
#else
GolitFetchChildrenUnmanaged (name, wdp, parent, args, num_args, closure)
        String                          name;
        register GolitWidgetDescPtr     wdp;
        Widget                          parent;
        ArgList                         args;
        Cardinal                        num_args;
        XtPointer                       closure;
#endif  /*__STDC__*/
{
	Widget	*children;

	if (wdp == (GolitWidgetDescPtr)NULL ||
	    GolitWDPtrChildren(wdp) == (GolitWidgetDescPtr)NULL) {
		return ((Widget)NULL);
	}


	if (parent == (Widget)NULL) {
		_GolitWarning(parent, wdp, GolitNullWidgetID);
		return (parent);
	}

#ifdef	CHECKVERSION
	if (GolitWDPtrVersion(wdp) != GoltRTVersion) {
		_GolitWarning(parent, wdp, GolitVersionMismatch); 
	}
#endif

	if (GolitWDPtrIsShell(wdp) || (!GolitWDPtrIsPopupShell(wdp) &&
	    (GolitWDPtrIsShell(wdp) =
		 _GolitWDIsSubclass(wdp, shellWidgetClass)))) {
		_GolitError(parent, wdp, GolitFetchWDOnShell);
	}

	children = _GolitFetchWDSiblings((String)NULL,
					 GolitWDPtrChildren(wdp),
					 parent,
					 args, num_args,
					 GolitFetchWidgetUnmanaged,
					 closure);

	if (children != (Widget *)NULL) {
		XtFree((char *)children);
	} else {
		parent = (Widget)NULL;
	}

	return (parent);
}

/*************************
 *
 * GolitFetchPopups
 *
 *************************/

Widget
#if     defined(__STDC__)
GolitFetchPopups (String name, GolitWidgetDescPtr wdp, Widget parent,
                        ArgList args, Cardinal num_args, XtPointer closure)
#else
GolitFetchPopups (name, wdp, parent, args, num_args, closure)
        String                          name;
        register GolitWidgetDescPtr     wdp;
        Widget                          parent;
        ArgList                         args;
        Cardinal                        num_args;
        XtPointer                       closure;
#endif  /*__STDC__*/
{
	Widget	*popups;

	if (wdp == (GolitWidgetDescPtr)NULL ||
	    GolitWDPtrPopups(wdp) == (GolitWidgetDescPtr)NULL) {
		return ((Widget)NULL);
	}

	if (parent == (Widget)NULL) {
		_GolitWarning(parent, wdp, GolitNullWidgetID);
		return (parent);
	}

#ifdef	CHECKVERSION
	if (GolitWDPtrVersion(wdp) != GoltRTVersion) {
		_GolitWarning(parent, wdp, GolitVersionMismatch); 
	}
#endif

	if (GolitWDPtrIsShell(wdp) || (!GolitWDPtrIsPopupShell(wdp) &&
	    (GolitWDPtrIsShell(wdp) =
		 _GolitWDIsSubclass(wdp, shellWidgetClass)))) {
		_GolitError(parent, wdp, GolitFetchWDOnShell);
	}

	popups = _GolitFetchWDSiblings((String)NULL,
					 GolitWDPtrPopups(wdp),
					 parent,
					 args, num_args,
					 GolitFetchWidget,
					 closure);

	if (popups != (Widget *)NULL) {
		XtFree((char *)popups);
	} else {
		parent = (Widget)NULL;
	}

	return (parent);
}



/*************************
 *
 * GolitFetchPopupsUnmanaged
 *
 *************************/

Widget
#if     defined(__STDC__)
GolitFetchPopupsUnmanaged (String name, GolitWidgetDescPtr wdp, Widget parent,
                        ArgList args, Cardinal num_args, XtPointer closure)
#else
GolitFetchPopupsUnmanaged (name, wdp, parent, args, num_args, closure)
        String                          name;
        register GolitWidgetDescPtr     wdp;
        Widget                          parent;
        ArgList                         args;
        Cardinal                        num_args;
        XtPointer                       closure;
#endif  /*__STDC__*/
{
	Widget	*popups;

	if (wdp == (GolitWidgetDescPtr)NULL ||
	    GolitWDPtrPopups(wdp) == (GolitWidgetDescPtr)NULL) {
		return ((Widget)NULL);
	}

	if (parent == (Widget)NULL) {
		_GolitWarning(parent, wdp, GolitNullWidgetID);
		return (parent);
	}

#ifdef	CHECKVERSION
	if (GolitWDPtrVersion(wdp) != GoltRTVersion) {
		_GolitWarning(parent, wdp, GolitVersionMismatch); 
	}
#endif

	if (GolitWDPtrIsShell(wdp) || (!GolitWDPtrIsPopupShell(wdp) &&
	    (GolitWDPtrIsShell(wdp) =
		 _GolitWDIsSubclass(wdp, shellWidgetClass)))) {
		_GolitError(parent, wdp, GolitFetchWDOnShell);
	}

	popups = _GolitFetchWDSiblings((String)NULL,
					 GolitWDPtrPopups(wdp),
					 parent,
					 args, num_args,
					 GolitFetchWidgetUnmanaged,
					 closure);

	if (popups != (Widget *)NULL) {
		XtFree((char *)popups);
	} else {
		parent = (Widget)NULL;
	}

	return (parent);
}

/*************************
 *
 * GolitFetchWidgetHierUmanaged
 *
 *************************/

Widget
#if     defined(__STDC__)
GolitFetchWidgetHierUnmanaged (String name, GolitWidgetDescPtr wdp, Widget parent,
                        ArgList args, Cardinal num_args, XtPointer closure)
#else
GolitFetchWidgetHierUnmanaged (name, wdp, parent, args, num_args, closure)
        String                          name;
        register GolitWidgetDescPtr     wdp;
        Widget                          parent;
        ArgList                         args;
        Cardinal                        num_args;
        XtPointer                       closure;
#endif  /* __STDC__ */
{
	Boolean 	save = (Boolean)GolitWDPtrCreateUnmanaged(wdp);
	Widget		w;

	GolitWDPtrCreateUnmanaged(GolitWDPtrChildren(wdp)) = True;
	w = GolitFetchWidgetHier(name, wdp, parent, args, num_args, closure);
	GolitWDPtrCreateUnmanaged(GolitWDPtrChildren(wdp)) = save;

	return (w);
}

/*************************
 *
 * GolitFetchWidgetHier
 *
 *************************/

Widget
#if     defined(__STDC__)
GolitFetchWidgetHier (String name, GolitWidgetDescPtr wdp, Widget parent,
                        ArgList args, Cardinal num_args, XtPointer closure)
#else
GolitFetchWidgetHier (name, wdp, parent, args, num_args, closure)
        String                          name;
        register GolitWidgetDescPtr     wdp;
        Widget                          parent;
        ArgList                         args;
        Cardinal                        num_args;
        XtPointer                       closure;
#endif  /* __STDC__ */
{
	Widget	w = (Widget)NULL;
	Boolean	key;

	if (wdp == (GolitWidgetDescPtr)NULL) {
		_GolitWarning(parent, wdp, GolitNullWidgetDesc);
			     
		return (w);
	}

	if (parent == (Widget)NULL) {
		_GolitWarning(parent, wdp, GolitNullWidgetID);
		return (w);
	}

#ifdef	CHECKVERSION
	if (GolitWDPtrVersion(wdp) != GoltRTVersion) {
		_GolitWarning(parent, wdp, GolitVersionMismatch); 
	}
#endif

	if (GolitWDPtrIsShell(wdp) || (!GolitWDPtrIsPopupShell(wdp) &&
	    (GolitWDPtrIsShell(wdp) =
		 _GolitWDIsSubclass(wdp, shellWidgetClass)))) {
		_GolitError(parent, wdp, GolitFetchWDOnShell);
	}

	key = (GolitWDPtrCpIdx(wdp) == (unsigned int)0);

	if (CreateProcListNULL(wdp) ||
	    DoRealCreate(wdp, GolitFetchWidgetHier) ||
	    DoRealCreate(wdp, GolitFetchWidgetHierUnmanaged)) {
		Boolean	t;

		if ((t = (!CreateProcListNULL(wdp) &&
		          (int)GolitWDPtrCpIdx(wdp) <= (2 << BitsInCpIdx) - 2 &&
			  GolitWDPtrCreateProcs(wdp)[GolitWDPtrCpIdx(wdp)] !=
			  (_GolitWCProc)NULL)))
			_IncrWDPtrCpIdx(wdp);
	
		w = GolitFetchWidget(name, wdp, parent, args, num_args,
				     closure);


		if (w == (Widget)NULL) {
			_GolitWarning (parent, wdp, GolitNullWidgetID);
			return (w);
		}

		GolitFetchChildren((String)NULL, wdp, w, args, num_args,
				   closure);
		GolitFetchPopups((String)NULL, wdp, w, args, num_args,
				 closure);

		if (t) _DecrWDPtrCpIdx(wdp);
	} else {
		w = CreateProc(name, wdp, parent, args, num_args, closure);
		_DecrWDPtrCpIdx(wdp);
	}

	if (key) GolitWDPtrCpIdx(wdp) = 0;

	return (w);
}

/*************************
 *
 * GolitMenuButtonCreateProc
 *
 *************************/

Widget
#if     defined(__STDC__)
GolitMenuButtonCreateProc (String name, GolitWidgetDescPtr wdp, Widget parent,
                        ArgList args, Cardinal num_args, XtPointer closure)
#else
GolitMenuButtonCreateProc (name, wdp, parent, args, num_args, closure)
        String                          name;
        register GolitWidgetDescPtr     wdp;
        Widget                          parent;
        ArgList                         args;
        Cardinal                        num_args;
        XtPointer                       closure;
#endif  /* __STDC__ */
{
	Widget	mb, pane = (Widget)NULL;
	Arg	arg;
	Boolean	key;

	if (wdp == (GolitWidgetDescPtr)NULL) {
		_GolitWarning(parent, wdp, GolitNullWidgetDesc);
			     
		return (parent);
	}

	if (parent == (Widget)NULL) {
		_GolitWarning(parent, wdp, GolitNullWidgetID);
		return (parent);
	}

#ifdef	CHECKVERSION
	if (GolitWDPtrVersion(wdp) != GoltRTVersion) {
		_GolitWarning(parent, wdp, GolitVersionMismatch); 
	}
#endif

	if (GolitWDPtrIsShell(wdp) || (!GolitWDPtrIsPopupShell(wdp) &&
	    (GolitWDPtrIsShell(wdp) =
		 _GolitWDIsSubclass(wdp, shellWidgetClass)))) {
		_GolitError(parent, wdp, GolitFetchWDOnShell);
	}

	key = (GolitWDPtrCpIdx(wdp) == 0);

	if (CreateProcListNULL(wdp) ||
	    DoRealCreate(wdp, GolitMenuButtonCreateProc)) {
		Boolean	t;

		if ((t = (!CreateProcListNULL(wdp) &&
		          (int)GolitWDPtrCpIdx(wdp) <= (2 << BitsInCpIdx) - 2 &&
			  GolitWDPtrCreateProcs(wdp)[GolitWDPtrCpIdx(wdp)] !=
			  (_GolitWCProc)NULL)))
			_IncrWDPtrCpIdx(wdp);

		mb = GolitFetchWidget(name, wdp, parent, args, num_args,
				      closure);


		if (mb == (Widget)NULL) return (mb);

		XtSetArg(arg, XtNmenuPane, (XtPointer)&pane);
		XtGetValues(mb, &arg, 1);

		if (pane == (Widget)NULL) pane = mb;

		GolitFetchChildren((String)NULL, wdp, pane, args, num_args,
				   closure);
		GolitFetchPopups((String)NULL, wdp, mb, args, num_args,
				 closure);

		if (t) _DecrWDPtrCpIdx(wdp);
	} else {
		mb = CreateProc(name, wdp, parent, args, num_args, closure);
		_DecrWDPtrCpIdx(wdp);
	}

	if (key) GolitWDPtrCpIdx(wdp) = 0;

	return (mb);
}


/*************************
 *
 * GolitPopupWindowCreateProc
 *
 *************************/

Widget
#if     defined(__STDC__)
GolitPopupWindowCreateProc (String name, GolitWidgetDescPtr wdp, Widget parent,
                        ArgList args, Cardinal num_args, XtPointer closure)
#else
GolitPopupWindowCreateProc (name, wdp, parent, args, num_args, closure)
        String                          name;
        register GolitWidgetDescPtr     wdp;
        Widget                          parent;
        ArgList                         args;
        Cardinal                        num_args;
        XtPointer                       closure;
#endif  /* __STDC__ */
{
	Widget	pw, uca, lca, fp;
	Arg	arg[3];
	Boolean	key;

	if (wdp == (GolitWidgetDescPtr)NULL) {
		_GolitWarning(parent, wdp, GolitNullWidgetDesc);
			     
		return (parent);
	}

	if (parent == (Widget)NULL) {
		_GolitWarning(parent, wdp, GolitNullWidgetID);
		return (parent);
	}

#ifdef	CHECKVERSION
	if (GolitWDPtrVersion(wdp) != GoltRTVersion) {
		_GolitWarning(parent, wdp, GolitVersionMismatch); 
	}
#endif

	if (GolitWDPtrIsShell(wdp) || (!GolitWDPtrIsPopupShell(wdp) &&
	    (GolitWDPtrIsShell(wdp) =
		 _GolitWDIsSubclass(wdp, shellWidgetClass)))) {
		_GolitError(parent, wdp, GolitFetchWDOnShell);
	}

	key = (GolitWDPtrCpIdx(wdp) == 0);

	if (CreateProcListNULL(wdp) ||
	    DoRealCreate(wdp, GolitPopupWindowCreateProc)) {
		Boolean	t;

		uca = lca = fp = (Widget)NULL;

		if ((t = (!CreateProcListNULL(wdp) &&
		          (int)GolitWDPtrCpIdx(wdp) <= (2 << BitsInCpIdx) - 2 &&
			  GolitWDPtrCreateProcs(wdp)[GolitWDPtrCpIdx(wdp)] !=
			  (_GolitWCProc)NULL)))
			_IncrWDPtrCpIdx(wdp);

		pw = GolitFetchWidget(name, wdp, parent, args, num_args,
				      closure);

		if (pw == (Widget)NULL) return (pw);

		XtSetArg(arg[0], XtNupperControlArea, (XtPointer)&uca);
		XtSetArg(arg[1], XtNlowerControlArea, (XtPointer)&lca);
		XtSetArg(arg[2], XtNfooterPanel,      (XtPointer)&fp);
		XtGetValues(pw, arg, sizeof(arg) / sizeof(arg[0]));

		if (uca == (Widget)NULL) uca = pw;

		GolitFetchChildren((String)NULL, wdp, uca, args, num_args,
				   closure);
		GolitFetchPopups((String)NULL, wdp, pw, args, num_args,
				   closure);

		if (t) _DecrWDPtrCpIdx(wdp);
	} else {
		pw = CreateProc(name, wdp, parent, args, num_args, closure);
		_DecrWDPtrCpIdx(wdp);
	}

	if (key) GolitWDPtrCpIdx(wdp) = 0;

	return (pw);
}

/*************************
 *
 * GolitFetchShellHier
 *
 *************************/

Widget
#if     defined(__STDC__)
GolitFetchShellHier ( String app_name, String app_class, GolitWidgetDescPtr wdp, 
				Display *dpy, ArgList args,
                              	Cardinal num_args, XtPointer closure)
#else
GolitFetchShellHier ( app_name, app_class, wdp, dpy, args,
			      num_args, closure)
	String				app_name;
	String				app_class;
	register GolitWidgetDescPtr	wdp;
	Display				*dpy;
	ArgList				args;
	Cardinal			num_args;
	XtPointer			closure;
#endif  /* __STDC__ */
{
	XtVarArgsList	list;
	Widget		shell = (Widget)NULL;
	Boolean		key;

	if (wdp == (GolitWidgetDescPtr)NULL) {
		return (shell);
	}

#ifdef	CHECKVERSION
	if (GolitWDPtrVersion(wdp) != GoltRTVersion) {
		_GolitWarning(parent, wdp, GolitVersionMismatch); 
	}
#endif

	if (dpy == (Display *)NULL) {
		return (shell);
	}

	list = GolitMergeArgLists(wdp, args, num_args);

	key = (GolitWDPtrCpIdx(wdp) == 0);

	if (ShellCreateProcListNULL(wdp) ||
	    DoRealShellCreate(wdp, GolitFetchShellHier)) {
		GolitWidgetDescPtr	child = GolitWDPtrChildren(wdp);

		if (list) {
			shell = XtVaAppCreateShell(app_name, app_class, 
					           *GolitWDPtrWidgetClass(wdp),
						   dpy, XtVaNestedList, list,
						   NULL);
		} else {
			shell = XtVaAppCreateShell(app_name, app_class, 
					           *GolitWDPtrWidgetClass(wdp),
						   dpy, NULL);
		}

		if (ShellCreateProcListNULL(wdp) ||
		    (GolitShellWidgetCreateProc)(GolitWDPtrShellCreateProcs(wdp)
                    [GolitWDPtrCpIdx(wdp) + 1]) == 
					(GolitShellWidgetCreateProc)NULL) {
			GolitWDPtrCpIdx(wdp) = 0;
		} else
			_IncrWDPtrCpIdx(wdp);

		GolitWDPtrLastWidgetCreated(wdp) = shell;
		_GolitInstallCBsOnWidget(shell, wdp, closure);

		if (shell != (Widget)NULL &&
		    child != (GolitWidgetDescPtr)NULL) {
			GolitWDPtrCpIdx(child) = 0;
			GolitFetchWidget((String)NULL, child, shell, args,
				     num_args, closure);
		}
	} else {
		shell = ShellCreateProc(app_name, app_class, wdp, dpy,
					args, num_args, closure);
		_IncrWDPtrCpIdx(wdp);
	}

	if (list != (XtVarArgsList)NULL)
		XtFree((char *)list);

	if (key) GolitWDPtrCpIdx(wdp) = 0;

	return (shell);
}

/*************************
 *
 * some public sharable
 * create proc lists
 *
 *************************/

/*DATADEFB*/
GolitWidgetCreateProc
_GolitWDDefaultCPList[]
/*DATADEFE*/ = {
		GolitFetchWidgetHier,
		(GolitWidgetCreateProc)NULL
};

/*DATADEFB*/
GolitShellWidgetCreateProc
_GolitWDDefaultShellCPList[]
/*DATADEFE*/ = {
		GolitFetchShellHier,
		(GolitShellWidgetCreateProc)NULL
};

/*DATADEFB*/
GolitWidgetCreateProc
_GolitWDDefaultUnmanagedCPList[]
/*DATADEFE*/ = {
		GolitFetchWidgetHierUnmanaged,
		(GolitWidgetCreateProc)NULL
};

/*DATADEFB*/
GolitWidgetCreateProc
_GolitWDOnlyCreatedCPList[]
/*DATADEFE*/ = {
		GolitFetchWidgetUnmanaged,
		(GolitWidgetCreateProc)NULL
};

/*DATADEFB*/
GolitWidgetCreateProc
_GolitWDChildrenOnlyCPList[]
/*DATADEFE*/ = {
		GolitFetchChildren,
		(GolitWidgetCreateProc)NULL
};


/*DATADEFB*/
GolitWidgetCreateProc
_GolitWDMenuButtonCPList[]
/*DATADEFE*/ = {
		GolitMenuButtonCreateProc,
		(GolitWidgetCreateProc)NULL
};

/*DATADEFB*/
GolitWidgetCreateProc
_GolitWDPopupWindowCPList[]
/*DATADEFE*/ = {
		GolitPopupWindowCreateProc,
		(GolitWidgetCreateProc)NULL
};
