/*
 * This file is a product of Sun Microsystems, Inc. and is provided for
 * unrestricted use provided that this legend is included on all tape
 * media and as a part of the software program in whole or part.  Users
 * may copy or modify this file without charge, but are not authorized to
 * license or distribute it to anyone else except as part of a product
 * or program developed by the user.
 * 
 * THIS FILE IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
 * WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 * 
 * This file is provided with no support and without any obligation on the
 * part of Sun Microsystems, Inc. to assist in its use, correction,
 * modification or enhancement.
 * 
 * SUN MICROSYSTEMS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
 * INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY THIS FILE
 * OR ANY PART THEREOF.
 * 
 * In no event will Sun Microsystems, Inc. be liable for any lost revenue
 * or profits or other special, indirect and consequential damages, even
 * if Sun has been advised of the possibility of such damages.
 * 
 * Sun Microsystems, Inc.
 * 2550 Garcia Avenue
 * Mountain View, California  94043
 */
#ifndef lint
static char     sccsid[] = "@(#)rasview.c	2.11 91/08/14 Copyright 1989 Sun Microsystems.";
#endif

#include <stdio.h>
#include <string.h>
#include <sys/param.h>
#include <sys/mman.h>
#include <sys/stat.h>
#include <xview/xview.h>
#include <xview/canvas.h>
#include <xview/notice.h>
#include <xview/panel.h>
#include <xview/scrollbar.h>
#include <xview/dragdrop.h>
#include <xview/cms.h>
#include <xview/screen.h>
#include <xview/xv_xrect.h>
#include <X11/X.h>
#include <X11/Xlib.h>
#include <gdd.h>
#include <gfm.h>
#include "rasview_ui.h"


#ifdef SVR4
#include <pixrect/rasterfile.h>
#else
#include <rasterfile.h>
#endif

#define  ESCAPE   128
#define  PIX_ERR  -1
#define  MAXDEPTH 32
#define  PIPE_LIMIT 1000

/*
 * Global object definitions.
 */
rasview_win_objects	*Rasview_win;


/*
 * Instance XV_KEY_DATA key.  An instance is a set of related user interface
 * objects.  A pointer to an object's instance is stored under this key in
 * every object.  This must be a global variable.
 */
Attr_attribute	INSTANCE;

char				*Program_name[MAXPATHLEN];
FILE           			*Current_file;
static gfm_popup_objects	*Gfm;
int				Size = 0;	/* Size of data to be dragged */
char				*Buf = NULL; 	/* Buffer to hold drag data */
char				*File = NULL; 	/* Name of file to drag */
static Scrollbar		Canvas_hscrollbar; /* canvas hor scrollbar */
static Scrollbar		Canvas_vscrollbar; /* canvas vert scrollbar */
Visual				*X_visual;	/* Pointer to the X visual */
int				View_depth;
Drawable			View_Xid;	/* Xid for view window */
GC 				Viewgc;		/* View window GC */
XImage				*Ximage = NULL;	/* Current image */
int 				Image_depth;
Display				*Dpy;		/* Display id of frame */
Canvas_paint_window		Cpw;
int				Gc_flags;	/* Flags for GC */	
int		 		pad_info [MAXDEPTH];
int				cmapused;	/* Is image > 1 bit deep */
int				Previous_depth = 0;
unsigned 	char		*red_values;
unsigned 	char		*green_values;
unsigned 	char		*blue_values;
int				iscompressed = 0;


void	rasview_initialize();
void	rasview_file_close();
void	init_pad();
int	rasview_file_load();
int	gfm_proc();
void	unmap_drag_data();
void	fill_drag_data();
void	close_file();

void
main(argc, argv)
	int             argc;
	char          **argv;
{

	/*
	 * Initialize XView.
	 */
	xv_init(XV_INIT_ARGC_PTR_ARGV, &argc, argv, 0);
	INSTANCE = xv_unique_key();

	strcpy((char *) Program_name, (const char *) argv[0]);

	/*
	 * Initialize user interface components.
	 */
	Rasview_win = rasview_win_objects_initialize(NULL, NULL);

	rasview_initialize(NULL);

	/*
	 * Initialize the Drag Drop package.
	 */
	gdd_init_dragdrop(Rasview_win->win);
	
	if (argc > 1)
		rasview_file_load(argv[1]);

	/*
	 * Turn control over to XView.
	 */
	xv_main_loop(Rasview_win->win);
	unmap_drag_data();
	exit(0);
}

/*
 * Initialize rasview module.
 */
void
rasview_initialize(owner)
	Xv_opaque       owner;
{
	XGCValues			Gc_val;
	unsigned long 			gc_mask;

	Gfm = gfm_initialize(NULL, Rasview_win->win, "Rasview: Load");

	X_visual = (Visual *) xv_get(Rasview_win->win, XV_VISUAL);
	Dpy = (Display *) xv_get(Rasview_win->win, XV_DISPLAY);
	Cpw = canvas_paint_window(Rasview_win->canvas);
	View_depth = xv_get(Rasview_win->win, WIN_DEPTH);
	View_Xid = (Drawable) xv_get(Cpw, XV_XID);
	gc_mask = GCForeground | GCBackground;
	Gc_val.foreground = xv_get(xv_get(Rasview_win->win, WIN_CMS), 
					  CMS_FOREGROUND_PIXEL);
	Gc_val.background = xv_get(xv_get(Rasview_win->win, WIN_CMS), 
					  CMS_BACKGROUND_PIXEL);

	Viewgc = XCreateGC(Dpy, View_Xid, gc_mask, &Gc_val);

  	xv_set(Cpw, WIN_BIT_GRAVITY, ForgetGravity, 0);

	Canvas_hscrollbar = (Scrollbar) xv_get(Rasview_win->canvas,
					       WIN_HORIZONTAL_SCROLLBAR);
	Canvas_vscrollbar = (Scrollbar) xv_get(Rasview_win->canvas,
					       WIN_VERTICAL_SCROLLBAR);
	xv_set(Rasview_win->canvas,
		CANVAS_AUTO_SHRINK, FALSE,
		CANVAS_AUTO_EXPAND, TRUE,
		WIN_BACK, NULL,
		CANVAS_AUTO_CLEAR, TRUE,
		CANVAS_X_PAINT_WINDOW, TRUE,
		CANVAS_RETAINED, FALSE,
	       NULL);
}


void
display_notice(string)
	char	*string;
{

	Event 	event;

	notice_prompt(Rasview_win->win, &event,
		      NOTICE_MESSAGE_STRINGS, string, 0,
		      NOTICE_BUTTON_YES, "Continue",
		      0);
}

/*
 * Get rasterfile image data from stream.
 */
unsigned char *
get_image(rh)
register struct rasterfile *rh;
{
	unsigned char *data;
  	int lineb = imagelen (rh->ras_width, rh->ras_height, rh->ras_depth);

	if (rh == 0) return(0);

	if ((data = (unsigned char *) malloc((size_t) lineb)) == NULL)
		return(NULL);

	switch (rh->ras_type)
	{
		case RT_OLD          :
	      	case RT_STANDARD     :
	      	case RT_FORMAT_RGB   :  
					sn_fread((char *) data, 1, lineb);
				        break;
	 
	      	case RT_BYTE_ENCODED :  
					read_encoded(rh->ras_length, data, lineb);

	}

	return (data);
}

/*
 * Allocate or deallocate memory for the colormap entries.
 */
void
check_cmap (cmap_size)
	int cmap_size;
{
    	if (cmap_size > 0) 
	{
       		if (red_values != (unsigned char *) NULL) 
		{
          		red_values = (unsigned char *) 
					realloc(red_values, cmap_size);
          		green_values = (unsigned char *) 
					realloc(green_values, cmap_size);
          		blue_values = (unsigned char *) 
					realloc(blue_values, cmap_size);
          	}
       		else 
       		{
          		red_values = (unsigned char *) 
					malloc((unsigned) cmap_size);
          		green_values = (unsigned char *) 
					malloc((unsigned) cmap_size);
          		blue_values = (unsigned char *) 
					malloc((unsigned) cmap_size);
       		}
       	}
	else 
	{
       		if (red_values != (unsigned char *) NULL) 
		{
			  free (red_values); 
			  free (green_values); 
			  free (blue_values); 
			  red_values = (unsigned char *) NULL;
			  green_values = (unsigned char *) NULL;
			  blue_values = (unsigned char *) NULL;
		}
       	}
}


void
compress (ximage)
XImage *ximage;
{
	
	unsigned char *old_red;
	unsigned char *old_blue;
	unsigned char *old_green;
	unsigned char *new_data;
	int length, i;
	unsigned char *iptr;
	unsigned long color;
	unsigned long *pixel;
	unsigned int *used;
	unsigned int a, x, y;
	int new_cmapused;
	
	old_red = (unsigned char *) malloc (cmapused);
	old_green = (unsigned char *) malloc (cmapused);
	old_blue = (unsigned char *) malloc (cmapused);
	length = ximage->height * ximage->bytes_per_line;
	new_data = (unsigned char *) malloc (length);
	new_cmapused = 0;

	memcpy ((char *) new_data, (char *) ximage->data, length);

    	for (i = 0; i < cmapused; i++) 
	{
	    	old_red [i] = red_values[i];
	    	old_green [i] = green_values[i];
	    	old_blue [i] = blue_values[i];
	}

    	pixel = (unsigned long *) malloc(sizeof(unsigned long) * cmapused);
    	used  = (unsigned int *)  malloc(sizeof(unsigned int)  * cmapused);
    	iptr  = (unsigned char *) new_data;

    	for (x = 0; x < cmapused; x++) 
	    *(used + x) = NULL;

    	for (y = 0; y < ximage->height; y++)                        
    	{
      	    for (x = 0; x < ximage->width; x++)
            {
                color = *iptr;
          	if (*(used + color) == 0)
             	{
              	    for (a = 0; a < new_cmapused; a++)
                        if ((*(red_values   + a) == *(old_red   + color)) &&
                    	    (*(green_values + a) == *(old_green + color)) &&
                    	    (*(blue_values  + a) == *(old_blue  + color)))
                  		break;
              	    *(pixel + color) = a;
                    *(used + color)  = 1;

              	    if (a == new_cmapused)
                    {
                        *(red_values   + a) = *(old_red   + color);
                  	*(green_values + a) = *(old_green + color);
                  	*(blue_values  + a) = *(old_blue  + color);
                  	new_cmapused++;
                    }
            	}

                *iptr = (unsigned char) pixel[(unsigned int) color];
          	iptr++;
            }

      	    iptr += (ximage->bytes_per_line - ximage->width);
    	}

    	cmapused = new_cmapused;
    	free(old_red);
    	free(old_green);
    	free(old_blue);
    	free(used);
    	free(pixel);

    	free(ximage->data);
    	ximage->data = (char *) new_data;
}


void 
add_colors (canvas, ximage)
Canvas canvas;
XImage *ximage;
{
  	Xv_singlecolor 	*colors;
  	unsigned char 	*iptr;
  	unsigned long 	*pixel_table;
  	int 		 c, x, y;
  	Cms		 cms;
	char		buf[MAXPATHLEN];
 
  	iptr = (unsigned char *) ximage->data;
  	colors = (Xv_singlecolor *)
    	malloc((unsigned) (sizeof(Xv_singlecolor) * cmapused));
 
	/* 
	 *Transfer colormap data to Xv_singlecolor array 
	 */                           
 
  	for (c = 0; c < cmapused; c++)
    	{
      		colors[c].red   = red_values [c];
      		colors[c].green = green_values [c];
		colors[c].blue  = blue_values [c];
    	}
 
  	/* 
	 * Create the cms from the colors 
	 */
  	cms = (Cms) xv_create(xv_get(canvas, XV_SCREEN), CMS,
                        CMS_SIZE,                  cmapused,
                        CMS_COLORS,                colors,
                        0);
 
  	if (!cms)
    	{
		sprintf(buf, "Unable to create colormap.");
		display_notice(buf);
		return;
    	}
 
  	pixel_table = (unsigned long *) xv_get(cms, CMS_INDEX_TABLE);

	/*
	 * Adjust image data to the new pixels 
	 */                           
    
  	for (y = 0; y < ximage->height; y++)
    	{
      		for (x = 0; x < ximage->width; x++)
        	{
          		*iptr = pixel_table[(unsigned char) *iptr];
          		iptr++;
        	}

      		iptr += (ximage->bytes_per_line - ximage->width);
    	}    

	/* 
	 * Set the cms on the canvas 
	 */
 
  	xv_set (canvas, WIN_CMS, cms, NULL);
}


/*
 * Take a 1 bit deep image and copy it into an 8 bit deep image.
 */
XImage *
expand1to8(old)
XImage *old;
{
  	unsigned char *dst, *linep, *src;
  	unsigned char *new_data;
  	int dll, i, j, linesize, mask, dst_rem;
  	XImage *new;

  	cmapused = 2;
  	check_cmap (cmapused);

  	dll = linelen (old->width, 8);
  	new_data = (unsigned char *) malloc((size_t) (dll * old->height));

  	new = XCreateImage (Dpy, X_visual, 8, ZPixmap, 0, (char *) new_data,
			old->width, old->height, pad_value (8), 0);

  	memset((char *) new_data, 0, dll * old->height);

	/*
	 * Set White and Black pixels.
	 */
  	red_values [0] = green_values [0] = blue_values [0] = 255;
  	red_values [1] = green_values [1] = blue_values [1] = 0;

  	linep = (unsigned char *) old->data;
  	dst = (unsigned char *) new->data;
  	linesize = linelen (old->width, old->depth);

  	dst_rem = linelen (new->width, new->depth) - (new->width * new->depth / 8);

  	for (i = 0; i < old->height; i++)
    	{
      		src = linep;
      		mask = 0x80;
      		for (j = 0; j < old->width; j++, dst++)
        	{

          		if (mask == 0)
            		{
              			src++;
              			mask = 0x80;
            		}

          		if (*src & mask) 
				*dst = 1;

          		mask >>= 1;
       		}

		linep += linesize;
      		dst += dst_rem;
    	}
  
  	return(new);
}

/*
 * Depending on the depth of the screen and the depth of the image,
 * massage the data and create the viewable image.
 */
XImage *
gen_image(image)
XImage *image;
{
	XImage		*new;

  	switch (View_depth)                    /* Screen depth. */
    	{
      		case 1  : 
			switch (Image_depth)             /* Image depth. */
                   	{ 
                    		case 1:	new = image;
                              		break;

		    		default: return((XImage *) NULL);
                  	}

			break;

      		case 8  : switch (Image_depth)
                  	{
                    		case 1: new = expand1to8(image);
			      		XDestroyImage (image);
                              		break;

                    		case 8: new = image;
			 		compress(new);
                              		break;

                    		default: return((XImage *) NULL);
                  	}

                	new->byte_order = MSBFirst;
                	add_colors(Rasview_win->canvas, new);
                	break;

      		default: return((XImage *) NULL);
    	}

    	return(new);
}

/*
 * Repaint callback function for `canvas'.
 */
void
rasview_canvas_repaint(canvas, paint_window, display, xid, rects)
	Canvas		canvas;
	Xv_window	paint_window;
	Display		*display;
	Window		xid;
	Xv_xrectlist	*rects;
{

	if (Ximage != (XImage *) NULL) 
	{
		XSetFunction (Dpy, Viewgc, GXcopy);
		XPutImage (Dpy, View_Xid, Viewgc, Ximage, 0, 0, 0, 0,
                           Ximage->width, Ximage->height);
	}
	
	XSync (Dpy, 0);
}

/*
 * Load a raster file.
 */
int
rasview_file_load(file)
	char           *file;
{
	char           *p;
	int 		width;
	int 		height;
	int 		bytes_per_line;
	int 		cmaptype;
	unsigned char 	*image_data;
	struct rasterfile rh;
	XImage		*tmp_image;
	char            buf[MAXPATHLEN];
	int		len;
	
	
	iscompressed = 0;

	rasview_file_close();

	/*
	 * Open file.
	 */

	/*
	 * Check to see if file is compressed.
	 */
	len = strlen(file) ;
	if (len > 2 && !strncmp(&file[len-2], ".Z", 2)) 
		iscompressed = 1;

	if ((Current_file = fopen(file, "r")) == NULL) 
	{
		sprintf(buf, "Cannot load %s.", file);
		display_notice(buf);
		(void) fclose(Current_file);
		return GFM_ERROR;
	} 
	else if (iscompressed)
	{
		fclose(Current_file);
		sprintf(buf, "zcat %s", file);
		if ((Current_file = popen(buf, "r")) == NULL)
			{
				sprintf(buf, "Cannot load compressed file %s.", file); 
				display_notice(buf);
				(void) pclose(Current_file);
				return GFM_ERROR; 
			}
	}

	init_pad();
	if (get_image_header(&rh) == PIX_ERR)
	{
		sprintf(buf, "Error getting header, cannot load %s.",
				file);
		display_notice(buf);
		rasview_file_close(Current_file);
		return GFM_ERROR;
	}

	/*
	 * Set the current directory/file name.
	 */
	if (p = strrchr(file, '/'))
		xv_set(Rasview_win->win, FRAME_RIGHT_FOOTER, p + 1, 0);
	else
		xv_set(Rasview_win->win, FRAME_RIGHT_FOOTER, file, 0);

	width          = rh.ras_width;
	height         = rh.ras_height;
	Image_depth    = rh.ras_depth;
	bytes_per_line = linelen (width, Image_depth);

	Size = rh.ras_length + rh.ras_maplength + 32;

	cmaptype       = rh.ras_maptype;
	cmapused       = rh.ras_maplength / 3;

	/*
	 * Currently, Rasview_win only allows display of 1 bit deep images
	 * on a monochrome display and 1 or 8 bit deep images on an 8
	 * bit deep display.
	 */
	if (View_depth == 1 && Image_depth != 1)
	{
		sprintf(buf, "%s can only load a 1 bit deep image \non a monochrome display.\n%s is %d bits deep.",
				Program_name,
				file,
				Image_depth);
		display_notice(buf);
		rasview_file_close(Current_file);
		return GFM_ERROR;
	}
	else if (View_depth == 8 && (Image_depth != 1 && Image_depth != 8 ))
	{
		sprintf(buf, "%s can only load a 1 or 8 bit deep\nimage on an 8 bit deep display.\n%s is %d bits deep.",
				Program_name,
				file,
				Image_depth);
		display_notice(buf);
		rasview_file_close(Current_file);
		return GFM_ERROR;
	}

	check_cmap (cmapused);

	if (get_image_cmap(&rh, cmapused, cmaptype) == PIX_ERR)
	  {
		sprintf(buf, "Error loading colormap for\n%s.", file);
		display_notice(buf);
		rasview_file_close(Current_file);
	    	return GFM_ERROR;
	  }

	if ((image_data = get_image(&rh)) == NULL)
	  {
		sprintf(buf, "Error getting image data for\n%s.", file);
		display_notice(buf);
		rasview_file_close(Current_file);
	    	return GFM_ERROR;
	  }


	tmp_image = XCreateImage (Dpy, X_visual, Image_depth,
				Image_depth == 1 ? XYPixmap : ZPixmap,
				0, (char *) image_data, width, height, 
				pad_value (Image_depth), bytes_per_line);

	if ((Ximage = gen_image(tmp_image)) == (XImage *)NULL)
	{
		sprintf(buf, "Error generating image for\n%s.", file);
		display_notice(buf);
	    	return GFM_ERROR;
	}

	/*
	 * Reset canvas width/height and scrollbars.
	 */
	xv_set(Rasview_win->canvas,
	       CANVAS_WIDTH, width,
	       CANVAS_HEIGHT, height,
	       0);

	xv_set(Canvas_hscrollbar, SCROLLBAR_VIEW_START, 0, 0);
	xv_set(Canvas_vscrollbar, SCROLLBAR_VIEW_START, 0, 0);

	fill_drag_data();

	if (Previous_depth == Image_depth)
		rasview_canvas_repaint(Rasview_win->canvas, Cpw, Dpy, View_Xid, NULL);
	else
		Previous_depth = Image_depth;

	return GFM_OK;
}

/*
 * Menu handler for `file_menu (Load...)'.
 */
Menu_item
rasview_load_handler(item, op)
	Menu_item       item;
	Menu_generate   op;
{
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		gfm_activate(Gfm, NULL, NULL, NULL, gfm_proc, NULL, GFM_LOAD);
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		/* gxv_end_connections */
		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Callback for file chooser
 */
int
gfm_proc(ip, dir, file)
	gfm_popup_objects	*ip;
	char			*dir;
	char			*file;
{
	char	buf[MAXPATHLEN];

	sprintf(buf, "%s/%s", dir, file);
	return rasview_file_load(buf);
}

/*
 * Menu handler for `file_menu (Close)'.
 */
Menu_item
rasview_close_handler(item, op)
	Menu_item       item;
	Menu_generate   op;
{
	switch (op) {
	case MENU_DISPLAY:
		xv_set(item, MENU_INACTIVE, Ximage == (XImage *) NULL, 0);
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		rasview_file_close();
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		/* gxv_end_connections */
		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}


/*
 * Close a raster file.
 */
void
rasview_file_close()
{
	if (Ximage)
	{
		XClearWindow(Dpy, View_Xid);
		XDestroyImage(Ximage);
		Ximage = NULL;
	}

	/*
	 * Set the drop target to show that there is no available data to
	 * drag.
	 */
	xv_set(Rasview_win->drop_target1, PANEL_DROP_FULL, FALSE, 0);

	xv_set(Rasview_win->win, FRAME_RIGHT_FOOTER, "", 0);

	if (iscompressed)
		pclose(Current_file);
	else
		fclose(Current_file);
}

/*
 * Drop callback function for `canvas'.
 */
void
canvas_drop_function(item, event, drop_info)
	Xv_opaque	item;
	Event		*event;
	GDD_DROP_INFO	*drop_info;
{
	
	char	buf[MAXPATHLEN];

	if (drop_info->tmpfile && (strcmp(drop_info->tmpfile, "") != 0 ))
		sprintf(buf,"%s", drop_info->tmpfile);
	else if (drop_info->filename && (strcmp(drop_info->filename, "") != 0 ))
		strcpy(buf, drop_info->filename);
	else
	{
		/* Drop Error */
		return;
	}

	rasview_file_load(buf);
}


/*
 * Drag callback function for `drop_target1'.
 */
void
rasview_drag_function(item, event, drop_info, drag_state)
	Xv_opaque	item;
	Event		*event;
	GDD_DROP_INFO	*drop_info;
	int		drag_state;
{
	switch (drag_state) {
	case GDD_DRAG_STARTED:
		drop_info->data_label = File;
		drop_info->data = Buf;
		drop_info->length = Size;
		break;

	case GDD_DRAG_COMPLETED:
		break;

	}
}


void
unmap_drag_data()
{
	if (Buf && Size > 0)
	{
		munmap(Buf, Size);
		Buf = NULL;
		File = NULL;
		Size = 0;
	}
}

void
fill_drag_data()
{
	struct stat	statbuf;

	unmap_drag_data();
	if (!iscompressed)
	{
		fstat(fileno(Current_file), &statbuf);
		Size = statbuf.st_size;
		Buf = mmap(0, Size, PROT_READ, MAP_PRIVATE, fileno(Current_file), 0);
		/*
		 * Set the drop target to show that there is available data to
		 * drag.
		 */
		xv_set(Rasview_win->drop_target1, PANEL_DROP_FULL, TRUE, 0);

		File = (char *) xv_get(Rasview_win->win, FRAME_RIGHT_FOOTER);
	}
	else
	{
	/*
	 * Rasview can't drag and drop compressed (.Z) files at this
	 * time.
	 */
	}

}

int
pad_value (depth)
	int depth;
{
    	return (pad_info [depth - 1]);
}

/*
 * init_pad - Initializes padding info for rasterfile padding.
 *            May need to change if image returned from XGetImage,
 *            use set_current_pad function for that.
 */
 
void
init_pad ()
{
    	int i;
 
    	for (i = 0; i < 17; i++)
        	pad_info[i] = 16;
    	for (i = 17; i < MAXDEPTH; i++)
        	pad_info[i] = 32;
 
    	pad_info[23] = 24;    
}


/*
 * linelen function... The macro LINELEN just didn't seem to work for
 * all cases now that we've added support for depths of 4 and 24. 
 */

int
linelen (width, depth)
	int width;
	int depth;
{
    	int temp2;
    	int temp;
    	int the_depth = depth;

    	if (depth == 4) 
		the_depth = 8;
    
	temp = width * the_depth;
    	temp2 = (temp / 8) + 
	    (temp % pad_value (the_depth) ?
	    ((pad_value (the_depth) - (temp % pad_value (the_depth) )) / 8) :
		 0 );

    	if (temp2 % 2) 
		temp2++;

    	return (temp2);
}


/*
 * imagelen function... Most of the work done in linelen function above.
 */

int imagelen (width, height, depth)
	int width;
	int height;
	int depth;
{
    	return ( linelen (width, depth) * height);
}


int
sn_fread(ptr, size, nitems)
	char 	*ptr;
	int 	nitems, size;
{
 
#ifdef SVR4
     	if (nitems > PIPE_LIMIT) 
	{
        	int i;
        	int nobytes = 0;

        	for (i = 0; nobytes < (nitems * size); i++)
            		nobytes += fread (&ptr[i * PIPE_LIMIT], 
					  size, PIPE_LIMIT, Current_file);

        	return(nobytes);
        }
#endif
 
     	return (fread(ptr, size, nitems, Current_file));
}

static int
read_encoded(incount, out, outcount)
	register int incount;
	register u_char *out;
	register int outcount;
{
  	register u_char c;
  	register int repeat;

  	while (1)
    	{
      		while (--incount >= 0 && --outcount >= 0 &&
             	      (c = fgetc(Current_file)) != ESCAPE) 
			*out++ = c;

      		if (outcount < 0 || --incount < 0) 
			break;

      		if ((repeat = fgetc(Current_file)) == 0) 
			*out++ = c;
      		else
        	{
          		if ((outcount -= repeat) < 0 || --incount < 0) 
				break;

          		c = fgetc(Current_file);

          		do
            			*out++ = c;
          		while (--repeat != -1);
        	}
	}

	if (outcount < 0) 
		incount--;
  	else if (incount < -1) 
		outcount--;

  	if ((incount += 2) > 0) 
		return(incount);

  	return -(++outcount);
}


/* 
 * Get Sun rasterfile header from stream. 
 */
int
get_image_header(rh)
	register struct rasterfile *rh;
{
  	if (rh == 0) 
		return(PIX_ERR);

  	return(sn_fread((char *) rh, 1, sizeof(*rh)) == sizeof(*rh) &&
               rh->ras_magic == RAS_MAGIC ? 0 : PIX_ERR);
}


/* 
 * Get image colormap from stream. 
 */

get_image_cmap(rh, cmap_used, cmap_type)
	register struct rasterfile 	*rh;
	int 				cmap_used;
	int 				cmap_type;
{
  	register int len, error = PIX_ERR;
 
  	len = cmap_used;
  	if (rh == 0) 
		return(error);
 
	/* 
	 * Read colormap data, if any 
	 */

  	if (len == 0 || cmap_type == RMT_NONE ||
            sn_fread((char *) red_values,   1, len) == len &&
            (cmap_type != RMT_EQUAL_RGB ||
            sn_fread((char *) green_values, 1, len) == len &&
            sn_fread((char *) blue_values,  1, len) == len)) 
		error = 0;

  	return(error);
}


void
close_file()
{
}
